/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.client.AbstractBgOrgSetUI;
import com.kingdee.eas.ma.mbg.client.BgEnableKDStructCostCenterUI;
import com.kingdee.eas.ma.mbg.client.BgOrgMigrationReportUI;
import com.kingdee.eas.ma.mbg.client.BgOrgMigrationUI;
import com.kingdee.eas.ma.mbg.client.BgOrgSetReportUI;
import com.kingdee.eas.ma.mbg.utils.BgOrgDataHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.orgunit.BgOrgUnitTreeUtils;
import com.kingdee.eas.ma.mbg.utils.orgunit.BgTreeView;
import com.kingdee.eas.ma.mbg.utils.orgunit.CsOrgUnitTreeUtils;
import com.kingdee.eas.ma.mbg.utils.orgunit.IOrgCheckListener;
import com.kingdee.eas.ma.mbg.utils.orgunit.MbgOrgUnitHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgOrgSetUI
extends AbstractBgOrgSetUI {
    private static final long serialVersionUID = 4157091904477750868L;
    private static final Logger logger = CoreUIObject.getLogger(BgOrgSetUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgOrgUnitReource";
    private BgOrgDataHelper helper = null;
    private String viewId = null;
    private LongTimeDialog dialog = null;
    private CsOrgUnitTreeUtils csOrgUnitUtils = null;
    private BgOrgUnitTreeUtils bgOrgUnitUtils = null;
    private BgOrgUnitTreeUtils moOrgUnitUtils = null;
    private MbgOrgUnitHelper unitHelper = new MbgOrgUnitHelper();
    private Set<String> hasDataIdSet = new HashSet<String>();
    public boolean submit = false;

    protected LongTimeDialog getDialog() {
        return this.dialog;
    }

    protected void setDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    public BgOrgUnitTreeUtils getBgOrgUnitUtils() {
        return this.bgOrgUnitUtils;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.ccPanel.remove((Component)this.kdCSTreeView);
        this.bgPanel.remove((Component)this.kdBgOrgTreeView);
        this.moPanel.remove((Component)this.moOrgTreeView);
        this.kdCSTreeView = new BgTreeView();
        this.kdCSTreeView.setName("kdCSTreeView");
        this.kdCSTreeView.setTitle(this.resHelper.getString("kdCSTreeView.title"));
        this.kdCSTreeView.setBounds(new Rectangle(10, 35, 465, 470));
        this.ccPanel.add((Component)this.kdCSTreeView, (Object)new KDLayout.Constraints(10, 35, 475, 470, 0));
        this.kdCSTreeView.setTree(this.kDCSTree);
        this.kdBgOrgTreeView = new BgTreeView();
        this.kdBgOrgTreeView.setName("kdBgOrgTreeView");
        this.kdBgOrgTreeView.setTitle(this.resHelper.getString("kdBgOrgTreeView.title"));
        this.kdBgOrgTreeView.setBounds(new Rectangle(10, 35, 465, 470));
        this.bgPanel.add((Component)this.kdBgOrgTreeView, (Object)new KDLayout.Constraints(10, 35, 475, 470, 0));
        this.kdBgOrgTreeView.setTree(this.kDBgOrgTree);
        this.moOrgTreeView = new BgTreeView();
        this.moOrgTreeView.setName("moOrgTreeView");
        this.moOrgTreeView.setTitle(this.resHelper.getString("moOrgTreeView.title"));
        this.moOrgTreeView.setBounds(new Rectangle(10, 35, 465, 470));
        this.moPanel.add((Component)this.moOrgTreeView, (Object)new KDLayout.Constraints(10, 35, 475, 470, 0));
        this.moOrgTreeView.setTree(this.moOrgTree);
    }

    protected void initListener() {
        super.initListener();
        AbstractAction actionEnableKDStructCostCenter = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow iuiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgEnableKDStructCostCenterUI.class.getName(), BgOrgSetUI.this.getUIContext(), null, OprtState.EDIT);
                    iuiWindow.show();
                    if (((BgEnableKDStructCostCenterUI)iuiWindow.getUIObject()).isCancle()) {
                        return;
                    }
                    BgOrgSetUI.this.kdStructCostCenter.setVisible(((BgEnableKDStructCostCenterUI)iuiWindow.getUIObject()).isEnable());
                }
                catch (UIException uiException) {
                    logger.error((Object)"", (Throwable)uiException);
                    SysUtil.abort();
                }
            }
        };
        String strKey = "CTRL_SHIFT_F11";
        KeyStroke ks = KeyStroke.getKeyStroke(122, 192, false);
        this.getActionMap().put(strKey, actionEnableKDStructCostCenter);
        this.getInputMap(2).put(ks, strKey);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRemove.setText(null);
        this.btnRemove.setVisible(true);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.kdBgOrgTreeView.getControlPane().add((Component)this.btnRemove);
        this.btnMove.setText(null);
        this.btnMove.setVisible(true);
        this.btnMove.setIcon(EASResource.getIcon((String)"imgTree_move"));
        this.kdBgOrgTreeView.getControlPane().add((Component)this.btnMove);
        try {
            this.kdStructCostCenter.setVisible(BgOrgUnitHelper.isEnableStructCostCenter());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public String getOprtState() {
        return super.getOprtState();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("BGORGVIEW_ID", (Object)((BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO")).getId().toString());
            request.put("ORGUNIT_ID", (Object)((String)this.getUIContext().get("ORGUNIT_ID")));
        }
        return handler;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() throws Exception {
        this.initBase();
        this.initCostCenterTree();
        this.initBgOrgUnitTree();
        this.initMoveTree();
        this.initHasDataOrgUnitIds();
        this.checkAddAllFunction();
    }

    protected void initBase() throws Exception {
        BgOrgViewInfo bgOrgView = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        this.setDataObject((IObjectValue)bgOrgView);
    }

    protected void initCostCenterTree() throws Exception {
        this.kDCSTree.setShowCheckBox(true);
        this.csOrgUnitUtils = new CsOrgUnitTreeUtils((Component)((Object)this), (BgTreeView)this.kdCSTreeView, this.kDCSTree);
        this.csOrgUnitUtils.setAsyncLoad(true);
        this.csOrgUnitUtils.buildCsTeee((String)this.getUIContext().get("ORGUNIT_ID"), this.kDIsContainSealUp.isSelected());
    }

    protected void initBgOrgUnitTree() throws Exception {
        this.kDBgOrgTree.getSelectionModel().setSelectionMode(4);
        this.kDBgOrgTree.setRootVisible(false);
        this.kDBgOrgTree.setShowsRootHandles(true);
        this.kDBgOrgTree.setShowCheckBox(false);
        BgOrgViewInfo bgOrgView = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        this.bgOrgUnitUtils = new BgOrgUnitTreeUtils((Component)((Object)this), this.kDBgOrgTree, null, false);
        this.bgOrgUnitUtils.setCreateOrgId(bgOrgView.getOrgUnit().getId().toString());
        this.bgOrgUnitUtils.setHasVirtualRoot(true);
        this.bgOrgUnitUtils.buildBgTeee(bgOrgView.getId(), true, this.kDIsContainOrgNumber.isSelected());
        this.checkIsEmptyCcOrgNodeMap();
    }

    private void checkIsEmptyCcOrgNodeMap() {
        if (this.bgOrgUnitUtils.getCcOrgNodeMap().isEmpty()) {
            this.disableKDDesignatedOrg();
        } else {
            this.enableKDDesignatedOrg();
        }
    }

    protected void initMoveTree() throws Exception {
        this.moOrgTree.setRootVisible(false);
        this.moOrgTree.setShowsRootHandles(true);
        this.moOrgTree.setShowCheckBox(true);
        this.moOrgUnitUtils = new BgOrgUnitTreeUtils((Component)((Object)this), this.moOrgTree, null, false);
        this.moOrgUnitUtils.setShowPopMenu(false);
        this.moOrgUnitUtils.buildBgTeee(null, false, this.kDIsContainOrgNumber.isSelected());
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.moOrgUnitUtils.getKdTree().getModel().getRoot();
        root.setCheckBoxEnabled(false);
        root.setCheckBoxVisible(false);
    }

    protected void initHasDataOrgUnitIds() throws EASBizException, BOSException {
        BgOrgViewInfo bgOrgView = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        this.hasDataIdSet = this.getBizInterface().getHasBgDataOrgIds(bgOrgView.getId());
        this.bgOrgUnitUtils.setCheckOrgUnitIds(this.hasDataIdSet);
    }

    @Override
    protected void btnCsSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.csOrgUnitUtils.selectAllOrgUnit();
    }

    @Override
    protected void btnCsCancelAll_actionPerformed(ActionEvent e) throws Exception {
        this.csOrgUnitUtils.unSelectAllOrgUnit();
    }

    @Override
    protected void btnCsSearch_actionPerformed(ActionEvent e) throws Exception {
        String searchText = this.txtScSearch.getText();
        String inputInfo = EASResource.getString((String)RESOURCE, (String)"inputInfo");
        if (StringUtils.isEmpty((String)searchText) || inputInfo.equals(searchText)) {
            return;
        }
        this.csOrgUnitUtils.serachTree(searchText);
    }

    @Override
    protected void txtScSearch_focusGained(FocusEvent e) throws Exception {
        super.txtScSearch_focusGained(e);
        if (StringUtils.isEmpty((String)this.txtScSearch.getText())) {
            this.txtScSearch.setText(EASResource.getString((String)RESOURCE, (String)"inputInfo"));
        }
    }

    @Override
    protected void txtScSearch_focusLost(FocusEvent e) throws Exception {
        super.txtScSearch_focusLost(e);
        String searchText = this.txtScSearch.getText();
        String inputInfo = EASResource.getString((String)RESOURCE, (String)"inputInfo");
        if (StringUtils.isEmpty((String)searchText) || inputInfo.equals(searchText)) {
            this.csOrgUnitUtils.serachTree(null);
        } else {
            this.csOrgUnitUtils.serachTree(searchText);
        }
    }

    @Override
    protected void kDIsContainSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.kDIsContainSealUp_itemStateChanged(e);
        this.csOrgUnitUtils.rebuildCsTeee(this.kDIsContainSealUp.isSelected(), this.kDIsContainOrgNumber.isSelected());
        this.refreshColorToNode();
    }

    @Override
    protected void kDIsContainOrgNumber_itemStateChanged(ItemEvent e) throws Exception {
        super.kDIsContainOrgNumber_itemStateChanged(e);
        this.csOrgUnitUtils.rebuildCsTeee(this.kDIsContainSealUp.isSelected(), this.kDIsContainOrgNumber.isSelected());
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getModel().getRoot();
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            FullOrgUnitInfo orginfo = null;
            if (node == null || node.getUserObject() == null) continue;
            orginfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
            if (node.getText().indexOf(orginfo.getNumber() + "_") != -1) {
                node.setText(node.getText().substring(node.getText().indexOf(orginfo.getNumber() + "_") + orginfo.getNumber().length() + 1, node.getText().length()));
            }
            if (!this.kDIsContainOrgNumber.isSelected()) continue;
            node.setText(orginfo.getNumber() + "_" + node.getText());
        }
        this.bgOrgUnitUtils.getKdTree().updateUI();
    }

    @Override
    protected void KdShowColorNotAdd_itemStateChanged(ItemEvent e) throws Exception {
        if (1 == e.getStateChange()) {
            this.setColorToNode(true);
        } else {
            this.setColorToNode(false);
        }
    }

    @Override
    protected void kdDesignatedOrg_itemStateChanged(ItemEvent e) throws Exception {
        if (1 == e.getStateChange()) {
            this.kdStructCostCenter.setEnabled(true);
        } else {
            this.kdStructCostCenter.setEnabled(false);
            this.kdStructCostCenter.setSelected(false);
        }
    }

    private void setColorToNode(boolean isSelected) {
        Set<String> currentIds = this.bgOrgUnitUtils.getCcOrgNodeMap().keySet();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.csOrgUnitUtils.getTreeModel().getRoot();
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (node == null || node.getUserObject() == null) continue;
            FullOrgUnitInfo orgInfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
            if (!currentIds.contains(orgInfo.getId().toString()) && isSelected) {
                node.setTextColor(Color.blue);
                continue;
            }
            node.setTextColor(Color.black);
        }
        this.csOrgUnitUtils.getKdTree().updateUI();
    }

    private void refreshColorToNode() {
        long time = System.currentTimeMillis();
        if (this.KdShowColorNotAdd.isSelected()) {
            this.setColorToNode(true);
        } else {
            this.setColorToNode(false);
        }
        logger.info((Object)("---refresh color to node,use time :" + (System.currentTimeMillis() - time) + ".ms---"));
    }

    @Override
    protected void txtBgScearch_focusGained(FocusEvent e) throws Exception {
        super.txtBgScearch_focusGained(e);
        if (StringUtils.isEmpty((String)this.txtBgScearch.getText())) {
            this.txtBgScearch.setText(EASResource.getString((String)RESOURCE, (String)"inputInfo"));
        }
    }

    @Override
    protected void txtBgScearch_focusLost(FocusEvent e) throws Exception {
        super.txtBgScearch_focusLost(e);
        String searchText = this.txtBgScearch.getText();
        String inputInfo = EASResource.getString((String)RESOURCE, (String)"inputInfo");
        if (StringUtils.isEmpty((String)searchText) || inputInfo.equals(searchText)) {
            this.bgOrgUnitUtils.serachTree(null);
        } else {
            this.bgOrgUnitUtils.serachTree(searchText);
        }
    }

    @Override
    protected void btnBgOrgSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnBgOrgSearch_actionPerformed(e);
        String searchText = this.txtBgScearch.getText();
        String inputInfo = EASResource.getString((String)RESOURCE, (String)"inputInfo");
        if (StringUtils.isEmpty((String)searchText) || inputInfo.equals(searchText)) {
            return;
        }
        this.bgOrgUnitUtils.serachTree(searchText);
    }

    @Override
    protected void kDBgOrgTree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kDBgOrgTree_valueChanged(e);
        TreePath[] treePaths = this.bgOrgUnitUtils.getKdTree().getSelectionPaths();
        if (treePaths != null && treePaths.length > 0) {
            this.btnMove.setEnabled(true);
            DefaultKingdeeTreeNode node = null;
            int in = treePaths.length;
            for (int i = 0; i < in; ++i) {
                node = (DefaultKingdeeTreeNode)treePaths[i].getLastPathComponent();
                if (!this.bgOrgUnitUtils.checkVirtualOrg(node)) continue;
                this.btnMove.setEnabled(false);
                break;
            }
        } else {
            this.btnMove.setEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void kDConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.kDConfirm_actionPerformed(e);
        ArrayList<BgOrgUnitInfo> bgOrgUnits = null;
        if (((DefaultKingdeeTreeNode)this.moOrgTree.getModel().getRoot()).getChildCount() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"existMoveOrg"));
            SysUtil.abort();
        }
        this.verify();
        BgOrgViewInfo orgViewInfo = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        Set<String> checkOrgUnitIds = this.bgOrgUnitUtils.getCheckOrgUnitIds();
        BgOrgUnitCollection bgOrgUnitColl = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select id,number,name,orgUnitID where viewId = '" + orgViewInfo.getId().toString() + "' and isLeaf = 1 and isVirtual = 0 order by longNumber");
        LinkedHashSet<String> leafOrgIds = new LinkedHashSet<String>();
        if (bgOrgUnitColl != null && !bgOrgUnitColl.isEmpty()) {
            int in = bgOrgUnitColl.size();
            for (int i = 0; i < in; ++i) {
                leafOrgIds.add(bgOrgUnitColl.get(i).getOrgUnitID());
            }
        }
        List<BgOrgUnitInfo> allOrgUnits = BgOrgUnitUtils.getAllOrgUnits(this.bgOrgUnitUtils.getOrgUnits(orgViewInfo.getOrgUnit().getId().toString()));
        Map<String, List<BgOrgUnitInfo>> parentOrgUnits = BgOrgUnitUtils.getParentOrgUnits(allOrgUnits, false);
        Set<String> keySet = parentOrgUnits.keySet();
        LinkedHashSet<String> oldLeafOrgIds = new LinkedHashSet<String>(leafOrgIds.size());
        oldLeafOrgIds.addAll(leafOrgIds);
        oldLeafOrgIds.removeAll(keySet);
        LinkedHashSet<String> newLeafOrgIds = new LinkedHashSet<String>(keySet.size());
        newLeafOrgIds.addAll(keySet);
        newLeafOrgIds.removeAll(leafOrgIds);
        for (Map.Entry<String, List<BgOrgUnitInfo>> entry : parentOrgUnits.entrySet()) {
            String newOrgId = entry.getKey();
            List<BgOrgUnitInfo> parents = entry.getValue();
            for (BgOrgUnitInfo bgOrgUnitInfo : parents) {
                if (!leafOrgIds.contains(bgOrgUnitInfo.getOrgUnitID())) continue;
                newLeafOrgIds.add(newOrgId);
            }
        }
        this.filterNewLeafOrgUnits(newLeafOrgIds, parentOrgUnits);
        LinkedHashMap<String, ArrayList<BgOrgUnitInfo>> oldRefNewOrgUnits = new LinkedHashMap<String, ArrayList<BgOrgUnitInfo>>();
        LinkedHashMap<String, BgOrgUnitInfo> oldOrgUnits = new LinkedHashMap<String, BgOrgUnitInfo>();
        for (BgOrgUnitInfo info : allOrgUnits) {
            if (!oldLeafOrgIds.contains(info.getOrgUnitID()) || info.isIsVirtual()) continue;
            bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
            bgOrgUnits.add(info);
            List<BgOrgUnitInfo> childs = BgOrgUnitUtils.getAllOrgUnits(bgOrgUnits);
            bgOrgUnits.clear();
            for (BgOrgUnitInfo childrenInfo : childs) {
                if (!newLeafOrgIds.contains(childrenInfo.getOrgUnitID()) || childrenInfo.isIsVirtual()) continue;
                bgOrgUnits.add(childrenInfo);
                oldRefNewOrgUnits.put(info.getOrgUnitID(), bgOrgUnits);
            }
            oldOrgUnits.put(info.getOrgUnitID(), info);
        }
        IUIWindow window = null;
        List bgSchemes = BgOrgUnitFacadeFactory.getRemoteInstance().getBgSchemesByOrgViewId(orgViewInfo.getId().toString());
        if (oldRefNewOrgUnits != null && !oldRefNewOrgUnits.isEmpty()) {
            Set entrySet = oldRefNewOrgUnits.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                if (checkOrgUnitIds == null || checkOrgUnitIds.contains(key)) continue;
                iterator.remove();
            }
        }
        if (oldRefNewOrgUnits != null && !oldRefNewOrgUnits.isEmpty() && bgSchemes != null && !bgSchemes.isEmpty()) {
            UIContext context = new UIContext((Object)this);
            context.put((Object)"oldRefNewOrgUnits", oldRefNewOrgUnits);
            context.put((Object)"oldOrgUnits", oldOrgUnits);
            context.put((Object)"hasDataOrgUnitIds", checkOrgUnitIds);
            context.put((Object)"BGORGVIEW_INFO", (Object)orgViewInfo);
            context.put((Object)"parentOrgUnits", parentOrgUnits);
            window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgOrgMigrationUI.class.getName(), (Map)context, null, OprtState.EDIT);
            window.show();
        }
        if (window != null) {
            if (!((BgOrgMigrationUI)window.getUIObject()).isCancel()) {
                void var17_26;
                List<BgOrgUnitInfo[]> migOrgUnit = ((BgOrgMigrationUI)window.getUIObject()).getResult();
                Object var17_24 = null;
                try {
                    Map map = BgOrgUnitFacadeFactory.getRemoteInstance().executeMigration(migOrgUnit, orgViewInfo.getId().toString(), this.bgOrgUnitUtils.getOrgUnits(orgViewInfo.getOrgUnit().getId().toString()));
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"migrationException", (Object[])new Object[]{e1.getMessage()}));
                    SysUtil.abort();
                }
                UIContext context = new UIContext((Object)this);
                context.put((Object)"BgMigrationUI", (Object)window.getUIObject());
                context.put((Object)"migrationResult", (Object)var17_26);
                window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgOrgMigrationReportUI.class.getName(), (Map)context, null, OprtState.EDIT);
                window.show();
                this.submit = true;
                this.getUIWindow().close();
            }
        } else {
            this.getBizInterface().batchUpdate(orgViewInfo.getId(), this.bgOrgUnitUtils.getOrgUnits(orgViewInfo.getOrgUnit().getId().toString()));
            this.submit = true;
            this.getUIWindow().close();
        }
    }

    private void filterOldLeafOrgUnits(Set<String> checkOrgUnitIds, Set<String> oldLeafOrgIds) {
        if (checkOrgUnitIds == null || oldLeafOrgIds == null) {
            return;
        }
        String orgUnitId = null;
        Iterator<String> iter = oldLeafOrgIds.iterator();
        while (iter.hasNext()) {
            orgUnitId = iter.next();
            if (checkOrgUnitIds.contains(orgUnitId)) continue;
            iter.remove();
        }
    }

    private void filterNewLeafOrgUnits(Set<String> newLeafOrgIds, Map<String, List<BgOrgUnitInfo>> parentOrgUnits) {
        if (newLeafOrgIds == null || parentOrgUnits == null) {
            return;
        }
        String orgUnitId = null;
        Iterator<Map.Entry<String, List<BgOrgUnitInfo>>> iter = parentOrgUnits.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, List<BgOrgUnitInfo>> entry = iter.next();
            orgUnitId = entry.getKey();
            if (newLeafOrgIds.contains(orgUnitId)) continue;
            iter.remove();
        }
    }

    @Override
    protected void kdExit_actionPerformed(ActionEvent e) throws Exception {
        int re;
        super.kdExit_actionPerformed(e);
        boolean check = true;
        if (((DefaultKingdeeTreeNode)this.moOrgTree.getModel().getRoot()).getChildCount() > 0 && ((re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"hasMoveOrg"))) == 1 || re == 2)) {
            check = false;
        }
        if (check) {
            this.getUIWindow().close();
        }
    }

    protected void verify() throws Exception {
        this.bgOrgUnitUtils.checkAllTreeNode();
        List<DefaultKingdeeTreeNode> nodes = this.bgOrgUnitUtils.getAllNode();
        for (DefaultKingdeeTreeNode node : nodes) {
            if (!this.bgOrgUnitUtils.checkVirtualOrg(node)) continue;
            this.bgOrgUnitUtils.checkParentNode(node, (DefaultKingdeeTreeNode)node.getParent());
            this.bgOrgUnitUtils.checkChildNode(node);
            this.bgOrgUnitUtils.checkVirtualNode(node);
        }
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getTreeModel().getRoot();
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            Map<String, DefaultKingdeeTreeNode> virNodeMap = this.bgOrgUnitUtils.getVirtualNodes(node);
            this.bgOrgUnitUtils.checkVirtualNode(node, virNodeMap);
        }
        if (!this.currentNodesIsExistCostOrg()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"addfailed", (Object[])new Object[]{(String)this.getUIContext().get("name")}));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddAll_actionPerformed(e);
        if (this.checkBgOrgTreeIsEmpty() && this.bgOrgUnitUtils != null) {
            IOrgCheckListener l = this.bgOrgUnitUtils.getOrgCheckListener();
            try {
                this.bgOrgUnitUtils.setOrgCheckListener(null);
                this.unitHelper.copyFromCsTree(this.csOrgUnitUtils, this.bgOrgUnitUtils);
            }
            finally {
                this.bgOrgUnitUtils.setOrgCheckListener(l);
            }
        }
    }

    protected boolean checkBgOrgTreeIsEmpty() {
        TreeModel obj = this.kDBgOrgTree.getModel();
        return obj == null || obj.getRoot() == null || ((DefaultKingdeeTreeNode)obj.getRoot()).getChildCount() == 0;
    }

    protected void checkAddAllFunction() {
        this.btnAddAll.setEnabled(this.checkBgOrgTreeIsEmpty());
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        if (this.isMove()) {
            this.moveTo();
        } else {
            this.addNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode() throws Exception {
        List<DefaultKingdeeTreeNode> orgUnits = this.csOrgUnitUtils.getSelectNodes();
        if (orgUnits == null || orgUnits.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"selectOrg"));
            return;
        }
        DefaultKingdeeTreeNode root = null;
        if (this.kdDesignatedOrg.isSelected()) {
            TreePath[] treePaths = this.bgOrgUnitUtils.getKdTree().getSelectionPaths();
            if (this.kdStructCostCenter.isSelected()) {
                if (treePaths == null || treePaths.length == 0 || treePaths.length > 1) {
                    DefaultKingdeeTreeNode modelNode = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getModel().getRoot();
                    if (modelNode.getChildCount() == 1) {
                        root = (DefaultKingdeeTreeNode)modelNode.getChildAt(0);
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"selectSingleBgOrgUnit"));
                    }
                } else {
                    root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getSelectionPath().getLastPathComponent();
                }
            } else if (treePaths == null || treePaths.length == 0 || treePaths.length > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"selectSingleBgOrgUnit"));
            } else {
                root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getSelectionPath().getLastPathComponent();
            }
        } else {
            root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getModel().getRoot();
        }
        if (this.bgOrgUnitUtils.getOrgUnit(root) != null && this.bgOrgUnitUtils.getOrgUnit(root).isIsOUSealUp()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"cantAddForSealUp"));
            return;
        }
        if (!this.currentNodesIsExistCostOrg() && !this.addNodesIsExistCostOrg(orgUnits)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"addfailed", (Object[])new Object[]{(String)this.getUIContext().get("name")}));
            return;
        }
        try {
            if (this.kdStructCostCenter.isSelected()) {
                StringBuilder errMsg = new StringBuilder();
                this.bgOrgUnitUtils.addSelectNodesByStructCostCenter(root, orgUnits, true, errMsg);
                if (errMsg.length() > 0) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"addPartFail"), (String)errMsg.toString(), (int)1);
                }
            } else {
                this.bgOrgUnitUtils.addSelectNodes(root, orgUnits, true);
            }
            if (this.kDIsContainOrgNumber.isSelected() && root != null) {
                Enumeration nodeEnum = root.breadthFirstEnumeration();
                DefaultKingdeeTreeNode node = null;
                while (nodeEnum.hasMoreElements()) {
                    node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
                    FullOrgUnitInfo orginfo = null;
                    if (node == null || node.getUserObject() == null) continue;
                    orginfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
                    if (node.getText().indexOf(orginfo.getNumber() + "_") != -1) {
                        node.setText(node.getText().substring(node.getText().indexOf(orginfo.getNumber() + "_") + orginfo.getNumber().length() + 1, node.getText().length()));
                    }
                    if (!this.kDIsContainOrgNumber.isSelected()) continue;
                    node.setText(orginfo.getNumber() + "_" + node.getText());
                }
            }
            this.bgOrgUnitUtils.getKdTree().updateUI();
            this.bgOrgUnitUtils.expandNode(root);
            this.checkAddAllFunction();
            this.checkIsEmptyCcOrgNodeMap();
            this.refreshColorToNode();
        }
        finally {
            this.csOrgUnitUtils.unSelectAllOrgUnit();
        }
    }

    private boolean addNodesIsExistCostOrg(List<DefaultKingdeeTreeNode> orgUnits) {
        String costOrgID = (String)this.getUIContext().get("ORGUNIT_ID");
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getModel().getRoot();
        if (orgUnits != null) {
            for (int i = 0; i < orgUnits.size(); ++i) {
                DefaultKingdeeTreeNode node = orgUnits.get(i);
                if (StringUtils.isEmpty((String)costOrgID) || !costOrgID.equals(this.bgOrgUnitUtils.getOrgUnit(node).getId().toString()) && !costOrgID.equals(this.bgOrgUnitUtils.getOrgUnit(node).get("orgunitid"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean currentNodesIsExistCostOrg() {
        String costOrgID = (String)this.getUIContext().get("ORGUNIT_ID");
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getModel().getRoot();
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (StringUtils.isEmpty((String)costOrgID) || !costOrgID.equals(this.bgOrgUnitUtils.getOrgUnit(node).getId().toString()) && !costOrgID.equals(this.bgOrgUnitUtils.getOrgUnit(node).get("orgunitid"))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        TreePath[] treePaths = this.bgOrgUnitUtils.getKdTree().getSelectionPaths();
        if (treePaths == null || treePaths.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgOrgUnitHelper.getBgOrgMsg("selectOrgFromView"));
        } else {
            DefaultKingdeeTreeNode[] nodes = new DefaultKingdeeTreeNode[treePaths.length];
            int in = treePaths.length;
            for (int i = 0; i < in; ++i) {
                nodes[i] = (DefaultKingdeeTreeNode)treePaths[i].getLastPathComponent();
                this.bgOrgUnitUtils.removeNode(nodes[i]);
            }
            this.checkAddAllFunction();
            this.checkIsEmptyCcOrgNodeMap();
            this.refreshColorToNode();
        }
    }

    @Override
    protected void btnMove_actionPerformed(ActionEvent e) throws Exception {
        super.btnMove_actionPerformed(e);
        this.moveTo();
    }

    protected void moveTo() throws Exception {
        TreePath[] treePaths = this.bgOrgUnitUtils.getKdTree().getSelectionPaths();
        if (treePaths == null || treePaths.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgOrgUnitHelper.getBgOrgMsg("selectOrgFromView"));
        } else {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.moOrgUnitUtils.getKdTree().getModel().getRoot();
            DefaultKingdeeTreeNode node = null;
            DefaultKingdeeTreeNode hisNode = null;
            ArrayList<DefaultKingdeeTreeNode> list = new ArrayList<DefaultKingdeeTreeNode>();
            int in = treePaths.length;
            for (int i = 0; i < in; ++i) {
                node = (DefaultKingdeeTreeNode)treePaths[i].getLastPathComponent();
                list.add(node);
                if (!this.addNodesIsExistCostOrg(list)) continue;
                list.clear();
                if (this.isMove()) {
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"movefailed", (Object[])new Object[]{(String)this.getUIContext().get("name")}));
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"addorgFail", (Object[])new Object[]{(String)this.getUIContext().get("name")}));
                }
                return;
            }
            if (!this.isMove()) {
                this.openMove();
            }
            ArrayList<DefaultKingdeeTreeNode> nodes = new ArrayList<DefaultKingdeeTreeNode>();
            FullOrgUnitInfo bgOrgUnit = null;
            FullOrgUnitInfo hisOrgUnit = null;
            int in2 = treePaths.length;
            for (int i = 0; i < in2; ++i) {
                node = (DefaultKingdeeTreeNode)treePaths[i].getLastPathComponent();
                if (nodes.isEmpty()) {
                    nodes.add(node);
                    continue;
                }
                bgOrgUnit = this.bgOrgUnitUtils.getOrgUnit(node);
                int jn = nodes.size();
                for (int j = 0; j < jn; ++j) {
                    hisNode = (DefaultKingdeeTreeNode)nodes.get(j);
                    hisOrgUnit = this.bgOrgUnitUtils.getOrgUnit(hisNode);
                    if (bgOrgUnit.getString("longNumber").startsWith(hisOrgUnit.getString("longNumber") + "!")) continue;
                    nodes.add(node);
                }
            }
            this.bgOrgUnitUtils.moveToNodes(this.moOrgUnitUtils.getKdTree().getModel(), root, this.bgOrgUnitUtils.getKdTree().getModel(), nodes);
            this.moOrgUnitUtils.expandNode(root);
        }
    }

    @Override
    protected void btnMoveBack_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveBack_actionPerformed(e);
        this.moveBack();
    }

    protected void moveBack() throws Exception {
        List<DefaultKingdeeTreeNode> nodes = this.moOrgUnitUtils.getSelectNodes();
        if (nodes == null || nodes.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"selectOrg"));
            return;
        }
        DefaultKingdeeTreeNode root = null;
        TreePath[] treePaths = this.bgOrgUnitUtils.getKdTree().getSelectionPaths();
        if (treePaths == null || treePaths.length == 0 || treePaths.length > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"selectSingleBgOrgUnit"));
        } else {
            DefaultKingdeeTreeNode path = (DefaultKingdeeTreeNode)treePaths[0].getLastPathComponent();
            if (this.bgOrgUnitUtils.getOrgUnit(path) != null && this.bgOrgUnitUtils.getOrgUnit(path).isIsOUSealUp()) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"cantAddForSealUp"));
                return;
            }
            root = (DefaultKingdeeTreeNode)this.bgOrgUnitUtils.getKdTree().getSelectionPath().getLastPathComponent();
            this.bgOrgUnitUtils.moveBackNodes(this.bgOrgUnitUtils.getKdTree().getModel(), root, this.moOrgUnitUtils.getKdTree().getModel(), nodes, this.kDIsContainOrgNumber.isSelected());
            root = (DefaultKingdeeTreeNode)this.moOrgTree.getModel().getRoot();
            if (root.getChildCount() == 0) {
                this.closeMove();
            }
        }
    }

    protected void openMove() {
        this.ccPanel.setVisible(false);
        Rectangle bgRect = this.bgPanel.getBounds();
        bgRect.x = 1;
        this.bgPanel.setBounds(bgRect);
        this.moPanel.setVisible(true);
        this.btnAddAll.setVisible(false);
        this.btnAddAll.setEnabled(false);
        this.btnMoveBack.setVisible(true);
        this.btnMoveBack.setEnabled(true);
        this.kdDesignatedOrg.setEnabled(false);
        this.kdStructCostCenter.setEnabled(false);
        this.setUITitle(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"orgMoveTitle"));
    }

    protected void closeMove() {
        this.ccPanel.setVisible(true);
        Rectangle bgRect = this.bgPanel.getBounds();
        bgRect.x = 530;
        this.bgPanel.setBounds(bgRect);
        this.moPanel.setVisible(false);
        this.btnAddAll.setVisible(true);
        this.btnAddAll.setEnabled(true);
        this.btnMoveBack.setVisible(false);
        this.btnMoveBack.setEnabled(false);
        this.kdDesignatedOrg.setEnabled(true);
        this.kdStructCostCenter.setEnabled(true);
        this.setUITitle(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"orgSetTitle"));
    }

    protected boolean isMove() {
        return this.moPanel.isVisible();
    }

    @Override
    protected void btnMoSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoSelectAll_actionPerformed(e);
        this.moOrgUnitUtils.selectAllOrgUnit();
    }

    @Override
    protected void btnMoClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoClearAll_actionPerformed(e);
        this.moOrgUnitUtils.unSelectAllOrgUnit();
    }

    private DefaultKingdeeTreeNode getBaseOrgBySelectVirtualNode(KDTree kDBgOrgTree, BgOrgUnitInfo selectBgOrgInfo) {
        Object root;
        Object object = root = kDBgOrgTree == null || kDBgOrgTree.getModel() == null ? null : kDBgOrgTree.getModel().getRoot();
        if (root == null || selectBgOrgInfo == null) {
            return null;
        }
        DefaultKingdeeTreeNode nodeTarget = null;
        String bgOrgUnitID = selectBgOrgInfo.getOrgUnitID();
        String orgUnitId = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        Object curBgOrgUnitInfo = null;
        if (root != null && root instanceof DefaultKingdeeTreeNode) {
            Enumeration enumTarget = ((DefaultKingdeeTreeNode)root).breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                bgOrgUnitInfo = (BgOrgUnitInfo)nodeTarget.getUserObject();
                orgUnitId = bgOrgUnitInfo.getOrgUnitID();
                if (!bgOrgUnitID.equals(orgUnitId) || bgOrgUnitInfo.isIsVirtual()) continue;
                return nodeTarget;
            }
        }
        return null;
    }

    private DefaultKingdeeTreeNode getSelectedTreeRoot(KDTree kDBgOrgTree, DefaultKingdeeTreeNode selectedNode) {
        DefaultKingdeeTreeNode curNode = null;
        if (selectedNode.getLevel() == 1) {
            return selectedNode;
        }
        curNode = (DefaultKingdeeTreeNode)selectedNode.getParent();
        selectedNode = this.getSelectedTreeRoot(kDBgOrgTree, curNode);
        return selectedNode;
    }

    private Set<DefaultKingdeeTreeNode> getSelectedOrgTreeSet(KDTree bgOrgTree, DefaultKingdeeTreeNode selectedNode) {
        if (selectedNode == null) {
            return null;
        }
        HashSet<DefaultKingdeeTreeNode> orgTreeSet = new HashSet<DefaultKingdeeTreeNode>();
        DefaultKingdeeTreeNode selectedOrg = null;
        Enumeration enumTarget = selectedNode.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            selectedOrg = (DefaultKingdeeTreeNode)enumTarget.nextElement();
            orgTreeSet.add(selectedOrg);
        }
        return orgTreeSet;
    }

    private void checkOrgRepeat(Set<DefaultKingdeeTreeNode> bgOrgTreeSet, Set<DefaultKingdeeTreeNode> csOrgNodeSet) {
        Map<Object, Object> costCenterSelectedIds = new HashMap();
        Map<Object, Object> bgOrgTreeIds = new HashMap();
        HashSet<Object> intersection = new HashSet<Object>();
        bgOrgTreeIds = this.getTreeNodeIds(bgOrgTreeSet);
        costCenterSelectedIds = this.getTreeNodeIds(csOrgNodeSet);
        intersection.addAll(bgOrgTreeIds.keySet());
        intersection.retainAll(costCenterSelectedIds.keySet());
        StringBuffer buffer = new StringBuffer();
        Object var7_7 = null;
        for (String string : intersection) {
            buffer.append(((FullOrgUnitInfo)costCenterSelectedIds.get(string)).getName()).append(",");
        }
        if (!intersection.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"repeatOrgOnTree", (Object[])new Object[]{buffer.subSequence(0, buffer.length() - 1)}));
            SysUtil.abort();
        }
    }

    private Map<String, Object> getTreeNodeIds(Set<DefaultKingdeeTreeNode> bgOrgTreeSet) {
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        if (bgOrgTreeSet.size() == 0) {
            return orgMap;
        }
        DefaultKingdeeTreeNode curNode2 = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        for (DefaultKingdeeTreeNode curNode2 : bgOrgTreeSet) {
            if (curNode2.getUserObject() instanceof OrgStructureInfo) {
                structureInfo = (OrgStructureInfo)curNode2.getUserObject();
                fullOrgUnitInfo = structureInfo.getUnit();
                orgMap.put(fullOrgUnitInfo.getId().toString(), fullOrgUnitInfo);
                continue;
            }
            if (!(curNode2.getUserObject() instanceof BgOrgUnitInfo)) continue;
            bgOrgUnitInfo = (BgOrgUnitInfo)curNode2.getUserObject();
            orgMap.put(bgOrgUnitInfo.getOrgUnitID(), bgOrgUnitInfo);
        }
        return orgMap;
    }

    private void checkNotShareSubOrg(Set<String> subCostCenterNodeCols, Set<DefaultKingdeeTreeNode> csOrgNodeSet, BgOrgUnitInfo unitInfo) {
        if (csOrgNodeSet.size() == 0) {
            return;
        }
        DefaultKingdeeTreeNode curNode2 = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        String orgUnitId = null;
        boolean isAllSelectedNodeExist = true;
        ArrayList<String> notSubOrg = new ArrayList<String>();
        for (DefaultKingdeeTreeNode curNode2 : csOrgNodeSet) {
            structureInfo = (OrgStructureInfo)curNode2.getUserObject();
            fullOrgUnitInfo = structureInfo.getUnit();
            orgUnitId = fullOrgUnitInfo.getId().toString();
            if (subCostCenterNodeCols.contains(orgUnitId)) continue;
            isAllSelectedNodeExist = false;
            notSubOrg.add(fullOrgUnitInfo.getName());
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < notSubOrg.size(); ++i) {
            buffer.append((String)notSubOrg.get(i)).append(",");
        }
        if (!isAllSelectedNodeExist) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cantBeSubOrg", (Object[])new Object[]{buffer.subSequence(0, buffer.length() - 1), unitInfo.getName(), unitInfo.getName()}));
            SysUtil.abort();
        }
    }

    private void checkHasCurOrgRoot(Set<DefaultKingdeeTreeNode> selectedNodes) {
        String orgUnitId = (String)this.getUIContext().get("ORGUNIT_ID");
        TreeModel obj = this.kDBgOrgTree.getModel();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)obj.getRoot();
        DefaultKingdeeTreeNode selectedNode2 = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        String curSelectedOrgId = null;
        boolean isEmptyBgOrgTree = node.getChildCount() == 0;
        boolean hasCurOrgNode = false;
        if (isEmptyBgOrgTree) {
            for (DefaultKingdeeTreeNode selectedNode2 : selectedNodes) {
                structureInfo = (OrgStructureInfo)selectedNode2.getUserObject();
                fullOrgUnitInfo = structureInfo.getUnit();
                curSelectedOrgId = fullOrgUnitInfo.getId().toString();
                if (!curSelectedOrgId.equals(orgUnitId)) continue;
                hasCurOrgNode = true;
                break;
            }
            if (!hasCurOrgNode) {
                String msg = BgOrgUnitHelper.getBgOrgMsg("mustBeOrgViewRoot");
                BgOrgSetUI.showWarningAndAbort((Component)((Object)this), msg);
            }
        }
    }

    private void showReportUI(Map<String, String> resultMap) throws UIException {
        BgOrgViewInfo info = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        if (info != null && resultMap != null && !resultMap.isEmpty()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGORGSET_RESULT", resultMap);
            uiContext.put((Object)"BGORGVIEW_INFO", (Object)info);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getReportUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    public static void showWarningAndAbort(Component comp, String warning) {
        MsgBox.showWarning((Component)comp, (String)warning);
        SysUtil.abort();
    }

    protected String getReportUIName() {
        return BgOrgSetReportUI.class.getName();
    }

    private SuperOrgParam getCommSuperOrgParam(Set<DefaultKingdeeTreeNode> csOrgNodeSet) {
        if (csOrgNodeSet == null || csOrgNodeSet.isEmpty()) {
            return null;
        }
        int level = -1;
        DefaultKingdeeTreeNode treeNode2 = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo orgInfo = null;
        SuperOrgParam param = null;
        String longNumber = null;
        for (DefaultKingdeeTreeNode treeNode2 : csOrgNodeSet) {
            structureInfo = (OrgStructureInfo)treeNode2.getUserObject();
            orgInfo = structureInfo.getUnit();
            longNumber = orgInfo.getLongNumber();
            level = structureInfo.getLevel();
            if (param == null) {
                param = new SuperOrgParam(longNumber, true, level, treeNode2);
                continue;
            }
            param.update(longNumber, level, treeNode2);
        }
        return param;
    }

    protected void checkSpecipyHasRefBgData(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        if (this.helper.getRefBgDataOrgMap().containsKey(info.getId().toString()) && info.isIsLeaf()) {
            String msg = BgOrgUnitHelper.getBgOrgMsg("hasBgData");
            msg = MessageFormat.format(msg, info.getName());
            BgOrgSetUI.showWarningAndAbort((Component)((Object)this), msg);
        }
    }

    protected void checkResHasRefBgData(Collection<BgOrgUnitInfo> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (BgOrgUnitInfo info : collection) {
            if (!this.helper.getRefBgDataOrgMap().containsKey(info.getId().toString()) || info.isIsLeaf()) continue;
            String msg = BgOrgUnitHelper.getBgOrgMsg("hasBgData");
            msg = MessageFormat.format(msg, info.getName());
            BgOrgSetUI.showWarningAndAbort((Component)((Object)this), msg);
        }
    }

    protected void modifyInfoForChild(BgOrgUnitInfo info, BgOrgUnitInfo parentInfo) {
        if (info == null || parentInfo == null) {
            return;
        }
        String newLongNumber = parentInfo.getLongNumber() + "!" + info.getNumber();
        info.setIsLeaf(true);
        info.setLongNumber(newLongNumber);
        info.setParent(parentInfo);
        info.setLevel(parentInfo.getLevel() + 1);
        if (parentInfo.isIsLeaf()) {
            parentInfo.setIsLeaf(false);
            this.helper.addOpt(parentInfo);
        }
        this.helper.addOpt(info);
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.helper != null) {
            this.helper.clear();
        }
        try {
            BgOrgUnitHelper.releaseMutex(null, this.viewId);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    protected void checkBeforeConfirm() throws EASBizException, BOSException {
        Set<BgOrgUnitInfo> bgOrgSet = BgOrgTreeHelper.getAllLeafNodeUserObject(this.kDBgOrgTree);
        HashSet<String> idSet = new HashSet<String>();
        for (BgOrgUnitInfo info : bgOrgSet) {
            idSet.add(info.getOrgUnitID());
        }
        String msg = null;
        for (BgOrgUnitInfo info : this.helper.getRefBgDataOrgMap().values()) {
            if (idSet.contains(info.getOrgUnitID())) continue;
            msg = BgOrgUnitHelper.getBgOrgMsg("hasBgData");
            msg = MessageFormat.format(msg, info.getName());
            BgOrgSetUI.showWarningAndAbort((Component)((Object)this), msg);
        }
        this.checkCurOrgInBgOrgTree();
    }

    private void checkCurOrgInBgOrgTree() {
        String orgUnitId = (String)this.getUIContext().get("ORGUNIT_ID");
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.kDBgOrgTree.getModel().getRoot();
        DefaultKingdeeTreeNode curNode = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        if (rootNode.getChildCount() == 0) {
            return;
        }
        boolean canSave = false;
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            curNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            bgOrgUnitInfo = (BgOrgUnitInfo)curNode.getUserObject();
            if (bgOrgUnitInfo == null || !orgUnitId.equals(bgOrgUnitInfo.getOrgUnitID()) || bgOrgUnitInfo.isIsVirtual()) continue;
            canSave = true;
            break;
        }
        if (!canSave) {
            String msg = BgOrgUnitHelper.getBgOrgMsg("mustBeOrgViewRoot");
            BgOrgSetUI.showWarningAndAbort((Component)((Object)this), msg);
        }
    }

    protected IBgOrgUnit getBizInterface() throws BOSException {
        return BgOrgUnitFactory.getRemoteInstance();
    }

    private void updateLastestTreeModel(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        this.kDCSTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)((DefaultKingdeeTreeNode)this.kDCSTree.getModel().getRoot())));
        this.kDCSTree.updateUI();
    }

    private void setAllNodeLoaded(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        Enumeration enumList = node.breadthFirstEnumeration();
        DefaultKingdeeTreeNode curNode = null;
        OrgStructureInfo orgStructureInfo = null;
        while (enumList.hasMoreElements()) {
            curNode = (DefaultKingdeeTreeNode)enumList.nextElement();
            orgStructureInfo = (OrgStructureInfo)curNode.getUserObject();
            if (orgStructureInfo == null || orgStructureInfo.getUnit().isIsLeaf()) continue;
            orgStructureInfo.put("isChildLoad", (Object)true);
        }
    }

    private void addAllChildNodesToNode(DefaultKingdeeTreeNode curNodeTreeNode, DefaultKingdeeTreeNode node) {
        if (curNodeTreeNode == null || node == null) {
            return;
        }
        node.removeAllChildren();
        while (curNodeTreeNode.children().hasMoreElements()) {
            node.add((MutableTreeNode)((DefaultKingdeeTreeNode)curNodeTreeNode.children().nextElement()));
        }
    }

    private void enableKDDesignatedOrg() {
        this.kdDesignatedOrg.setEnabled(true);
    }

    private void disableKDDesignatedOrg() {
        this.kdDesignatedOrg.setEnabled(false);
        this.kdDesignatedOrg.setSelected(false);
    }

    class SuperOrgParam {
        private String longNumber;
        private boolean isSuperOrg;
        private int level;
        private DefaultKingdeeTreeNode node;
        private Set<String> longNumSet = new HashSet<String>();

        public SuperOrgParam(String longNumber, boolean isSuperOrg, int level, DefaultKingdeeTreeNode node) {
            this.longNumber = longNumber;
            this.isSuperOrg = isSuperOrg;
            this.level = level;
            this.node = node;
            this.longNumSet.add(longNumber);
        }

        public void update(String _LongNumber, int _Level, DefaultKingdeeTreeNode _Node) {
            if (StringUtils.isEmpty((String)_LongNumber) || this.longNumber.equals(_LongNumber)) {
                return;
            }
            this.longNumSet.add(_LongNumber);
            if (this.level == _Level || this.level < _Level && !_LongNumber.startsWith(this.longNumber)) {
                this.isSuperOrg = false;
            } else if (this.level > _Level) {
                this.longNumber = _LongNumber;
                this.isSuperOrg = true;
                this.level = _Level;
                this.node = _Node;
                for (String lonNumber : this.longNumSet) {
                    if (lonNumber.startsWith(this.longNumber)) continue;
                    this.isSuperOrg = false;
                    break;
                }
            }
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public boolean isSuperOrg() {
            return this.isSuperOrg;
        }

        public int getLevel() {
            return this.level;
        }

        public DefaultKingdeeTreeNode getNode() {
            return this.node;
        }
    }
}

