/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.client.AbstractBgOrgViewF7UI;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgOrgViewF7UI
extends AbstractBgOrgViewF7UI {
    private static final long serialVersionUID = -2574520929681540702L;
    private static final Logger logger = CoreUIObject.getLogger(BgOrgViewF7UI.class);
    private boolean isCancel = true;
    private BgOrgViewInfo resultValue = null;
    private String orgUnitID = SysContext.getSysContext().getCurrentCostUnit().getId().toString();

    public void setOrgUnitID(String orgUnitID) {
        this.orgUnitID = orgUnitID;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgOrgViewInfo getresultValue() {
        return this.resultValue;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("ORGUNIT_ID") != null) {
            this.orgUnitID = (String)this.getUIContext().get("ORGUNIT_ID");
        }
        this.btnEleSearch.setText("");
        this.btnEleSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.tblMain.checkParsed();
        super.onLoad();
        this.colSetLocked();
    }

    private void colSetLocked() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creator.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor ex = super.getQueryExecutor(queryPK, viewInfo);
        return ex;
    }

    private Set getCurrentOrgLongNumber() {
        String[] tmpStrs;
        HashSet<String> numbers = null;
        CostCenterOrgUnitInfo info = SysContext.getSysContext().getCurrentCostUnit();
        String longNumber = info.getLongNumber().toString();
        if (!StringUtils.isEmpty((String)longNumber) && (tmpStrs = longNumber.split("!")) != null) {
            numbers = new HashSet<String>();
            int in = tmpStrs.length;
            for (int i = 0; i < in; ++i) {
                numbers.add(tmpStrs[i]);
            }
        }
        return numbers;
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.bgOrgViewQuery == null) {
            this.bgOrgViewQuery = new EntityViewInfo();
        }
        this.bgOrgViewQuery = this.getEntityViewFilter();
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            IQueryExecutor exec = this.getQueryExecutor(this.bgOrgViewQueryPK, this.bgOrgViewQuery);
            exec.option().isAutoTranslateEnum = true;
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    protected EntityViewInfo getEntityViewFilter() {
        EntityViewInfo result = new EntityViewInfo();
        FilterInfo filter = BgOrgTreeHelper.getBgOrgViewFilter(this.orgUnitID);
        FilterInfo quickSearchFilter = this.getQuickSearchFilter();
        if (quickSearchFilter != null) {
            try {
                filter.mergeFilter(quickSearchFilter, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        result.setFilter(filter);
        return result;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    private void onBtnConfirm() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        String id = iRow.getCell("id").getValue().toString();
        try {
            this.resultValue = this.getBizInterface().getBgOrgViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    protected IBgOrgView getBizInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.tblMain.getRow(currRow);
            String id = iRow.getCell("id").getValue().toString();
            try {
                this.resultValue = this.getBizInterface().getBgOrgViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"selectOrgViewName"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnEleSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnEleSearch_actionPerformed(e);
        this.putDataToKDTable();
    }

    @Override
    protected void txtEleSearchEleSearch_focusLost(FocusEvent e) throws Exception {
        super.txtEleSearchEleSearch_focusLost(e);
        if (StringUtils.isEmpty((String)this.txtEleSearch.getText())) {
            return;
        }
        this.tblMain.removeRows();
        this.putDataToKDTable();
    }

    private void putDataToKDTable() {
        if (this.bgOrgViewQuery == null) {
            this.bgOrgViewQuery = new EntityViewInfo();
        }
        this.tblMain.removeRows();
        this.bgOrgViewQuery.setFilter(this.getQuickSearchFilter());
    }

    private FilterInfo getQuickSearchFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.txtEleSearch.getText().trim().length() > 0) {
            FilterItemInfo item = new FilterItemInfo("number", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("name", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
        }
        return filter;
    }
}

