/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.client.AbstractBgPeriodDecomposeResultUI;
import com.kingdee.eas.ma.mbg.common.BgDecomposeError;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgPeriodDecomposeResultUI
extends AbstractBgPeriodDecomposeResultUI {
    private static final long serialVersionUID = -2026098978303835766L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodDecomposeResultUI.class);
    public static final String ERROR_RESULTS = "ERROR_RESULTS";
    private final String COL_BGORGUNITNAME = "bgOrgUnitName";
    private final String COL_BGSCENARIONAME = "bgScenarioName";
    private final String COL_BGCURRENCYNAME = "currencyName";
    private final String COL_BGELEMENTNAME = "bgElementName";
    private final String COL_BGPERIODNAME = "bgPeriodName";
    private final String COL_BGACCOUNTNAME = "bgAccountName";
    private final String COL_BGMEMBERNAME = "bgMemberName";
    private final String COL_ERROR = "error";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.setMergeColumn();
        super.onLoad();
        if (this.getUIContext().get(ERROR_RESULTS) instanceof List) {
            List results = (List)this.getUIContext().get(ERROR_RESULTS);
            this.fillErrorResults(results);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        IUIWindow window = this.getUIWindow();
        if (window instanceof KDFrame) {
            ((KDFrame)window).setExtendedState(6);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    protected void fillErrorResults(List<BgDecomposeError> results) {
        if (results == null || results.isEmpty()) {
            return;
        }
        IRow row = null;
        BgDecomposeError result = null;
        for (int i = 0; i < results.size(); ++i) {
            result = results.get(i);
            row = this.tblMain.addRow();
            row.getCell("bgOrgUnitName").setValue((Object)result.getBgOrgUnitName());
            row.getCell("bgScenarioName").setValue((Object)result.getBgScenarioName());
            row.getCell("currencyName").setValue((Object)result.getCurrencyName());
            row.getCell("bgElementName").setValue((Object)result.getBgElementName());
            row.getCell("bgPeriodName").setValue((Object)result.getBgPeriodName());
            row.getCell("bgAccountName").setValue((Object)result.getAccountStr());
            row.getCell("bgMemberName").setValue((Object)result.getMemberStr());
            row.getCell("error").setValue((Object)result.getErrorStr());
        }
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"bgOrgUnitName", "bgScenarioName", "currencyName", "bgElementName", "bgPeriodName", "bgAccountName", "bgMemberName"};
        return columns;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"exportTitle"));
        fc.setFileFilter((FileFilter)new ExcelFile());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFile(new File(BgCommHelper.getDefaultDirtory() + "//" + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"exportResult") + ".xls"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                if (!file.delete()) {
                    MsgBox.showError((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"cantEditByFile"));
                    return;
                }
            }
            try {
                KDSBook kdsBook = new KDSBook(file.getPath());
                KDSSheet kdsSheet = this.tblMain.getIOManager().saveToKDSSheet(kdsBook, true, false, "Sheet1");
                kdsBook.addSheet(null, kdsSheet);
                ExportManager em = new ExportManager();
                em.exportToExcel(kdsBook, file.getPath());
            }
            catch (Exception ex) {
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    protected String getKeyFieldName() {
        return "bgOrgUnitName";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

