/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgPeriodNameEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgPeriodNameEditUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class BgPeriodNameEditUI
extends AbstractBgPeriodNameEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodNameEditUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDButtonGroup1.add((AbstractButton)this.curOrgUnit);
        this.kDButtonGroup1.add((AbstractButton)this.rbImmOrgUnit);
        this.kDButtonGroup1.add((AbstractButton)this.rbAllOrgUnit);
        this.kDButtonGroup1.add((AbstractButton)this.rbLevelOrgUnit);
        this.curOrgUnit.setSelected(true);
        this.initBgOrgUnitF7();
    }

    protected void initBgOrgUnitF7() throws BOSException, Exception {
        BgOrgViewInfo info = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        String viewId = info.getId().toString();
        BgOrgUnitInfo orgUnitInfo = (BgOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        BgNewOrgDialog dialog = new BgNewOrgDialog((IUIObject)this);
        dialog.setBgOrgViewId(viewId);
        this.prmtCU.setData((Object)orgUnitInfo);
        this.prmtCU.setSelector((KDPromptSelector)dialog);
        this.prmtCU.setEditable(false);
    }

    protected IObjectValue createNewData() {
        BgOrgUnitInfo Info = new BgOrgUnitInfo();
        Info.setId(BOSUuid.create((BOSObjectType)Info.getBOSType()));
        Info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        Info.setCU(currentCtrlUnit);
        return Info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgOrgUnitFactory.getRemoteInstance();
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BgOrgUnitInfo curbgOrgUnitInfo = (BgOrgUnitInfo)this.prmtCU.getData();
        this.setDataObject((IObjectValue)curbgOrgUnitInfo);
        this.checkCurOrgIsEmpty(curbgOrgUnitInfo);
        super.actionSubmit_actionPerformed(e);
        this.prmtCU.setData((Object)curbgOrgUnitInfo);
    }

    public IObjectPK runSubmit() throws Exception {
        BgOrgUnitInfo curbgOrgUnitInfo = (BgOrgUnitInfo)this.prmtCU.getData();
        BgPeriodNameEnum periodName = BgPeriodNameEnum.getEnum(this.comboPeriodName.getSelectedIndex());
        int orgScope = this.getOrgScope();
        BgOrgUnitFactory.getRemoteInstance().updatePeriodName((IObjectValue)curbgOrgUnitInfo, periodName, orgScope);
        return new ObjectUuidPK(curbgOrgUnitInfo.getId());
    }

    private int getOrgScope() {
        int orgScope = -1;
        if (this.curOrgUnit.isSelected()) {
            orgScope = 0;
        } else if (this.rbImmOrgUnit.isSelected()) {
            orgScope = 1;
        } else if (this.rbAllOrgUnit.isSelected()) {
            orgScope = 2;
        } else if (this.rbLevelOrgUnit.isSelected()) {
            orgScope = 3;
        }
        return orgScope;
    }

    private void checkCurOrgIsEmpty(BgOrgUnitInfo curbgOrgUnitInfo) {
        if (curbgOrgUnitInfo == null || StringUtils.isEmpty((String)curbgOrgUnitInfo.getName())) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"EmptyBgOrgUnit"));
            SysUtil.abort();
            return;
        }
    }
}

