/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgProcessSelectUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgProcessSelectUI
extends AbstractBgProcessSelectUI {
    private static final long serialVersionUID = 2025729556984838633L;
    private static final Logger logger = CoreUIObject.getLogger(BgProcessSelectUI.class);
    private static final String COL_SELECT = "select";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    public static final String ISMULTI = "isMulti";
    public static final String FILTER_MEMBERS = "FILTER_MEMBERS";
    private boolean isMulti = false;
    private boolean isCancel = true;
    private List<BgProcessEnum> data = null;

    public boolean isMulti() {
        return this.isMulti;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.getUIContext().get(ISMULTI) instanceof Boolean) {
            this.isMulti = (Boolean)this.getUIContext().get(ISMULTI);
        }
        this.tblMain.getColumn(COL_SELECT).getStyleAttributes().setHided(!this.isMulti());
        this.initTblMain();
    }

    protected void initTblMain() {
        HashSet selects = new HashSet();
        if (this.getUIContext().get("backfillMember") instanceof Set) {
            selects.addAll((Set)this.getUIContext().get("backfillMember"));
        }
        HashSet filterMembers = new HashSet();
        if (this.getUIContext().get(FILTER_MEMBERS) instanceof Set) {
            filterMembers.addAll((Set)this.getUIContext().get(FILTER_MEMBERS));
        }
        this.tblMain.removeRows();
        List lst = BgProcessEnum.getEnumList();
        for (int i = 0; i < lst.size(); ++i) {
            BgProcessEnum bgEnum = (BgProcessEnum)((Object)lst.get(i));
            if (filterMembers.contains(bgEnum.getName())) continue;
            IRow row = this.tblMain.addRow();
            if (this.isMulti()) {
                row.getCell(COL_SELECT).setValue((Object)false);
            }
            if (selects.contains(bgEnum.getName())) {
                row.getCell(COL_SELECT).setValue((Object)true);
            }
            row.getCell(COL_NUMBER).setValue((Object)bgEnum.getName());
            row.getCell(COL_NAME).setValue((Object)bgEnum.getAlias());
            row.setUserObject((Object)bgEnum);
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.data = new ArrayList<BgProcessEnum>();
        if (this.isMulti()) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!row.getCell(COL_SELECT).getValue().toString().equals(Boolean.TRUE.toString()) || !(row.getUserObject() instanceof BgProcessEnum)) continue;
                this.data.add((BgProcessEnum)((Object)row.getUserObject()));
            }
        } else if (this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()) != null) {
            this.data.add((BgProcessEnum)((Object)this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getUserObject()));
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public Object getData() {
        if (!this.data.isEmpty()) {
            if (this.data.size() == 1) {
                return this.data.get(0);
            }
            return this.lstToArr(this.data);
        }
        return null;
    }

    protected BgProcessEnum[] lstToArr(List<BgProcessEnum> lst) {
        BgProcessEnum[] arr = new BgProcessEnum[lst.size()];
        for (int i = 0; i < lst.size(); ++i) {
            arr[i] = lst.get(i);
        }
        return arr;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (!this.isMulti() && e.getType() == 1 && e.getClickCount() == 2) {
            this.btnOk_actionPerformed(null);
        }
    }
}

