/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.AbstractBgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultCollection;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.IBgFinalizedResult;
import com.kingdee.eas.ma.mbg.client.AbstractBgProgressUI;
import com.kingdee.eas.ma.mbg.client.MyMsgBox;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgProgressUI
extends AbstractBgProgressUI {
    private static final long serialVersionUID = 5392749647518961582L;
    private static final Logger logger = CoreUIObject.getLogger(BgProgressUI.class);
    private boolean isClose = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.progBar.setStringPainted(true);
        String calcSchemId = (String)this.getUIContext().get("ID");
        Set orgIds = this.getUIContext().containsKey("ORGUNIT_IDS") ? (Set)this.getUIContext().get("ORGUNIT_IDS") : null;
        BgFinalizedResultInfo runResultInfo = this.getRunResult(calcSchemId);
        if (runResultInfo != null) {
            this.startShowResultThread(runResultInfo);
        } else {
            BgFinalizedResultInfo resultInfo = this.getResult(calcSchemId);
            this.startExecuteFinalzeThread(calcSchemId, resultInfo, orgIds);
            this.startShowResultThread(resultInfo);
        }
    }

    protected void startShowResultThread(final BgFinalizedResultInfo resultInfo) {
        Thread result = new Thread(){

            @Override
            public void run() {
                if (UserMonitorClientTool.getRegistryInfo() != null) {
                    UserMonitorClientTool.getRegistryInfo().setFinished(false);
                }
                try {
                    BgProgressUI.this.showResult(resultInfo);
                }
                finally {
                    if (UserMonitorClientTool.getRegistryInfo() != null) {
                        UserMonitorClientTool.getRegistryInfo().setFinished(true);
                    }
                }
            }
        };
        result.start();
    }

    protected BgFinalizedResultInfo getResult(String calcSchemeId) throws BOSException, EASBizException {
        BgFinalizedResultInfo result = null;
        IBgFinalizedResult iBgFinalizedResult = BgFinalizedResultFactory.getRemoteInstance();
        result = new BgFinalizedResultInfo();
        result.setId(BOSUuid.create((BOSObjectType)result.getBOSType()));
        result.setOperateID(calcSchemeId);
        result.setState(BgFinalizedResultEnum.run);
        result.setResult("\u64cd\u4f5c\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026");
        result.setCurrentIndex(0);
        result.setTotalCount(0);
        iBgFinalizedResult.save(result);
        return result;
    }

    protected BgFinalizedResultInfo getRunResult(String calcSchemeId) throws BOSException, EASBizException {
        BgFinalizedResultInfo result = null;
        IBgFinalizedResult iBgFinalizedResult = BgFinalizedResultFactory.getRemoteInstance();
        BgFinalizedResultCollection colls = iBgFinalizedResult.getBgFinalizedResultCollection("where operateID = '" + calcSchemeId + "' and state =" + 8 + "");
        if (colls != null && !colls.isEmpty()) {
            result = colls.get(0);
        }
        return result;
    }

    protected void startExecuteFinalzeThread(final String calcSchemeId, final BgFinalizedResultInfo resultInfo, final Set<String> orgIds) {
        Thread executor = new Thread(){

            @Override
            public void run() {
                BgProgressUI.this.execute(calcSchemeId, resultInfo, orgIds);
            }
        };
        executor.start();
    }

    protected void execute(String calcSchemeId, BgFinalizedResultInfo resultInfo, Set<String> orgIds) {
        try {
            BgCalculateSchemeFacadeFactory.getRemoteInstance().reCalculate(calcSchemeId, resultInfo, orgIds);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    @Override
    protected void btnBackStage_actionPerformed(ActionEvent e) throws Exception {
        super.btnBackStage_actionPerformed(e);
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        this.isClose = true;
        return super.destroyWindow();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuBar.setVisible(false);
        if (this.statusBar != null) {
            this.statusBar.setVisible(false);
        }
    }

    private void showResult(BgFinalizedResultInfo resultInfo) {
        long startTime = System.currentTimeMillis();
        long maxTimeout = 6000000L;
        ObjectUuidPK pk = new ObjectUuidPK(resultInfo.getId());
        boolean isFirst = true;
        while (!this.isClose) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                AbstractBgFinalizedResultInfo r = null;
                BgFinalizedResultCollection col = BgFinalizedResultFactory.getRemoteInstance().getBgFinalizedResultCollection("where id = '" + pk + "'");
                if (col != null && !col.isEmpty()) {
                    r = col.get(0);
                    if (isFirst) {
                        isFirst = false;
                    }
                }
                if (r == null) {
                    if (System.currentTimeMillis() - startTime <= maxTimeout) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)"\u64cd\u4f5c\u8d85\u65f6");
                    this.destroyWindow();
                    return;
                }
                if (BgFinalizedResultEnum.calcFinish.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.destroyWindow();
                    return;
                }
                if (BgFinalizedResultEnum.exception.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.showException((BgFinalizedResultInfo)r);
                    return;
                }
                if (!BgFinalizedResultEnum.calc.equals((Object)r.getState())) continue;
                this.progBar.setMaximum(r.getTotalCount());
                this.progBar.setValue(r.getCurrentIndex());
                this.lblState.setText(r.getResult());
                this.progBar.setString(r.getCurrentIndex() + "/" + r.getTotalCount());
                this.updateUI();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                if (BgProgressUI.isSessionClosedException(e)) {
                    if (MyMsgBox.showSessionError((Component)((Object)this), e) == 99) continue;
                    this.isClose = true;
                    continue;
                }
                this.isClose = true;
                this.handUIExceptionAndAbort(e);
            }
        }
        this.destroyWindow();
    }

    private static boolean isSessionClosedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            int errorCode = Utils.getRPCErrorCode((Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && (errorCode == 1002 || errorCode == 1001) || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private void showException(BgFinalizedResultInfo r) {
        String reg = "#";
        if (r.getException().indexOf(reg) > 0) {
            String[] code = r.getException().split(reg);
            if (code != null && code.length == 2 && code[0].equals("12-101")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgCalculateSchemeResource", (String)"hasAdjustData"), (String)code[1], (int)0);
                this.destroyWindow();
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u64cd\u4f5c\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u6536\u96c6\u65e5\u5fd7\u540e\u53cd\u9988\u5206\u6790\uff01", (String)r.getException(), (int)1);
                this.destroyWindow();
            }
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u64cd\u4f5c\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u6536\u96c6\u65e5\u5fd7\u540e\u53cd\u9988\u5206\u6790\uff01", (String)r.getException(), (int)1);
            this.destroyWindow();
        }
    }
}

