/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.IPropertyRefSource;
import com.kingdee.eas.ma.base.PropertyRefSourceFactory;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgPropertyUtils;
import com.kingdee.eas.ma.mbg.client.AbstractBgPropertyChooseUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgPropertyChooseUI
extends AbstractBgPropertyChooseUI {
    private static final Logger logger = CoreUIObject.getLogger(BgPropertyChooseUI.class);
    private boolean isCancel = true;
    private TreeModel oldTree = null;
    private Set<String> selectSet = null;

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("selectOrg") != null) {
            this.selectSet = (Set)this.getUIContext().get("selectOrg");
        }
        this.init();
    }

    protected void init() throws Exception {
        this.initBgOrgUnit();
        TreeNode root = (TreeNode)this.treeProperty.getModel().getRoot();
        this.treeProperty.expandAllNodes(true, root);
        BgBaseHelper.setRootCannotClose((KDTree)this.treeProperty);
    }

    protected void initBgOrgUnit() throws Exception {
        this.setOldTree(BgPropertyUtils.buildTreeModel());
        this.treeProperty.setShowCheckBox(true);
        this.treeProperty.setModel(this.getOldTree());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void initListener() {
        super.initListener();
        this.treeProperty.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                BgPropertyChooseUI.this.treeProperty_nodeStateChange(event);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.txtKey.setUserObject((Object)this.txtKey.getText());
        String value = this.txtKey.getText();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        }
        if (StringUtils.isEmpty((String)value)) {
            this.treeProperty.setModel(this.getOldTree());
            BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)node, (boolean)false);
            TreeNode root = (TreeNode)this.treeProperty.getModel().getRoot();
            this.treeProperty.expandAllNodes(true, root);
            return;
        }
        TreeModel model = null;
        model = BgPropertyUtils.clipAndCloneTreeModel((TreeModel)this.getOldTree(), (String[])new String[]{"name", "number"}, (String)value, (boolean)true);
        this.treeProperty.setModel(model);
        BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)node, (boolean)false);
        TreeNode root = (TreeNode)this.treeProperty.getModel().getRoot();
        this.treeProperty.expandAllNodes(true, root);
    }

    @Override
    protected void txtKey_focusLost(FocusEvent e) throws Exception {
        super.txtKey_focusLost(e);
        if (StringUtils.equals((String)((String)this.txtKey.getUserObject()), (String)this.txtKey.getText())) {
            return;
        }
        this.txtKey.setUserObject((Object)this.txtKey.getText());
        String value = this.txtKey.getText();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        }
        if (StringUtils.isEmpty((String)value)) {
            this.treeProperty.setModel(this.getOldTree());
            BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)node, (boolean)false);
            TreeNode root = (TreeNode)this.treeProperty.getModel().getRoot();
            this.treeProperty.expandAllNodes(true, root);
            return;
        }
        TreeModel model = null;
        model = BgPropertyUtils.clipAndCloneTreeModel((TreeModel)this.getOldTree(), (String[])new String[]{"name", "number"}, (String)value, (boolean)true);
        this.treeProperty.setModel(model);
        BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)node, (boolean)false);
        TreeNode root = (TreeNode)this.treeProperty.getModel().getRoot();
        this.treeProperty.expandAllNodes(true, root);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        Map chooseMap = BgPropertyUtils.getPropertyTreeChecked((DefaultKingdeeTreeNode)root);
        HashSet set = null;
        HashSet orgSet = new HashSet();
        HashMap selectMap = new HashMap();
        HashSet allOrgSet = new HashSet();
        String orgId = null;
        HashSet<String> noExistSet = new HashSet<String>();
        if (chooseMap.isEmpty()) {
            this.isCancel = true;
            this.getUIWindow().close();
        }
        for (String sortId : chooseMap.keySet()) {
            if (chooseMap.size() == 1) {
                set = (HashSet)chooseMap.get(sortId);
                orgSet = this.getRefOrgIds(set);
                this.selectSet.addAll(orgSet);
                continue;
            }
            set = (HashSet)chooseMap.get(sortId);
            orgSet = this.getRefOrgIds(set);
            allOrgSet.addAll(orgSet);
            selectMap.put(sortId, orgSet);
        }
        Iterator it = allOrgSet.iterator();
        while (it.hasNext()) {
            orgId = it.next().toString();
            for (String sortId : selectMap.keySet()) {
                orgSet = (HashSet)selectMap.get(sortId);
                if (orgSet.contains(orgId)) continue;
                noExistSet.add(orgId);
            }
        }
        allOrgSet.removeAll(noExistSet);
        this.selectSet.addAll(allOrgSet);
        this.isCancel = false;
        this.getUIWindow().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRefOrgIds(Set<String> idSets) {
        HashSet<String> orgSet = new HashSet();
        IPropertyRefSource iSource = null;
        try {
            iSource = PropertyRefSourceFactory.getRemoteInstance();
            orgSet = iSource.querySourcesByIds(idSets);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        return orgSet;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        }
        BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)node, (boolean)true);
        this.treeProperty.repaint();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeProperty.getModel().getRoot();
        }
        BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)node, (boolean)false);
        this.treeProperty.repaint();
    }

    protected void treeProperty_nodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode curNode = (DefaultKingdeeTreeNode)event.getNode();
        Object subNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        parentNode = (DefaultKingdeeTreeNode)curNode.getParent();
        if (parentNode != null && parentNode.getUserObject() instanceof BgPropertyInfo && parentNode.isChecked()) {
            BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)curNode, (boolean)true);
        }
        if (curNode.isChecked()) {
            BgPropertyUtils.setPropertyTreeChecked((DefaultKingdeeTreeNode)curNode, (boolean)true);
        }
        this.treeProperty.repaint();
    }
}

