/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.mbg.client.AbstractBgRecalculateReportUI;
import com.kingdee.eas.ma.mbg.utils.RecalculateObjInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;

public class BgRecalculateReportUI
extends AbstractBgRecalculateReportUI {
    private static final long serialVersionUID = 3449083562201279155L;
    private static final String resourcePath = "com.kingdee.eas.ma.mbg.client.BgFormAnalyseLableResource";
    private Field[] fs;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        Map context = this.getUIContext();
        List bgFormList = (List)context.get("bgFormList");
        if (bgFormList != null) {
            this.fillBaseDataToTable();
            this.fillDataToTable(bgFormList);
        }
        this.actionPopupPaste.setVisible(false);
        this.actionExport.setVisible(false);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        ActionMap am = this.tblMain.getActionMap();
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPage.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrePage.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemPage.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrePage.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    private void fillDataToTable(List list) throws IllegalArgumentException, IllegalAccessException {
        Collections.sort(list, new RecalculateObjCompare());
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            RecalculateObjInfo info = (RecalculateObjInfo)list.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("orgUnit").setValue((Object)(info.getOrgUnit().getNumber() + "(" + info.getOrgUnit().getName() + ")"));
            row.getCell("templateName").setValue((Object)info.getTemplateInfo().getName());
            row.getCell("period").setValue((Object)(info.getPeriodInfo().getName() + "(" + info.getPeriodInfo().getNumber().substring(0, 4) + ")"));
            row.getCell("processType").setValue((Object)info.getProcessType());
            if (info.getBgForm() != null) {
                row.getCell("bgFormName").setValue((Object)info.getBgForm().getName());
                if (!info.getBgForm().getBgSpecialItems().isEmpty()) {
                    row.getCell("specialItem").setValue((Object)info.getBgForm().getBgSpecialItems().get(0).getMemberDisplayName());
                } else {
                    row.getCell("specialItem").setValue((Object)"");
                }
            } else {
                row.getCell("bgFormName").setValue((Object)"");
                row.getCell("specialItem").setValue((Object)"");
            }
            row.getCell("result").setValue((Object)this.getValueByName(info.getRecalculateResult()));
        }
    }

    private void fillBaseDataToTable() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_COST");
        if (orgInfo == null) {
            orgInfo = SysContext.getSysContext().getCurrentCostUnit().castToFullOrgUnitInfo();
        }
        IRow row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)EASResource.getString((String)resourcePath, (String)"ExePerson"));
        row.getCell(1).setValue((Object)userInfo.getName());
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)EASResource.getString((String)resourcePath, (String)"ExeTime"));
        row.getCell(1).setValue(this.getUIContext().get("beginTime"));
        this.tblMain.addRow();
    }

    private void init() throws ClassNotFoundException {
        Class<?> cls = Class.forName("com.kingdee.eas.ma.mbg.client.BgRecalculateReportUI$ErrorType");
        this.fs = cls.getFields();
    }

    private String getValueByName(String name) throws IllegalArgumentException, IllegalAccessException {
        int num = this.fs.length;
        for (int i = 0; i < num; ++i) {
            if (!this.fs[i].getName().equals(name)) continue;
            return this.fs[i].get(name).toString();
        }
        return "";
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    @Override
    protected void btnPage_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    protected void btnPrePage_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    static class ErrorType {
        public static final String cancel = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRptResource", (String)"CancelError");
        public static final String noBgForm = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRptResource", (String)"NoBgFormError");
        public static final String stateError = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRptResource", (String)"StateError");
        public static final String success = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRptResource", (String)"Success");

        ErrorType() {
        }
    }

    private class RecalculateObjCompare
    implements Comparator {
        private RecalculateObjCompare() {
        }

        public int compare(Object o1, Object o2) {
            RecalculateObjInfo obj1 = (RecalculateObjInfo)o1;
            RecalculateObjInfo obj2 = (RecalculateObjInfo)o2;
            int r = obj1.getOrgUnit().getLongNumber().compareTo(obj2.getOrgUnit().getLongNumber());
            return r;
        }
    }
}

