/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionCollection;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.BgViewFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgReportViewAddNewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.form.ActionOrgAdd;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgReportViewAddNewUI
extends AbstractBgReportViewAddNewUI {
    private static final long serialVersionUID = 160151892931492099L;
    private static final Logger logger = CoreUIObject.getLogger(BgReportViewAddNewUI.class);
    private Map bgViewDimensionColMap = new HashMap();
    private static final int currYear = new CalendarHelper().getCurrentlyYear();
    private boolean hasOldBgForm = false;
    private static final Map<Integer, int[]> parentBgPeriodEnums = new HashMap<Integer, int[]>();

    @Override
    protected void initTitle() {
        super.initTitle();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setUITitle(BgViewClientHelper.getString("view") + " - " + this.getMessageStr(this.getCcOprtState() + "_FIX"));
        }
    }

    @Override
    protected boolean checkBgTemplateType(int bgTemplateFormType) {
        return 4 == bgTemplateFormType;
    }

    @Override
    protected void prmtBatchBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBatchBgTemplate_dataChanged(e);
        this.checkBgForm();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        this.dealPrmtBgPeriodAndBgVersion();
    }

    protected void dealPrmtBgPeriodAndBgVersion() {
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)this.prmtBatchBgTemplate.getValue();
        if (bgTemplateInfo == null) {
            this.prpmtBgVersion.setEnabled(false);
            this.prmtBgPeriod.setEnabled(false);
        } else {
            this.prpmtBgVersion.setEnabled(true);
            this.prmtBgPeriod.setEnabled(true);
            HashSet<String> versionNumbers = new HashSet<String>();
            HashSet<String> bgPeriodTypeNumbers = new HashSet<String>();
            try {
                BgViewDimensionInfo viewDim = (BgViewDimensionInfo)this.bgViewDimensionColMap.get(bgTemplateInfo.getId().toString());
                if (viewDim == null) {
                    viewDim = BgViewDimensionFactory.getRemoteInstance().getBgViewDimensionInfo("select data where template.id = '" + bgTemplateInfo.getId() + "'");
                }
                HashSet<String> bgPeriodNumbers = new HashSet<String>();
                MbgXMLParser parser2 = new MbgXMLParser();
                IMbgViewManager view = parser2.parse(viewDim.getData());
                if (view != null) {
                    for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                        BgDimensionInfo dimension = (BgDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_VERSION_NUMBER, view.getSheetManagers().get(s).getDimensionManager().getDimension());
                        if (dimension != null) {
                            if (DimensionMemberValueModeEnum.SelectMember.equals((Object)dimension.getMemberValueType()) && !dimension.isDinamicAdd()) {
                                for (int m = 0; m < dimension.getMember().size(); ++m) {
                                    if (versionNumbers == null) continue;
                                    versionNumbers.add(((BgDimensionMember)dimension.getMember().get(m)).getNumber());
                                }
                            } else {
                                versionNumbers = null;
                            }
                        }
                        if ((dimension = (BgDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, view.getSheetManagers().get(s).getDimensionManager().getDimension())) == null) continue;
                        if (DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType())) {
                            bgPeriodTypeNumbers.add(dimension.getBgPeriodType().getNumber());
                            continue;
                        }
                        if (!dimension.getMember().isEmpty()) {
                            int size = dimension.getMember().size();
                            for (int index = 0; index < size; ++index) {
                                bgPeriodNumbers.add(((BgDimensionMember)dimension.getMember().get(index)).getNumber());
                            }
                            continue;
                        }
                        bgPeriodNumbers.add(dimension.getValue());
                    }
                }
                if (!bgPeriodNumbers.isEmpty()) {
                    HashSet<Integer> bgPeriodEnums = new HashSet<Integer>();
                    HashSet<Integer> parentEnums = new HashSet<Integer>();
                    Integer bgPeriodEnum2 = null;
                    String bgPeriodNumber2 = null;
                    for (String bgPeriodNumber2 : bgPeriodNumbers) {
                        bgPeriodEnum2 = BgPeriodHelper.getPeriodType((String)bgPeriodNumber2);
                        bgPeriodTypeNumbers.add(bgPeriodNumber2.substring(0, bgPeriodNumber2.indexOf(".")));
                        if (bgPeriodEnum2 < 0) continue;
                        bgPeriodEnums.add(bgPeriodEnum2);
                    }
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(new FilterInfo());
                    evi.setSelector(new SelectorItemCollection());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", bgPeriodTypeNumbers, CompareType.INCLUDE));
                    BgPeriodTypeCollection coll = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(evi);
                    if (coll != null && !coll.isEmpty()) {
                        HashMap<String, BgPeriodTypeInfo> bgPeriodTypes = new HashMap<String, BgPeriodTypeInfo>();
                        for (int i = 0; i < coll.size(); ++i) {
                            BgPeriodTypeInfo type = coll.get(i);
                            bgPeriodTypes.put(type.getNumber(), type);
                            bgPeriodEnums.add(type.getBgPeriodEnum());
                        }
                        for (Integer bgPeriodEnum2 : bgPeriodEnums) {
                            int[] enums = parentBgPeriodEnums.get(bgPeriodEnum2);
                            if (enums == null) continue;
                            for (int e = 0; e < enums.length; ++e) {
                                parentEnums.add(enums[e]);
                            }
                        }
                        bgPeriodEnums.removeAll(parentEnums);
                        bgPeriodTypeNumbers.clear();
                        for (BgPeriodTypeInfo type : bgPeriodTypes.values()) {
                            if (!bgPeriodEnums.contains(type.getBgPeriodEnum())) continue;
                            bgPeriodTypeNumbers.add(type.getNumber());
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIException(e);
            }
            BgPeriodDialog dialog = null;
            if (this.prmtBgPeriod.getSelector() != null && this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
                dialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
                dialog.close();
            }
            dialog = new BgPeriodDialog((CoreUIObject)this);
            dialog.setBgPeriodBeginDate(this.bgSchemeInfo.getDateFrom());
            dialog.setBgPeriodEndDate(this.bgSchemeInfo.getDateTo());
            try {
                bgPeriodTypeNumbers.retainAll(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
            }
            catch (EASBizException e1) {
                logger.error((Object)"", (Throwable)e1);
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
                this.handUIException(e1);
            }
            dialog.setBgPeriodTypeNumbers(bgPeriodTypeNumbers);
            this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            if (versionNumbers != null) {
                if (versionNumbers.isEmpty()) {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
                } else {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", versionNumbers, CompareType.INCLUDE));
                }
            } else {
                try {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_VERSION_NUMBER, true), CompareType.INCLUDE));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
            this.prpmtBgVersion.setEntityViewInfo(evi);
            if (this.prpmtBgVersion != null && this.prpmtBgVersion.getData() != null && this.prpmtBgVersion.getData() instanceof BgVersionInfo && versionNumbers != null && !versionNumbers.contains(((BgVersionInfo)this.prpmtBgVersion.getData()).getNumber())) {
                this.prpmtBgVersion.setDataNoNotify(null);
            }
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        this.checkBgForm();
    }

    @Override
    protected void prpmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        super.prpmtBgVersion_dataChanged(e);
        this.checkBgForm();
    }

    protected void comCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.checkBgForm();
    }

    protected void checkBgForm() throws Exception {
        if (!OprtState.ADDNEW.equals(this.getCcOprtState())) {
            return;
        }
        Object old = null;
        if (this.checkCreateName()) {
            this.storeFields();
            if (this.prpmtBgVersion.getData() != null) {
                // empty if block
            }
        }
        if (old == null) {
            if (this.hasOldBgForm) {
                this.hasOldBgForm = false;
                if (this.numberCodeHelper.isHasCodeNumber()) {
                    this.txtNumber.setEnabled(false);
                    if (this.numberCodeHelper.isHasShowCodeNumber()) {
                        this.getNumberByCodingRule((IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString());
                    }
                } else {
                    this.txtNumber.setEnabled(true);
                }
                this.txtName.setText(null);
                if (this.nameCodeHelper.isHasCodeNumber()) {
                    this.txtName.setEnabled(false);
                    if (this.nameCodeHelper.isHasShowCodeNumber()) {
                        this.storeFields();
                        this.nameCodeHelper.applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), null);
                    }
                } else {
                    this.txtName.setEnabled(true);
                    this.updateBgFormName();
                }
                this.txtContent.setText(null);
            }
        } else {
            this.hasOldBgForm = true;
            if (!this.numberCodeHelper.isHasCodeNumber()) {
                this.txtNumber.setText(old.getNumber());
                this.txtNumber.setEnabled(false);
            }
            if (this.nameCodeHelper.isHasCodeNumber()) {
                this.txtName.setEnabled(false);
                if (this.nameCodeHelper.isHasShowCodeNumber()) {
                    this.storeFields();
                    this.nameCodeHelper.applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), null);
                }
            } else {
                this.txtName.setText(old.getName());
                this.txtName.setEnabled(false);
            }
            this.txtContent.setText(old.getDescription());
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.prmtBatchBgTemplate.setEnabledMultiSelection(false);
        this.prpmtBgVersion.setEnabled(false);
        this.prmtBgPeriod.setEnabled(false);
        super.onLoad();
        this.dealCheckInfo();
        this.comCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    BgReportViewAddNewUI.this.comCurrency_itemStateChanged(e);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                    BgReportViewAddNewUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        Object obj = this.prmtBgScheme.getData();
        if (obj != null && obj instanceof BgSchemeInfo) {
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            this.initTemplateFormBgScheme(_bgSchemeInfo);
            this.initBgViewDimensionFormBgScheme(_bgSchemeInfo);
        } else {
            this.prmtBgScheme.setData(null);
            this.prmtBatchBgTemplate.setData(null);
        }
    }

    protected void initBgViewDimensionFormBgScheme(BgSchemeInfo bgSchemeInfo) throws Exception {
        this.bgViewDimensionColMap.clear();
        BgViewDimensionCollection bgViewDimensionColl = TemplateFacadeFactory.getRemoteInstance().getBgViewDimensionInfo(bgSchemeInfo.getId().toString(), this.ccOrgUnitInfo.getId().toString(), true);
        BgViewDimensionInfo bgViewDimensionInfo = null;
        for (int i = 0; i < bgViewDimensionColl.size(); ++i) {
            bgViewDimensionInfo = bgViewDimensionColl.get(i);
            this.bgViewDimensionColMap.put(bgViewDimensionInfo.getTemplate().getId().toString(), bgViewDimensionInfo);
        }
    }

    @Override
    protected void doSubmintForAddNew(ActionEvent e) throws Exception {
        this.verify(e);
        this.submitBgFormInfo();
        this.openProgressUI(this.isBatch());
    }

    @Override
    protected void checkNumberRepeat() throws BOSException, EASBizException {
        List orgs = BgViewFacadeFactory.getRemoteInstance().checkNumber(this.editData, this.isBatch());
        if (orgs != null && !orgs.isEmpty()) {
            boolean hasAllDup = Boolean.TRUE.equals(orgs.get(0));
            String tmp = BgViewClientHelper.getString("numberDetail");
            StringBuffer msg = new StringBuffer();
            for (int i = 1; i < orgs.size(); ++i) {
                if (i != 1) {
                    msg.append("\n");
                }
                OrgUnitInfo o = (OrgUnitInfo)orgs.get(i);
                msg.append(MessageFormat.format(tmp, o.getNumber(), o.getName(), this.editData.getNumber()));
            }
            int f = MsgBox.showConfirm3((Component)((Object)this), (String)MessageFormat.format(BgViewClientHelper.getString("numberConfirm"), orgs.size() - 1), (String)msg.toString());
            if (hasAllDup || f != 0) {
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void checkFormRepeat() throws Exception {
        super.checkFormRepeat();
        this.checkExistsForm();
    }

    @Override
    public BgFormInfo saveBgFormInfo(boolean isBatch) throws Exception {
        Map result = BgViewFacadeFactory.getRemoteInstance().addNewViewInfo(this.editData, (String)this.getUIContext().get("BGORGVIEW_ID"), isBatch, this.getAddNewPermissionNumber());
        if (result != null) {
            String id = (String)result.remove(BgBaseConstants.ID);
            this.editData.setId(BOSUuid.read((String)id));
            if (isBatch) {
                int totalCount = (Integer)result.remove("totalCount");
                String resultKey = (String)result.remove("result");
                if (!result.isEmpty()) {
                    int failCount = 0;
                    for (Object obj : result.values()) {
                        if (obj instanceof Collection) {
                            failCount += ((Collection)obj).size();
                            continue;
                        }
                        if (!(obj instanceof Map)) continue;
                        failCount += ((Map)obj).size();
                    }
                    String error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"addNewBatchFail"), totalCount, failCount);
                    String detail = ActionOrgAdd.buildDetailMessage(null, null, result).toString();
                    detail = this.getBatchAddNewDetail(detail, result);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail, (int)1);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"addBathWarng"));
                }
            }
        }
        return this.editData;
    }

    private String getBatchAddNewDetail(String msg, Map result) {
        StringBuffer detail = new StringBuffer(msg);
        Map auditBgFormStateOrgs = (Map)result.get("auditBgFormState");
        String auditBgFormStateMsg = MBGViewListFormClientHelper.getString("auditBgFormState");
        if (auditBgFormStateOrgs != null && !auditBgFormStateOrgs.isEmpty()) {
            for (Map.Entry entry : auditBgFormStateOrgs.entrySet()) {
                String orgUnitName = ((String)entry.getKey()).split(DimensionConstants.TICK_SEPARATOR)[1];
                Set parentOrgUnits = (Set)entry.getValue();
                StringBuffer buff = new StringBuffer();
                Iterator iter = parentOrgUnits.iterator();
                while (iter.hasNext()) {
                    String parentOrgName = ((OrgUnitInfo)iter.next()).getName();
                    buff.append(parentOrgName).append("\uff0c");
                }
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                detail.append(MessageFormat.format(auditBgFormStateMsg, orgUnitName, ((BgTemplateInfo)this.prmtBatchBgTemplate.getValue()).getName(), ((BgPeriodInfo)this.prmtBgPeriod.getData()).getName(), ((CurrencyInfo)this.comCurrency.getSelectedItem()).getName(), ((BgVersionInfo)this.prpmtBgVersion.getData()).getName(), buff.toString()));
            }
        }
        return detail.toString();
    }

    protected String getAddNewPermissionNumber() {
        return "mbg_form02_addNew";
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("BGFORM_LINK_SCHEME", this.getUIContext().get("BGFORM_LINK_SCHEME"));
            request.put("BGFORM_LINK_TEMPLATE", this.getUIContext().get("BGFORM_LINK_TEMPLATE"));
            request.put("BGFORM_LINK_PERIOD", this.getUIContext().get("BGFORM_LINK_PERIOD"));
            request.put("BGFORM_LINK_CURRENCY", this.getUIContext().get("BGFORM_LINK_CURRENCY"));
        }
        return handler;
    }

    @Override
    public boolean isPrepareDestoryWindow() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnit.*");
        sic.add("number");
        sic.add("bgScheme.*");
        sic.add("currency");
        sic.add("bgPeriod.*");
        sic.add("bgVersion.*");
        sic.add("creator.*");
        sic.add("name");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.formType");
        sic.add("bgType.*");
        sic.add("measureUnit");
        sic.add("createTime");
        sic.add("description");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        return sic;
    }

    static {
        parentBgPeriodEnums.put(7, new int[]{5, 6, 9, 4, 3, 2, 1});
        parentBgPeriodEnums.put(5, new int[]{1});
        parentBgPeriodEnums.put(6, new int[]{4, 3, 2, 1});
        parentBgPeriodEnums.put(9, new int[]{4, 3, 2, 1});
        parentBgPeriodEnums.put(4, new int[]{3, 2, 1});
        parentBgPeriodEnums.put(3, new int[]{2, 1});
        parentBgPeriodEnums.put(2, new int[]{1});
    }
}

