/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgRollRuleFactory;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgRollRuleListUI;
import com.kingdee.eas.ma.mbg.client.BgRollRuleEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgRollRuleListUI
extends AbstractBgRollRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgRollRuleListUI.class);

    protected String getCopyPermission() {
        return "mbg_BgRollRule02_addnew";
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        UserInfo useInfo = SysContext.getSysContext().getCurrentUserInfo();
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(useInfo.getId()), (IObjectPK)new ObjectUuidPK(currentOrgUnit.getId()), this.getCopyPermission());
        UIContext uicontext = new UIContext((Object)this);
        uicontext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uicontext, e);
        IUIWindow copyUI = UIFactory.createUIFactory().create(this.getEditUIName(), (Map)uicontext, null, OprtState.COPYADDNEW);
        copyUI.show();
        this.tblMain.refresh();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnit("cantEdit");
        super.actionEdit_actionPerformed(e);
    }

    public String getRemovePermission() {
        return "mbg_BgRollRule05_delete";
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess;
        this.checkSelected();
        StringBuffer result = new StringBuffer();
        ArrayList selectedIdValues = this.getSelectedIdValues();
        CostCenterOrgUnitInfo currentCostUnit = SysContext.getSysContext().getCurrentCostUnit();
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(currentCostUnit.getId()), this.getRemovePermission());
        if (selectedIdValues.isEmpty()) {
            return;
        }
        int rowBegin = 0;
        int rowEnd = 0;
        int size = 0;
        HashMap<String, String> idNums = new HashMap<String, String>();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            size = range.size();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    String id = row.getCell("id").getValue().toString();
                    String number = row.getCell("number").getValue() == null ? "" : row.getCell("number").getValue().toString();
                    idNums.put(id, number);
                }
            }
        }
        Map msg = BgRollRuleFactory.getRemoteInstance().batchDelete(selectedIdValues);
        Set success = (Set)msg.get("DELETE_OVER");
        Set refTemlate = (Set)msg.get("DELETE_CANT");
        Set mutex = (Set)msg.get("Mutex");
        Set orgDiff = (Set)msg.get("orgDiff");
        boolean bl = isSuccess = refTemlate.isEmpty() && mutex.isEmpty() && orgDiff.isEmpty();
        if (isSuccess) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRollRuleResource", (String)"deleteSuccess"));
        } else {
            this.processDeleteMsg(refTemlate, idNums, EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRollRuleResource", (String)"refTemplate"), result);
            this.processDeleteMsg(mutex, idNums, EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRollRuleResource", (String)"mutex"), result);
            this.processDeleteMsg(orgDiff, idNums, EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRollRuleResource", (String)"orgDiff"), result);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRollRuleResource", (String)"deleteFaild", (Object[])new Object[]{selectedIdValues.size(), success.size(), selectedIdValues.size() - success.size()}), (String)result.toString(), (int)1);
        }
        if (!success.isEmpty()) {
            BgNFCHelper.refreshListUI((CoreUI)this);
        }
    }

    private void processDeleteMsg(Set ids, Map idNums, String msg, StringBuffer result) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (String id : ids) {
            result.append(MessageFormat.format(msg, idNums.get(id))).append("\r\n");
        }
    }

    private void checkOrgUnit(String key) throws Exception {
        FullOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCostUnit().castToFullOrgUnitInfo();
        BgRollRuleInfo value = (BgRollRuleInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (!value.getOrgUnit().getId().equals((Object)orgUnitInfo.getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgRollRuleResource", (String)key));
            SysUtil.abort();
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return BgRollRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgRollRuleFactory.getRemoteInstance();
    }
}

