/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.AssignSolutionCollection;
import com.kingdee.eas.ma.mbg.AssignSolutionFactory;
import com.kingdee.eas.ma.mbg.AssignSolutionInfo;
import com.kingdee.eas.ma.mbg.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewCollection;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgOrgunitViewFoldEnum;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.IBgSchemeDispatchFacade;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeDispatchUI;
import com.kingdee.eas.ma.mbg.client.BgPropertyChooseUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeDispatchReportUI;
import com.kingdee.eas.ma.mbg.client.SearchKeyEnum;
import com.kingdee.eas.ma.mbg.client.utils.AssignSolutionInterface;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.designer.IAction;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgSchemeDispatchUI
extends AbstractBgSchemeDispatchUI
implements AssignSolutionInterface {
    private static final long serialVersionUID = -1819748278525103933L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeDispatchUI.class);
    private static final String COL_SELECT = "select";
    private static final Color NO_DISPATCHED = Color.BLACK;
    private static final Color DISPATCHED_BY_CURRSCHEME = Color.RED;
    private static final Color NOFINANCE = Color.GRAY;
    protected Set<String> selectIds = null;
    private Set<BOSUuid> companyIds = new HashSet<BOSUuid>();
    private Map<BOSUuid, Set<BOSUuid>> dispatchMap = new HashMap<BOSUuid, Set<BOSUuid>>();
    private TreeModel oldTree = null;
    private TreeWillExpandListener listener = null;
    private BgTemplateCollection temColls = new BgTemplateCollection();
    private KDPopupMenu popMenu = new KDPopupMenu();
    private LongTimeDialog dialog = null;
    private boolean isRefeshOrgUnitTree = false;

    public Set<String> getSelectIds() {
        return this.selectIds;
    }

    public void setSelectIds(Set<String> selectIds) {
        this.selectIds = selectIds;
    }

    public Set<BOSUuid> getCompanyIds() {
        return this.companyIds;
    }

    public Map<BOSUuid, Set<BOSUuid>> getDispatchMap() {
        return this.dispatchMap;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public BgTemplateCollection getTemColls() {
        return this.temColls;
    }

    protected String getBgSchemeId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
    }

    protected BgSchemeInfo getBgScheme() {
        return (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
    }

    protected String getBgOrgViewId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGORGVIEW_ID);
    }

    protected String getOrgUnitId() {
        return (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
    }

    public void onLoad() throws Exception {
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        super.onLoad();
        if (this.getUIContext().get("selectTemplates") != null) {
            this.setSelectIds((Set)this.getUIContext().get("selectTemplates"));
        } else {
            this.setSelectIds(new HashSet<String>());
        }
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void initListener() {
        super.initListener();
        this.treeOrgUnit.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                BgSchemeDispatchUI.this.treeOrgUnit_nodeStateChange(event);
            }
        });
        this.iniPoppMenu();
    }

    protected String getSelectOrgViewId() {
        if (this.comBgOrgView.getSelectedItem() instanceof BgOrgViewInfo) {
            return ((BgOrgViewInfo)this.comBgOrgView.getSelectedItem()).getId().toString();
        }
        return this.getBgOrgViewId();
    }

    protected void init() throws Exception {
        BgOrgTreeHelper.resetAction(this.treeViewOrgUnit, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgSchemeDispatchUI.this.loadOrgUnitTree();
                TreeNode root = (TreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getModel().getRoot();
                BgSchemeDispatchUI.this.treeOrgUnit.expandAllNodes(true, root);
            }
        });
        this.initData();
        this.initBgOrgView();
        this.initBgOrgUnit();
        this.initBgTemplate();
    }

    protected void initData() throws Exception {
        this.initCompanyIds();
        this.initDispatchData();
    }

    protected void initBgOrgView() throws Exception {
        this.contBgOrgView.setEnabled(false);
        BgOrgViewCollection colls = this.getBgOrgViews();
        if (colls != null && !colls.isEmpty()) {
            BgOrgViewInfo orgView = null;
            BgOrgViewInfo selView = null;
            String bgOrgViewId = this.getBgOrgViewId();
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                orgView = colls.get(i);
                this.comBgOrgView.addItem((Object)orgView);
                if (!orgView.getId().toString().equals(bgOrgViewId)) continue;
                selView = orgView;
            }
            if (selView != null) {
                this.comBgOrgView.setSelectedItem(selView);
            } else {
                this.comBgOrgView.setSelectedIndex(0);
            }
            this.comBgOrgView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        BgSchemeDispatchUI.this.comBgOrgView_itemStateChanged(e);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"", (Throwable)e1);
                        BgSchemeDispatchUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            });
        }
    }

    protected void initBgOrgUnit() throws Exception {
        BgOrgViewInfo bgOrgView;
        String schemeOrgId = this.getBgScheme().getOrgUnit().getId().toString();
        boolean isContainSealUp = false;
        if (this.getClass().getName().indexOf("BgSchemeAntiDispatchUI") > 0) {
            isContainSealUp = true;
        }
        if (!schemeOrgId.equals(this.getOrgUnitId())) {
            String bgOrgId = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(this.getOrgUnitId(), this.getSelectOrgViewId(), false);
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, bgOrgId, this.getListener(), this.getSelectOrgViewId(), true, null, false, isContainSealUp));
        } else {
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, null, this.getListener(), this.getSelectOrgViewId(), true, null, false, isContainSealUp));
        }
        this.setRefeshOrgUnitTree(false);
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.setModel(this.getOldTree());
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitId(), null);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        if ((bgOrgView = (BgOrgViewInfo)this.comBgOrgView.getSelectedItem()).getBgOrguniteDirectFold() != BgOrgunitViewFoldEnum.unfold) {
            this.treeOrgUnit.expandOnLevel(2);
        } else {
            this.treeOrgUnit.expandOnLevel(3);
        }
    }

    protected void initBgTemplate() throws Exception {
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.temTable.getColumn("createtime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getTemColls().clear();
        BgTemplateCollection colls = this.getBgTemplateColls(this.getBgSchemeId(), this.getOrgUnitId());
        if (colls != null) {
            int i;
            BgTemplateInfo template = null;
            int in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus()) || !this.selectIds.contains(template.getId().toString())) continue;
                this.getTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, true);
            }
            in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus()) || this.selectIds.contains(template.getId().toString())) continue;
                this.getTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, false);
            }
            this.temTable.getSelectManager().select(0, 0);
        }
    }

    protected void comBgOrgView_itemStateChanged(ItemEvent e) throws Exception {
        this.initBgOrgUnit();
    }

    protected BgOrgViewCollection getBgOrgViews() throws Exception {
        return BgOrgViewFactory.getRemoteInstance().getBgOrgViewCollection("where id in(select FmemberID FROM T_MBG_BgDimSettingsMember where FBgDimSettingsID in (select FID FROM T_MBG_BgDimSettings Where FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' And FBgSchemeID = '" + this.getBgSchemeId() + "'))  And id in (Select FViewId FROM T_Mbg_BgOrgUnit Where FOrgUnitId = '" + this.getOrgUnitId() + "') order by number");
    }

    protected void addRowByTemplate(KDTable table, BgTemplateInfo template, boolean isChoose) {
        if (table == null || template == null) {
            return;
        }
        IRow row = this.temTable.addRow();
        row.setUserObject((Object)template);
        row.getCell("id").setValue((Object)template.getId());
        row.getCell(COL_SELECT).setValue((Object)isChoose);
        row.getCell("number").setValue((Object)template.getNumber());
        row.getCell("name").setValue((Object)template.getName());
        row.getCell("creator").setValue((Object)template.getCreator().getName());
        row.getCell("createtime").setValue((Object)template.getCreateTime());
        row.getCell("temType").setValue((Object)template.getFormType());
    }

    protected BgTemplateCollection getBgTemplateColls(String bgSchemeId, String orgUnitId) throws Exception {
        return BgSchemeDispatchUtils.getBgTemplateColls(bgSchemeId, orgUnitId);
    }

    protected void buildBgOrgTree(List<BgOrgUnitInfo> orgUnitColl, String bgOrgViewId, List<String> nodeOrgIDList) throws BOSException, Exception {
        this.treeViewOrgUnit.setShowButton(true);
        this.treeViewOrgUnit.updateUI();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(false);
        TreeModel bgOrgTreeModel = null;
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            return;
        }
        TreePath path = null;
        List<DefaultKingdeeTreeNode> nodeList = null;
        bgOrgTreeModel = BgOrgTreeHelper.buildMultiTreeModel(orgUnitColl);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)bgOrgTreeModel.getRoot();
        root.setCheckBoxVisible(false);
        this.treeOrgUnit.setModel(bgOrgTreeModel);
        this.setOldTree(bgOrgTreeModel);
        this.treeOrgUnit.getSelectionModel().setSelectionMode(4);
        if (EmptyUtil.isEmpty(nodeOrgIDList)) {
            this.treeOrgUnit.expandOnLevel(3);
        } else {
            nodeList = BgOrgTreeHelper.findForAllExtendNode(root, nodeOrgIDList);
            for (DefaultKingdeeTreeNode node : nodeList) {
                if (node == null) continue;
                path = new TreePath(node.getPath());
                this.treeOrgUnit.expandPath(path);
            }
        }
        this.treeOrgUnit.setShowCheckBox(true);
        Set userSet = BgOrgViewFactory.getRemoteInstance().getOrgUnitCollByViewId(BOSUuid.read((String)this.getBgOrgViewId()), true);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable(root, true, true, this.getOrgUnitId(), userSet);
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowsRootHandles(true);
        this.treeOrgUnit.repaint();
    }

    protected void initCompanyIds() throws Exception {
        this.getCompanyIds().addAll(this.queryCompanyIds());
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return this.getDispatchInterface().queryCompanyIds();
    }

    protected void initDispatchData() throws Exception {
        this.getDispatchMap().clear();
        Map tmpMap = this.getDispatchInterface().queryDispatchInfo(BOSUuid.read((String)this.getBgSchemeId()));
        if (tmpMap != null) {
            Map disMap = (Map)tmpMap.get(BgSchemeDispatchConstants.SCHEME_DISPATCH);
            this.getDispatchMap().putAll(disMap);
        }
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"allLeafOrg"));
        menuItem.addActionListener((ActionListener)new AllLeafOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new AllSubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectDispatch"));
        menuItem.addActionListener((ActionListener)new DispatchOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectCompany"));
        menuItem.addActionListener((ActionListener)new CompanyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"propertyChoose"));
        menuItem.addActionListener((ActionListener)new PropertyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
    }

    protected void treeOrgUnit_nodeStateChange(TreeNodeStateChangeEvent event) {
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.fillDispatchInfo();
    }

    protected BgTemplateInfo getSelectedTemplate() {
        int rowIndex = this.temTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        IRow row = this.temTable.getRow(rowIndex);
        BgTemplateInfo template = (BgTemplateInfo)row.getUserObject();
        return template;
    }

    protected List<String> getSelectedTemplateIds() {
        ArrayList<String> selBgTemplateIds = new ArrayList<String>();
        Object obj = null;
        IRow row = null;
        BgTemplateInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgTemplateInfo)row.getUserObject();
            obj = row.getCell(COL_SELECT).getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            selBgTemplateIds.add(template.getId().toString());
        }
        return selBgTemplateIds;
    }

    protected void selectedTemplateIds(Collection<String> selBgTemplateIds) {
        IRow row = null;
        BgTemplateInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgTemplateInfo)row.getUserObject();
            if (selBgTemplateIds != null && selBgTemplateIds.contains(template.getId().toString())) {
                row.getCell(COL_SELECT).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
        }
    }

    protected List<String> getSelectedOrgUnitIds() {
        return BgOrgUnitUtils.getSelectOrgUnitIds(this.treeOrgUnit);
    }

    @Override
    public void clear() throws Exception {
        BgOrgViewInfo orgView = new BgOrgViewInfo();
        orgView.setId(BOSUuid.read((String)this.getBgOrgViewId()));
        BgNFCHelper.setSelectObject(this.comBgOrgView, orgView);
        this.selectedTemplateIds(null);
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
    }

    @Override
    public Object saveSolution() throws Exception {
        HashMap<String, String> solution = new HashMap<String, String>();
        solution.put("BGORGVIEW_ID", this.getSelectOrgViewId());
        solution.put(BgBaseConstants.BGTEMPLATE_ID, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(this.getSelectedTemplateIds())));
        solution.put(BgBaseConstants.ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(this.getSelectedOrgUnitIds())));
        return solution;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        if (o instanceof Map) {
            Map solution = (Map)o;
            BgOrgViewInfo orgView = new BgOrgViewInfo();
            if (solution.get("BGORGVIEW_ID") instanceof String) {
                orgView.setId(BOSUuid.read((String)((String)solution.get("BGORGVIEW_ID"))));
            } else {
                orgView.setId(BOSUuid.read((String)this.getBgOrgViewId()));
            }
            BgNFCHelper.setSelectObject(this.comBgOrgView, orgView);
            if (solution.containsKey(BgBaseConstants.BGTEMPLATE_ID)) {
                Collection selBgTemplateIds = (Collection)BgAnalyseHelper.getObject(BgAnalyseHelper.decode((String)solution.get(BgBaseConstants.BGTEMPLATE_ID)));
                this.selectedTemplateIds(selBgTemplateIds);
            }
            if (solution.containsKey(BgBaseConstants.ORGUNIT_IDS)) {
                Collection selOrgUnitIds = (Collection)BgAnalyseHelper.getObject(BgAnalyseHelper.decode((String)solution.get(BgBaseConstants.ORGUNIT_IDS)));
                HashSet ids = null;
                if (selOrgUnitIds instanceof Set) {
                    ids = (HashSet)selOrgUnitIds;
                } else if (selOrgUnitIds != null) {
                    ids = new HashSet(selOrgUnitIds);
                }
                final HashSet copy = ids;
                IAction after = new IAction(){

                    @Override
                    public String getID() {
                        return null;
                    }

                    @Override
                    public void doAction() throws Exception {
                        BgOrgUnitUtils.selectOrgUnit(BgSchemeDispatchUI.this.treeOrgUnit, (Set<String>)copy);
                    }
                };
                this.loadOrgUnitTree(after);
            }
        }
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = this.getBgSchemeId();
        String operateType = null;
        if (this.getUIContext().get("operateType") != null) {
            operateType = (String)this.getUIContext().get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String CUID = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_CU);
            oql.append(" and cuid='" + CUID + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + BgSchemeDispatchUI.class.getName() + "'");
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = this.getBgSchemeId();
        String operateType = null;
        if (this.getUIContext().get("operateType") != null) {
            operateType = (String)this.getUIContext().get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution = 1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + BgSchemeDispatchUI.class.getName() + "'");
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    @Override
    public void verifyData() throws Exception {
        List<String> bgOrgUnitIds;
        super.verifyData();
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)("selectBgTemplate" + this.getMessageFlag())));
            SysUtil.abort();
        }
        if ((bgOrgUnitIds = this.getSelectedOrgUnitIds()) == null || bgOrgUnitIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)("selectBgOrgUnit" + this.getMessageFlag())));
            SysUtil.abort();
        }
    }

    protected String getMessageFlag() {
        return "";
    }

    @Override
    protected void btnConferm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConferm_actionPerformed(e);
        this.verifyData();
        this.assign();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.verifyData();
        this.assign();
        return false;
    }

    protected void assign() throws Exception {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                return BgSchemeDispatchUI.this.bgSchemeDispatch();
            }

            public void afterExec(Object result) throws Exception {
                List _result = (List)result;
                if (_result != null) {
                    BgOrgTreeHelper.selectAllSubNode((DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getModel().getRoot(), false);
                    BgSchemeDispatchUI.this.treeOrgUnit.repaint();
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH, (Object)Boolean.TRUE);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)_result);
                    uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)BgSchemeDispatchUI.this.getBgScheme());
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSchemeDispatchUI.this.getDispatchReportUIName(), (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
            }
        });
        this.dialog.show();
        this.setRefeshOrgUnitTree(false);
        this.initDispatchData();
        this.refeshOrgUnitTree();
    }

    protected List<String[]> bgSchemeDispatch() throws BOSException, EASBizException {
        return this.getDispatchInterface().dispatch(this.getParameter());
    }

    protected Map<String, Object> getParameter() {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put(BgBaseConstants.BGSCHEME_ID, this.getBgSchemeId());
        parameter.put(BgBaseConstants.BGTEMPLATE_ID, this.getSelectedTemplateIds());
        parameter.put(BgBaseConstants.ORGUNIT_ID, this.getSelectedOrgUnitIds());
        return parameter;
    }

    protected String getDispatchReportUIName() {
        return BgSchemeDispatchReportUI.class.getName();
    }

    protected String getPropertyChooseUIName() {
        return BgPropertyChooseUI.class.getName();
    }

    @Override
    public boolean cancel() throws Exception {
        this.destroyWindow();
        return true;
    }

    @Override
    public String getNewConfermLabel() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeResource", (String)"re.assign");
    }

    public LongTimeDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    protected void loadOrgUnit() {
        if (!this.isRefeshOrgUnitTree()) {
            this.loadOrgUnitTree(null);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void loadOrgUnitTree() {
        this.loadOrgUnitTree(null);
    }

    private void loadAllOrgToOrgUnitTree() throws Exception {
        IObjectCollection orgCols = BgOrgUnitFactory.getRemoteInstance().getRootPermisionOrg(this.getBgOrgViewId(), "", true, false, "", true, false);
        BgOrgUnitCollection bgOrgCols = null;
        ArrayList<BgOrgUnitInfo> orgList = new ArrayList<BgOrgUnitInfo>();
        if (orgCols instanceof BgOrgUnitCollection) {
            bgOrgCols = (BgOrgUnitCollection)orgCols;
        }
        if (bgOrgCols == null) {
            return;
        }
        for (int i = 0; i < bgOrgCols.size(); ++i) {
            orgList.add(bgOrgCols.get(i));
        }
        TreeModel bgOrgTreeModel = BgOrgTreeHelper.buildMultiTreeModel(orgList);
        this.treeOrgUnit.setModel(bgOrgTreeModel);
        this.treeOrgUnit.setShowCheckBox(true);
    }

    private void loadOrgUnitTree(final IAction afterAction) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSchemeDispatchUI.this.refeshOrgUnitTree();
                if (afterAction != null) {
                    afterAction.doAction();
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void refeshOrgUnitTree() throws Exception {
        if (!this.isRefeshOrgUnitTree() && this.getOldTree() != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            this.refeshOrgUnitTree(root);
            this.fillOrgUnitColor();
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1) {
            try {
                BgOrgUnitUtils.addChildNode(root, this.getSelectOrgViewId(), false);
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    protected void fillOrgUnitColor() throws Exception {
        BgTemplateInfo template = this.getSelectedTemplate();
        if (template != null) {
            this.fillOrgUnitColor(template);
            this.treeOrgUnit.repaint();
        }
    }

    protected void fillOrgUnitColor(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        BgTemplateInfo template = this.getSelectedTemplate();
        if (template != null) {
            this.fillOrgUnitColor(template, root);
            this.treeOrgUnit.repaint();
        }
    }

    protected void fillOrgUnitColor(BgTemplateInfo template) throws Exception {
        if (template == null || this.treeOrgUnit.getModel() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.fillOrgUnitColor(template, root);
    }

    protected void fillOrgUnitColor(BgTemplateInfo template, DefaultKingdeeTreeNode root) throws Exception {
        if (template == null || root == null) {
            return;
        }
        Set<BOSUuid> orgUnitIds = this.getDispatchMap().get(template.getId());
        if (orgUnitIds == null) {
            orgUnitIds = new HashSet<BOSUuid>();
        }
        this.fillOrgUnitColor(root, orgUnitIds);
    }

    protected void fillOrgUnitColor(DefaultKingdeeTreeNode root, Set<BOSUuid> orgUnitIds) {
        if (root == null || orgUnitIds == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        BOSUuid uuid = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                bgOrgUnit = (BgOrgUnitInfo)node.getUserObject();
                uuid = BOSUuid.read((String)bgOrgUnit.getOrgUnitID());
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    uuid = oui.getUnit().getId();
                }
            } else if (node.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)node.getUserObject();
                uuid = tmpUnit.getId();
            }
            if (orgUnitIds.contains(uuid)) {
                node.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                node.setTextColor(NO_DISPATCHED);
            }
            if (node.isLeaf()) continue;
            this.fillOrgUnitColor(node, orgUnitIds);
        }
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_SELECT).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), true);
        this.treeOrgUnit.expandOnLevel(7);
        this.treeOrgUnit.repaint();
    }

    private void _selectAllBgOrg() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        }
        node.setCheckBoxVisible(false);
        try {
            this.fillOrgUnitColor();
        }
        catch (Exception e) {
            logger.error((Object)"fill color error", (Throwable)e);
        }
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable(node, true, true, this.getOrgUnitId(), null);
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), true);
        BgOrgUnitUtils.removeTreeWillExpandListeners(this.treeOrgUnit);
    }

    private TreeModel loadAllOrgModel() {
        String viewId = this.getBgOrgViewId();
        EntityViewInfo bgOrgEntityInfo = BgOrgUnitHelper.getBgOrgEntityViewInfo(viewId);
        ArrayList<BgOrgUnitInfo> bgOrgList = new ArrayList<BgOrgUnitInfo>();
        BgOrgUnitCollection orgUnitColl = null;
        BgOrgUnitInfo bgOrginfo = null;
        TreeModel bgOrgTreeModel = null;
        try {
            orgUnitColl = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(bgOrgEntityInfo);
            int size = orgUnitColl.size();
            for (int i = 0; i < size; ++i) {
                bgOrginfo = orgUnitColl.get(i);
                bgOrgList.add(bgOrginfo);
            }
            bgOrgTreeModel = BgOrgTreeHelper.buildMultiTreeModel(bgOrgList);
        }
        catch (BOSException e) {
            logger.error((Object)"load org error ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"load org error ", (Throwable)e);
        }
        return bgOrgTreeModel;
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        }
        BgOrgUnitUtils.selectOrgUnit(node, false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void txtKey_focusLost(FocusEvent e) throws Exception {
        super.txtKey_focusLost(e);
        this.doSearch();
    }

    @Override
    public void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.doSearch();
    }

    protected void doSearch() {
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)((Object)this.comSearchKey.getSelectedItem());
        if (StringUtils.isEmpty((String)value)) {
            this.restartTemplateColls(this.getTemColls());
            this.treeOrgUnit.setModel(this.getOldTree());
            this.treeOrgUnit.updateUI();
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            return;
        }
        BgTemplateInfo template = this.getSelectedTemplate();
        Set<Object> orgUnitIds = null;
        orgUnitIds = template != null ? this.getDispatchMap().get(template.getId()) : new HashSet();
        TreeModel model = null;
        if (keyEnum.getValue() == 0 || keyEnum.getValue() == 10) {
            if (keyEnum.getValue() == 0) {
                model = BgOrgUnitUtils.clipAndCloneTreeModel(this.getOldTree(), new String[]{"name"}, value, true, orgUnitIds);
            } else if (keyEnum.getValue() == 10) {
                model = BgOrgUnitUtils.clipAndCloneTreeModel(this.getOldTree(), new String[]{"number"}, value, true, orgUnitIds);
            }
            this.treeOrgUnit.setModel(model);
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitId(), null);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            if (root != null) {
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
                root.setChecked(false);
            }
            this.treeOrgUnit.expandOnLevel(7);
        } else if (keyEnum.getValue() == 30) {
            this.filterTemplateColls(this.getTemColls(), "number", value, true);
        } else if (keyEnum.getValue() == 20) {
            this.filterTemplateColls(this.getTemColls(), "name", value, true);
        }
    }

    protected void restartTemplateColls(BgTemplateCollection colls) {
        List<String> selectIds = this.getSelectedTemplateIds();
        this.temTable.removeRows();
        if (colls == null) {
            return;
        }
        BgTemplateInfo template = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            if (BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus())) continue;
            this.addRowByTemplate(this.temTable, template, selectIds != null && selectIds.contains(template.getId().toString()));
        }
        this.temTable.repaint();
    }

    protected void filterTemplateColls(BgTemplateCollection colls, String fields, String value, boolean isBlured) {
        this.temTable.removeRows();
        if (colls == null || fields == null || value == null) {
            return;
        }
        BgTemplateInfo template = null;
        Object obj = null;
        String tmpValue = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            if (BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus()) || (obj = template.get(fields)) == null) continue;
            tmpValue = obj.toString();
            if (isBlured) {
                if (tmpValue.indexOf(value) < 0) continue;
                this.addRowByTemplate(this.temTable, template, false);
                continue;
            }
            if (!tmpValue.equals(value)) continue;
            this.addRowByTemplate(this.temTable, template, false);
        }
        this.temTable.repaint();
    }

    @Override
    protected void temTable_editValueChanged(KDTEditEvent e) throws Exception {
        this.temTable.getEditManager().stopEditing();
        this.fillDispatchInfo();
    }

    @Override
    protected void temTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() > 0 && !COL_SELECT.equals(this.temTable.getColumnKey(e.getColIndex()))) {
            ICell cell;
            cell.setValue((Object)(!Boolean.TRUE.equals((cell = this.temTable.getCell(e.getRowIndex(), COL_SELECT)).getValue()) ? 1 : 0));
            this.fillDispatchInfo();
        }
    }

    private void fillDispatchInfo() throws Exception {
        HashSet<String> selectTemplateIds = new HashSet<String>(this.getSelectedTemplateIds());
        this.selectIds = selectTemplateIds;
        if (this.treeOrgUnit.getModel() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.fillDispatchInfo(root, selectTemplateIds);
        this.treeOrgUnit.repaint();
    }

    private void fillDispatchInfo(DefaultKingdeeTreeNode root, Set<String> selectTemplateIds) throws Exception {
        if (root == null || selectTemplateIds == null) {
            return;
        }
        HashMap orgAndBgTemplateIds = new HashMap();
        Iterator<BOSUuid> it = this.getDispatchMap().keySet().iterator();
        while (it.hasNext()) {
            String bgTemplateId = it.next().toString();
            Set<BOSUuid> ordIds = this.getDispatchMap().get(BOSUuid.read((String)bgTemplateId));
            Iterator<BOSUuid> ite = ordIds.iterator();
            while (ite.hasNext()) {
                String orgId = ite.next().toString();
                if (!orgAndBgTemplateIds.containsKey(orgId)) {
                    orgAndBgTemplateIds.put(orgId, new HashSet());
                }
                ((Set)orgAndBgTemplateIds.get(orgId)).add(bgTemplateId);
            }
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        String orgUnitId = null;
        Object dispatchIds = null;
        HashSet cloneDispatchIds = new HashSet();
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            cloneDispatchIds.clear();
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    orgUnitId = oui.getUnit().getId().toString();
                }
            } else if (node.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)node.getUserObject();
                orgUnitId = tmpUnit.getId().toString();
            } else {
                if (!(node.getUserObject() instanceof BgOrgUnitInfo)) continue;
                orgUnitId = ((BgOrgUnitInfo)node.getUserObject()).getOrgUnitID();
            }
            if (orgUnitId != null && orgAndBgTemplateIds.get(orgUnitId) != null) {
                cloneDispatchIds.addAll((Collection)orgAndBgTemplateIds.get(orgUnitId));
            }
            cloneDispatchIds.retainAll(selectTemplateIds);
            if (!cloneDispatchIds.isEmpty()) {
                node.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                node.setTextColor(NO_DISPATCHED);
            }
            if (node.isLeaf()) continue;
            this.fillDispatchInfo(node, selectTemplateIds);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeId());
            request.put(BgBaseConstants.BGORGVIEW_ID, (Object)this.getBgOrgViewId());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitId());
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserPk().toString());
        }
        return handler;
    }

    protected IBgOrgView getBgOrgViewInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    protected IBgSchemeDispatchFacade getDispatchInterface() throws BOSException {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance();
    }

    class PropertyListener
    implements ActionListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set<String> set = new HashSet<String>();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSchemeDispatchUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getModel().getRoot();
            if (set != null) {
                set = BgOrgUnitHelper.getOrgIdByFid(set, BgSchemeDispatchUI.this.getBgOrgViewId()).keySet();
            }
            BgOrgUnitUtils.selectOrgUnitIds(node, set);
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class CompanyListener
    implements ActionListener {
        CompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgSchemeDispatchUI.this.getCompanyIds());
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class AllSubOrgUnitListener
    implements ActionListener {
        AllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class AllLeafOrgUnitListener
    implements ActionListener {
        AllLeafOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectLeafOrgUnit(node, true);
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgUnitListener
    implements ActionListener {
        AllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgUnitUtils.selectOrgUnit(BgSchemeDispatchUI.this.treeOrgUnit.getModel(), true);
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class DispatchOrgUnitListener
    implements ActionListener {
        DispatchOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgTemplateInfo template = BgSchemeDispatchUI.this.getSelectedTemplate();
            if (template != null) {
                BgOrgUnitUtils.selectOrgUnitByIds(node, BgSchemeDispatchUI.this.getDispatchMap().get(template.getRootId()));
            }
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class SubOrgUnitListener
    implements ActionListener {
        SubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSchemeDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgSchemeDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgSchemeDispatchUI.this.getPopMenu().show((Component)BgSchemeDispatchUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

