/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationReportFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeIntegrateClearUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgSchemeIntegrateClearUI
extends AbstractBgSchemeIntegrateClearUI {
    private static final long serialVersionUID = -5042272736047207408L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeIntegrateClearUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtTotalCount.setText(String.valueOf(BgSchemeIntegrationReportFactory.getRemoteInstance().getTotalCount()));
        this.txtTotalCount.setEnabled(false);
        Calendar lastMonth = Calendar.getInstance();
        lastMonth.add(2, -1);
        this.pkEndTime.setValue((Object)lastMonth.getTime());
        this.pkBeginTime.setValue(null);
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        Date end = (Date)this.pkEndTime.getValue();
        if (end == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeIntegrationResource", (String)"selectEndTime"));
            return;
        }
        end = BgNPeriodHelper.getDayEnd((Date)end);
        Date begin = (Date)this.pkBeginTime.getValue();
        if (begin != null && end.compareTo(begin = BgNPeriodHelper.getDayBegin((Date)begin)) < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeIntegrationResource", (String)"startLargeEnd"));
            return;
        }
        final Timestamp beginStamp = begin == null ? null : new Timestamp(begin.getTime());
        final Timestamp endStamp = new Timestamp(end.getTime());
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        LongTimeDialog dialog = new LongTimeDialog((Dialog)win);
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSchemeIntegrationReportFactory.getRemoteInstance().clearRpt(beginStamp, endStamp);
                BgSchemeIntegrateClearUI.this.disposeUIWindow();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    @Override
    protected void tbnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

