/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimCollection;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimFactory;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeRefDimPickUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeEditUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.cube.RefDimInfo;
import com.kingdee.eas.ma.mbg.utils.VOComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSchemeRefDimPickUI
extends AbstractBgSchemeRefDimPickUI {
    private static final long serialVersionUID = 1670634077870404502L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeRefDimPickUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadRefDimens();
    }

    protected void loadRefDimens() throws Exception {
        this.tblMain.removeRows();
        List bgTemplateIds = (List)this.getUIContext().get("IDList");
        String bgSchemeId = (String)this.getUIContext().get("ID");
        Map result = BgSchemeRefDimFactory.getRemoteInstance().checkRefDim(bgSchemeId, bgTemplateIds);
        if (result == null || result.isEmpty()) {
            return;
        }
        ArrayList<DimensionSourceInfo> sources = new ArrayList<DimensionSourceInfo>();
        for (BgSchemeRefDimCollection col : result.values()) {
            for (int i = 0; i < col.size(); ++i) {
                sources.add(col.get(i).getIndexSource());
            }
        }
        DimensionClientHelper.loadSourceNameInfo(sources);
        ArrayList bgTemplates = new ArrayList(result.keySet());
        VOComparator comp = new VOComparator(new String[]{"number"}, true);
        Collections.sort(bgTemplates, comp);
        for (int t = 0; t < bgTemplates.size(); ++t) {
            BgTemplateInfo bgTemplate = (BgTemplateInfo)bgTemplates.get(t);
            BgSchemeRefDimCollection refDims = (BgSchemeRefDimCollection)((Object)result.get(bgTemplate));
            for (int r = 0; r < refDims.size(); ++r) {
                BgSchemeRefDimInfo refDim = refDims.get(r);
                IRow row = this.tblMain.addRow();
                row.setUserObject((Object)refDim);
                row.getCell("select").setValue((Object)Boolean.FALSE);
                row.getCell("bgTemplate.number").setValue((Object)bgTemplate.getNumber());
                row.getCell("bgTemplate.name").setValue((Object)bgTemplate.getName());
                row.getCell("indexSource").setValue((Object)refDim.getIndexSource());
                row.getCell("bgElement").setValue((Object)RefDimInfo.getBgElementMembers(refDim));
                row.getCell("bgScenario").setValue((Object)RefDimInfo.getBgScenarioMembers(refDim));
                String dimName = refDim.getBgDimName();
                dimName = dimName.indexOf(";") >= 0 ? dimName.substring(dimName.indexOf(";") + 1) : "";
                row.getCell("refDim").setValue((Object)dimName);
            }
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            this.tblMain.getCell(r, "select").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            this.tblMain.getCell(r, "select").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadRefDimens();
    }

    @Override
    public void actionBuild_actionPerformed(ActionEvent e) throws Exception {
        super.actionBuild_actionPerformed(e);
        BgSchemeRefDimCollection refDims = new BgSchemeRefDimCollection();
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            if (!Boolean.TRUE.equals(this.tblMain.getCell(r, "select").getValue())) continue;
            refDims.add((BgSchemeRefDimInfo)this.tblMain.getRow(r).getUserObject());
        }
        if (refDims.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        if (this.getUIContext().get("Owner") instanceof BgSchemeEditUI) {
            // empty if block
        }
        this.getUIWindow().close();
    }
}

