/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.client.MbgProgressBaseUI;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.progress.IMbgProgress;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgSchemeFacade;
import com.kingdee.eas.ma.mbg.MbgConvertSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeTreeListUI;
import com.kingdee.eas.ma.mbg.client.AssignSolutionUI;
import com.kingdee.eas.ma.mbg.client.BgCopyDataToDecompUI;
import com.kingdee.eas.ma.mbg.client.BgDataExportUI;
import com.kingdee.eas.ma.mbg.client.BgDataImportUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.ma.mbg.client.BgParamUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeAntiDispatchUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeDispatchUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeEditUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeEditUI4Copy;
import com.kingdee.eas.ma.mbg.client.DimensionMainUI;
import com.kingdee.eas.ma.mbg.client.MbgSchemeSplitUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.cube.utils.MbgSchemeSplitInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgSchemeTreeListUI
extends AbstractBgSchemeTreeListUI {
    private static final long serialVersionUID = -4924023663857707426L;
    private static final Logger logger = Logger.getLogger((String)BgSchemeTreeListUI.class.getName());
    private static final String RESORRCE_CLIENT = "com.kingdee.eas.ma.mbg.client.BgSchemeResource";
    public static final String PROVIDER = "provider";
    private CostCenterOrgUnitInfo ccOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
    private OrgUnitInfo currOrgUnit = null;
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private static final Color filingColor = new Color(230, 230, 230);

    public OrgUnitInfo getCurrOrgUnit() {
        if (this.currOrgUnit == null && this.ccOrgUnit != null) {
            this.currOrgUnit = this.ccOrgUnit.castToFullOrgUnitInfo();
        }
        return this.currOrgUnit;
    }

    private void setCurrOrgUnit(OrgUnitInfo currOrgUnit) {
        this.currOrgUnit = currOrgUnit;
    }

    public CtrlUnitInfo getCurrCU() {
        return this.currCU;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        MbgUpdateHelper.checkUpdate();
        this.initDataFacade();
        this.tblMain.getColumn("dateFrom").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.tblMain.getColumn("dateTo").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.verifyPermission(this.getUserPk().toString(), this.getCurrOrgUnit().getId().toString(), this.getListPermission());
        BgCommCHelper.initOrgUnit((CoreUIObject)this, (KDBizPromptBox)this.prmtOrgUnit, (Object)this.getCurrOrgUnit(), (String)this.getCurrCU().getId().toString(), (String)this.getListPermission());
        BgOrgViewF7 orgView = (BgOrgViewF7)this.prmtOrgUnit.getSelector();
        orgView.setContainSealUp(true);
        AbstractAction actionCheckCube = new AbstractAction(){
            private static final long serialVersionUID = 2579953743658686110L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgSchemeTreeListUI.this.actionCheckCube_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgSchemeTreeListUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_SHIFT_F1";
        KeyStroke ks = KeyStroke.getKeyStroke(112, 192, false);
        this.getActionMap().put(strKey, actionCheckCube);
        this.getInputMap(2).put(ks, strKey);
        AbstractAction actionConvertInt = new AbstractAction(){
            private static final long serialVersionUID = 2579953743658686110L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgSchemeTreeListUI.this.actionConvertInt_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgSchemeTreeListUI.this.handleException(ex);
                }
            }
        };
        strKey = "CTRL_SHIFT_ALT_F5";
        ks = KeyStroke.getKeyStroke(116, 200, false);
        this.getActionMap().put(strKey, actionConvertInt);
        this.getInputMap(2).put(ks, strKey);
    }

    protected void initListener() {
        super.initListener();
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnUnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.btnExecute.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnAntiExecute.setIcon(EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.btnViewBgOrg.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnFiling.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.btnUnFiling.setIcon(EASResource.getIcon((String)"imgTbtn_unarchive"));
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionQuery.setEnabled(true);
        this.actionViewDim.setEnabled(true);
        this.menuItemExecute.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemAntiExecute.setIcon(EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.menuItemAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemUnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.menuItemViewBgOrg.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnQuery.setVisible(true);
        this.btnViewDim.setVisible(true);
        this.menuItemImportData.setIcon(EASResource.getIcon((String)"imgTbtn_importexcel"));
        this.menuItemImportData.setVisible(false);
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_dcdwj"));
        this.menuItemExportData.setVisible(false);
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (((KDPromptBox)eventObj.getSource()).getData() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)BgSchemeTreeListUI.RESORRCE_CLIENT, (String)"errorCostCenterEmpty"));
                    BgSchemeTreeListUI.this.prmtOrgUnit.setData((Object)BgSchemeTreeListUI.this.getCurrOrgUnit());
                    SysUtil.abort();
                }
            }
        });
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    protected IBgScheme getInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    public IBgSchemeFacade getBgSchemeFacade() throws BOSException {
        return BgSchemeFacadeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgSchemeEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        OrgUnitInfo _orgUnit = this.getOrgUnitInfo();
        FilterInfo filter = this.getDefaultFilterForQuery();
        try {
            if (_orgUnit != null) {
                Set<String> tmpList = this.getBgSchemeIds(_orgUnit.getId());
                BgNFCHelper.setSchemeIdFilter(tmpList, filter);
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
            }
        }
        catch (Exception ex) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("bgSchemeType.schemeType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
        EntityViewInfo view = (EntityViewInfo)viewInfo.clone();
        FilterInfo cusFilter = view.getFilter();
        try {
            BgNFCHelper.removeFilterItems(cusFilter, "id");
            filter.mergeFilter(cusFilter, "AND");
        }
        catch (BOSException ex) {
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        try {
            filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        view.setFilter(filter);
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, view);
        return queryExecutor;
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected Set<String> getBgSchemeIds(BOSUuid orgUnitId) throws Exception {
        return BgNFCHelper.getBgSchemeIds(orgUnitId);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void actionCheckCube_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)"is Check Selected Cube?");
        if (re == 0) {
            String bgSchemeId = this.getSelectedKeyValue();
            BgDimensionFacadeFactory.getRemoteInstance().checkCube(BOSUuid.read((String)bgSchemeId));
        }
    }

    protected void actionConvertInt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgConvertSchemeResource", (String)"confirmSplit"));
        if (re == 0) {
            String bgSchemeId = this.getSelectedKeyValue();
            MbgConvertProgress progressInvoke = new MbgConvertProgress();
            progressInvoke.bgSchemeId = bgSchemeId;
            MbgProgressBaseUI.showProgressUI((CoreUIObject)this, (IMbgProgress)progressInvoke);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getOrgUnitInfo());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)this.getCtrlUnitInfo());
    }

    public void showSplitUI(Object result) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", result);
        try {
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(MbgSchemeSplitUI.class.getName(), (Map)uiContext, null, OprtState.EDIT, 64);
            BgBaseHelper.setMaxDialog((IUIWindow)window);
            if (window instanceof JFrame) {
                ((JFrame)window).setExtendedState(6);
            }
            window.show();
        }
        catch (UIException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected void checkSelectOrgUnit() {
        if (this.prmtOrgUnit.getData() == null) {
            this.prmtOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"selectOrgUnit"));
            SysUtil.abort();
        }
    }

    protected OrgUnitInfo getOrgUnitInfo() {
        Object obj = this.prmtOrgUnit.getData();
        if (obj instanceof FullOrgUnitInfo || obj instanceof OrgUnitInfo) {
            this.setCurrOrgUnit((OrgUnitInfo)obj);
        }
        return this.getCurrOrgUnit();
    }

    protected CtrlUnitInfo getCtrlUnitInfo() {
        CtrlUnitInfo _CU = null;
        OrgUnitInfo _unit = this.getOrgUnitInfo();
        if (_unit != null) {
            if (_unit.getCU() != null) {
                _CU = _unit.getCU();
            } else {
                FullOrgUnitInfo _tmpUnit = null;
                try {
                    _tmpUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id, CU.name where id = '" + _unit.getId() + "'");
                    _unit.setCU(_tmpUnit.getCU());
                    _CU = _unit.getCU();
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
            }
        }
        return _CU;
    }

    protected String getBgOrgViewId() {
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        return (String)row.getCell("bgOrgView.id").getValue();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        if (e.getNewValue() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo _newUnit = (FullOrgUnitInfo)e.getNewValue();
            String permission = this.getListPermission();
            try {
                this.verifyPermission(this.getUserPk().toString(), _newUnit.getId().toString(), permission);
            }
            catch (PermissionException exc) {
                this.handUIException(exc);
                this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                SysUtil.abort();
                return;
            }
            if (e.getOldValue() instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo _oldUnit = (FullOrgUnitInfo)e.getOldValue();
                if (!_oldUnit.getId().equals((Object)_newUnit.getId())) {
                    this.setCurrOrgUnit((OrgUnitInfo)_newUnit);
                    this.refreshList();
                }
            } else {
                this.setCurrOrgUnit((OrgUnitInfo)_newUnit);
                this.refreshList();
            }
        } else {
            this.setCurrOrgUnit(null);
            this.refreshList();
            this.prmtOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"selectOrgUnit"));
            SysUtil.abort();
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        Boolean isFiling = Boolean.FALSE;
        Boolean isFormal = Boolean.FALSE;
        IRow row = this.tblMain.getRow(rowIndex);
        Object obj = row.getCell("isFiling").getValue();
        if (obj instanceof Boolean) {
            isFiling = (Boolean)obj;
        }
        if ((obj = row.getCell("isFormal").getValue()) instanceof Boolean) {
            isFormal = (Boolean)obj;
        }
        String orgUnitId = (String)row.getCell("orgUnit.id").getValue();
        if (isFiling.booleanValue()) {
            BgCommCHelper.disableAction(null, (JMenuItem)this.menuItemFiling, (ItemAction)this.actionFiling);
            BgCommCHelper.enableAction(null, (JMenuItem)this.menuItemUnFiling, (ItemAction)this.actionUnfiling);
            BgCommCHelper.disableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
            BgCommCHelper.disableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
            BgCommCHelper.disableAction((JButton)this.btnAssign, (JMenuItem)this.menuItemAssign, (ItemAction)this.actionAssign);
            BgCommCHelper.disableAction((JButton)this.btnUnAssign, (JMenuItem)this.menuItemUnAssign, (ItemAction)this.actionUnAssign);
            BgCommCHelper.disableAction((JButton)this.btnExecute, (JMenuItem)this.menuItemExecute, (ItemAction)this.actionExecute);
            BgCommCHelper.disableAction((JButton)this.btnAntiExecute, (JMenuItem)this.menuItemAntiExecute, (ItemAction)this.actionAntiExecute);
        } else {
            BgCommCHelper.enableAction((JButton)this.btnAssign, (JMenuItem)this.menuItemAssign, (ItemAction)this.actionAssign);
            BgCommCHelper.enableAction((JButton)this.btnUnAssign, (JMenuItem)this.menuItemUnAssign, (ItemAction)this.actionUnAssign);
            BgCommCHelper.enableAction(null, (JMenuItem)this.menuItemFiling, (ItemAction)this.actionFiling);
            BgCommCHelper.disableAction(null, (JMenuItem)this.menuItemUnFiling, (ItemAction)this.actionUnfiling);
            BgCommCHelper.enableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
            if (isFormal.booleanValue()) {
                BgCommCHelper.disableAction((JButton)this.btnExecute, (JMenuItem)this.menuItemExecute, (ItemAction)this.actionExecute);
                BgCommCHelper.enableAction((JButton)this.btnAntiExecute, (JMenuItem)this.menuItemAntiExecute, (ItemAction)this.actionAntiExecute);
            } else {
                BgCommCHelper.enableAction((JButton)this.btnExecute, (JMenuItem)this.menuItemExecute, (ItemAction)this.actionExecute);
                BgCommCHelper.disableAction((JButton)this.btnAntiExecute, (JMenuItem)this.menuItemAntiExecute, (ItemAction)this.actionAntiExecute);
                BgCommCHelper.enableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
                if (this.getOrgUnitInfo().getId().toString().equals(orgUnitId)) {
                    BgCommCHelper.enableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
                } else {
                    BgCommCHelper.disableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
                }
            }
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        Object obj = null;
        IRow row = null;
        Boolean isFiling = false;
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            obj = row.getCell("isFiling").getValue();
            if (!(obj instanceof Boolean) || !(isFiling = (Boolean)obj).booleanValue()) continue;
            row.getStyleAttributes().setBackground(this.getFilingColor());
        }
    }

    protected boolean checkCreateOrgUnit() {
        boolean isCreateOrgUnit = false;
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell cell = this.tblMain.getRow(selectRowIndex).getCell("orgUnit.id");
        if (cell != null) {
            String _orgUnitId = (String)cell.getValue();
            if (this.getOrgUnitInfo().getId().toString().equals(_orgUnitId)) {
                isCreateOrgUnit = true;
            }
        }
        return isCreateOrgUnit;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkCreateOrgUnit()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"createOrgUnitCantEdit", (Object[])new Object[]{this.getCurrOrgUnit().getName()}));
            SysUtil.abort();
        }
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String bgOrgViewId = (String)row.getCell("bgOrgView.id").getValue();
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)this.getSelectedKeyValue()));
        bgScheme.setName((String)row.getCell("name").getValue());
        bgScheme.setNumber((String)row.getCell("number").getValue());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)bgScheme);
        uiContext.put((Object)BgBaseConstants.BGORGVIEW_ID, (Object)bgOrgViewId);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)this.getCtrlUnitInfo().getId().toString());
        uiContext.put((Object)"selfPanelUiName", (Object)this.getAssignUIName());
        uiContext.put((Object)"operateType", (Object)"1");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
    }

    @Override
    public void actionUnAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAssign_actionPerformed(e);
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String bgOrgViewId = (String)row.getCell("bgOrgView.id").getValue();
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)this.getSelectedKeyValue()));
        bgScheme.setName((String)row.getCell("name").getValue());
        bgScheme.setNumber((String)row.getCell("number").getValue());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)bgScheme);
        uiContext.put((Object)BgBaseConstants.BGORGVIEW_ID, (Object)bgOrgViewId);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)this.getCtrlUnitInfo().getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getUnAssignUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getAssignUIName() {
        return BgSchemeDispatchUI.class.getName();
    }

    protected String getUnAssignUIName() {
        return BgSchemeAntiDispatchUI.class.getName();
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        super.actionExecute_actionPerformed(e);
        this.checkSelected();
        if (!this.checkCreateOrgUnit()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"createOrgUnitCantExecute"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        BOSUuid bgSchemeId = BOSUuid.read((String)((String)row.getCell("id").getValue()));
        String name = (String)row.getCell("name").getValue();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"ConfirmExecute", (Object[])new String[]{name}));
        if (re == 0) {
            OrgUnitInfo _unit = this.getOrgUnitInfo();
            this.getInterface().execute(bgSchemeId, _unit.getId());
            this.refreshList();
        }
    }

    @Override
    public void actionAntiExecute_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiExecute_actionPerformed(e);
        this.checkSelected();
        if (!this.checkCreateOrgUnit()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"createOrgUnitCantExecute"));
            SysUtil.abort();
        }
        BOSUuid bgSchemeId = BOSUuid.read((String)this.getSelectedKeyValue());
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String name = (String)row.getCell("name").getValue();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"ConfirmCancel", (Object[])new String[]{name}));
        if (re == 0) {
            this.getInterface().antiExecute(bgSchemeId);
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"scheme.uninvoke.success"));
            this.refreshList();
        }
    }

    public Color getFilingColor() {
        return filingColor;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row != null) {
            BgSchemeInfo _bgSchemeInfo = new BgSchemeInfo();
            _bgSchemeInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            _bgSchemeInfo.setName(row.getCell("name").getValue().toString());
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGSCHEME_INFO", (Object)_bgSchemeInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDataImportUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSelectOrgUnit();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row != null) {
            BgSchemeInfo _bgSchemeInfo = new BgSchemeInfo();
            _bgSchemeInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            _bgSchemeInfo.setName(row.getCell("name").getValue().toString());
            _bgSchemeInfo.setNumber(row.getCell("number").getValue().toString());
            _bgSchemeInfo.setOrgUnit(this.getOrgUnitInfo().castToFullOrgUnitInfo());
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGSCHEME_INFO", (Object)_bgSchemeInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDataExportUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
    }

    @Override
    public void actionFiling_actionPerformed(ActionEvent e) throws Exception {
        super.actionFiling_actionPerformed(e);
        this.checkSelected();
        if (!this.checkCreateOrgUnit()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"createOrgUnitCantFiling"));
            SysUtil.abort();
        }
        BOSUuid bgSchemeId = BOSUuid.read((String)this.getSelectedKeyValue());
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"sureToFilling"), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"filingRemark"));
        if (re == 0) {
            this.getInterface().filing(bgSchemeId);
            this.refreshList();
        }
    }

    @Override
    public void actionUnFiling_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnFiling_actionPerformed(e);
        this.checkSelected();
        if (!this.checkCreateOrgUnit()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"createOrgUnitCantFiling"));
            SysUtil.abort();
        }
        BOSUuid bgSchemeId = BOSUuid.read((String)this.getSelectedKeyValue());
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String bgSchemeName = (String)row.getCell("name").getValue();
        if (this.getInterface().antiFiling(bgSchemeId)) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"unFilingRemark", (Object[])new String[]{bgSchemeName}));
            this.refreshList();
        }
    }

    @Override
    public void actionViewBgOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBgOrg_actionPerformed(e);
        String bgOrgViewId = this.getBgOrgViewId();
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESORRCE_CLIENT, (String)"setSchemeOrgView"));
        } else {
            BgNewOrgDialog dialog = new BgNewOrgDialog((IUIObject)this);
            dialog.setFilterByCurOrg(false);
            dialog.setBgOrgViewId(bgOrgViewId);
            dialog.show();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (this.getOrgUnitInfo() != null) {
                request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
            }
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserPk().toString());
        }
        return handler;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionRemove(itemAction);
        if (request != null) {
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserInfo().getId().toString());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionExecute() {
        return false;
    }

    @Override
    public RequestContext prepareActionExecute(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionExecute(itemAction);
        if (request != null) {
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionAntiExecute() {
        return false;
    }

    @Override
    public RequestContext prepareActionAntiExecute(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAntiExecute(itemAction);
        if (request != null) {
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionAssign() {
        return true;
    }

    @Override
    public RequestContext prepareActionAssign(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAssign(itemAction);
        this.checkSelected();
        if (request != null) {
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserInfo().getId().toString());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionUnAssign() {
        return true;
    }

    @Override
    public RequestContext prepareActionUnAssign(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionUnAssign(itemAction);
        this.checkSelected();
        if (request != null) {
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserInfo().getId().toString());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionFiling() {
        return false;
    }

    @Override
    public RequestContext prepareActionFiling(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionFiling(itemAction);
        if (request != null) {
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionUnFiling() {
        return false;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected String getListPermission() {
        return "mbg_scheme01_list";
    }

    protected boolean verifyPermission(String userId, String orgUnitId, String permission) throws Exception {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        this.getPermissionInterface().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), permission);
        return true;
    }

    protected IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getOrgUnitInfo() != null) {
            return new ObjectUuidPK(this.getCurrOrgUnit().getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Remove() throws Exception {
        Throwable[] ex = null;
        HashMap<String, EASBizException> exceptionMap = new HashMap<String, EASBizException>();
        ArrayList ids = this.getSelectedIdValues();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                exceptionMap.put(id, mutexException);
                lt.remove();
            }
            if (ids.size() > 0) {
                ArrayList<ObjectStringPK> pkArray = new ArrayList<ObjectStringPK>();
                for (int i = 0; i < ids.size(); ++i) {
                    if (ids.get(i) == null) continue;
                    ObjectStringPK pk = new ObjectStringPK(ids.get(i).toString());
                    pkArray.add(pk);
                }
                BatchExecuteResult result = BgSchemeFactory.getRemoteInstance().deleteBatchData(pkArray.toArray(new IObjectPK[0]), (FullOrgUnitInfo)this.getCurrOrgUnit());
                ex = result.getExceptions();
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (ex != null) {
            for (int i = 0; i < ex.length; ++i) {
                if (ex[i] == null) continue;
                errorMsg.append(ExceptionMessageUtility.getMessage((Throwable)ex[i]) + "\n");
            }
        }
        if (ex != null && ex.length > 0) {
            String deleteError = EASResource.getString((String)RESORRCE_CLIENT, (String)"deleteReport", (Object[])new Object[]{ids.size(), ids.size() - ex.length, ex.length});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorMsg.toString(), (int)8188);
        }
    }

    @Override
    public void actionViewDim_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkViewDimPermission();
        UIContext uiContext = new UIContext((Object)this);
        ArrayList idList = this.getSelectedIdValues();
        uiContext.put((Object)"BGSCHEME_ID", idList.get(0));
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getOrgUnitInfo());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)this.currCU);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getDimUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionBgParam_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgParamUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getDimUIName() {
        return DimensionMainUI.class.getName();
    }

    protected String getViewDimPermission() {
        return "dimension001_list";
    }

    protected void checkViewDimPermission() throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgUnitPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgUnitPK, this.getViewDimPermission());
    }

    protected void initDataFacade() throws Exception {
        AbstractAction controlAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"ORGUNIT_COST", BgSchemeTreeListUI.this.prmtOrgUnit.getData());
                    IUIWindow wnd = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCopyDataToDecompUI.class.getName(), (Map)uiContext);
                    wnd.show();
                }
                catch (UIException ex) {
                    BgSchemeTreeListUI.this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
            }
        };
        String strKey = "CTRL_SHIFT_R";
        KeyStroke ks = KeyStroke.getKeyStroke(82, 192, false);
        this.getActionMap().put(strKey, controlAction);
        this.getInputMap(2).put(ks, strKey);
    }

    @Override
    public void actionCopyScheme_actionPerformed(ActionEvent e) throws Exception {
        this.checkCopyPermission();
        this.checkSelected();
        super.actionCopyScheme_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getSelectedKeyValue());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getOrgUnitInfo());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)this.getCtrlUnitInfo());
        uiContext.put((Object)"addPermission", (Object)this.getAddPermission());
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getCopyShmemUIName(), (Map)uiContext, null, OprtState.EDIT);
        win.show();
    }

    protected String getCopyShmemUIName() {
        return BgSchemeEditUI4Copy.class.getName();
    }

    protected String getAddPermission() {
        return "mbg_scheme02_addNew";
    }

    protected void checkCopyPermission() throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        OrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
        ObjectUuidPK orgUnitPK = new ObjectUuidPK(orgUnitInfo.getId());
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgUnitPK, this.getAddPermission());
    }

    class MbgConvertProgress
    implements IMbgProgress {
        private String bgSchemeId = null;

        MbgConvertProgress() {
        }

        public String getTitle() {
            return EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgConvertSchemeResource", (String)"progressTitle");
        }

        public String getProgressKey() {
            return MbgSchemeSplitInfo.getProgressKey(this.bgSchemeId);
        }

        public Object cancel() throws Exception {
            BgSchemeInfo info = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("Select useAccInt where id = '" + this.bgSchemeId + "'");
            logger.error((Object)("useAccInt " + info.getUseAccInt()));
            MbgConvertSchemeFacadeFactory.getRemoteInstance().setSplitState(this.bgSchemeId, 0);
            info = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("Select useAccInt where id = '" + this.bgSchemeId + "'");
            logger.error((Object)("useAccInt " + info.getUseAccInt()));
            return true;
        }

        public Object start() throws Exception {
            File saveFile = new File("D:/" + this.bgSchemeId + ".data");
            if (saveFile.exists()) {
                return (MbgSchemeSplitInfo)BgAnalyseHelper.getObject(BgAnalyseHelper.loadFormFile(saveFile));
            }
            MbgSchemeSplitInfo splitInfo = MbgConvertSchemeFacadeFactory.getRemoteInstance().readSpitInfo(this.bgSchemeId);
            BgAnalyseHelper.saveToFile(saveFile.getAbsolutePath(), BgAnalyseHelper.getBytes(splitInfo), 4096);
            return splitInfo;
        }

        public void end(Object result) {
            if (result == null) {
                return;
            }
            BgSchemeTreeListUI.this.showSplitUI(result);
        }

        public void exception(Exception e) {
            BgSchemeTreeListUI.this.handUIException(e);
        }
    }
}

