/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.client.AbstractBgSelectOrgUnitUI;
import com.kingdee.eas.ma.mbg.client.BgPropertyChooseUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.ma.mbg.designer.IAction;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgUnitBaseUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgSelectOrgUnitUI
extends AbstractBgSelectOrgUnitUI
implements KeyListener {
    private static final long serialVersionUID = 3843958672933229824L;
    private static final Logger logger = CoreUIObject.getLogger(BgSelectOrgUnitUI.class);
    private OrgUnitInfo unitInfo = null;
    private BgSchemeInfo bgScheme = null;
    private String bgOrgViewId = null;
    private Set<BOSUuid> companyIds = new HashSet<BOSUuid>();
    private TreeModel treeModelOld = null;
    private LongTimeDialog dialog = null;
    private boolean isRefeshOrgUnitTree = false;
    private TreeWillExpandListener listener = null;
    KDPopupMenu popMenu = new KDPopupMenu();
    private ArrayList orgSelectList;

    public OrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(OrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    public void setBgScheme(BgSchemeInfo bgScheme) {
        this.bgScheme = bgScheme;
    }

    public BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    public String getSelectOrgViewId() {
        return this.bgOrgViewId;
    }

    public void getSelectOrgViewId(String bgOrgViewId) {
        this.bgOrgViewId = bgOrgViewId;
    }

    public Set<BOSUuid> getCompanyIds() {
        return this.companyIds;
    }

    public BgSelectOrgUnitUI() throws Exception {
    }

    public BgSelectOrgUnitUI(OrgUnitInfo unitInfo, BgSchemeInfo bgScheme, String bgOrgViewId) throws Exception {
        this.unitInfo = unitInfo;
        this.bgScheme = bgScheme;
        this.bgOrgViewId = bgOrgViewId;
    }

    public void onLoad() throws Exception {
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        super.onLoad();
        this.initCompanyIds();
        this.initOrgUnitTree();
        this.iniPoppMenu();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.treeViewOrgUnit.setShowButton(true);
        this.treeViewOrgUnit.updateUI();
        this.initQuickSearch();
    }

    protected void initCompanyIds() throws Exception {
        this.getCompanyIds().addAll(this.queryCompanyIds());
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance().queryCompanyIds();
    }

    protected void initQuickSearch() {
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtSearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtSearch.addKeyListener((KeyListener)this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.doSearch();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void initOrgUnitTree() throws Exception {
        BgOrgTreeHelper.resetAction(this.treeViewOrgUnit, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgSelectOrgUnitUI.this.loadOrgUnitTree();
                TreeNode root = (TreeNode)BgSelectOrgUnitUI.this.treeOrgUnit.getModel().getRoot();
                BgSelectOrgUnitUI.this.treeOrgUnit.expandAllNodes(true, root);
            }
        });
        this.initOrgUnitModel();
    }

    private void initOrgUnitModel() throws Exception {
        String orgId = this.getUnitInfo().getId().toString();
        String schemeOrgId = this.getBgScheme().getOrgUnit().getId().toString();
        if (!schemeOrgId.equals(orgId)) {
            String bgOrgId = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(orgId, this.getSelectOrgViewId(), false);
            this.treeModelOld = BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, bgOrgId, this.getListener(), this.getSelectOrgViewId(), true, null, false);
        } else {
            this.treeModelOld = BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, null, this.getListener(), this.getSelectOrgViewId(), true, null, false);
        }
        this.setRefeshOrgUnitTree(false);
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.setModel(this.treeModelOld);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        if (root != null && root.getChildCount() > 0) {
            int in = root.getChildCount();
            for (int i = 0; i < in; ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OrgUnitBaseUtils.expandNode(this.treeOrgUnit, child);
            }
        }
    }

    public LongTimeDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    private void loadOrgUnitTree() {
        this.loadOrgUnitTree(null);
    }

    private void loadOrgUnitTree(final IAction afterAction) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSelectOrgUnitUI.this.refeshOrgUnitTree();
                if (afterAction != null) {
                    afterAction.doAction();
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void refeshOrgUnitTree() throws Exception {
        if (!this.isRefeshOrgUnitTree() && this.treeModelOld != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
            this.refeshOrgUnitTree(root);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1) {
            try {
                BgOrgUnitUtils.addChildNode(root, this.getSelectOrgViewId(), false);
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    public void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"allLeafOrg"));
        menuItem.addActionListener((ActionListener)new AllLeafOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new AllSubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectCompany"));
        menuItem.addActionListener((ActionListener)new CompanyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"propertyChoose"));
        menuItem.addActionListener((ActionListener)new PropertyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
    }

    private Set<String> getOrgIdByFid(Set ids) {
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitCollection unitCol = null;
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("orgUnitID");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("ViewId", (Object)this.getSelectOrgViewId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        try {
            iBgOrgUnit = BgOrgUnitFactory.getRemoteInstance();
            unitCol = iBgOrgUnit.getBgOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (unitCol == null || unitCol.isEmpty()) {
            return null;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            set.add(unitCol.get(i).getOrgUnitID());
        }
        return set;
    }

    protected String getPropertyChooseUIName() {
        return BgPropertyChooseUI.class.getName();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect(true, root, true, this.treeOrgUnit);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect(false, root, true, this.treeOrgUnit);
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.doSearch();
    }

    protected void doSearch() {
        String value = this.txtSearch.getText();
        if (StringUtils.isEmpty((String)value)) {
            if (StringUtils.isEmpty((String)((String)this.txtSearch.getUserObject()))) {
                return;
            }
            this.txtSearch.setUserObject((Object)value);
            this.treeOrgUnit.setModel(this.treeModelOld);
            this.treeOrgUnit.updateUI();
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            return;
        }
        this.txtSearch.setUserObject((Object)value);
        TreeModel model = BgOrgUnitUtils.clipAndCloneTreeModel(this.treeModelOld, new String[]{"number", "name"}, value, true, null);
        this.treeOrgUnit.setModel(model);
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getUnitInfo().getId().toString(), null);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        this.treeOrgUnit.expandOnLevel(7);
    }

    public ArrayList getOrgSelectList() {
        return this.orgSelectList;
    }

    public void setOrgSelectList(ArrayList orgSelectList) {
        this.orgSelectList = orgSelectList;
    }

    public boolean verify() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        ArrayList orgs = null;
        try {
            orgs = (ArrayList)this.traceNode(root, new ArrayList());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (orgs == null || orgs.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"selectCalcOrg"));
            SysUtil.abort();
        } else {
            this.setOrgSelectList(orgs);
        }
        return super.verify();
    }

    private List traceNode(DefaultKingdeeTreeNode root, List list) throws Exception {
        if (list == null) {
            list = new ArrayList<FullOrgUnitInfo>();
        }
        if (root.isChecked()) {
            BgOrgUnitInfo oui = (BgOrgUnitInfo)root.getUserObject();
            list.add(oui.castToFullOrgUnitInfo());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
        return list;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams param = new CustomerParams();
        ArrayList orgLst = this.getOrgSelectList();
        param.addCustomerParam("orgSize", String.valueOf(orgLst.size()));
        param.addCustomerParam("orgs", BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(orgLst)));
        return param;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("orgSize") != null) {
            try {
                ArrayList orgLst = (ArrayList)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam("orgs")));
                ArrayList<String> orgIds = new ArrayList<String>();
                if (orgLst != null && !orgLst.isEmpty()) {
                    for (int i = 0; i < orgLst.size(); ++i) {
                        orgIds.add(((OrgUnitInfo)orgLst.get(i)).getId().toString());
                    }
                }
                this.setOrgSelected((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), orgIds);
                this.treeOrgUnit.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setOrgSelected(DefaultKingdeeTreeNode root, ArrayList list) {
        if (list == null) {
            return;
        }
        String orgUnitId = null;
        if (root.getUserObject() instanceof OrgStructureInfo) {
            orgUnitId = ((OrgStructureInfo)root.getUserObject()).getUnit().getId().toString();
        } else if (root.getUserObject() instanceof BgOrgUnitInfo) {
            orgUnitId = ((BgOrgUnitInfo)root.getUserObject()).getOrgUnitID();
        }
        if (list.contains(orgUnitId)) {
            root.setChecked(true);
        } else {
            root.setChecked(false);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.setOrgSelected(node, list);
        }
    }

    public void clear() {
        this.clearNodes((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
        this.treeOrgUnit.repaint();
    }

    private void clearNodes(DefaultKingdeeTreeNode root) {
        root.setChecked(false);
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            node.setChecked(false);
            this.clearNodes(node);
        }
    }

    class PropertyListener
    implements ActionListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set<String> set = new HashSet<String>();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectOrgUnitUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSelectOrgUnitUI.this.treeOrgUnit.getModel().getRoot();
            if (set != null) {
                set = BgSelectOrgUnitUI.this.getOrgIdByFid(set);
            }
            BgOrgUnitUtils.selectOrgUnitIds(node, set);
            BgSelectOrgUnitUI.this.treeOrgUnit.repaint();
        }
    }

    class CompanyListener
    implements ActionListener {
        CompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSelectOrgUnitUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgSelectOrgUnitUI.this.getCompanyIds());
            BgSelectOrgUnitUI.this.treeOrgUnit.repaint();
        }
    }

    class AllSubOrgUnitListener
    implements ActionListener {
        AllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSelectOrgUnitUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgSelectOrgUnitUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgUnitListener
    implements ActionListener {
        AllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgUnitUtils.selectOrgUnit(BgSelectOrgUnitUI.this.treeOrgUnit.getModel(), true);
            BgSelectOrgUnitUI.this.treeOrgUnit.repaint();
        }
    }

    class AllLeafOrgUnitListener
    implements ActionListener {
        AllLeafOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSelectOrgUnitUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectLeafOrgUnit(node, true);
            BgSelectOrgUnitUI.this.treeOrgUnit.repaint();
        }
    }

    class SubOrgUnitListener
    implements ActionListener {
        SubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgSelectOrgUnitUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgSelectOrgUnitUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgSelectOrgUnitUI.this.popMenu.show((Component)BgSelectOrgUnitUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

