/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgSheetManager;
import com.kingdee.eas.ma.mbg.client.AbstractBgSheetManagerUI;
import com.kingdee.eas.ma.mbg.client.BgSheetNameUI;
import com.kingdee.eas.ma.mbg.client.ViewListLayoutDesignerUI;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSheetManagerUI
extends AbstractBgSheetManagerUI {
    private static final long serialVersionUID = 922795756984688193L;
    private static final Logger logger = CoreUIObject.getLogger(BgSheetManagerUI.class);
    public static final String SHEET_MANAGERS = "sheetManagers";
    public static final String OWNER = "Owner";
    public static final String VIEWLISTTEMPLATERESOURCE = "com.kingdee.eas.ma.mbg.ViewListTemplateResource";
    protected List<MbgViewListSheetManager> sheetManageList = null;
    private BgSheetManager tmpSheet = null;

    public List<MbgViewListSheetManager> getSheetManageList() {
        return this.sheetManageList;
    }

    public KDList getSheetList() {
        return this.sheetList;
    }

    public void setSheetManageList(List<MbgViewListSheetManager> sheetManageList) {
        this.sheetManageList = sheetManageList;
    }

    public void onLoad() {
        this.init();
    }

    private void init() {
        this.sheetManageList = (List)this.getUIContext().get(SHEET_MANAGERS);
        for (MbgViewListSheetManager sheetManager : this.sheetManageList) {
            BgSheetManager copySheetManager = new BgSheetManager(sheetManager, sheetManager.getSheetName(), null);
            this.sheetList.addElement((Object)copySheetManager);
        }
    }

    @Override
    protected void btnAddSheet_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddSheet_actionPerformed(e);
        MbgViewListSheetManager sheetManager = null;
        sheetManager = MbgViewListManager.getDefaultSheetManagerImpl(((ViewListLayoutDesignerUI)this.getOwner()).getView(), ((ViewListLayoutDesignerUI)this.getOwner()).getSchemeHelper().getAllDimensions());
        BgSheetManager copySheetManager = new BgSheetManager(sheetManager, sheetManager.getSheetName(), sheetManager.getSheetName());
        this.sheetList.addElement((Object)copySheetManager);
    }

    @Override
    protected void btnModifySheet_actionPerformed(ActionEvent e) throws Exception {
        super.btnModifySheet_actionPerformed(e);
        int selectedIndex = this.sheetList.getSelectedIndex();
        if (selectedIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)VIEWLISTTEMPLATERESOURCE, (String)"checkSelectSheet"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"selectedIndex", (Object)selectedIndex);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getSheetNameUI(), (Map)uiContext);
        BgSheetNameUI ui = (BgSheetNameUI)uiWindow.getUIObject();
        ui.setUITitle(EASResource.getString((String)VIEWLISTTEMPLATERESOURCE, (String)"ModifySheetName"));
        uiWindow.show();
    }

    protected String getSheetNameUI() {
        return BgSheetNameUI.class.getName();
    }

    @Override
    protected void btnDelSheet_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelSheet_actionPerformed(e);
        int selectedIndex = this.sheetList.getSelectedIndex();
        if (selectedIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)VIEWLISTTEMPLATERESOURCE, (String)"checkSelectSheet"));
            return;
        }
        if (this.sheetList.getElementCount() <= 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"atLeastOneSheet"));
            return;
        }
        BgSheetManager sheet = (BgSheetManager)this.sheetList.getElement(selectedIndex);
        int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"confiremDelSheet").replace("{0}", sheet.getSheetName()));
        if (result == 0) {
            this.sheetList.removeElementAt(selectedIndex);
            List<MbgViewListSheetManager> addNewSheetManagerList = null;
            addNewSheetManagerList = ((ViewListLayoutDesignerUI)this.getOwner()).getAddNewSheetManagerList();
            if (addNewSheetManagerList != null && addNewSheetManagerList.contains(sheet.getSheetManager())) {
                addNewSheetManagerList.remove(sheet.getSheetManager());
            }
        }
    }

    @Override
    protected void btnMoveUpSheet_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveUpSheet_actionPerformed(e);
        int selectedIndex = this.sheetList.getSelectedIndex();
        if (selectedIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)VIEWLISTTEMPLATERESOURCE, (String)"checkSelectSheet"));
            return;
        }
        if (selectedIndex == 0) {
            return;
        }
        this.tmpSheet = (BgSheetManager)this.sheetList.getElement(selectedIndex - 1);
        this.sheetList.removeElementAt(selectedIndex - 1);
        this.sheetList.insertElement((Object)this.tmpSheet, selectedIndex);
        this.sheetScrollPane.getVerticalScrollBar().setValue(this.sheetList.indexToLocation((int)selectedIndex).y - 40);
    }

    @Override
    protected void btnMoveDownSheet_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveDownSheet_actionPerformed(e);
        int selectedIndex = this.sheetList.getSelectedIndex();
        if (selectedIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)VIEWLISTTEMPLATERESOURCE, (String)"checkSelectSheet"));
            return;
        }
        if (selectedIndex == this.sheetList.getElementCount() - 1) {
            return;
        }
        this.tmpSheet = (BgSheetManager)this.sheetList.getElement(selectedIndex + 1);
        this.sheetList.removeElementAt(selectedIndex + 1);
        this.sheetList.insertElement((Object)this.tmpSheet, selectedIndex);
        this.sheetScrollPane.getVerticalScrollBar().setValue(this.sheetList.indexToLocation((int)selectedIndex).y - 180);
    }

    @Override
    protected void btnCopySheet_actionPerformed(ActionEvent e) throws Exception {
        super.btnCopySheet_actionPerformed(e);
        int index = 2;
        int selectedIndex = this.sheetList.getSelectedIndex();
        if (selectedIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)VIEWLISTTEMPLATERESOURCE, (String)"checkSelectSheet"));
            return;
        }
        this.tmpSheet = (BgSheetManager)this.sheetList.getElement(selectedIndex);
        if (this.tmpSheet.getSheetManager() != null) {
            MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)ObjectUtils.createCopy((Object)this.tmpSheet.getSheetManager());
            sheetManager.setSheetID(null);
            BgSheetManager copySheetManger = new BgSheetManager(sheetManager, this.getCopySheetName(sheetManager.getSheetName(), index), null);
            this.sheetList.insertElement((Object)copySheetManger, selectedIndex + 1);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        ((ViewListLayoutDesignerUI)this.getOwner()).getView().getSheetManagers().clear();
        this.sheetManageList.clear();
        int in = this.sheetList.getElementCount();
        for (int i = 0; i < in; ++i) {
            BgSheetManager copySheetManager = (BgSheetManager)this.sheetList.getElement(i);
            if (!copySheetManager.getSheetManager().getSheetName().equals(copySheetManager.getSheetName())) {
                copySheetManager.getSheetManager().setSheetName(copySheetManager.getSheetName());
            }
            if (copySheetManager.getSheetSignName() != null) {
                ((ViewListLayoutDesignerUI)this.getOwner()).getAddNewSheetManagerList().add(copySheetManager.getSheetManager());
            }
            this.sheetManageList.add(copySheetManager.getSheetManager());
        }
        ((ViewListLayoutDesignerUI)this.getOwner()).getView().setSheetManagers(this.sheetManageList);
        for (int j = 0; j < ((ViewListLayoutDesignerUI)this.getOwner()).getView().getSheetManagers().size(); ++j) {
            ((MbgViewListSheetManager)((ViewListLayoutDesignerUI)this.getOwner()).getView().getSheetManagers().get(j)).setSheetIndex(j);
        }
        ((ViewListLayoutDesignerUI)this.getOwner()).reloadSheetComboValueWithoutStateChangeListener();
        this.destroyWindow();
    }

    private String getCopySheetName(String tmpSheetName, int index) {
        tmpSheetName = new StringBuffer(this.tmpSheet.getSheetName()).append("(").append(index).append(")").toString();
        int in = this.sheetList.getElementCount();
        for (int i = 0; i < in; ++i) {
            if (!tmpSheetName.equals(((BgSheetManager)this.sheetList.getElement(i)).getSheetName())) continue;
            return this.getCopySheetName(this.tmpSheet.getSheetName(), ++index);
        }
        return tmpSheetName;
    }

    public CoreUI getOwner() {
        return (CoreUI)this.getUIContext().get(OWNER);
    }
}

