/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.client.AbstractBgSheetSelectF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgSheetSelectF7UI
extends AbstractBgSheetSelectF7UI {
    private static final long serialVersionUID = 5289365539609338422L;
    private static final Logger logger = CoreUIObject.getLogger(BgSheetSelectF7UI.class);
    public static final String SHEET_NAMES = "SHEET_NAMES";
    private static final String COL_SELECT = "isSelect";
    private static final String COL_SHEET_NAME = "SheetName";
    private boolean isCancel = false;
    private String[] data = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadSheet();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblSheet.checkParsed();
    }

    private void loadSheet() {
        String[] sheetStr = (String[])this.getUIContext().get(SHEET_NAMES);
        if (sheetStr == null || sheetStr.length == 0) {
            return;
        }
        IRow row = null;
        for (int i = 0; i < sheetStr.length; ++i) {
            row = this.tblSheet.addRow();
            row.getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
            row.getCell(COL_SHEET_NAME).setValue((Object)sheetStr[i]);
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (int r = 0; r < this.tblSheet.getRowCount(); ++r) {
            if (!Boolean.TRUE.equals(this.tblSheet.getCell(r, COL_SELECT).getValue())) continue;
            sheetNames.add((String)this.tblSheet.getCell(r, COL_SHEET_NAME).getValue());
        }
        if (sheetNames.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"checkSelectSheet"));
            return;
        }
        this.data = sheetNames.toArray(new String[0]);
        this.isCancel = false;
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    protected void tblSheet_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblSheet_tableClicked(e);
        if (e.getRowIndex() >= 0 && this.tblSheet.getColumnIndex(COL_SHEET_NAME) == e.getColIndex() && e.getClickCount() == 1) {
            ICell cell;
            cell.setValue((Object)((Boolean)(cell = this.tblSheet.getCell(e.getRowIndex(), COL_SELECT)).getValue() == false ? 1 : 0));
        }
    }

    public void setSelectSheetNames(String[] sheetNames) {
        this.data = sheetNames;
        HashSet<String> sheetSet = new HashSet<String>();
        if (sheetNames != null) {
            sheetSet.addAll(Arrays.asList(sheetNames));
        }
        for (int r = 0; r < this.tblSheet.getRowCount(); ++r) {
            this.tblSheet.getCell(r, COL_SELECT).setValue((Object)sheetSet.contains(this.tblSheet.getCell(r, COL_SHEET_NAME).getValue()));
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String[] getData() {
        return this.data;
    }
}

