/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgSpecialItemsCollection;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.client.BgNTemplateProcessUI;
import com.kingdee.eas.ma.mbg.client.BgSpecialTemplateEditUI;
import com.kingdee.eas.ma.mbg.client.BgTemFormatImportUI;
import com.kingdee.eas.ma.mbg.client.action.actions.template.SpecialImportAction;
import com.kingdee.eas.ma.mbg.client.utils.BgMessageClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialTemplateProvider;
import com.kingdee.eas.ma.mbg.client.utils.BgTemplateMenuManager;
import com.kingdee.eas.ma.mbg.client.utils.DimensionFillHelper;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialTemplateProcessUI;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSpecialTemplateProcessUI
extends BgNTemplateProcessUI
implements IBgSpecialTemplateProcessUI {
    private static final long serialVersionUID = 637601530996546918L;
    private static final Logger logger = CoreUIObject.getLogger(BgSpecialTemplateProcessUI.class);
    private KDPanel pagePanel = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.addPagePanel();
    }

    @Override
    public void actionBgItemFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"ORGUNITID", (Object)this.getTemplateInfo().getOrgUnit().getId().toString());
        uiContext.put((Object)"item_formula_map", (Object)this.getItemFormulMap());
        uiContext.put((Object)"this_is_from_template", (Object)Boolean.TRUE);
        uiContext.put((Object)"BGSCHEME_ID", (Object)this.getBgSchemeId());
        uiContext.put((Object)"filterValueMap", this.getFilterMap());
        uiContext.put((Object)"IS_SPECIAL_BUDGET", (Object)Boolean.TRUE);
        try {
            uiContext.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
        }
        catch (EASBizException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormatImportUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        String orgUnitId = this.getTemplateInfo().getOrgUnit().getId().toString();
        try {
            DimensionFillHelper.showBgItem((IUIObject)this, this.getBgSchemeId(), this.getBook().getActiveSheet(), true, "", "", this.getItemFormulMap(), null, false, false, orgUnitId, false, this.getFilterMap());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    @Override
    public Map<String, Set<String>> getFilterMap() throws EASBizException, BOSException {
        return BgSpecialBudgetHelper.getFilterMapByBgTemplate(null, this.getTemplateInfo(), this.getSchemeHelper());
    }

    @Override
    public boolean isElementRequired() {
        return true;
    }

    @Override
    public boolean isScenarioRequired() {
        return true;
    }

    @Override
    public void actionMutiUpdateFormula_actionPerformed(ActionEvent e) throws Exception {
        String orgUnitId = this.getTemplateInfo().getOrgUnit().getId().toString();
        this.getBook().getUndoManager().startGroup();
        try {
            DimensionFillHelper.mutiUpdateBgItemFormula((IUIObject)this, this.getBook().getActiveSheet(), null, orgUnitId, this.getSchemeHelper(), this.getFilterMap());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    @Override
    public void actionCreateItemFormula_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        String orgUnitId = this.getTemplateInfo().getOrgUnit().getId().toString();
        try {
            DimensionFillHelper.createItemFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), this.getItemFormulMap(), true, false, false, orgUnitId, !this.isSelfFormType(), this.getFilterMap());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCreateBgFormula_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        String orgUnitId = this.getTemplateInfo().getOrgUnit().getId().toString();
        try {
            Map<String, Set<String>> filterValueMap = this.getFilterMap();
            if (e.getActionCommand().equalsIgnoreCase("MbgActualS")) {
                DimensionFillHelper.createBgFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), "MbgActualS", false, false, orgUnitId, !this.isSelfFormType(), filterValueMap, true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgAggregate")) {
                DimensionFillHelper.createBgFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), "MbgAggregate", false, false, orgUnitId, !this.isSelfFormType(), filterValueMap, true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgFormula")) {
                DimensionFillHelper.createBgFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), "MbgFormula", false, false, orgUnitId, !this.isSelfFormType(), filterValueMap, true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgActualSF")) {
                DimensionFillHelper.createBgFormulaFromItemFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), "MbgActualS", false, false, orgUnitId, !this.isSelfFormType(), filterValueMap, true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgAggregateF")) {
                DimensionFillHelper.createBgFormulaFromItemFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), "MbgAggregate", false, false, orgUnitId, !this.isSelfFormType(), filterValueMap, true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgFormulaF")) {
                DimensionFillHelper.createBgFormulaFromItemFormula((IUIObject)this, this.getBook().getActiveSheet(), (IObjectValue)this.getTemplateInfo(), "MbgFormula", false, false, orgUnitId, !this.isSelfFormType(), filterValueMap, true);
            }
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    @Override
    public void actionClearItemFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearItemFormula_actionPerformed(e);
    }

    @Override
    protected void initAction() {
        super.initAction();
        SpreadAction actionBeforeClearCell_DefaultAction = this.getSpreadActionManager().getAction("Clear_CellFormulaAndValue");
        actionBeforeClearCell_DefaultAction.setAfterAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                this.actionAfterClearCell_DefaultAction(evt);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void actionAfterClearCell_DefaultAction(NotifyEvent evt) {
                BgSpecialTemplateProcessUI.this.getBook().getUndoManager().startGroup();
                try {
                    BgSpecialTemplateProcessUI.this.checkBeforeEditRange();
                    Cell cell = null;
                    Sheet sheet = BgSpecialTemplateProcessUI.this.getBook().getActiveSheet();
                    int maxRowIndex = sheet.getMaxRowIndex();
                    int maxColIndex = sheet.getMaxColIndex();
                    Range range = sheet.getSelectionRange();
                    int num = range.size();
                    if (num <= 0) {
                        return;
                    }
                    for (int i = 0; i < range.size(); ++i) {
                        CellBlock block = range.getBlock(i);
                        int rowBegin = block.getRow();
                        int rowEnd = block.getRow2() > maxRowIndex ? maxRowIndex : block.getRow2();
                        int colBegin = block.getCol();
                        int colEnd = block.getCol2() > maxColIndex ? maxColIndex : block.getCol2();
                        for (int j = rowBegin; j <= rowEnd; ++j) {
                            for (int k = colBegin; k <= colEnd; ++k) {
                                cell = sheet.getCell(j, k, false);
                                if (cell == null) continue;
                                BgNFSHelper.clearBgItemInfo(cell);
                            }
                        }
                    }
                }
                finally {
                    BgSpecialTemplateProcessUI.this.getBook().getUndoManager().endGroup();
                }
            }
        });
    }

    @Override
    protected void beforeSaveDealWithBgItems() {
        try {
            Book book = this.getBook();
            String orgUnitId = this.getTemplateInfo().getOrgUnit().getId().toString();
            BgNTemplateHelper.dealWith(book, orgUnitId, this.getItemFormulMap(), true, true, "bgData", false, false, null, this.getSchemeHelper(), !this.isSelfFormType(), this.getFilterMap());
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BgTemplateMenuManager((Component)((Object)this));
    }

    @Override
    public IBookProvider getBudgetProvider() {
        return new BgSpecialTemplateProvider(this);
    }

    private KDPanel getPagePanel() {
        if (this.pagePanel == null) {
            this.pagePanel = new KDPanel();
            this.pagePanel.setLayout((LayoutManager)new BorderLayout());
        }
        return this.pagePanel;
    }

    private SpreadContext getSpreadContext() {
        return this.getSpreadManager().getSpreadContainer();
    }

    private Component getPageDimensionPanel() throws Exception {
        KDPanel kdPanel = this.getPagePanel();
        kdPanel.removeAll();
        SpreadContext sc = this.getSpreadContext();
        kdPanel.add(this.getBgSpecialItemsComponet(), (Object)"North");
        kdPanel.add((Component)sc, (Object)"Center");
        kdPanel.revalidate();
        return kdPanel;
    }

    public void addPagePanel() throws Exception {
        this.getUIContentPane().add(this.getPageDimensionPanel(), "Center");
    }

    private Component getBgSpecialItemsComponet() throws Exception {
        return BgSpecialBudgetClientHelper.parseSpecialItemsComponet((CoreUI)this, this.getTemplateInfo(), this.getSchemeHelper(), this.getOrgUnitInfo().getId().toString());
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.itemEditItemFormualFormula.isSelected() || this.menuItemViewVulueMe.isSelected()) {
            MsgBox.showInfo((String)BgMessageClientHelper.getMessage("please.switch.formual.view.to.do"));
            return;
        }
        String sql = "select id where root.id = '" + this.templateInfo.getId().toString() + "' ";
        sql = sql + " and id <> '" + this.templateInfo.getId().toString() + "'";
        BgTemplateCollection temCol = this.getIBgTemplate().getBgTemplateCollection(sql);
        if (temCol != null && temCol.size() > 0) {
            MsgBox.showInfo((String)BgMessageClientHelper.getMessage("tem.has.assign.not.import"));
            SysUtil.abort();
        }
        String temModifyType = this.formulaType;
        if (!this.formulaType.equals("bgData")) {
            this.actionViewEditBgDataFormula_actionPerformed(e);
        }
        Book _book = this.getBook();
        Sheet _sheet = null;
        HashMap<String, Object> creatorMap = new HashMap<String, Object>();
        int sheetSizeBegin = 0;
        if (_book != null) {
            int sheetIndex = 0;
            sheetSizeBegin = _book.getSheetCount();
            Object sheetCreater = null;
            for (sheetIndex = 0; sheetIndex < sheetSizeBegin; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                sheetCreater = _sheet.getUserObjectValue("SHEET_CREATER_ID");
                creatorMap.put(String.valueOf(sheetIndex), sheetCreater);
            }
        }
        SpecialImportAction ea = new SpecialImportAction(this.getSpreadManager().getSpreadContainer(), this.getSchemeHelper(), this.getTemplateInfo());
        ea.actionPerformed(e);
        this.getSpreadManager().getModifyManager().setModified();
        if (_book != null) {
            int sheetIndex;
            BgNFSHelper.setBookProtection(_book, false, BgNFSHelper.getMaxOperation());
            int sheetSizeAfter = _book.getSheetCount();
            if (sheetSizeBegin >= sheetSizeAfter) {
                for (sheetIndex = 0; sheetIndex < sheetSizeAfter; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _sheet.setUserObject("SHEET_CREATER_ID", creatorMap.get(String.valueOf(sheetIndex)));
                }
            } else {
                for (sheetIndex = 0; sheetIndex < sheetSizeBegin; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _sheet.setUserObject("SHEET_CREATER_ID", creatorMap.get(String.valueOf(sheetIndex)));
                }
                for (sheetIndex = sheetSizeBegin; sheetIndex < sheetSizeAfter; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _sheet.setUserObject("SHEET_CREATER_ID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
                }
            }
            for (int i = 0; i < _book.getSheetCount(); ++i) {
                BgNFSHelper.setSheetProtection(_book.getSheet(i), false, BgNFSHelper.getMaxOperation());
            }
            BookChangeEvent bce = new BookChangeEvent(_book.getActiveSheet(), "Sheet_Active", false);
            this.getSpreadActionManager().changed(bce);
        }
        this.formulaType = temModifyType;
        this.editBgFormula(null);
        this.setUiTitle();
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        Book book = this.getBook();
        BgSpecialItemsCollection colls = this.getTemplateInfo().getBgSpecialItems();
        ArrayList itemList = new ArrayList();
        for (int i = 0; i < colls.size(); ++i) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            BgSpecialItemsInfo item = colls.get(i);
            itemMap.put("dimensionNumber", item.getDimensionNumber());
            itemMap.put("dimensionName", item.getDimensionName());
            itemMap.put("memberName", item.getMemberName());
            itemMap.put("memberDisplayName", item.getMemberDisplayName());
            itemList.add(itemMap);
        }
        UserObject obj = new UserObject("bgSpecialItems", itemList);
        book.getUserObjects().append((Object)obj);
        super.actionExport_actionPerformed(e);
    }

    @Override
    protected String getTemplateEditUIName() {
        return BgSpecialTemplateEditUI.class.getName();
    }
}

