/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgTemExportUI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgExportUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgTemExportUI
extends AbstractBgTemExportUI {
    private static final long serialVersionUID = -4835013008080957779L;
    private static final Logger logger = CoreUIObject.getLogger(BgTemExportUI.class);
    private List<String> billIds = null;
    private String bgOrgUnitId = null;
    private BgSchemeInfo bgScheme = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private LongTimeDialog dialog = null;

    protected BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.bgScheme != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.bgScheme.getId().toString());
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void init() throws Exception {
        Object obj = this.getUIContext().get("BGTEMPLATE_ID");
        if (obj instanceof List) {
            this.billIds = (List)obj;
        }
        if ((obj = this.getUIContext().get("BGORGUNIT_ID")) instanceof String) {
            this.bgOrgUnitId = (String)obj;
        }
        if ((obj = this.getUIContext().get("BGSCHEME_ID")) instanceof String) {
            this.bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK((String)obj), BgSchemeUtils.getSelectors());
        }
    }

    protected void initData() throws Exception {
        List<String> currencyNums = this.bgScheme.getMemberNumber(DimensionBaseConstants.DEF_CURRENCY_NUMBER);
        if (!currencyNums.isEmpty()) {
            HashSet<String> tmpSet = new HashSet<String>(currencyNums);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", tmpSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CurrencyCollection colls = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                this.cbxCurrency.addItem((Object)colls.get(i));
            }
        }
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.setEditable(false);
        List<String> versionNums = this.bgScheme.getMemberNumber(DimensionBaseConstants.DEF_VERSION_NUMBER);
        if (!versionNums.isEmpty()) {
            HashSet<String> tmpSet = new HashSet<String>(versionNums);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", tmpSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("number"));
            this.prmtBgVersion.setEntityViewInfo(view);
        }
        this.prmtBgVersion.setEditable(false);
        this.txtLocalWay.setRequestFocusEnabled(false);
        BgExportUtils.setDefaultFilePath(this.txtLocalWay);
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
    }

    @Override
    protected void prmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgVersion_dataChanged(e);
    }

    @Override
    protected void btnLocalWay_actionPerformed(ActionEvent e) throws Exception {
        super.btnLocalWay_actionPerformed(e);
        BgExportUtils.selectFilePath((Component)((Object)this), this.txtLocalWay, true);
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        super.btnExport_actionPerformed(e);
        this.verifyData();
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgExportUtils utils = new BgExportUtils();
                utils.bgScheme = BgTemExportUI.this.bgScheme;
                utils.billIds = BgTemExportUI.this.billIds;
                utils.expObjs = BgTemExportUI.this.getExpObjects();
                utils.orgUnits = BgOrgUnitFactory.getRemoteInstance().getChildrenUnit(BOSUuid.read((String)BgTemExportUI.this.bgOrgUnitId));
                utils.filepaths = utils.exportOrgUnitPath(BgTemExportUI.this.txtLocalWay.getText());
                if (!utils.filepaths.isEmpty()) {
                    utils.exportTemplate();
                }
                return utils.result;
            }

            public void afterExec(Object obj) throws Exception {
                if (obj instanceof List) {
                    List result = (List)obj;
                    List succeed = (List)result.get(0);
                    List defeated = (List)result.get(1);
                    int size = succeed.size() + defeated.size();
                    String context = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"styleexport_context1", (Object[])new Object[]{size});
                    if (succeed.size() > 0) {
                        context = context + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"styleexport_context2", (Object[])new Object[]{succeed.size()});
                    }
                    if (defeated.size() > 0) {
                        context = context + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"styleexport_context3", (Object[])new Object[]{defeated.size()});
                    }
                    StringBuffer msgs = new StringBuffer();
                    for (String msg : defeated) {
                        msgs.append(msg);
                    }
                    MsgBox.showDetailAndOK(null, (String)context, (String)msgs.toString(), (int)1);
                }
                BgTemExportUI.this.getUIWindow().close();
            }
        });
        this.dialog.show();
    }

    public void verifyData() throws Exception {
        File file;
        super.verifyData();
        if (this.cbxCurrency.getSelectedItem() == null) {
            this.cbxCurrency.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"440_BgTemStyleExportUI"));
            SysUtil.abort();
        }
        if (!(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
            this.prmtBgPeriod.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"441_BgTemStyleExportUI"));
            SysUtil.abort();
        }
        if (!(this.prmtBgVersion.getData() instanceof BgVersionInfo)) {
            this.prmtBgVersion.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"442_BgTemStyleExportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtLocalWay.getText())) {
            this.txtLocalWay.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"443_BgTemStyleExportUI"));
            SysUtil.abort();
        }
        if ((file = new File(this.txtLocalWay.getText())).isFile()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"error_export_local"));
            SysUtil.abort();
        } else if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected Object[] getExpObjects() {
        Object[] objs = new Object[]{this.getCurrency(), this.getBgPeriod(), this.getBgVersion()};
        return objs;
    }

    protected CurrencyInfo getCurrency() {
        return (CurrencyInfo)this.cbxCurrency.getSelectedItem();
    }

    protected BgPeriodInfo getBgPeriod() {
        return (BgPeriodInfo)this.prmtBgPeriod.getData();
    }

    protected BgVersionInfo getBgVersion() {
        return (BgVersionInfo)this.prmtBgVersion.getData();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
        }
        return handler;
    }
}

