/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgTemImportUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgExportUtils;
import com.kingdee.eas.ma.mbg.utils.BgImportUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgTemImportUI
extends AbstractBgTemImportUI {
    private static final long serialVersionUID = 5369987241716446392L;
    private static final Logger logger = CoreUIObject.getLogger(BgTemImportUI.class);
    private BgOrgUnitInfo bgOrgUnit = null;
    private OrgUnitInfo orgUnit = null;
    private BgSchemeInfo bgScheme = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private LongTimeDialog dialog = null;

    protected BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.bgScheme != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.bgScheme.getId().toString());
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void init() throws Exception {
        Object obj = this.getUIContext().get("BGORGUNIT_ID");
        if (obj instanceof String) {
            this.bgOrgUnit = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo((IObjectPK)new ObjectStringPK((String)obj));
        }
        if ((obj = this.getUIContext().get("ORGUNIT_ID")) instanceof String) {
            this.orgUnit = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectStringPK((String)obj));
        }
        this.prmtBgScheme.setRequestFocusEnabled(false);
        this.prmtBgScheme.setRequired(true);
        this.prmtBgScheme.setEditable(false);
        this.prmtBgScheme.setEnabled(false);
        obj = this.getUIContext().get("BGSCHEME_ID");
        if (obj instanceof String) {
            this.bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK((String)obj), BgSchemeUtils.getSelectors());
            this.prmtBgScheme.setDataNoNotify((Object)this.bgScheme);
        }
    }

    protected void initData() throws Exception {
        BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, this.orgUnit, false, this.getSourceType(), false, false);
        this.txtLocalWay.setRequestFocusEnabled(false);
        BgExportUtils.setDefaultFilePath(this.txtLocalWay);
    }

    protected RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    @Override
    protected void btnLocalWay_actionPerformed(ActionEvent e) throws Exception {
        super.btnLocalWay_actionPerformed(e);
        BgExportUtils.selectFilePath((Component)((Object)this), this.txtLocalWay, false);
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnImport_actionPerformed(e);
        this.verifyData();
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgImportUtils utils = new BgImportUtils();
                utils.bgOrgUnit = BgTemImportUI.this.bgOrgUnit;
                utils.bgScheme = BgTemImportUI.this.bgScheme;
                utils.orgUnits = BgOrgUnitFactory.getRemoteInstance().getChildrenUnit(BgTemImportUI.this.bgOrgUnit.getId());
                utils.filepaths = utils.importOrgUnitPath(BgTemImportUI.this.txtLocalWay.getText());
                if (!utils.getFilepaths().isEmpty()) {
                    utils.importDatas();
                } else {
                    MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"local_isempty"));
                    SysUtil.abort();
                }
                return utils.result;
            }

            public void afterExec(Object obj) throws Exception {
                if (obj instanceof List) {
                    List result = (List)obj;
                    List succeed = (List)result.get(0);
                    List defeated = (List)result.get(1);
                    List warning = (List)result.get(2);
                    String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"import_title1");
                    if (succeed.size() > 0) {
                        title = title + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"import_title2", (Object[])new Object[]{succeed.size()});
                    }
                    if (defeated.size() > 0 || warning.size() > 0) {
                        title = title + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"import_title3", (Object[])new Object[]{defeated.size() + warning.size()});
                    }
                    StringBuffer msgs = new StringBuffer();
                    for (String msg : warning) {
                        msgs.append(msg);
                    }
                    for (String msg : defeated) {
                        msgs.append(msg);
                    }
                    MsgBox.showDetailAndOK(null, (String)title, (String)msgs.toString(), (int)1);
                }
                BgTemImportUI.this.getUIWindow().close();
            }
        });
        this.dialog.show();
    }

    public void verifyData() throws Exception {
        super.verifyData();
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            this.bgScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
        } else if (this.prmtBgScheme.getData() != null && !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            this.prmtBgScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"selectInBgScheme"));
            SysUtil.abort();
        }
        File file = new File(this.txtLocalWay.getText());
        if (file.isFile()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"error_import_local"));
            SysUtil.abort();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("BGORGUNIT_ID", this.getUIContext().get("BGORGUNIT_ID"));
            request.put("ORGUNIT_ID", this.getUIContext().get("ORGUNIT_ID"));
            request.put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
        }
        return handler;
    }
}

