/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgTemplateSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgTemplateSelectUI
extends AbstractBgTemplateSelectUI {
    private static final long serialVersionUID = 7601055450687813865L;
    private static final Logger logger = CoreUIObject.getLogger(BgTemplateSelectUI.class);
    private Set<String> selectBgTemplateIds = new HashSet<String>();
    private BgTemplateInfo[] data = null;
    private boolean isCancel = true;
    private BgTemplateCollection allColls = new BgTemplateCollection();
    private static final String defaultSeachText = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"serchTemplate");

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void setSelectBgTemplateIds(Set<String> selectBgTemplateIds) {
        this.selectBgTemplateIds = selectBgTemplateIds;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadBgSchemeTemplate();
        this.loadTemplates();
    }

    public void loadBgSchemeTemplate() throws EASBizException, BOSException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        this.allColls = null;
        this.allColls = TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeInfo.getId(), null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtQuickQueryInput.setText(defaultSeachText);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtQuickQueryInput, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtQuickQueryInput.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BgTemplateSelectUI.this.loadTemplates();
                }
            }
        });
    }

    protected void loadTemplates() {
        this.storeSelect();
        String text = this.txtQuickQueryInput.getText();
        if (defaultSeachText.equals(text)) {
            text = "";
        }
        this.tblMain.removeRows();
        if (this.allColls != null && this.allColls.size() > 0) {
            String id = null;
            BgTemplateInfo bgTemplateInfo = null;
            boolean selected = false;
            for (int i = 0; i < this.allColls.size(); ++i) {
                bgTemplateInfo = this.allColls.get(i);
                id = bgTemplateInfo.getId().toString();
                if (!this.isInclude(bgTemplateInfo, text)) continue;
                selected = this.selectBgTemplateIds.contains(id);
                if (this.btnNotSelected.isSelected() && selected || this.btnSeleted.isSelected() && !selected) continue;
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgTemplateInfo);
                iRow.getCell("id").setValue((Object)id);
                iRow.getCell("select").setValue((Object)selected);
                iRow.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgTemplateInfo.getName());
                iRow.getCell("temGroupName").setValue(bgTemplateInfo.getBgType() == null ? null : bgTemplateInfo.getBgType().getName());
                iRow.getCell("creator").setValue((Object)bgTemplateInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgTemplateInfo.getCreateTime());
            }
        }
    }

    private boolean isInclude(BgTemplateInfo bgTemplateInfo, String filter) {
        if (StringUtils.isEmpty((String)filter) || filter.equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"serchTemplate"))) {
            return true;
        }
        if (bgTemplateInfo.getNumber().indexOf(filter) >= 0) {
            return true;
        }
        if (bgTemplateInfo.getName().indexOf(filter) >= 0) {
            return true;
        }
        if (bgTemplateInfo.getBgType() != null && !StringUtils.isEmpty((String)bgTemplateInfo.getBgType().getName()) && bgTemplateInfo.getBgType().getName().indexOf(filter) >= 0) {
            return true;
        }
        return bgTemplateInfo.getCreator().getName().indexOf(filter) >= 0;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
        SysUtil.abort();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.storeSelect();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    protected void storeSelect() {
        int rowCount = this.tblMain.getRowCount();
        this.selectBgTemplateIds.clear();
        ArrayList<BgTemplateInfo> selectColls = new ArrayList<BgTemplateInfo>();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.tblMain.getRow(i);
            if (!iRow.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)iRow.getUserObject();
            String bgTempID = iRow.getCell("id").getValue().toString();
            this.selectBgTemplateIds.add(bgTempID);
            selectColls.add(bgTemplateInfo);
        }
        this.data = selectColls.isEmpty() ? null : selectColls.toArray(new BgTemplateInfo[0]);
    }

    @Override
    protected void btnAll_actionPerformed(ActionEvent e) throws Exception {
        this.loadTemplates();
    }

    @Override
    protected void btnSeleted_actionPerformed(ActionEvent e) throws Exception {
        this.loadTemplates();
    }

    @Override
    protected void btnNotSelected_actionPerformed(ActionEvent e) throws Exception {
        this.loadTemplates();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgTemplateInfo[] getData() {
        return this.data;
    }
}

