/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.mbg.BgTypeFactory;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IBgType;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BgTypeEditUI
extends AbstractBgTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTypeEditUI.class);
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    public static final String ITEM_PERMISSION_EDIT = "mbg_bgtype_edit";

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("parent.id"));
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        String costId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        BgTypeInfo bgTemplateInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            bgTemplateInfo = new BgTypeInfo();
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)bgTemplateInfo, (String)costId));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)bgTemplateInfo, (String)costId));
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        finally {
            codingRuleManager = null;
        }
        if (this.isRef()) {
            this.txtNumber.setEditable(false);
        }
    }

    private boolean isRef() {
        String resKey = null;
        try {
            String id;
            IBgType iBg = BgTypeFactory.getRemoteInstance();
            if (this.editData.getId() != null && (id = this.editData.getId().toString()) != null && !id.equals("")) {
                int res = iBg.checkRefAll(id);
                switch (res) {
                    case 1: {
                        resKey = "notEditRefByForm";
                        break;
                    }
                    case 2: {
                        resKey = "notEditRefByTemplate";
                        break;
                    }
                    case 3: {
                        resKey = "notEditRefByChild";
                    }
                }
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            logger.error((Object)"", (Throwable)e1);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            logger.error((Object)"", (Throwable)e1);
        }
        return resKey != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeLoad() throws EASBizException {
        String costId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        BgTypeInfo bgTemplateInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            bgTemplateInfo = new BgTypeInfo();
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)bgTemplateInfo, (String)costId));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)bgTemplateInfo, (String)costId));
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        finally {
            codingRuleManager = null;
        }
        if (this.getOprtState().equals(OprtState.EDIT) && Boolean.FALSE.equals(this.getUIContext().get("NUMBER_EDITABLE"))) {
            this.txtNumber.setEditable(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBeforeSave()) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    protected boolean checkBeforeSave() {
        String name;
        if (this.txtNumber.isEnabled()) {
            if (this.txtNumber == null || this.txtNumber.getText().trim().equals("")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"num"));
                return false;
            }
            if (this.txtNumber.getText().trim().toLowerCase().startsWith("SelfDefineAnalysisTemplateGroup".toLowerCase() + ".")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"notAddChildBySysSet"));
                return false;
            }
        }
        if (StringUtils.isEmpty((String)(name = (String)this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"name"));
            return false;
        }
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBeforeSave()) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    protected IObjectValue createNewData() {
        BgTypeInfo info = new BgTypeInfo();
        info.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType")));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        String OUID = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            this.getNumberByCodingRule((IObjectValue)info, OUID);
        } else if (this.isHasCodeNumber()) {
            String num = "";
            info.setNumber(num);
            this.txtNumber.setText(num);
            this.txtNumber.setEnabled(false);
        }
        return info;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
        if (this.getOprtState().equals(OprtState.VIEW) && !this.editData.getNumber().equalsIgnoreCase("SelfDefineAnalysisTemplateGroup") && !this.editData.getNumber().equalsIgnoreCase("expensesbudget") && !this.editData.getNumber().equalsIgnoreCase("FmBudgetTemplate")) {
            this.btnEdit.setEnabled(true);
            this.txtNumber.setEditable(false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtNumber.setEditable(true);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgTypeFactory.getRemoteInstance();
    }

    private int setSelectLanguage() {
        int nTemp = 0;
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        LanguageInfo currentLang = new LanguageInfo(SysContext.getSysContext().getLocale());
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            if (currentLang.getLocale().toString().equals(languageInfo.getLocale().toString())) break;
            ++nTemp;
        }
        return nTemp;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled() && this.txtNumber.getText() != null && this.txtNumber.getText().trim().length() > 50) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"longNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() != null && this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() > 50) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"longName"));
            SysUtil.abort();
        }
        if (this.txtSimpleName.getText() != null && this.txtSimpleName.getText().trim().length() > 50) {
            this.txtSimpleName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"longSN"));
            SysUtil.abort();
        }
        if (this.txtDescription.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() != null && this.txtDescription.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() > 255) {
            this.txtDescription.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTypeResource", (String)"longDes"));
            SysUtil.abort();
        }
    }
}

