/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgTypeCollection;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.BgTypeListUI;
import java.util.HashSet;
import java.util.Set;

public class BgTypeF7ListUI
extends BgTypeListUI {
    private boolean isDisplaySelf = true;
    private boolean isOnlyDisplaySelf = false;
    private Set displayTemplateGroupNumber = null;
    private RptSrcTypeEnum sourceType = RptSrcTypeEnum.PT_BUDGET_REPORT;

    @Override
    protected boolean isF7Query() {
        return true;
    }

    public BgTypeCollection getSelectedBgType() {
        this.checkSelected();
        BgTypeCollection col = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null && range.size() > 0) {
            int rangeCount = range.size();
            col = new BgTypeCollection();
            for (int i = 0; i < rangeCount; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int start = block.getBeginRow();
                int end = block.getEndRow();
                for (int j = start; j <= end; ++j) {
                    String id = this.getCellValue(j, "id");
                    if (id == null) continue;
                    BgTypeInfo info = new BgTypeInfo();
                    info.setId(BOSUuid.read((String)id));
                    info.setNumber(this.getCellValue(j, "number"));
                    info.setName(this.getCellValue(j, "name"));
                    col.add(info);
                }
            }
        }
        return col;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo view) {
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        if (!this.isDisplaySelf()) {
            BgCommHelper.addFilterItem((FilterInfo)view.getFilter(), (FilterItemInfo)new FilterItemInfo("id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        }
        if (this.isOnlyDisplaySelf) {
            BgCommHelper.addFilterItem((FilterInfo)view.getFilter(), (FilterItemInfo)new FilterItemInfo("number", (Object)"SelfDefineAnalysisTemplateGroup", CompareType.LIKE));
        } else if (this.displayTemplateGroupNumber != null && !this.displayTemplateGroupNumber.isEmpty()) {
            BgCommHelper.addFilterItem((FilterInfo)view.getFilter(), (FilterItemInfo)new FilterItemInfo("number", (Object)this.displayTemplateGroupNumber, CompareType.INCLUDE));
        }
        return super.getQueryExecutor(arg0, view);
    }

    @Override
    protected RptSrcTypeEnum getSourceType() {
        return this.sourceType;
    }

    protected void setSourceType(RptSrcTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    protected Set getNotDisplayNumber() {
        HashSet<String> set = new HashSet<String>();
        set.add("expensesbudget");
        set.add("FmBudgetTemplate");
        return set;
    }

    protected Set getExpDisplayNumber() {
        HashSet<String> set = new HashSet<String>();
        set.add("expensesbudget");
        set.add("SelfDefineAnalysisTemplateGroup");
        return set;
    }

    public String getCellValue(int rowIndex, String colName) {
        ICell cell = this.tblMain.getCell(rowIndex, colName);
        if (cell != null && cell.getValue() != null) {
            return cell.getValue().toString();
        }
        return null;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    public KDWorkButton getQueryBtn() {
        return this.btnQuery;
    }

    public boolean isDisplaySelf() {
        return this.isDisplaySelf;
    }

    public void setDisplaySelf(boolean isDisplaySelf) {
        this.isDisplaySelf = isDisplaySelf;
    }

    public void setOnlyDisplaySelf(boolean isOnlyDisplaySelf) {
        this.isOnlyDisplaySelf = isOnlyDisplaySelf;
    }

    public boolean isOnlyDisplaySelf() {
        return this.isOnlyDisplaySelf;
    }

    public void setDisplayTemplateGroupNumber(Set displayTemplateGroupNumber) {
        this.displayTemplateGroupNumber = displayTemplateGroupNumber;
    }

    public Set getDisplayTemplateGroupNumber() {
        return this.displayTemplateGroupNumber;
    }
}

