/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPeriodNameEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgVariateClassEnum;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgVariateListUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgVariateTypeDispInfo;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgVariateListUI
extends AbstractBgVariateListUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = 2194031259860717701L;
    private static final Logger logger = CoreUIObject.getLogger(BgVariateListUI.class);
    private final String ID = "id";
    private final String NUMBER = "number";
    private final String NAME = "name";
    private final String DIMNUMBER = "dimNumber";
    private final String DIMNAME = "dimName";
    private final String DIMSEQ = "dimSeq";
    private final String MEMBERID = "memberId";
    private final String MEMBERNAME = "memberName";
    private final String MEMBERNUMBER = "memberNumber";
    private final String CREATOR_NAME = "creator.name";
    private final String CREATETIME = "createTime";
    private final String ORGUNTI_NAME = "orgUnit.name";
    private final String DESCRIPTION = "description";
    private final String BGVARIATE_CLASS = "bgVariateClass";
    private final String RES = "com.kingdee.eas.ma.base.BgAccountResource";
    public static final String ONLY_NUMERIC = "onlyNumeric";
    public static final String MODEL_TYPE = "modelType";
    public static final String VARIATE_NUMBERS = "variateNumbers";
    private boolean cancelSave = false;
    Map<String, Map<String, String>> memberIdMap = null;
    List<BgDimSettingsInfo> dimensions = null;
    Date beginDate = null;
    Date endDate = null;
    private CostCenterOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private boolean isShowAlias = false;
    private BgSchemeDimensionHelper schemeHelper = null;

    public CostCenterOrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(CostCenterOrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    public CtrlUnitInfo getCU() {
        return this.CU;
    }

    protected void setShowAlias(boolean isShowAlias) {
        this.isShowAlias = isShowAlias;
    }

    protected boolean isShowAlias() {
        return this.isShowAlias;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get(MODEL_TYPE) != null && ((Boolean)this.getUIContext().get(MODEL_TYPE)).booleanValue()) {
            this.btnAddLine.setVisible(false);
            this.btnInsertLine.setVisible(false);
            this.btnCopyLine.setVisible(false);
            this.btnDeleteLine.setVisible(false);
            this.prmtOrgUnit.setEnabled(false);
            this.prmtBgScheme.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.getUIContext().get("BGSCHEME_INFO") != null) {
            BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            this.beginDate = bgScheme.getDateFrom();
            this.endDate = bgScheme.getDateTo();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("select FOrgUnitId FROM T_MBG_BgScheme Where FID = '" + bgScheme.getId() + "'"), CompareType.INNER));
            this.setUnitInfo(CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi).get(0));
        }
        super.onLoad();
        this.init();
    }

    protected void init() throws EASBizException, BOSException {
        BgViewHelper.removeEditHelper(this.tblMain);
        this.initOrgUnit();
        this.initTblMain();
    }

    protected void initOrgUnit() {
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setPermissionItem(this.getListPermission());
        f7.setRootUnitID(this.getCU().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtOrgUnit.setData((Object)this.getUnitInfo());
        this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
        this.prmtOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BgVariateListUI.this.checkSave(null);
                }
                catch (Exception e1) {
                    e.setCanceled(true);
                    BgVariateListUI.this.handUIException(e1);
                }
            }
        });
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.prmtOrgUnit.getData() != null) {
            return new ObjectUuidPK(((OrgUnitInfo)this.prmtOrgUnit.getData()).getId());
        }
        return super.getOrgPK(action);
    }

    protected void initTblMain() throws EASBizException, BOSException {
        this.tblMain.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        this.tblMain.getColumn("name").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        KDTextField textField = new KDTextField();
        textField.setMaxLength(255);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textField);
        this.tblMain.getColumn("description").setEditor((ICellEditor)editor);
        Boolean onlyNumeric = (Boolean)this.getUIContext().get(ONLY_NUMERIC);
        if (onlyNumeric != null && onlyNumeric.booleanValue()) {
            this.tblMain.getColumn("dimName").getStyleAttributes().setLocked(true);
        }
        for (int i = 2; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setSortable(false);
            this.tblMain.getColumn(i).setRenderer(null);
        }
    }

    protected void initVariateTypeColumnEditor() throws EASBizException, BOSException {
        KDComboBox cbxVariateType = new KDComboBox();
        this.tblMain.getColumn("dimName").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxVariateType));
        this.tblMain.getColumn("dimName").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("memberNumber").getStyleAttributes().setLocked(false);
        this.queryDimensionByScheme();
        BgVariateTypeDispInfo bgVariateDisp = null;
        bgVariateDisp = new BgVariateTypeDispInfo("NUMERIC", BgVariateTypeDispInfo.NUMERIC_NAME, BgVariateClassEnum.CONSTANTS_TYPE);
        cbxVariateType.addItem((Object)bgVariateDisp);
        for (BgDimSettingsInfo dim : this.dimensions) {
            if (dim.getDimNumber().equals(DimensionConstants.DEF_CSL_NUMBER)) continue;
            bgVariateDisp = new BgVariateTypeDispInfo(dim.getDimNumber(), dim.getDimName(), BgVariateClassEnum.DIMENSION_TYPE);
            cbxVariateType.addItem((Object)bgVariateDisp);
        }
        this.dimChangeAction(cbxVariateType);
    }

    protected void queryDimensionByScheme() throws EASBizException, BOSException {
        this.dimensions = new ArrayList<BgDimSettingsInfo>();
        String bgSchemeID = this.getSchemeHelper().getBgSchemeId();
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("seq"));
        view.setSorter(sorter);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeID, CompareType.EQUALS));
        BgDimSettingsCollection coll = BgDimSettingsFactory.getRemoteInstance().getBgDimSettingsCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            this.dimensions.add(coll.get(i));
        }
    }

    private void dimChangeAction(KDComboBox cbx) {
        cbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int curRowIndex = BgVariateListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                IRow row = BgVariateListUI.this.tblMain.getRow(curRowIndex);
                BgVariateTypeDispInfo oldValue = (BgVariateTypeDispInfo)row.getCell("dimName").getValue();
                KDComboBox cbxVariateType = (KDComboBox)e.getSource();
                BgVariateTypeDispInfo newValue = (BgVariateTypeDispInfo)cbxVariateType.getSelectedItem();
                if (e.getStateChange() == 1 && (oldValue == null || newValue != null && !oldValue.getNumber().equals(newValue.getNumber()))) {
                    row.getCell("bgVariateClass").setValue(null);
                    String bgVariateType = newValue.getNumber();
                    for (BgDimSettingsInfo bgDimSettingsInfo : BgVariateListUI.this.dimensions) {
                        if (!bgVariateType.equals(bgDimSettingsInfo.getDimNumber())) continue;
                        row.getCell("dimSeq").setValue((Object)bgDimSettingsInfo.getSeq());
                        row.getCell("dimNumber").setValue((Object)bgDimSettingsInfo.getDimNumber());
                        row.getCell("dimName").setUserObject((Object)bgDimSettingsInfo);
                        BizEnumValueInfo tpye = new BizEnumValueInfo();
                        tpye.setInt(BgVariateClassEnum.DIMENSION_TYPE.getValue());
                        tpye.setAlias(BgVariateClassEnum.DIMENSION_TYPE.getAlias());
                        row.getCell("bgVariateClass").setValue((Object)BizEnumValueDTO.createDTO((BizEnumValueInfo)tpye));
                        break;
                    }
                    if (row.getCell("bgVariateClass").getValue() == null) {
                        row.getCell("dimNumber").setValue((Object)"NUMERIC");
                        row.getCell("dimName").setUserObject(null);
                        BizEnumValueInfo tpye = new BizEnumValueInfo();
                        tpye.setInt(BgVariateClassEnum.CONSTANTS_TYPE.getValue());
                        tpye.setAlias(BgVariateClassEnum.CONSTANTS_TYPE.getAlias());
                        row.getCell("bgVariateClass").setValue((Object)BizEnumValueDTO.createDTO((BizEnumValueInfo)tpye));
                    }
                    BgVariateListUI.this.initMemberCellEditor(row, newValue.getNumber());
                }
            }
        });
    }

    protected void initMemberCellEditor(IRow row, String bgVariateType) {
        row.getCell("memberId").setValue(null);
        row.getCell("memberNumber").setValue(null);
        row.getCell("memberName").setValue(null);
        row.getCell("memberNumber").getStyleAttributes().setLocked(true);
        try {
            BgDimensionInfo dimInfo;
            String dimNumber = null;
            for (BgDimSettingsInfo bgDimSettingsInfo : this.dimensions) {
                if (!bgVariateType.equals(bgDimSettingsInfo.getDimNumber())) continue;
                dimNumber = bgDimSettingsInfo.getDimNumber();
                break;
            }
            BgDimensionInfo bgDimensionInfo = dimInfo = dimNumber != null ? this.getSchemeHelper().getDimension(dimNumber) : null;
            if (dimInfo != null && dimInfo.getNumber() != null) {
                KDBizPromptBox prmtMember = this.getMemberPrmt(dimInfo);
                if (prmtMember != null) {
                    this.addFormaterToPrmt(prmtMember);
                    row.getCell("memberNumber").getStyleAttributes().setLocked(false);
                    row.getCell("memberNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMember));
                    prmtMember.setEditable(false);
                    this.memberChangeAction(prmtMember);
                }
            } else {
                KDTextField textField = new KDTextField();
                textField.setMaxLength(255);
                row.getCell("memberNumber").getStyleAttributes().setLocked(false);
                row.getCell("memberNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
            }
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected KDBizPromptBox getMemberPrmt(BgDimensionInfo dimInfo) throws EASBizException, BOSException {
        if (dimInfo == null) {
            return null;
        }
        String dimensionNum = dimInfo.getNumber();
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimensionNum)) {
            return this.getBgPeriodPrmt();
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionNum)) {
            return this.getBgOrgUnitPrmt();
        }
        dimInfo.setValue("BgVariateListUI");
        NewDimensionMemberSelectDialog dimDialog = new NewDimensionMemberSelectDialog((Component)((Object)this), this.getBgSchemeInfo().getId().toString(), dimInfo, this.getUnitInfo().getId().toString(), false, false);
        dimDialog.setOrgUnit(this.getUnitInfo().castToFullOrgUnitInfo());
        KDBizPromptBox prmtDim = new KDBizPromptBox();
        prmtDim.setRequired(true);
        prmtDim.setEditable(false);
        prmtDim.setSelector((KDPromptSelector)dimDialog);
        return prmtDim;
    }

    protected void addFormaterToPrmt(KDBizPromptBox prmt) {
        IFormatter formatter = new IFormatter(){

            public String valueToString(Object o) {
                BgDimensionMember member;
                if (o != null && o instanceof DataBaseInfo) {
                    if (o instanceof BgPeriodInfo) {
                        if (BgVariateListUI.this.isShowAlias) {
                            return ((BgPeriodInfo)o).getDisplayName();
                        }
                        return ((BgPeriodInfo)o).getNumber();
                    }
                    return ((DataBaseInfo)o).getNumber();
                }
                if (o instanceof List && ((List)o).size() == 1 && ((List)o).get(0) instanceof BgDimensionMember && (member = (BgDimensionMember)((List)o).get(0)) != null) {
                    return member.getNumber();
                }
                return null;
            }

            public void applyPattern(String pattern) {
            }
        };
        prmt.setDisplayFormatter(formatter);
    }

    protected void memberChangeAction(KDBizPromptBox prmt) {
        prmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgDimensionMember member;
                KDBizPromptBox box = (KDBizPromptBox)eventObj.getSource();
                int curRowIndex = BgVariateListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                IRow row = BgVariateListUI.this.tblMain.getRow(curRowIndex);
                Object data = box.getData();
                if (data == null) {
                    row.getCell("memberNumber").setUserObject(null);
                    row.getCell("memberId").setValue(null);
                    row.getCell("memberNumber").setValue(null);
                    row.getCell("memberName").setValue(null);
                } else if (data != null && data instanceof DataBaseInfo) {
                    row.getCell("memberNumber").setUserObject((Object)((DataBaseInfo)data));
                    row.getCell("memberId").setValue((Object)((DataBaseInfo)data).getId());
                    if (data instanceof BgPeriodInfo && BgVariateListUI.this.isShowAlias) {
                        row.getCell("memberName").setValue((Object)((BgPeriodInfo)data).getDisplayName());
                    } else {
                        row.getCell("memberName").setValue((Object)((DataBaseInfo)data).getName());
                    }
                } else if (data instanceof List && ((List)data).size() == 1 && ((List)data).get(0) instanceof BgDimensionMember && (member = (BgDimensionMember)((List)data).get(0)) != null) {
                    row.getCell("memberNumber").setUserObject((Object)member);
                    if (BgVariateListUI.this.memberIdMap == null) {
                        BgVariateListUI.this.initMemberIds();
                    }
                    row.getCell("memberId").setValue((Object)BgVariateListUI.this.memberIdMap.get(member.getType()).get(member.getNumber()));
                    row.getCell("memberName").setValue((Object)member.getName());
                }
            }
        });
    }

    private KDBizPromptBox getBgOrgUnitPrmt() throws EASBizException, BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        BgNewOrgDialog dialog = new BgNewOrgDialog();
        dialog.setBgOrgViewId(this.getSchemeHelper().getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
        prmtSelect.setSelector((KDPromptSelector)dialog);
        return prmtSelect;
    }

    private KDBizPromptBox getBgPeriodPrmt() throws EASBizException, BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        BgPeriodDialog period = new BgPeriodDialog((CoreUIObject)this, false);
        period.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        prmtSelect.addDataChangeListener((DataChangeListener)period);
        period.setCanSelectUserPeriod(false);
        period.setMultiSelect(false);
        period.setBgPeriodBeginDate(this.beginDate);
        period.setBgPeriodEndDate(this.endDate);
        prmtSelect.setSelector((KDPromptSelector)period);
        prmtSelect.setEditable(false);
        return prmtSelect;
    }

    private void formatPrmtBox(KDBizPromptBox prmtSelect) {
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
            this.prmtOrgUnit.setValue(e.getOldValue());
            return;
        }
        super.prmtOrgUnit_dataChanged(e);
        if (this.prmtOrgUnit.getData() instanceof CostCenterOrgUnitInfo) {
            CostCenterOrgUnitInfo ccOrgUnit = (CostCenterOrgUnitInfo)this.prmtOrgUnit.getData();
            this.checkPermission(ccOrgUnit.getId().toString(), (ItemAction)this.actionOnLoad);
            this.setUnitInfo(ccOrgUnit);
        }
        this.initPrmtBgSchemeInfo(this.prmtBgScheme, this.getUnitInfo());
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), (OrgUnitInfo)this.getUnitInfo());
        if (this.getUIContext().get("BGSCHEME_INFO") != null) {
            BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            this.prmtBgScheme.setValue((Object)bgScheme);
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected void initPrmtBgSchemeInfo(KDBizPromptBox prmtBgScheme, CostCenterOrgUnitInfo ccOrgUnitInfo) throws BOSException, EASBizException {
        BgSchemeCollection colls;
        if (prmtBgScheme == null || ccOrgUnitInfo == null) {
            return;
        }
        EntityViewInfo _view = prmtBgScheme.getEntityViewInfo();
        if (_view == null) {
            _view = new EntityViewInfo();
        }
        if (_view.getFilter() == null) {
            _view.setFilter(new FilterInfo());
        }
        if ((colls = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection("select id where orgUnit.id = '" + ccOrgUnitInfo.getId() + "'")) != null && !colls.isEmpty()) {
            FilterInfo _filter = new FilterInfo();
            HashSet<String> bgSchemeIds = new HashSet<String>();
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                if (colls.get(i).getId() == null) continue;
                bgSchemeIds.add(colls.get(i).getId().toString());
            }
            BgNFCHelper.setSchemeIdFilter(bgSchemeIds, _filter);
            _filter.getFilterItems().add(new FilterItemInfo("bgSchemeType.schemeType", (Object)this.getSourceType().getValue()));
            _view.setFilter(_filter);
        } else {
            BgCommCHelper.replaceFilterItems((FilterInfo)_view.getFilter(), (FilterItemInfo)new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
        }
        FilterInfo filter = _view.getFilter();
        filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter);
        _view.setFilter(filter);
        prmtBgScheme.setEntityViewInfo(_view);
    }

    @Override
    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.getBgSchemeInfo() instanceof BgSchemeInfo) {
            this.schemeHelper = new BgSchemeDimensionHelper(null, this.getBgSchemeInfo().getId().toString());
        }
        return this.schemeHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        try {
            if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
                this.prmtBgScheme.setDataNoNotify(e.getOldValue());
                this.beginDate = oldInfo.getDateFrom();
                this.endDate = oldInfo.getDateTo();
                SysUtil.abort();
            } else if (newInfo != null && !BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, newInfo.getId().toString());
                this.memberIdMap = null;
                this.beginDate = newInfo.getDateFrom();
                this.endDate = newInfo.getDateTo();
            }
            if (oldInfo != null) {
                this.checkSave(oldInfo);
            }
            this.tblMain.refresh();
        }
        finally {
            this.prmtBgScheme.setUserObject(null);
        }
        if (this.getSchemeHelper() != null) {
            this.initVariateTypeColumnEditor();
            this.initMemberIds();
            this.dealRollBgVersion();
            this.processPeriodAlias(newInfo);
        }
    }

    private void dealRollBgVersion() throws EASBizException, BOSException {
        LinkedHashMap<String, BgDimensionInfo> dimensions = this.getSchemeHelper().getDimensions();
        BgDimensionInfo bgDimensionInfo = dimensions.get(DimensionBaseConstants.DEF_VERSION_NUMBER);
        Iterator ite = bgDimensionInfo.getMember().iterator();
        while (ite.hasNext()) {
            BgDimensionMember tempMember = (BgDimensionMember)ite.next();
            if (this.memberIdMap.get(DimensionConstants.DEF_VERSION_NUMBER).keySet().contains(tempMember.getNumber())) continue;
            ite.remove();
        }
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
        this.initPrmtBgSchemeInfo(this.prmtBgScheme, this.getUnitInfo());
        FilterInfo filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
    }

    private void processPeriodAlias(BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        if (bgSchemeInfo instanceof BgSchemeInfo && bgSchemeInfo.getOrgUnit() != null && this.getSchemeHelper().getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() != null) {
            String oql = "where orgUnitID = '" + bgSchemeInfo.getOrgUnit().getId() + "' and viewID = '" + this.getSchemeHelper().getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() + "' and isVirtual = 0";
            BgOrgUnitInfo bgOrgUnitInfo = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo(oql);
            if (bgOrgUnitInfo != null) {
                this.setShowAlias(BgPeriodNameEnum.Alias == bgOrgUnitInfo.getPeriodName());
            }
        }
    }

    private void initMemberIds() {
        try {
            List blst;
            List elst;
            List slst;
            List clst;
            List<String> dimLst = this.getSchemeHelper().getAccAndOtherDim(true);
            this.memberIdMap = new HashMap<String, Map<String, String>>();
            if (dimLst != null && !dimLst.isEmpty()) {
                HashMap<String, String> viewMap = new HashMap<String, String>();
                HashSet<String> viewSet = new HashSet<String>();
                String dimNum = null;
                int in = dimLst.size();
                for (int i = 0; i < in; ++i) {
                    dimNum = dimLst.get(i);
                    viewMap.put(this.getSchemeHelper().getDimension(dimNum).getViewId(), dimNum);
                    viewSet.add(this.getSchemeHelper().getDimension(dimNum).getViewId());
                    this.memberIdMap.put(dimNum, new HashMap());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("name");
                sic.add("viewId");
                viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("viewId", viewSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                MbgMemberCollection memberColls = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(viewInfo);
                if (memberColls != null && !memberColls.isEmpty()) {
                    MbgMemberInfo info = null;
                    int in2 = memberColls.size();
                    for (int i = 0; i < in2; ++i) {
                        info = memberColls.get(i);
                        if (!viewMap.containsKey(info.getViewId().toString())) continue;
                        this.memberIdMap.get(viewMap.get(info.getViewId().toString())).put(info.getNumber().toString(), info.getId().toString());
                    }
                }
            }
            if (this.getSchemeHelper().getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId() != null) {
                this.memberIdMap.put(DimensionConstants.DEF_ACCOUNT_NUMBER, new HashMap());
                String viewID = this.getSchemeHelper().getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId();
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("name");
                sic.add("viewId");
                viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgAccountView", (Object)viewID, CompareType.EQUALS));
                viewInfo.setFilter(filter);
                BgAccountCollection colls = BgAccountFactory.getRemoteInstance().getBgAccountCollection(viewInfo);
                if (colls != null && !colls.isEmpty()) {
                    BgAccountInfo info = null;
                    int in = colls.size();
                    for (int i = 0; i < in; ++i) {
                        info = colls.get(i);
                        this.memberIdMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER).put(info.getNumber(), info.getId().toString());
                    }
                }
            }
            if ((clst = this.getSchemeHelper().getDimension(DimensionConstants.DEF_CURRENCY_NUMBER).getMember()) != null && !clst.isEmpty()) {
                this.memberIdMap.put(DimensionConstants.DEF_CURRENCY_NUMBER, new HashMap());
                BgDimensionMember member = null;
                int in = clst.size();
                for (int i = 0; i < in; ++i) {
                    member = (BgDimensionMember)clst.get(i);
                    this.memberIdMap.get(DimensionConstants.DEF_CURRENCY_NUMBER).put(member.getNumber(), member.getAttribute().toString());
                }
            }
            if ((slst = this.getSchemeHelper().getDimension(DimensionConstants.DEF_SCENARIO_NUMBER).getMember()) != null && !slst.isEmpty()) {
                this.memberIdMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, new HashMap());
                BgDimensionMember member = null;
                int in = slst.size();
                for (int i = 0; i < in; ++i) {
                    member = (BgDimensionMember)slst.get(i);
                    this.memberIdMap.get(DimensionConstants.DEF_SCENARIO_NUMBER).put(member.getNumber(), member.getAttribute().toString());
                }
            }
            if ((elst = this.getSchemeHelper().getDimension(DimensionConstants.DEF_ELEMENT_NUMBER).getMember()) != null && !elst.isEmpty()) {
                this.memberIdMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, new HashMap());
                BgDimensionMember member = null;
                int in = elst.size();
                for (int i = 0; i < in; ++i) {
                    member = (BgDimensionMember)elst.get(i);
                    this.memberIdMap.get(DimensionConstants.DEF_ELEMENT_NUMBER).put(member.getNumber(), member.getAttribute().toString());
                }
            }
            if ((blst = this.getSchemeHelper().getDimension(DimensionConstants.DEF_VERSION_NUMBER).getMember()) != null && !blst.isEmpty()) {
                HashSet<String> idSet = new HashSet<String>();
                this.memberIdMap.put(DimensionConstants.DEF_VERSION_NUMBER, new HashMap());
                BgDimensionMember member = null;
                int in = blst.size();
                for (int i = 0; i < in; ++i) {
                    member = (BgDimensionMember)blst.get(i);
                    idSet.add(member.getAttribute());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("name");
                sic.add("isRollVersion");
                viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                BgVersionCollection colls = BgVersionFactory.getRemoteInstance().getBgVersionCollection(viewInfo);
                if (colls != null && !colls.isEmpty()) {
                    BgVersionInfo info = null;
                    int in3 = colls.size();
                    for (int i = 0; i < in3; ++i) {
                        info = colls.get(i);
                        if (info.isIsRollVersion()) continue;
                        this.memberIdMap.get(DimensionConstants.DEF_VERSION_NUMBER).put(info.getNumber(), info.getId().toString());
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("initMemberIds error:" + (Object)((Object)e)));
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException ex) {
            logger.error((Object)("initMemberIds error:" + (Object)((Object)ex)));
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
    }

    protected BgSchemeInfo getBgSchemeInfo() {
        return this.prmtBgScheme.getData() instanceof BgSchemeInfo ? (BgSchemeInfo)this.prmtBgScheme.getData() : null;
    }

    private void checkBgSchemeNull() {
        if (this.getBgSchemeInfo() == null || !(this.getBgSchemeInfo() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"schemeIsNull"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.checkBgSchemeNull();
        this.checkBgSchemeFilling();
        IRow row = this.tblMain.addRow();
        this.afterCreateNewLine(row);
        int newRowCount = this.tblMain.getRowCount() + 1;
        this.tblMain.setRowCount(newRowCount);
        this.tblMain.getSelectManager().setActiveRowIndex(newRowCount);
        this.tblMain.getSelectManager().select(newRowCount, -1);
    }

    private void afterCreateNewLine(IRow row) {
        row.getCell("id").setValue(null);
        row.getCell("orgUnit.name").setValue((Object)this.getUnitInfo());
        row.getCell("createTime").setValue((Object)new Timestamp(System.currentTimeMillis()));
        row.getCell("creator.name").setValue((Object)this.getUserInfo());
        row.getCell("number").getStyleAttributes().setLocked(false);
        if (row.getCell("dimNumber").getValue() != null) {
            row.getCell("memberNumber").getStyleAttributes().setLocked(false);
        } else {
            row.getCell("memberNumber").getStyleAttributes().setLocked(true);
        }
        row.getCell("creator.name").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object != null && object instanceof UserInfo) {
                    TextRender.sharedInstance().draw(graphics, clip, StringUtils.cnulls((String)((UserInfo)object).getName()), cellStyle);
                }
            }
        });
        this.setCellRender(row.getCell("memberNumber"));
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        this.checkBgSchemeNull();
        this.checkBgSchemeFilling();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.addRow(selectIndex + 1);
        this.afterCreateNewLine(row);
        int newRowCount = this.tblMain.getRowCount() + 1;
        this.tblMain.setRowCount(newRowCount);
        this.tblMain.getSelectManager().setActiveRowIndex(selectIndex + 1);
        this.tblMain.getSelectManager().select(selectIndex + 1, -1);
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
        this.checkBgSchemeNull();
        this.checkBgSchemeFilling();
        List indexs = BgAccountHelper.getSelectRowIndex((KDTable)this.tblMain);
        if (indexs == null || indexs.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int rowIndex = (Integer)indexs.get(0);
        IRow row = this.tblMain.getRow(rowIndex);
        KDTRow kRow = (KDTRow)row.getKDTRow().clone();
        IRow addRow = this.tblMain.addRow(rowIndex + 1, kRow);
        int newRowCount = this.tblMain.getRowCount() + 1;
        this.tblMain.setRowCount(newRowCount);
        this.afterCreateNewLine(addRow);
        this.tblMain.getSelectManager().setActiveRowIndex(rowIndex + 1);
        this.tblMain.getSelectManager().select(rowIndex + 1, -1);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteLine_actionPerformed(e);
        this.checkBgSchemeFilling();
        this.checkSelected();
        List indexs = BgAccountHelper.getSelectRowIndex((KDTable)this.tblMain);
        if (indexs == null || indexs.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        if (e == null || this.confirmRemove()) {
            this.deleteLine(indexs);
        }
    }

    private void deleteLine(List<Integer> indexs) throws EASBizException, BOSException, Exception {
        ArrayList<String> needRealDel = new ArrayList<String>();
        IRow row = null;
        Object value = null;
        int rowIndex = 0;
        for (int index = 0; index < indexs.size(); ++index) {
            rowIndex = indexs.get(index);
            row = this.tblMain.getRow(rowIndex);
            value = row.getCell("id").getValue();
            if (value == null) continue;
            needRealDel.add(value.toString());
        }
        if (!needRealDel.isEmpty()) {
            IObjectPK[] objectPk = new IObjectPK[needRealDel.size()];
            for (int i = 0; i < needRealDel.size(); ++i) {
                objectPk[i] = new ObjectStringPK(((String)needRealDel.get(i)).toString());
            }
            this.getBizInterface().deleteBatchData(objectPk);
        }
        StringBuffer msg = new StringBuffer();
        int count = this.tblMain.getRowCount();
        for (int i = count - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            value = row.getCell("id").getValue();
            if (!indexs.contains(i)) continue;
            this.tblMain.removeRow(i);
        }
        if (msg.length() > 0) {
            // empty if block
        }
        this.setMessageBarValue("delete_success");
    }

    private void setMessageBarValue(String value) {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)value));
        this.showMessage();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.checkBgSchemeFilling();
        this.save(this.getBgSchemeInfo());
    }

    protected void save(BgSchemeInfo schemeInfo) throws Exception {
        if (this.cancelSave) {
            this.cancelSave = false;
            return;
        }
        if (schemeInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            return;
        }
        int rowCount = this.tblMain.getRowCount();
        if (rowCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"noSaveBgVariate"));
            return;
        }
        String id = null;
        BgVariateInfo variateInfo = null;
        BgVariateInfo sourceInfo = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        IRow row = null;
        HashSet<String> numRepeatSet = new HashSet<String>();
        HashSet<String> nameRepeatSet = new HashSet<String>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (this.isNullRow(row)) continue;
            this.verifyBeforeSave(row, numRepeatSet, nameRepeatSet);
            variateInfo = new BgVariateInfo();
            if (row.getUserObject() instanceof BgVariateInfo) {
                sourceInfo = (BgVariateInfo)row.getUserObject();
            }
            String string = id = row.getCell("id").getValue() == null ? null : row.getCell("id").getValue().toString();
            if (id != null && !StringUtils.isEmpty((String)id)) {
                variateInfo.setId(BOSUuid.read((String)id));
            }
            variateInfo.setBgScheme(schemeInfo != null ? schemeInfo : this.getBgSchemeInfo());
            variateInfo.setOrgUnit(this.getUnitInfo());
            variateInfo.setNumber(row.getCell("number").getValue().toString());
            variateInfo.setName(row.getCell("name").getValue().toString());
            variateInfo.setBgVariateClass(BgVariateClassEnum.getEnum(((BizEnumValueDTO)row.getCell("bgVariateClass").getValue()).getInt()));
            if (variateInfo.getBgVariateClass().getValue() == 0) {
                BgDimensionMember member;
                variateInfo.setDimNumber(row.getCell("dimNumber").getValue().toString());
                variateInfo.setDimName(row.getCell("dimName").getValue().toString());
                variateInfo.setDimSeq(Integer.valueOf(row.getCell("dimSeq").getValue().toString()));
                variateInfo.setMemberId(row.getCell("memberId").getValue() == null ? null : BOSUuid.read((String)row.getCell("memberId").getValue().toString()));
                variateInfo.setMemberName(row.getCell("memberName").getValue().toString());
                Object o = row.getCell("memberNumber").getValue();
                if (o != null && o instanceof DataBaseInfo) {
                    variateInfo.setMemberNumber(((DataBaseInfo)row.getCell("memberNumber").getValue()).getNumber());
                } else if (o instanceof List && ((List)o).size() == 1 && ((List)o).get(0) instanceof BgDimensionMember && (member = (BgDimensionMember)((List)o).get(0)) != null) {
                    variateInfo.setMemberNumber(member.getNumber());
                }
            } else {
                variateInfo.setDimNumber("NUMERIC");
                variateInfo.setDimName(BgVariateTypeDispInfo.NUMERIC_NAME);
                variateInfo.setDimSeq(0);
                variateInfo.setMemberNumber(row.getCell("memberNumber").getValue().toString());
                variateInfo.setMemberName(row.getCell("memberNumber").getValue().toString());
            }
            variateInfo.setDescription(row.getCell("description").getValue() instanceof String ? row.getCell("description").getValue().toString() : null);
            Object createTime = row.getCell("createTime").getValue();
            Object creator = row.getCell("creator.name").getValue();
            if (createTime instanceof Timestamp) {
                variateInfo.setCreateTime(Timestamp.valueOf(createTime.toString()));
            } else {
                variateInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            if (creator == null) {
                variateInfo.setCreator(this.getUserInfo());
            } else if (creator instanceof UserInfo) {
                variateInfo.setCreator((UserInfo)creator);
            }
            variateInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            variateInfo.setLastUpdateUser(this.getUserInfo());
            variateInfo.setCU(this.getCU());
            if (!BgVariateInfo.checkHasChange(sourceInfo, variateInfo)) continue;
            colls.add((CoreBaseInfo)variateInfo);
        }
        this.getBizInterface().saveBatchData(colls);
        this.tblMain.refresh();
        this.setMessageBarValue("bgVariate_saveSuccess");
    }

    protected boolean isNullRow(IRow row) {
        return row == null || row.getCell("number").getValue() == null && row.getCell("name").getValue() == null && row.getCell("dimName").getValue() == null && row.getCell("memberName").getValue() == null;
    }

    protected void verifyBeforeSave(IRow row, Set<String> numSet, Set<String> nameSet) {
        String value;
        String number = null;
        String name = null;
        String rowNumber = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"rowNumber", (Object[])new Object[]{row.getRowIndex() + 1});
        String variate = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgVariate");
        if (row.getCell("number").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsNull")));
            SysUtil.abort();
        } else {
            number = row.getCell("number").getValue().toString();
            if (StringUtils.isEmpty((String)number)) {
                MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsNull")));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber((String)number)) {
                MsgBox.showWarning((Component)((Object)this), (String)(rowNumber + variate + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"haveEspecial")));
                SysUtil.abort();
            } else if (BgDBUtils.length((String)number) > 80) {
                MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsOverMax", (Object[])new Object[]{80})));
                SysUtil.abort();
            }
        }
        if (numSet.contains(number)) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberRepeat", (Object[])new Object[]{number})));
            SysUtil.abort();
        } else {
            numSet.add(number);
        }
        if (row.getCell("name").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsNull")));
            SysUtil.abort();
        } else {
            name = row.getCell("name").getValue().toString();
            if (StringUtils.isEmpty((String)name)) {
                MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsNull")));
                SysUtil.abort();
            } else if (BgDBUtils.length((String)name) > 80) {
                MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsOverMax", (Object[])new Object[]{80})));
                SysUtil.abort();
            }
        }
        if (nameSet.contains(name)) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + variate + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameRepeat", (Object[])new Object[]{name})));
            SysUtil.abort();
        } else {
            nameSet.add(name);
        }
        if (row.getCell("dimName").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgVariateTypeIsNull")));
            SysUtil.abort();
        }
        if (row.getCell("memberNumber").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"memberIsNull")));
            SysUtil.abort();
        } else if (row.getCell("memberNumber").getValue() instanceof String && (value = (String)row.getCell("memberNumber").getValue()).length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)(rowNumber + EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"numeric_too_long")));
            SysUtil.abort();
        }
    }

    protected void checkSave(BgSchemeInfo schemeInfo) throws Exception {
        int size = this.tblMain.getRowCount();
        if (size > 0) {
            int rs;
            boolean isNeedSave = false;
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (this.isNullRow(row)) continue;
                if (row.getCell("id") == null || row.getCell("id").getValue() == null) {
                    isNeedSave = true;
                    break;
                }
                isNeedSave = this.isRowModify(row);
                if (isNeedSave) break;
            }
            if (isNeedSave && ((rs = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"needSave"))) == 0 || rs == 0)) {
                this.save(schemeInfo);
            }
        }
    }

    protected boolean isRowModify(IRow row) {
        BgVariateInfo sInfo = null;
        String number = null;
        String name = null;
        String dimNumber = null;
        String memberNumber = null;
        String description = null;
        if (row.getUserObject() instanceof BgVariateInfo) {
            List memberList;
            sInfo = (BgVariateInfo)row.getUserObject();
            number = row.getCell("number").getValue() == null ? null : row.getCell("number").getValue().toString();
            String string = name = row.getCell("name").getValue() == null ? null : row.getCell("name").getValue().toString();
            if (row.getCell("dimNumber").getValue() instanceof BgDimSettingsInfo) {
                dimNumber = ((BgDimSettingsInfo)row.getCell("dimNumber").getValue()).getDimNumber();
            } else if (row.getCell("dimNumber").getValue() instanceof String) {
                dimNumber = row.getCell("dimNumber").getValue().toString();
            }
            if (row.getCell("memberNumber").getValue() instanceof DataBaseInfo) {
                memberNumber = ((DataBaseInfo)row.getCell("memberNumber").getValue()).getNumber();
            } else if (row.getCell("memberNumber").getValue() instanceof String) {
                memberNumber = row.getCell("memberNumber").getValue().toString();
            } else if (row.getCell("memberNumber").getValue() instanceof List && (memberList = (List)row.getCell("memberNumber").getValue()).size() > 0 && memberList.get(0) instanceof BgDimensionMember) {
                memberNumber = ((BgDimensionMember)memberList.get(0)).getNumber();
            }
            description = row.getCell("description").getValue() == null ? null : row.getCell("description").getValue().toString();
            String newStr = number + "_" + name + "_" + dimNumber + "_" + memberNumber + "_" + description;
            String oldStr = sInfo.getNumber() + "_" + sInfo.getName() + "_" + sInfo.getDimNumber() + "_" + sInfo.getMemberNumber() + "_" + sInfo.getDescription();
            return !newStr.equals(oldStr);
        }
        return true;
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkSave(this.getBgSchemeInfo());
        }
        catch (Exception e) {
            logger.error((Object)("checkSave error: " + e));
            return false;
        }
        return super.checkBeforeWindowClosing();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.checkSave(this.getBgSchemeInfo());
        super.actionRefresh_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        if (e.getType() == 1 ? (clickCount = e.getClickCount()) == 2 : e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1 && e.getColIndex() != 1) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(false);
        this.setRowUserObject();
    }

    protected void setRowUserObject() {
        IRow row = null;
        Object id = null;
        Object number = null;
        Object name = null;
        Object dimNumber = null;
        Object dimName = null;
        Object memberId = null;
        Object memberNumber = null;
        Object memberName = null;
        Object description = null;
        BgVariateInfo info = null;
        KDBizPromptBox prmtMember = null;
        int count = this.tblMain.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = this.tblMain.getRow(index);
            if (row.getUserObject() != null) {
                return;
            }
            info = new BgVariateInfo();
            id = row.getCell("id").getValue();
            number = row.getCell("number").getValue();
            name = row.getCell("name").getValue();
            dimNumber = row.getCell("dimNumber").getValue();
            dimName = row.getCell("dimName").getValue();
            memberId = row.getCell("memberId").getValue();
            memberNumber = row.getCell("memberNumber").getValue();
            memberName = row.getCell("memberName").getValue();
            description = row.getCell("description").getValue();
            info.setId(id instanceof String ? BOSUuid.read((String)id.toString()) : null);
            info.setNumber(number instanceof String ? number.toString() : null);
            info.setName(name instanceof String ? name.toString() : null);
            info.setDimNumber(dimNumber instanceof String ? dimNumber.toString() : null);
            info.setDimName(dimName instanceof String ? dimName.toString() : null);
            info.setMemberId(memberId instanceof String && !StringUtils.isEmpty((String)((String)memberId)) ? BOSUuid.read((String)memberId.toString()) : null);
            info.setMemberNumber(memberNumber instanceof String ? memberNumber.toString() : null);
            info.setMemberName(memberName instanceof String ? memberName.toString() : null);
            info.setDescription(description instanceof String ? description.toString() : null);
            row.setUserObject((Object)info);
            this.setCellRender(row.getCell("memberNumber"));
            BgVariateClassEnum bgVariateClass = null;
            bgVariateClass = dimNumber == "NUMERIC" ? BgVariateClassEnum.CONSTANTS_TYPE : BgVariateClassEnum.DIMENSION_TYPE;
            BgVariateTypeDispInfo bgVariateType = new BgVariateTypeDispInfo(info.getDimNumber(), info.getDimName(), bgVariateClass);
            row.getCell("dimName").setValue((Object)bgVariateType);
            if (dimNumber != null) {
                try {
                    BgDimensionInfo dimInfo = this.getSchemeHelper().getDimension(dimNumber.toString());
                    if (dimInfo != null) {
                        dimInfo.setValue("BgVarateListUI");
                    }
                    if ((prmtMember = this.getMemberPrmt(dimInfo)) != null) {
                        this.addFormaterToPrmt(prmtMember);
                        row.getCell("memberNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMember));
                        this.setCellObject(row, info);
                        prmtMember.setEditable(false);
                        this.memberChangeAction(prmtMember);
                    }
                }
                catch (EASBizException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
            if (number == null) continue;
            row.getCell("number").getStyleAttributes().setLocked(true);
        }
    }

    protected void setCellObject(IRow row, BgVariateInfo info) {
        String dimNumber = info.getDimNumber();
        String memberNumber = info.getMemberNumber();
        String memberName = info.getMemberName();
        if (dimNumber.equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            BgPeriodInfo period = new BgPeriodInfo();
            period.setNumber(memberNumber);
            period.setName(memberName);
            period.setDisplayName(memberName);
            row.getCell("memberNumber").setValue((Object)period);
        } else if (dimNumber.equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
            BgOrgUnitInfo orgUnit = new BgOrgUnitInfo();
            orgUnit.setNumber(memberNumber);
            orgUnit.setName(memberName);
            row.getCell("memberNumber").setValue((Object)orgUnit);
        } else {
            BgDimensionMember member = new BgDimensionMember(dimNumber, null, memberName, memberNumber);
            ArrayList<BgDimensionMember> memList = new ArrayList<BgDimensionMember>();
            memList.add(member);
            row.getCell("memberNumber").setValue(memList);
        }
    }

    protected void setCellRender(ICell cell) {
        cell.setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object != null && object instanceof DataBaseInfo) {
                    if (object instanceof BgPeriodInfo) {
                        if (BgVariateListUI.this.isShowAlias) {
                            TextRender.sharedInstance().draw(graphics, clip, StringUtils.cnulls((String)((BgPeriodInfo)object).getDisplayName()), cellStyle);
                        } else {
                            TextRender.sharedInstance().draw(graphics, clip, StringUtils.cnulls((String)((BgPeriodInfo)object).getName()), cellStyle);
                        }
                    } else {
                        TextRender.sharedInstance().draw(graphics, clip, StringUtils.cnulls((String)((DataBaseInfo)object).getName()), cellStyle);
                    }
                } else if (object instanceof List && ((List)object).size() == 1 && ((List)object).get(0) instanceof BgDimensionMember) {
                    BgDimensionMember member = (BgDimensionMember)((List)object).get(0);
                    if (member != null) {
                        TextRender.sharedInstance().draw(graphics, clip, StringUtils.cnulls((String)member.getName()), cellStyle);
                    }
                } else if (object instanceof String) {
                    TextRender.sharedInstance().draw(graphics, clip, StringUtils.cnulls((String)object.toString()), cellStyle);
                }
            }
        });
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        Set variateNumbers;
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
        }
        FilterItemInfo itemInfo = null;
        itemInfo = this.getBgSchemeInfo() instanceof BgSchemeInfo ? new FilterItemInfo("bgScheme.id", (Object)this.getBgSchemeInfo().getId().toString(), CompareType.EQUALS) : new FilterItemInfo("bgScheme.id", (Object)BgBaseConstants.noFindStr, CompareType.EQUALS);
        BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)itemInfo);
        Boolean onlyNumeric = (Boolean)this.getUIContext().get(ONLY_NUMERIC);
        if (onlyNumeric != null && onlyNumeric.booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("bgVariateClass", (Object)1, CompareType.EQUALS));
        }
        if ((variateNumbers = (Set)this.getUIContext().get(VARIATE_NUMBERS)) != null) {
            BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("number", (Object)variateNumbers, CompareType.INCLUDE));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgVariateFactory.getRemoteInstance();
    }

    protected String getListPermission() {
        return "mbg_bgVariate01_list";
    }

    protected void checkPermission(String orgUnitId, ItemAction action) throws Exception {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgUnitId), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)action);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        int col = e.getColIndex();
        Object obj = e.getValue();
        if (col == this.tblMain.getColumnIndex("memberNumber") && ((BizEnumValueDTO)this.tblMain.getRow(row).getCell("bgVariateClass").getValue()).getInt() == 1 && obj != null && obj instanceof String) {
            String value = (String)obj;
            if (!value.matches("\\-?([\\d]+\\.)?[\\d]+")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"not_numeric"));
                this.tblMain.getRow(row).getCell("memberNumber").setValue(null);
                this.tblMain.getEditManager().cancelEditing();
                this.cancelSave = true;
                SysUtil.abort();
            } else {
                String numeric = null;
                numeric = org.apache.commons.lang.StringUtils.stripStart((String)value, (String)"0");
                if (numeric.startsWith(".")) {
                    numeric = "0" + numeric;
                }
                if (value.contains(".")) {
                    numeric = org.apache.commons.lang.StringUtils.stripEnd((String)numeric, (String)"0");
                    numeric = org.apache.commons.lang.StringUtils.stripEnd((String)numeric, (String)".");
                }
                this.tblMain.getRow(row).getCell("memberNumber").setValue((Object)numeric);
            }
        }
    }

    protected void checkBgSchemeFilling() {
        BgSchemeInfo bgSchemeInfo = this.getBgSchemeInfo();
        if (bgSchemeInfo == null) {
            return;
        }
        if (bgSchemeInfo.isIsFiling()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"bgSchemeIsFilling"));
            SysUtil.abort();
        }
    }
}

