/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.AbstractBgVersionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgVersionUI
extends AbstractBgVersionUI {
    private static final Logger logger = CoreUIObject.getLogger(BgVersionUI.class);
    private static String BG_ADJUSTID = "ADJUSTID";
    private final int VERSIONNO_COL = 0;
    private final int ORIGIN_COL = 1;
    private final int ROLLPERIOD_COL = 2;
    private final int AUDITTIME_COL = 3;
    private final int LASTUPDATEUSER_COL = 4;
    private final int CREATORNAME_COL = 5;
    private String value = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.fillTable();
        this.tblMain.setEditable(false);
    }

    private void fillTable() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        String adjustId = (String)this.getUIContext().get(BG_ADJUSTID);
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjust.id", (Object)adjustId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("versionNo");
        sorter.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("versionNo"));
        selector.add(new SelectorItemInfo("bgRollPeriod.number"));
        selector.add(new SelectorItemInfo("auditTime"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("adjust.id"));
        selector.add(new SelectorItemInfo("dataSource"));
        selector.add(new SelectorItemInfo("lastUpdateUser.name"));
        selector.add(new SelectorItemInfo("bgTemplate.formType"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        BgFormCollection adjustFormColl = iBgForm.getBgFormCollection(viewInfo);
        IRow row = null;
        for (int i = 0; i < adjustFormColl.size(); ++i) {
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)adjustFormColl.get(i).getBgTemplate().getFormType()) || BgTemFormTypeEnum.VIEWFORM.equals((Object)adjustFormColl.get(i).getBgTemplate().getFormType())) continue;
            row = this.tblMain.addRow();
            BigDecimal verNo = adjustFormColl.get(i).getVersionNo().setScale(1);
            row.getCell(0).setValue((Object)verNo);
            row.getCell(1).setValue((Object)adjustFormColl.get(i).getDataSource().getAlias());
            row.getCell(3).setValue((Object)adjustFormColl.get(i).getAuditTime());
            row.getCell(4).setValue((Object)adjustFormColl.get(i).getLastUpdateUser().getName());
            row.getCell(5).setValue((Object)adjustFormColl.get(i).getCreator().getName());
            row.setUserObject((Object)adjustFormColl.get(i));
        }
        this.tblMain.getColumn(2).getStyleAttributes().setHided(true);
        if (adjustFormColl != null) {
            adjustFormColl.clear();
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String showDialogWindow(Component ui, String adjustId, String flag) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)BG_ADJUSTID, (Object)adjustId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgVersionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        String bgFormId = ((BgVersionUI)uiWindow.getUIObject()).getValue();
        return bgFormId;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        List rowList;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((rowList = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain)).size() > 0 && (row = this.tblMain.getRow(((Integer)rowList.get(0)).intValue())) != null) {
            BgFormInfo bgForm = (BgFormInfo)row.getUserObject();
            this.setValue(bgForm.getId().toString());
        }
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            IRow row;
            List rowList = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
            if (rowList.size() > 0 && (row = this.tblMain.getRow(((Integer)rowList.get(0)).intValue())) != null) {
                BgFormInfo bgForm = (BgFormInfo)row.getUserObject();
                this.setValue(bgForm.getId().toString());
            }
            this.destroyWindow();
        }
    }
}

