/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.IViewDimensionMemberF7;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgExamineReportFacadeFactory;
import com.kingdee.eas.ma.mbg.SimpleObj;
import com.kingdee.eas.ma.mbg.client.AbstractDimF7UI;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimF7UI
extends AbstractDimF7UI
implements IViewDimensionMemberF7 {
    private static final Logger logger = CoreUIObject.getLogger(DimF7UI.class);
    private boolean isCanceled = true;

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setMultiSelect(boolean multiSelect) {
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblRight.checkParsed();
        this.tblLeft.checkParsed();
        this.tblRight.getSelectManager().setSelectMode(10);
        this.tblLeft.getSelectManager().setSelectMode(10);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.initLeft();
        this.initRight(null);
    }

    private void initLeft() throws BOSException, EASBizException {
        SimpleObj so = (SimpleObj)((Object)this.getUIContext().get("SO"));
        HashSet<String> srcSelectedNumbers = new HashSet<String>();
        if (so != null) {
            String srcNumbers = so.getNumber();
            String[] split = srcNumbers.split(",");
            for (int i = 0; i < split.length; ++i) {
                srcSelectedNumbers.add(split[i]);
            }
        }
        this.resetLeft(srcSelectedNumbers);
    }

    private void resetLeft(Set<String> srcSelectedNumbers) {
        String schemeId = (String)this.getUIContext().get("schemeId");
        try {
            Map<String, String> srcField = this.getSrcRef();
            Map srcNameMap = BgExamineReportFacadeFactory.getRemoteInstance().getSrcNameMap(schemeId);
            ArrayList<SimpleObj> list = new ArrayList<SimpleObj>();
            for (Map.Entry entry : srcNameMap.entrySet()) {
                String src = (String)entry.getKey();
                String name = (String)entry.getValue();
                if (srcSelectedNumbers.contains(src)) continue;
                SimpleObj s = new SimpleObj();
                s.setName(name);
                s.setNumber(src);
                s.setDisplayFormat(srcField.get(src));
                list.add(s);
            }
            Collections.sort(list, new Comparator<SimpleObj>(){

                @Override
                public int compare(SimpleObj o1, SimpleObj o2) {
                    String substring = o1.getDisplayFormat().substring(1);
                    String substring2 = o2.getDisplayFormat().substring(1);
                    Integer a = Integer.valueOf(substring);
                    Integer b = Integer.valueOf(substring2);
                    if (a.equals(98) && b.compareTo(5) > 0 && !b.equals(99) || a.equals(99) && b.compareTo(5) > 0 && !b.equals(98)) {
                        return -1;
                    }
                    if (b.equals(98) && a.compareTo(5) > 0 && !a.equals(98) || b.equals(99) && a.compareTo(5) > 0 && !a.equals(98)) {
                        return 1;
                    }
                    return a.compareTo(b);
                }
            });
            this.tblLeft.removeRows();
            for (int i = 0; i < list.size(); ++i) {
                SimpleObj simpleObj = (SimpleObj)((Object)list.get(i));
                IRow addRow = this.tblLeft.addRow();
                addRow.getCell("name").setValue((Object)simpleObj.getName());
                addRow.getCell("src").setValue((Object)simpleObj.getNumber());
                addRow.getCell("ref").setValue((Object)simpleObj.getDisplayFormat());
                addRow.setUserObject((Object)simpleObj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblLeft_tableClicked(e);
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.doubleClick();
        }
    }

    private void doubleClick() {
        int currRowIndex = this.tblLeft.getSelectManager().getActiveRowIndex();
        if (currRowIndex >= 0) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            rows.add(currRowIndex);
            this.add(rows);
        }
    }

    private Map<String, String> getSrcRef() throws EASBizException, BOSException {
        String schemeId = (String)this.getUIContext().get("schemeId");
        BgSchemeDimensionHelper bgSchemeDimensionHelper = new BgSchemeDimensionHelper(schemeId);
        Map<String, String> srcNumberMap = bgSchemeDimensionHelper.getSrcNumberMap();
        Map<String, String> refFieldMap = bgSchemeDimensionHelper.getRefFieldMap();
        HashMap<String, String> srcField = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : refFieldMap.entrySet()) {
            srcField.put(srcNumberMap.get(entry.getKey()), entry.getValue());
        }
        return srcField;
    }

    private void initRight(SimpleObj sso) {
        SimpleObj so = null;
        so = sso == null ? (SimpleObj)((Object)this.getUIContext().get("SO")) : sso;
        if (so != null) {
            int i;
            String srcNumbers = so.getNumber();
            String nameString = so.getName();
            String[] split = srcNumbers.split(",");
            this.tblRight.removeRows();
            for (i = 0; i < split.length; ++i) {
                String src = split[i];
                IRow addRow = this.tblRight.addRow();
                addRow.getCell("src").setValue((Object)src);
            }
            split = nameString.split(",");
            for (i = 0; i < split.length; ++i) {
                String name = split[i];
                IRow row = this.tblRight.getRow(i);
                if (row == null) continue;
                row.getCell("name").setValue((Object)name);
            }
        }
    }

    public void reShow() {
        this.isCanceled = true;
        this.show();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.isCanceled = false;
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.destroyWindow();
    }

    public void dataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && !eventObj.getNewValue().equals(eventObj.getOldValue()) || eventObj.getOldValue() != null && !eventObj.getOldValue().equals(eventObj.getNewValue())) {
            if (eventObj.getNewValue() != null) {
                SimpleObj so = (SimpleObj)((Object)eventObj.getNewValue());
                this.initRight(so);
                this.reSetLeft();
            } else {
                this.tblRight.removeRows();
                this.reSetLeft();
            }
        }
    }

    public Object getData() throws BOSException, EASBizException {
        List selectRowIndexes = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblRight);
        if (selectRowIndexes == null) {
            return null;
        }
        String srcString = "";
        String nameString = "";
        for (int i = 0; i < selectRowIndexes.size(); ++i) {
            IRow row = this.tblRight.getRow(((Integer)selectRowIndexes.get(i)).intValue());
            String src = (String)row.getCell("src").getValue();
            String name = (String)row.getCell("name").getValue();
            if (src == null || name == null) continue;
            if (i == selectRowIndexes.size() - 1) {
                srcString = srcString + src;
                nameString = nameString + name;
                continue;
            }
            srcString = srcString + src + ",";
            nameString = nameString + name + ",";
        }
        SimpleObj so = new SimpleObj();
        so.setName(nameString);
        so.setNumber(srcString);
        return so;
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft);
        this.add(rows);
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddAll_actionPerformed(e);
        List rows = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblLeft);
        this.add(rows);
    }

    protected void add(List<Integer> rows) {
        if (rows == null) {
            return;
        }
        Collections.sort(rows);
        for (int i = 0; i < rows.size(); ++i) {
            IRow rowLeft = this.tblLeft.getRow(rows.get(i).intValue());
            IRow rowRight = this.tblRight.addRow();
            rowRight.getCell("name").setValue(rowLeft.getCell("name").getValue());
            rowRight.getCell("src").setValue(rowLeft.getCell("src").getValue());
        }
        this.reSetLeft();
    }

    private void reSetLeft() {
        List selectAllRowIndexes = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblRight);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            set.add((String)this.tblRight.getRow(i).getCell("src").getValue());
        }
        this.resetLeft(set);
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        List rowIndexs = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight);
        if (rowIndexs.size() == this.tblRight.getRowCount()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"selectedDims_notEmpty"));
            return;
        }
        this.remove(rowIndexs);
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"selectedDims_notEmpty"));
    }

    protected void remove(List<Integer> rows) throws Exception {
        if (rows == null) {
            return;
        }
        BgCommCHelper.removeRows((KDTable)this.tblRight, rows);
        this.reSetLeft();
    }

    protected void checkSelectRow(KDTable table) {
        if (table.getSelectManager().getBlocks() == null || table.getSelectManager().getBlocks().isEmpty()) {
            if (this.tblLeft == table) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"checkLeftSelectRow"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"checkRightSelectRow"));
            }
            SysUtil.abort();
        }
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveTop((KDTable)this.tblRight);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveUp((KDTable)this.tblRight);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveBottom((KDTable)this.tblRight);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveDown((KDTable)this.tblRight);
    }
}

