/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.AssignSolutionCollection;
import com.kingdee.eas.ma.mbg.AssignSolutionFactory;
import com.kingdee.eas.ma.mbg.AssignSolutionInfo;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionMemberFilterRemoveUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DimensionMemberFilterRemoveUI
extends AbstractDimensionMemberFilterRemoveUI {
    private static final Logger logger = CoreUIObject.getLogger(DimensionMemberFilterRemoveUI.class);
    private List<IObjectPK> removePks = new ArrayList<IObjectPK>();
    private static final String COL_SELECT = "select";
    private static final String COL_NAME = "name";

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionRemove.setEnabled(true);
        this.loadToTable(true);
    }

    private void loadToTable(boolean isOnLoad) throws Exception {
        AssignSolutionCollection col;
        this.tblMain.removeRows();
        String rootId = (String)this.getUIContext().get("BGTEMPLATE_ROOT_ID");
        if (rootId == null) {
            SysUtil.abort();
        }
        if ((col = MBGFormFacadeFactory.getRemoteInstance().getMemberFilter(rootId)) == null || col.isEmpty()) {
            if (isOnLoad) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"notFilter"));
                SysUtil.abort();
            } else {
                return;
            }
        }
        for (int i = 0; i < col.size(); ++i) {
            AssignSolutionInfo sol = col.get(i);
            IRow row = this.tblMain.addRow();
            row.setUserObject((Object)sol);
            row.getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
            row.getCell(COL_NAME).setValue((Object)sol.getSolutionName());
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COL_SELECT).getValue())) continue;
            pks.add(new ObjectUuidPK(((AssignSolutionInfo)row.getUserObject()).getId()));
        }
        if (pks.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        } else {
            int r = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete"));
            if (r == 0) {
                AssignSolutionFactory.getRemoteInstance().delete(pks.toArray(new IObjectPK[pks.size()]));
                this.removePks.addAll(pks);
                this.loadToTable(false);
            }
        }
    }

    public List<IObjectPK> getRemovePks() {
        return this.removePks;
    }
}

