/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgElementCollObject;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.DimensionDisplayModeEnum;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionMemberSetUI;
import com.kingdee.eas.ma.mbg.client.BgElementDialog;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.DimensionRelationF7;
import com.kingdee.eas.ma.mbg.client.common.ShowDefaultTextPromptBox;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationshipSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class DimensionMemberSetUI
extends AbstractDimensionMemberSetUI
implements IGetSchemeHelper {
    private static final Logger logger = CoreUIObject.getLogger(DimensionMemberSetUI.class);
    private static final long serialVersionUID = 1L;
    protected final String MEMBER_VALUE_TYPE_NAME = "MemberValueType";
    protected final String MEMBER_VALUE_F7_NAME = "MemberValueF7";
    protected final String MEMBER_MAPPING_F7_NAME = "MemberRelationF7";
    protected final String MEMBER_VALUE_DISPLAY_MODE_NAME = "MemberValueDisplayMode";
    protected final String DINAMIC_CHCK_NAME = "DinamicAddMemberChck";
    protected final String DINAMIC_CAN_ADD_MEMBER = "DinamicCanAddMember";
    protected final String ISSELECTRELATION_CHCK_NAME = "isSelectRelation";
    protected final String SELECTRELATION__NAME = "SelectRelation";
    protected final String BGPERIODTYPE_F7_NAME = "BgPeriodTypeF7";
    protected final String BGPERIODTYPE_LABEL_NAME = "BgPeriodTypeLabel";
    protected KDPanel viewPanel = new KDPanel();
    protected KDPanel pagePanel = new KDPanel();
    protected KDPanel rowPanel = new KDPanel();
    protected KDPanel colPanel = new KDPanel();
    protected String orgId = null;
    protected Map<String, KDPanel> dimensionPanels = new HashMap<String, KDPanel>();

    public DimensionMemberSetUI() throws Exception {
        this.initPanels();
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    protected void initPanels() {
        this.initPanel("viewDimensionDes", this.viewPanel);
        this.initPanel("pageDimensionDes", this.pagePanel);
        this.initPanel("rowDimensionDes", this.rowPanel);
        this.initPanel("colDimensionDes", this.colPanel);
    }

    protected void initPanel(String txtResourceKey, KDPanel panel) {
        KDPanel parent = new KDPanel();
        parent.setLayout((LayoutManager)new BorderLayout(5, 0));
        KDWorkButton colDesBtn = new KDWorkButton(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)txtResourceKey));
        colDesBtn.setPreferredSize(new Dimension(85, 20));
        KDPanel colDimensionDesPanel = new KDPanel();
        colDimensionDesPanel.add((Component)colDesBtn);
        parent.add((Component)colDimensionDesPanel, (Object)"West");
        parent.add((Component)panel, (Object)"Center");
        panel.setLayout((LayoutManager)new GridLayout(0, 1, 0, 0));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        GridBagLayout grigBagLayout = new GridBagLayout();
        this.pnlMember.setLayout((LayoutManager)grigBagLayout);
    }

    @Override
    public void loadFields() {
        this.curSheetTxt.setText(this.getSheetManager().getSheetName());
        Object[] scens = null;
        if (this.getSheetManager().getEditScenNumber() != null && !StringUtils.isEmpty((String)this.getSheetManager().getEditScenNumber())) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(this.getSheetManager().getEditScenNumber().split(","))), CompareType.INCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo("number"));
            try {
                BgScenarioCollection col = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(evi);
                if (col != null && !col.isEmpty()) {
                    scens = col.toArray();
                }
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        this.prmtCurScen.setData(scens);
        this.update();
    }

    protected void setCurScenFilter(KDPanel pnl) {
        if (pnl != null && !DimensionConstants.DEF_SCENARIO_NUMBER.equals(pnl.getName())) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        Set<String> numbers = this.getScenByF7(pnl);
        if (numbers != null && !numbers.isEmpty()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, true), CompareType.INCLUDE));
        }
        this.prmtCurScen.setEntityViewInfo(evi);
    }

    public void update() {
        this.pnlMember.removeAll();
        this.addDimensionPanel(this.getDimensionManager().getViewDimension(), this.viewPanel, (Container)this.pnlMember);
        this.addDimensionPanel(this.getDimensionManager().getPageDimension(), this.pagePanel, (Container)this.pnlMember);
        this.addDimensionPanel(this.getDimensionManager().getRowDimension(), this.rowPanel, (Container)this.pnlMember);
        this.addDimensionPanel(this.getDimensionManager().getColDimension(), this.colPanel, (Container)this.pnlMember);
        this.setCurScenFilter(null);
        this.updateUI();
    }

    private void addDimensionPanel(List<BgDimensionInfo> list, KDPanel panel, Container parentContainer) {
        BgDimensionInfo bgDimensionInfo2 = null;
        if (list.size() > 0) {
            panel.removeAll();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.gridheight = list.size();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            if (panel == this.colPanel) {
                gbc.weighty = 1.0;
            }
            if (panel != this.colPanel) {
                gbc.insets = new Insets(0, 0, 0, 0);
            }
            for (BgDimensionInfo bgDimensionInfo2 : list) {
                panel.add((Component)this.getDimensionPanel(bgDimensionInfo2));
            }
            ((GridBagLayout)parentContainer.getLayout()).setConstraints(panel.getParent(), gbc);
            parentContainer.add(panel.getParent());
        }
    }

    protected KDPanel getDimensionPanel(BgDimensionInfo bgDimensionInfo) {
        final KDPanel panel = new KDPanel();
        panel.setName(bgDimensionInfo.getNumber());
        panel.setPreferredSize(new Dimension(635, 35));
        panel.setLayout((LayoutManager)new FlowLayout(0));
        this.dimensionPanels.put(bgDimensionInfo.getNumber(), panel);
        KDLabel label = new KDLabel(bgDimensionInfo.getName());
        label.setPreferredSize(new Dimension(100, 20));
        panel.add((Component)label);
        KDComboBox valueTypeCombo = this.getDimensiionMemberValueTypeCombo(bgDimensionInfo);
        if (this.isOrgDimension(bgDimensionInfo)) {
            valueTypeCombo.setEnabled(false);
        }
        panel.add((Component)valueTypeCombo);
        KDComboBox bgPeriodTypeBox = this.getBgPeriodTypeCombox(bgDimensionInfo);
        bgPeriodTypeBox.setName("BgPeriodTypeF7");
        KDLabel bgPeriodTypeLbl = this.getBgPeriodTypeLable(bgDimensionInfo);
        try {
            KDBizPromptBox memberPromptBox = this.getDimensionMemberF7(this, bgDimensionInfo, this.orgId);
            memberPromptBox.setPreferredSize(new Dimension(160, 20));
            memberPromptBox.setName("MemberValueF7");
            panel.add((Component)memberPromptBox);
            memberPromptBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    DimensionMemberSetUI.this.setCurScenFilter(panel);
                }
            });
            KDBizPromptBox mappingPromptBox = this.getDimensionRelationF7(this, bgDimensionInfo, this.orgId);
            mappingPromptBox.setName("MemberRelationF7");
            mappingPromptBox.setPreferredSize(new Dimension(160, 20));
            panel.add((Component)mappingPromptBox);
            if (this.isOrgDimension(bgDimensionInfo)) {
                memberPromptBox.setEnabled(false);
                mappingPromptBox.setEnabled(false);
                mappingPromptBox.setVisible(false);
            }
            if (valueTypeCombo.getSelectedItem() instanceof DimensionMemberValueModeEnum) {
                this.setF7State(memberPromptBox, mappingPromptBox, bgPeriodTypeBox, bgPeriodTypeLbl, ((DimensionMemberValueModeEnum)((Object)valueTypeCombo.getSelectedItem())).getValue(), bgDimensionInfo);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        panel.add((Component)this.getDimensionDisplayModeCombo(bgDimensionInfo));
        panel.add((Component)bgPeriodTypeLbl);
        panel.add((Component)bgPeriodTypeBox);
        KDCheckBox chkSelectRelation = this.getIsSelectRelationCheckBox(bgDimensionInfo);
        panel.add((Component)chkSelectRelation);
        KDBizPromptBox prmtSelectRelation = this.getSelectRelationProp(bgDimensionInfo);
        panel.add((Component)prmtSelectRelation);
        KDCheckBox chkAddMember = this.getDinamicAddMemberCheckBox(bgDimensionInfo);
        panel.add((Component)chkAddMember);
        KDBizPromptBox canAddF7 = this.getDinamicCanAddMemberF7(chkAddMember, bgDimensionInfo, this.orgId);
        panel.add((Component)canAddF7);
        if (!this.isCanDinamicAddMember(bgDimensionInfo)) {
            chkAddMember.setVisible(false);
            canAddF7.setVisible(false);
        }
        if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(bgDimensionInfo.getNumber())) {
            chkAddMember.setSelected(true);
        }
        this.setCheckBoxState(bgDimensionInfo, panel);
        return panel;
    }

    private void setCheckBoxState(BgDimensionInfo bgDimensionInfo, KDPanel panel) {
        if (bgDimensionInfo.getMemberValueType().getValue() == 4) {
            this.setRelationMappingState(true, panel);
        } else {
            this.setRelationMappingState(false, panel);
        }
    }

    private void setRelationMappingState(boolean flag, KDPanel panel) {
        KDCheckBox chkSelectRelation = (KDCheckBox)this.findComponent(panel, "isSelectRelation");
        KDCheckBox chkAddMember = (KDCheckBox)this.findComponent(panel, "DinamicAddMemberChck");
        KDBizPromptBox dinamicCanAddMemberF7 = (KDBizPromptBox)this.findComponent(panel, "DinamicCanAddMember");
        KDBizPromptBox prmtSelectRelation = (KDBizPromptBox)this.findComponent(panel, "SelectRelation");
        chkSelectRelation.setVisible(flag);
        chkSelectRelation.setEnabled(flag);
        prmtSelectRelation.setEnabled(flag);
        prmtSelectRelation.setVisible(flag);
        List<String> viewNumbers = MBgTemplateHelper.getDimensionsNum(this.getDimensionManager().getViewDimension());
        boolean isView = viewNumbers != null && viewNumbers.contains(panel.getName());
        boolean isCanAddMember = this.isCanDinamicAddMember(panel.getName(), isView);
        if (chkAddMember != null) {
            chkAddMember.setVisible(!flag && isCanAddMember);
        }
        if (dinamicCanAddMemberF7 != null) {
            dinamicCanAddMemberF7.setVisible(!flag && isCanAddMember);
        }
    }

    private KDBizPromptBox getDimensionRelationF7(CoreUI owner, BgDimensionInfo dimensionInfo, String orgId) {
        KDBizPromptBox prmtSelect = this.getDimensionRelationF7UI(dimensionInfo);
        if (prmtSelect != null) {
            prmtSelect.addDataChangeListener((DataChangeListener)new DimRelaF7ChangeChangeListener());
        }
        return prmtSelect;
    }

    private KDBizPromptBox getDimensionMemberF7(CoreUI owner, BgDimensionInfo dimensionInfo, String orgId) throws Exception {
        if (dimensionInfo == null || StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        KDBizPromptBox f7 = null;
        boolean isMultiSelect = this.isMultiSelectMemberValue(dimensionInfo);
        f7 = MBGLayoutConstants.BG_PERIOD.equals(dimensionInfo.getNumber()) ? this.getBgPeriodF7UI(isMultiSelect) : (MBGLayoutConstants.BG_ELEMENT.equals(dimensionInfo.getNumber()) ? this.getBgElimentF7UI(dimensionInfo, isMultiSelect) : (MBGLayoutConstants.BG_CURRENCY.equals(dimensionInfo.getNumber()) ? this.getBgCurrencyF7UI(isMultiSelect) : (MBGLayoutConstants.BG_SCENARIO.equals(dimensionInfo.getNumber()) ? this.getBgScenarioF7UI(isMultiSelect) : (MBGLayoutConstants.BG_VERSION.equals(dimensionInfo.getNumber()) ? this.getBgVersionF7UI(isMultiSelect) : this.getDimensionF7(dimensionInfo, orgId, isMultiSelect)))));
        if (f7 != null && dimensionInfo.getMember().size() > 0) {
            if (isMultiSelect) {
                f7.setData(new ArrayList(dimensionInfo.getMember()));
            } else {
                f7.setData(dimensionInfo.getMember().get(0));
            }
        } else {
            f7.setData(null);
        }
        return f7;
    }

    private KDBizPromptBox getBgVersionF7UI(boolean isMultiSelect) {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.base.BgVersionQuery");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setEnabledMultiSelection(isMultiSelect);
        DimensionMemberSelectHelper.addIdFilter(prmtSelect, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
        BgNFormListUI.addRollVersionFilter(prmtSelect);
        return prmtSelect;
    }

    private KDBizPromptBox getBgScenarioF7UI(boolean isMultiSelect) {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setEnabledMultiSelection(isMultiSelect);
        DimensionMemberSelectHelper.addIdFilter(prmtSelect, DimensionConstants.DEF_SCENARIO_NUMBER, this.getSchemeHelper());
        return prmtSelect;
    }

    protected KDBizPromptBox getDimensionF7(BgDimensionInfo dimensionInfo, String orgId, boolean isMultiSelect) throws Exception {
        return DimensionClientHelper.getDimensionF7(this, dimensionInfo, orgId, isMultiSelect);
    }

    private KDBizPromptBox getBgCurrencyF7UI(boolean isMultiSelect) {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setEnabledMultiSelection(isMultiSelect);
        DimensionMemberSelectHelper.addIdFilter(prmtSelect, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
        return prmtSelect;
    }

    private KDBizPromptBox getBgElimentF7UI(BgDimensionInfo dimensionInfo, boolean isMultiSelect) {
        ArrayList<String> hasSelect = new ArrayList<String>();
        if (dimensionInfo.getMember() != null) {
            for (int i = 0; i < dimensionInfo.getMember().size(); ++i) {
                hasSelect.add(((BgDimensionMember)dimensionInfo.getMember().get(i)).getNumber());
            }
        }
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        BgElementDialog element = new BgElementDialog((IUIObject)this, hasSelect);
        element.setIsChooseOne(!isMultiSelect);
        prmtSelect.setSelector((KDPromptSelector)element);
        prmtSelect.setEditable(false);
        prmtSelect.addDataChangeListener((DataChangeListener)element);
        return prmtSelect;
    }

    private KDBizPromptBox getBgPeriodF7UI(boolean isMultiSelect) throws EASBizException, BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        BgPeriodDialog period = this.newBgPeriodDialog();
        String bgSchemeId = this.getSchemeHelper().getBgSchemeId();
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId));
        period.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
        period.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
        period.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        prmtSelect.addDataChangeListener((DataChangeListener)period);
        period.setCanSelectUserPeriod(true);
        period.setMultiSelect(isMultiSelect);
        prmtSelect.setSelector((KDPromptSelector)period);
        prmtSelect.setEditable(false);
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
        return prmtSelect;
    }

    protected BgPeriodDialog newBgPeriodDialog() {
        return new BgPeriodDialog((CoreUIObject)this, true);
    }

    protected KDBizPromptBox getDimensionRelationF7UI(BgDimensionInfo dimensionInfo) {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        DimensionRelationF7 f7 = new DimensionRelationF7((IUIObject)this, dimensionInfo, this.getSchemeHelper().getBgSchemeId());
        prmtSelect.setSelector((KDPromptSelector)f7);
        prmtSelect.setEditable(false);
        if (prmtSelect != null && dimensionInfo.getMappingList().size() > 0) {
            prmtSelect.setData(new ArrayList<DimensionRelationshipGroupInfo>(dimensionInfo.getMappingList()));
        } else {
            prmtSelect.setData(null);
        }
        return prmtSelect;
    }

    protected void setF7State(KDBizPromptBox memberF7, KDBizPromptBox mappingF7, KDComboBox bgPeriodTypeBox, KDLabel lblBgPeriodType, int dimensionMemberValueModeEnumValue, BgDimensionInfo dimension) {
        if (memberF7 == null || mappingF7 == null) {
            return;
        }
        if (this.isOrgDimension(dimension)) {
            bgPeriodTypeBox.setVisible(false);
            lblBgPeriodType.setVisible(false);
            return;
        }
        boolean isBgPeriod = DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber());
        bgPeriodTypeBox.setVisible(isBgPeriod);
        lblBgPeriodType.setVisible(isBgPeriod);
        if (dimensionMemberValueModeEnumValue == 1) {
            memberF7.setEnabled(false);
            memberF7.setVisible(true);
            mappingF7.setEnabled(false);
            mappingF7.setVisible(false);
            bgPeriodTypeBox.setEnabled(true);
        } else if (dimensionMemberValueModeEnumValue == 2) {
            memberF7.setEnabled(false);
            memberF7.setVisible(true);
            mappingF7.setEnabled(false);
            mappingF7.setVisible(false);
            bgPeriodTypeBox.setEnabled(false);
        } else if (dimensionMemberValueModeEnumValue == 3) {
            memberF7.setEnabled(true);
            memberF7.setVisible(true);
            memberF7.setRequired(true);
            mappingF7.setEnabled(false);
            mappingF7.setVisible(false);
            bgPeriodTypeBox.setEnabled(false);
        } else if (dimensionMemberValueModeEnumValue == 4) {
            memberF7.setEnabled(false);
            memberF7.setVisible(false);
            mappingF7.setEnabled(true);
            mappingF7.setVisible(true);
            mappingF7.setRequired(true);
            bgPeriodTypeBox.setEnabled(false);
        }
    }

    protected boolean isOrgDimension(BgDimensionInfo bgDimensionInfo) {
        if (bgDimensionInfo == null) {
            return false;
        }
        return MBGLayoutConstants.BG_ORGANIZATION.equals(bgDimensionInfo.getNumber());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        Set<String> numbers = this.getNumbersByF7(this.prmtCurScen);
        if (numbers != null && !numbers.isEmpty()) {
            StringBuffer num = new StringBuffer();
            Iterator<String> it = numbers.iterator();
            while (it.hasNext()) {
                if (num.length() > 0) {
                    num.append(",");
                }
                num.append((Object)it.next());
            }
            this.getSheetManager().setEditScenNumber(num.toString());
        } else {
            this.getSheetManager().setEditScenNumber(null);
        }
        Map<String, BgDimensionInfo> dimensionMap = this.getDimensionMap();
        this.storeDimensionMemberValue(this.viewPanel, dimensionMap);
        this.storeDimensionMemberValue(this.pagePanel, dimensionMap);
        this.storeDimensionMemberValue(this.rowPanel, dimensionMap);
        this.storeDimensionMemberValue(this.colPanel, dimensionMap);
    }

    protected void storeDimensionMemberValue(KDPanel pnl, Map<String, BgDimensionInfo> dimensionMap) {
        if (pnl == null || dimensionMap == null) {
            return;
        }
        KDPanel subPanel = null;
        String dimensionNum = null;
        BgDimensionInfo dimensionInfo = null;
        KDComboBox valueTypeCombo = null;
        int valueType = -1;
        KDBizPromptBox memberF7 = null;
        KDBizPromptBox mappingF7 = null;
        KDComboBox valueDisplayModeCombo = null;
        KDCheckBox isDinamicAddChck = null;
        KDBizPromptBox canAddMemberF7 = null;
        KDCheckBox chkSelectRelation = null;
        KDComboBox cbxBgPeriod = null;
        Object bgPeriodType = null;
        for (int i = 0; i < pnl.getComponentCount(); ++i) {
            if (!(pnl.getComponent(i) instanceof KDPanel) || StringUtils.isEmpty((String)(dimensionNum = (subPanel = (KDPanel)pnl.getComponent(i)).getName())) || dimensionMap.get(dimensionNum) == null) continue;
            valueTypeCombo = this.getMemberValueTypeComboFromPnl(subPanel);
            memberF7 = this.getMemberValueF7FromPnl(subPanel);
            mappingF7 = this.getMemberMappingF7FromPnl(subPanel);
            valueDisplayModeCombo = this.getMemberDisplayMode(subPanel);
            isDinamicAddChck = this.getDinamicAddMemberChckFromPnl(subPanel);
            canAddMemberF7 = this.getDinamicCanMemberF7FromPnl(subPanel);
            chkSelectRelation = this.getIsSelectRelationCheckBoxFromPnl(subPanel);
            cbxBgPeriod = this.getBgPeriodTypeF7FromPnl(subPanel);
            if (valueTypeCombo == null) continue;
            valueType = ((DimensionMemberValueModeEnum)((Object)valueTypeCombo.getSelectedItem())).getValue();
            dimensionInfo = dimensionMap.get(dimensionNum);
            bgPeriodType = null;
            if (valueType == 1) {
                dimensionInfo.setDinamicAdd(this.isCheckBoxSelected(isDinamicAddChck));
                dimensionInfo.getMember().clear();
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimensionNum) && cbxBgPeriod.getSelectedItem() instanceof BgPeriodTypeInfo) {
                    dimensionInfo.setBgPeriodType((BgPeriodTypeInfo)cbxBgPeriod.getSelectedItem());
                }
            } else if (valueType != 2) {
                if (valueType == 3) {
                    dimensionInfo.getMappingList().clear();
                    this.storeF7VauleToDimension(dimensionInfo, memberF7);
                    dimensionInfo.setDinamicAdd(this.isCheckBoxSelected(isDinamicAddChck));
                } else if (valueType == 4) {
                    dimensionInfo.getMappingList().clear();
                    if (mappingF7.getData() != null) {
                        dimensionInfo.getMappingList().addAll((List)mappingF7.getData());
                    }
                    dimensionInfo.setDinamicAdd(false);
                    dimensionInfo.setSelectRelationship(this.isCheckBoxSelected(chkSelectRelation));
                }
            }
            dimensionInfo.getCanAddMember().clear();
            if (dimensionInfo.isDinamicAdd() && canAddMemberF7.getData() instanceof List) {
                dimensionInfo.getCanAddMember().addAll((List)canAddMemberF7.getData());
            }
            dimensionInfo.setMemberValueType(DimensionMemberValueModeEnum.getEnum(valueType));
            int displayMode = ((DimensionDisplayModeEnum)((Object)valueDisplayModeCombo.getSelectedItem())).getValue();
            if (displayMode == 2) {
                dimensionInfo.setShowType("NUMBER");
                continue;
            }
            if (displayMode == 1) {
                dimensionInfo.setShowType("NAME");
                continue;
            }
            if (displayMode == 3) {
                dimensionInfo.setShowType("NAMEANDNUMBER");
                continue;
            }
            if (displayMode == 4) {
                dimensionInfo.setShowType("SIMPLENAME");
                continue;
            }
            if (displayMode != 7) continue;
            dimensionInfo.setShowType("LONGNAME");
        }
    }

    protected boolean isCheckBoxSelected(KDCheckBox checkBox) {
        return checkBox != null && checkBox.isVisible() && checkBox.isSelected();
    }

    public void verifyData() throws Exception {
        Set<String> editScenNumbers;
        super.verifyData();
        HashMap<String, DimensionRelationshipGroupInfo> groups = new HashMap<String, DimensionRelationshipGroupInfo>();
        HashMap<String, Set<String>> refDims = new HashMap<String, Set<String>>();
        this.verfyData(this.viewPanel, true, groups, refDims);
        this.verfyData(this.pagePanel, false, groups, refDims);
        this.verfyData(this.rowPanel, false, groups, refDims);
        this.verfyData(this.colPanel, false, groups, refDims);
        this.verfyRelation(groups, refDims);
        Set<String> numbers = this.getScenByF7(null);
        if (!(numbers == null || numbers.isEmpty() || (editScenNumbers = this.getNumbersByF7(this.prmtCurScen)) == null || editScenNumbers.isEmpty() || numbers.containsAll(editScenNumbers))) {
            throw new BgTemplateException(BgTemplateException.SETCURRSCEN);
        }
    }

    private Set<String> getScenByF7(KDPanel panel) {
        if (panel == null) {
            ArrayList<KDPanel> panels = new ArrayList<KDPanel>();
            panels.add(this.viewPanel);
            panels.add(this.pagePanel);
            panels.add(this.colPanel);
            panels.add(this.rowPanel);
            for (int i = 0; i < panels.size(); ++i) {
                Component comp = this.findComponent((KDPanel)panels.get(i), MBGLayoutConstants.BG_SCENARIO);
                if (!(comp instanceof KDPanel)) continue;
                panel = (KDPanel)comp;
                break;
            }
        }
        if (panel != null) {
            KDComboBox valueTypeCombo = this.getMemberValueTypeComboFromPnl(panel);
            DimensionMemberValueModeEnum valueType = (DimensionMemberValueModeEnum)((Object)valueTypeCombo.getSelectedItem());
            if (DimensionMemberValueModeEnum.SelectMember.equals((Object)valueType)) {
                KDBizPromptBox prmt = this.getMemberValueF7FromPnl(panel);
                return this.getNumbersByF7(prmt);
            }
            return null;
        }
        return null;
    }

    protected Set<String> getNumbersByF7(KDBizPromptBox prmt) {
        LinkedHashSet<String> numbers = new LinkedHashSet<String>();
        if (prmt.getData() instanceof DataBaseInfo) {
            numbers.add(((DataBaseInfo)prmt.getData()).getNumber());
        } else if (prmt.getData() instanceof IObjectCollection) {
            IObjectCollection col = (IObjectCollection)prmt.getData();
            for (int c = 0; c < col.size(); ++c) {
                numbers.add(col.getObject(c).getString("number"));
            }
        } else if (prmt.getData() instanceof Object[]) {
            Object[] objs = (Object[])prmt.getData();
            for (int c = 0; c < objs.length; ++c) {
                if (objs[c] instanceof DataBaseInfo) {
                    numbers.add(((DataBaseInfo)objs[c]).getNumber());
                    continue;
                }
                if (!(objs[c] instanceof BgDimensionMember)) continue;
                numbers.add(((BgDimensionMember)objs[c]).getNumber());
            }
        } else if (prmt.getData() instanceof List) {
            List list = (List)prmt.getData();
            for (int l = 0; l < list.size(); ++l) {
                if (list.get(l) instanceof DataBaseInfo) {
                    BgScenarioInfo info = (BgScenarioInfo)list.get(l);
                    numbers.add(info.getNumber());
                    continue;
                }
                if (!(list.get(l) instanceof BgDimensionMember)) continue;
                numbers.add(((BgDimensionMember)list.get(l)).getNumber());
            }
        } else if (prmt.getData() instanceof BgDimensionMember) {
            numbers.add(((BgDimensionMember)prmt.getData()).getNumber());
        }
        return numbers;
    }

    private void verfyRelation(Map<String, DimensionRelationshipGroupInfo> groups, Map<String, Set<String>> refDims) throws Exception {
        Map<String, BgDimensionInfo> map = this.getDimensionMap();
        HashMap<String, Integer> dimCount = new HashMap<String, Integer>();
        for (String groupId : refDims.keySet()) {
            Set<String> refDim = refDims.get(groupId);
            DimensionRelationshipGroupInfo group = groups.get(groupId);
            boolean hasCross = false;
            if (refDim.size() + 1 < group.getEntries().size()) {
                // empty if block
            }
            for (int e = 0; e < group.getEntries().size(); ++e) {
                String dimNumber = group.getEntries().get(e).getDimNumber();
                if (!map.containsKey(dimNumber)) {
                    throw new TemplateException(TemplateException.DIMENSIONRELATIONFAIL);
                }
                if (!dimCount.containsKey(dimNumber)) {
                    dimCount.put(dimNumber, new Integer(1));
                    continue;
                }
                if ((Integer)dimCount.get(dimNumber) >= 2 || hasCross) {
                    throw new TemplateException(TemplateException.DIMENSIONRELATIONFAIL);
                }
                dimCount.put(dimNumber, new Integer((Integer)dimCount.get(dimNumber) + 1));
                hasCross = true;
            }
        }
        for (Integer count : dimCount.values()) {
            if (count < 2) continue;
            throw new TemplateException(TemplateException.DIMENSIONRELATIONFAIL);
        }
    }

    protected void verfyData(KDPanel pnl, boolean isViewPnl, Map<String, DimensionRelationshipGroupInfo> groups, Map<String, Set<String>> refDims) throws Exception {
        if (pnl == null) {
            return;
        }
        Map<String, BgDimensionInfo> map = this.getDimensionMap();
        KDPanel subPanel = null;
        String dimensionNum = null;
        KDComboBox valueTypeCombo = null;
        int valueType = -1;
        KDBizPromptBox memberF7 = null;
        KDBizPromptBox mappingF7 = null;
        KDComboBox valueDisplayModeCombo = null;
        KDCheckBox isDinamicAddChck = null;
        KDComboBox cbxBgPeriodType = null;
        for (int i = 0; i < pnl.getComponentCount(); ++i) {
            if (!(pnl.getComponent(i) instanceof KDPanel) || StringUtils.isEmpty((String)(dimensionNum = (subPanel = (KDPanel)pnl.getComponent(i)).getName()))) continue;
            valueTypeCombo = this.getMemberValueTypeComboFromPnl(subPanel);
            valueType = ((DimensionMemberValueModeEnum)((Object)valueTypeCombo.getSelectedItem())).getValue();
            memberF7 = this.getMemberValueF7FromPnl(subPanel);
            mappingF7 = this.getMemberMappingF7FromPnl(subPanel);
            cbxBgPeriodType = this.getBgPeriodTypeF7FromPnl(subPanel);
            valueDisplayModeCombo = this.getMemberDisplayMode(subPanel);
            isDinamicAddChck = this.getDinamicAddMemberChckFromPnl(subPanel);
            if (MBGLayoutConstants.BG_INDEX.equals(dimensionNum)) {
                if (valueType == 1 && isDinamicAddChck != null && !isDinamicAddChck.isSelected()) {
                    throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{this.getDimensionNameByNumber(dimensionNum)});
                }
                if (valueType == 3 && (memberF7.getData() == null || memberF7.getData() instanceof List && ((List)memberF7.getData()).isEmpty())) {
                    throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{this.getDimensionNameByNumber(dimensionNum)});
                }
            }
            if (MBGLayoutConstants.BG_ELEMENT.equals(dimensionNum) && valueType == 3 && this.isEmptyOfElementF7Value(memberF7)) {
                throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{this.getDimensionNameByNumber(dimensionNum)});
            }
            if (isViewPnl && !MBGLayoutConstants.BG_ORGANIZATION.equals(dimensionNum) && this.isEmpltyOfF7Value(dimensionNum, memberF7)) {
                throw new TemplateException(TemplateException.VIEWDIMENSIONNEEDMEMBERS);
            }
            if (valueType == 3) {
                if (MBGLayoutConstants.BG_ORGANIZATION.equals(dimensionNum) || !this.isEmpltyOfF7Value(dimensionNum, memberF7)) continue;
                throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{this.getDimensionNameByNumber(dimensionNum)});
            }
            if (valueType == 4) {
                if (mappingF7.getData() == null || ((List)mappingF7.getData()).size() == 0) {
                    throw new TemplateException(TemplateException.DIMENSIONLACKRELATION, new Object[]{this.getDimensionNameByNumber(dimensionNum)});
                }
                List maps = (List)mappingF7.getData();
                for (int m = 0; m < maps.size(); ++m) {
                    DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)maps.get(m);
                    String id = group.getId().toString();
                    groups.put(id, group);
                    if (!refDims.containsKey(id)) {
                        refDims.put(id, new HashSet());
                    }
                    refDims.get(id).add(dimensionNum);
                }
                continue;
            }
            if (valueType != 1 || !DimensionConstants.DEF_PERIOD_NUMBER.equals(dimensionNum) || cbxBgPeriodType.getSelectedItem() instanceof BgPeriodTypeInfo) continue;
            throw new TemplateException(TemplateException.BGPERIODNULL);
        }
    }

    protected boolean isEmpltyOfF7Value(String dimensionNum, KDBizPromptBox memberF7) {
        if (MBGLayoutConstants.BG_PERIOD.equals(dimensionNum)) {
            return this.isEmptyOfPeriodF7Value(memberF7);
        }
        if (MBGLayoutConstants.BG_ELEMENT.equals(dimensionNum)) {
            return this.isEmptyOfElementF7Value(memberF7);
        }
        if (MBGLayoutConstants.BG_CURRENCY.equals(dimensionNum) || MBGLayoutConstants.BG_SCENARIO.equals(dimensionNum) || MBGLayoutConstants.BG_VERSION.equals(dimensionNum)) {
            return this.isEmptyOfQueryF7Value(memberF7);
        }
        if (memberF7.getData() instanceof List) {
            return ((List)memberF7.getData()).size() == 0;
        }
        return !(memberF7.getData() instanceof BgDimensionMember);
    }

    boolean isEmptyOfElementF7Value(KDBizPromptBox f7) {
        if (f7 == null || f7.getData() == null) {
            return true;
        }
        Object result = f7.getData();
        if (result instanceof BgElementCollObject) {
            return ((BgElementCollObject)result).getResult() == null || ((BgElementCollObject)result).getResult().size() == 0;
        }
        if (result instanceof List) {
            return ((List)result).size() == 0;
        }
        if (result instanceof BgElementInfo) {
            return false;
        }
        return false;
    }

    private boolean isEmptyOfPeriodF7Value(KDBizPromptBox f7) {
        if (f7 == null || f7.getData() == null) {
            return true;
        }
        Object result = f7.getData();
        if (result instanceof BgPeriodInfo[]) {
            if (((BgPeriodInfo[])result).length == 0) {
                return true;
            }
        } else if (result instanceof List) {
            if (((List)result).size() == 0) {
                return true;
            }
        } else {
            if (result instanceof BgPeriodInfo) {
                return false;
            }
            if (result instanceof String) {
                return false;
            }
        }
        return false;
    }

    private boolean isEmptyOfQueryF7Value(KDBizPromptBox f7) {
        if (f7 == null || f7.getData() == null) {
            return true;
        }
        Object result = f7.getData();
        if (result instanceof Object[]) {
            if (((Object[])result).length == 0) {
                return true;
            }
        } else {
            if (result instanceof CurrencyInfo) {
                return false;
            }
            if (result instanceof List && ((List)result).size() == 0) {
                return true;
            }
        }
        return false;
    }

    protected BgDimensionInfo getDimensionByNumber(String dimensionNum) {
        if (StringUtils.isEmpty((String)dimensionNum)) {
            return null;
        }
        List dimensions = this.getDimensionManager().getDimension();
        if (dimensions != null) {
            for (int i = 0; i < dimensions.size(); ++i) {
                if (!dimensionNum.equals(((BgDimensionInfo)dimensions.get(i)).getNumber())) continue;
                return (BgDimensionInfo)dimensions.get(i);
            }
        }
        return null;
    }

    protected String getDimensionNameByNumber(String dimensionNum) {
        if (StringUtils.isEmpty((String)dimensionNum)) {
            return "";
        }
        BgDimensionInfo dimension = this.getDimensionByNumber(dimensionNum);
        if (dimension != null) {
            return dimension.getName();
        }
        return "";
    }

    protected Map<String, BgDimensionInfo> getDimensionMap() {
        HashMap<String, BgDimensionInfo> map = new HashMap<String, BgDimensionInfo>();
        List list = this.getDimensionManager().getDimension();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((BgDimensionInfo)list.get(i)).getNumber(), (BgDimensionInfo)list.get(i));
        }
        return map;
    }

    protected KDComboBox getMemberValueTypeComboFromPnl(KDPanel pnl) {
        return (KDComboBox)this.findComponent(pnl, "MemberValueType");
    }

    private Component findComponent(KDPanel pnl, String compName) {
        if (pnl == null || StringUtils.isEmpty((String)compName)) {
            return null;
        }
        for (int i = 0; i < pnl.getComponentCount(); ++i) {
            if (!compName.equals(pnl.getComponent(i).getName())) continue;
            return pnl.getComponent(i);
        }
        return null;
    }

    protected KDBizPromptBox getMemberValueF7FromPnl(KDPanel pnl) {
        return (KDBizPromptBox)this.findComponent(pnl, "MemberValueF7");
    }

    protected KDBizPromptBox getMemberMappingF7FromPnl(KDPanel pnl) {
        return (KDBizPromptBox)this.findComponent(pnl, "MemberRelationF7");
    }

    protected KDComboBox getMemberDisplayMode(KDPanel pnl) {
        return (KDComboBox)this.findComponent(pnl, "MemberValueDisplayMode");
    }

    protected KDCheckBox getDinamicAddMemberChckFromPnl(KDPanel pnl) {
        return (KDCheckBox)this.findComponent(pnl, "DinamicAddMemberChck");
    }

    protected KDBizPromptBox getDinamicCanMemberF7FromPnl(KDPanel pnl) {
        return (KDBizPromptBox)this.findComponent(pnl, "DinamicCanAddMember");
    }

    protected KDCheckBox getIsSelectRelationCheckBoxFromPnl(KDPanel pnl) {
        return (KDCheckBox)this.findComponent(pnl, "isSelectRelation");
    }

    protected KDBizPromptBox getSelectRelationF7FromPnl(KDPanel pnl) {
        return (KDBizPromptBox)this.findComponent(pnl, "SelectRelation");
    }

    protected KDComboBox getBgPeriodTypeF7FromPnl(KDPanel pnl) {
        return (KDComboBox)this.findComponent(pnl, "BgPeriodTypeF7");
    }

    protected KDLabel getBgPeriodTypeLabelFromPnl(KDPanel pnl) {
        return (KDLabel)this.findComponent(pnl, "BgPeriodTypeLabel");
    }

    protected abstract IBgDimensionManager getDimensionManager();

    protected abstract IMbgSheetManager getSheetManager();

    public KDTextField getSheetNameTxt() {
        return this.curSheetTxt;
    }

    protected void storeF7VauleToDimension(BgDimensionInfo dimensionInfo, KDBizPromptBox f7) {
        if (dimensionInfo == null || f7 == null) {
            return;
        }
        List<BgDimensionMember> res = this.convertF7Value(dimensionInfo, f7);
        dimensionInfo.getMember().clear();
        if (res != null && res.size() > 0) {
            dimensionInfo.getMember().addAll(res);
        }
    }

    protected List<BgDimensionMember> convertF7Value(BgDimensionInfo dimensionInfo, KDBizPromptBox f7) {
        if (f7 == null || f7.getData() == null) {
            return null;
        }
        ArrayList<BgDimensionMember> res = new ArrayList<BgDimensionMember>();
        Object result = f7.getData();
        BgDimensionMember member = null;
        if (result instanceof BgDimensionMember) {
            res.add((BgDimensionMember)result);
        } else if (MBGLayoutConstants.BG_PERIOD.equals(dimensionInfo.getNumber())) {
            if (result instanceof BgPeriodInfo[]) {
                BgPeriodInfo[] infos = (BgPeriodInfo[])result;
                Object info = null;
                for (int n = 0; n < infos.length; ++n) {
                    member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), infos[n].getName(), infos[n].getNumber());
                    member.setAlias(infos[n].getDisplayName());
                    res.add(member);
                }
            } else if (result instanceof List) {
                ArrayList list = (ArrayList)result;
                for (int n = 0; n < list.size(); ++n) {
                    if (list.get(n) instanceof BgDimensionMember) {
                        res.add((BgDimensionMember)list.get(n));
                        continue;
                    }
                    member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), list.get(n).toString(), list.get(n).toString());
                    res.add(member);
                }
            } else if (result instanceof BgPeriodInfo) {
                member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), ((BgPeriodInfo)result).getName(), ((BgPeriodInfo)result).getNumber());
                res.add(member);
            } else if (result instanceof String) {
                member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), result.toString(), result.toString());
                res.add(member);
            }
        } else if (MBGLayoutConstants.BG_ELEMENT.equals(dimensionInfo.getNumber())) {
            if (result instanceof BgElementCollObject) {
                BgElementCollObject eleColl = (BgElementCollObject)result;
                if (eleColl.getResult() != null && eleColl.getResult().size() > 0) {
                    for (int i = 0; i < eleColl.getResult().size(); ++i) {
                        member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), eleColl.getResult().get(i).getName(), eleColl.getResult().get(i).getNumber());
                        res.add(member);
                    }
                }
            } else if (result instanceof BgElementInfo) {
                member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), ((BgElementInfo)result).getName(), ((BgElementInfo)result).getNumber());
                res.add(member);
            } else if (result instanceof List) {
                ArrayList list = (ArrayList)result;
                for (int n = 0; n < list.size(); ++n) {
                    if (!(list.get(n) instanceof BgDimensionMember)) continue;
                    res.add((BgDimensionMember)list.get(n));
                }
            }
        } else if (MBGLayoutConstants.BG_CURRENCY.equals(dimensionInfo.getNumber()) || MBGLayoutConstants.BG_SCENARIO.equals(dimensionInfo.getNumber()) || MBGLayoutConstants.BG_VERSION.equals(dimensionInfo.getNumber())) {
            if (result instanceof Object[]) {
                Object[] dataBaseArr = (Object[])result;
                for (int n = 0; n < dataBaseArr.length; ++n) {
                    if (!(dataBaseArr[n] instanceof DataBaseInfo)) continue;
                    member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), ((DataBaseInfo)dataBaseArr[n]).getName(), ((DataBaseInfo)dataBaseArr[n]).getNumber());
                    res.add(member);
                }
            } else if (result instanceof DataBaseInfo) {
                member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), ((DataBaseInfo)result).getName(), ((DataBaseInfo)result).getNumber());
                res.add(member);
            } else if (result instanceof List) {
                ArrayList list = (ArrayList)result;
                for (int n = 0; n < list.size(); ++n) {
                    if (!(list.get(n) instanceof BgDimensionMember)) continue;
                    res.add((BgDimensionMember)list.get(n));
                }
            } else if (result instanceof BgDimensionMember) {
                res.add((BgDimensionMember)result);
            }
        } else if (result instanceof List) {
            res.addAll((List)result);
        }
        return res;
    }

    protected boolean isMultiSelectMemberValue(BgDimensionInfo bgDimensionInfo) {
        return !"view".equals(bgDimensionInfo.getLayout());
    }

    protected boolean isCanDinamicAddMember(BgDimensionInfo bgDimensionInfo) {
        return this.isCanDinamicAddMember(bgDimensionInfo.getNumber(), "view".equals(bgDimensionInfo.getLayout()));
    }

    protected boolean isCanDinamicAddMember(String dimNumber, boolean isView) {
        return !isView && (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber) || !DimensionConstants.necessary.contains(dimNumber));
    }

    protected boolean isEnableDinamicAddMember(BgDimensionInfo bgDimensionInfo) {
        return bgDimensionInfo.getMemberValueType().getValue() != 2 && bgDimensionInfo.getMemberValueType().getValue() != 4;
    }

    protected KDComboBox getBgPeriodTypeCombox(BgDimensionInfo bgDimensionInfo) {
        KDComboBox cbx = new KDComboBox();
        cbx.setName("BgPeriodTypeF7");
        cbx.setPreferredSize(new Dimension(120, 20));
        cbx.addItem((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"bgPeriodType"));
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            if (this.getSchemeHelper() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true), CompareType.INCLUDE));
            }
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            BgPeriodTypeCollection coll = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(evi);
            if (coll != null) {
                for (int i = 0; i < coll.size(); ++i) {
                    cbx.addItem((Object)coll.get(i));
                }
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        cbx.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"bgPeriodType"));
        if (bgDimensionInfo != null && bgDimensionInfo.getBgPeriodType() != null) {
            BgNFCHelper.setSelectObject(cbx, bgDimensionInfo.getBgPeriodType());
        } else {
            cbx.setSelectedIndex(0);
        }
        return cbx;
    }

    private KDLabel getBgPeriodTypeLable(BgDimensionInfo bgDimensionInfo) {
        KDLabel lbl = new KDLabel();
        lbl.setName("BgPeriodTypeLabel");
        lbl.setPreferredSize(new KDCheckBox().getPreferredSize());
        return lbl;
    }

    protected KDCheckBox getDinamicAddMemberCheckBox(BgDimensionInfo bgDimensionInfo) {
        KDCheckBox chb = new KDCheckBox();
        chb.setName("DinamicAddMemberChck");
        chb.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"DinamicAddMember"));
        if (bgDimensionInfo != null) {
            chb.setEnabled(this.isEnableDinamicAddMember(bgDimensionInfo));
            this.setSelectedOrNot(bgDimensionInfo);
            chb.setSelected(bgDimensionInfo.isDinamicAdd());
        }
        chb.addItemListener((ItemListener)new CanAddMemberItemListener());
        return chb;
    }

    protected KDCheckBox getIsSelectRelationCheckBox(BgDimensionInfo bgDimensionInfo) {
        KDCheckBox chb = new KDCheckBox();
        chb.setName("isSelectRelation");
        chb.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"choiceWhenEdit"));
        if (bgDimensionInfo != null) {
            chb.setSelected(bgDimensionInfo.isSelectRelationship());
        }
        chb.addItemListener((ItemListener)new SelectRelationListener());
        return chb;
    }

    protected KDBizPromptBox getSelectRelationProp(BgDimensionInfo bgDimensionInfo) {
        DimensionRelationshipSelectDialog dialog = this.createRelationshipDialog(bgDimensionInfo);
        dialog.setGroupIds(bgDimensionInfo.getMappingList());
        dialog.setViewManager(this.getSheetManager().getViewManager());
        DimensionRelationShowDefaultPrmt prmt = null;
        prmt = new DimensionRelationShowDefaultPrmt();
        prmt.setEditable(false);
        prmt.setSelector(dialog);
        prmt.addDataChangeListener(dialog);
        prmt.setDefaultText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation"));
        prmt.setPreferredSize(new Dimension(120, 20));
        prmt.setName("SelectRelation");
        prmt.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation"));
        this.setSelectRelation(prmt, bgDimensionInfo.getMappingList());
        return prmt;
    }

    protected void setSelectRelation(KDBizPromptBox prmtSelectRelation, List<DimensionRelationshipGroupInfo> groups) {
        MbgRelationMap map;
        int i;
        ArrayList<Object> datas = new ArrayList<Object>();
        HashMap<String, MbgRelationMap> maps = new HashMap<String, MbgRelationMap>();
        if (this.getSheetManager().getViewManager().getRelationMaps() == null) {
            this.getSheetManager().getViewManager().setRelationMaps(new ArrayList<MbgRelationMap>());
        }
        for (i = 0; i < this.getSheetManager().getViewManager().getRelationMaps().size(); ++i) {
            map = this.getSheetManager().getViewManager().getRelationMaps().get(i);
            if (map.getGroup() == null) continue;
            maps.put(map.getGroup().getId().toString(), map);
        }
        if (groups != null && !groups.isEmpty()) {
            for (i = 0; i < groups.size(); ++i) {
                DimensionRelationshipGroupInfo group = groups.get(i);
                if (maps.containsKey(group.getId().toString())) {
                    datas.add(maps.get(group.getId().toString()));
                    continue;
                }
                map = new MbgRelationMap(this.getSheetManager().getViewManager());
                map.setGroup(group);
                map.setRelationShips(new DimensionRelationshipCollection());
                this.getSheetManager().getViewManager().getRelationMaps().add(map);
                datas.add(map);
            }
        }
        prmtSelectRelation.setData(datas);
    }

    protected void setSelectedOrNot(BgDimensionInfo bgDimensionInfo) {
        if (bgDimensionInfo.getMemberValueType().getValue() == 1 && this.isCanDinamicAddMember(bgDimensionInfo)) {
            bgDimensionInfo.setDinamicAdd(true);
        }
    }

    protected KDBizPromptBox getDinamicCanAddMemberF7(KDCheckBox chkAddMember, BgDimensionInfo dimensionInfo, String orgId) {
        NewDimensionMemberDialog f7 = this.getInstanceDimensionMemberDialog(dimensionInfo);
        ShowDefaultTextPromptBox prmt = null;
        try {
            prmt = new ShowDefaultTextPromptBox();
            prmt.setEditable(false);
            f7.setVersionNum(BigDecimal.ZERO);
            f7.setCanFillType(false);
            prmt.setSelector(f7);
            prmt.addDataChangeListener(f7);
            prmt.setDefaultText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectMemberRange"));
            if (dimensionInfo != null) {
                prmt.setEnabled(dimensionInfo.isDinamicAdd());
                if (!dimensionInfo.getCanAddMember().isEmpty()) {
                    prmt.setData(new ArrayList(dimensionInfo.getCanAddMember()));
                } else {
                    prmt.setData(null);
                }
            } else {
                prmt.setEnabled(false);
                prmt.setData(null);
            }
            prmt.setName("DinamicCanAddMember");
            prmt.setPreferredSize(new Dimension(120, 20));
            chkAddMember.setUserObject((Object)prmt);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return prmt;
    }

    protected NewDimensionMemberDialog getInstanceDimensionMemberDialog(BgDimensionInfo dimensionInfo) {
        return new NewDimensionMemberDialog((CoreUI)this, dimensionInfo, this.orgId, true);
    }

    protected DimensionRelationshipSelectDialog createRelationshipDialog(BgDimensionInfo bgDimensionInfo) {
        DimensionRelationshipSelectDialog dialog = new DimensionRelationshipSelectDialog(this);
        dialog.setOrgId(this.orgId);
        return dialog;
    }

    protected KDComboBox getDimensiionMemberValueTypeCombo(BgDimensionInfo bgDimensionInfo) {
        KDComboBox combo = new KDComboBox();
        combo.setPreferredSize(new Dimension(100, 20));
        combo.setName("MemberValueType");
        this.getDimensiionMemberValueTypeCombo(combo, bgDimensionInfo);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setDefaultMemberValueType(combo, bgDimensionInfo);
        }
        combo.addItemListener((ItemListener)new DimensionMemberValueTypeItemListener());
        return combo;
    }

    protected void changeChkStateForSameRelationship(KDPanel rowPnl, DimensionRelationshipGroupInfo curGroupInfo, boolean curRelationCheckBoxSelected) {
        if (rowPnl == null || curGroupInfo == null) {
            return;
        }
        String groupNumber = curGroupInfo.getNumber();
        KDPanel subPanel = null;
        String dimensionNum = null;
        int valueType = -1;
        KDComboBox valueTypeCombo = null;
        KDCheckBox chkSelectRelation = null;
        KDBizPromptBox mappingF7 = null;
        DimensionRelationshipGroupInfo groupInfo = null;
        int j = rowPnl.getComponentCount();
        for (int i = 0; i < j; ++i) {
            if (!(rowPnl.getComponent(i) instanceof KDPanel) || StringUtils.isEmpty((String)(dimensionNum = (subPanel = (KDPanel)rowPnl.getComponent(i)).getName())) || (valueType = ((DimensionMemberValueModeEnum)((Object)(valueTypeCombo = this.getMemberValueTypeComboFromPnl(subPanel)).getSelectedItem())).getValue()) != 4) continue;
            mappingF7 = this.getMemberMappingF7FromPnl(subPanel);
            groupInfo = mappingF7 == null ? null : (DimensionRelationshipGroupInfo)((List)mappingF7.getData()).get(0);
            chkSelectRelation = this.getIsSelectRelationCheckBoxFromPnl(subPanel);
            if (groupInfo == null || !groupInfo.getNumber().equals(groupNumber) || chkSelectRelation == null) continue;
            chkSelectRelation.setSelected(curRelationCheckBoxSelected);
        }
    }

    private void setDefaultMemberValueType(KDComboBox combo, BgDimensionInfo bgDimensionInfo) {
        if (combo == null || bgDimensionInfo == null) {
            return;
        }
        if ("view".equals(bgDimensionInfo.getLayout())) {
            combo.setSelectedItem((Object)DimensionMemberValueModeEnum.SelectMember);
        }
        if (MBGLayoutConstants.BG_INDEX.equals(bgDimensionInfo.getNumber())) {
            combo.setSelectedItem((Object)DimensionMemberValueModeEnum.SelectMember);
        }
        if (MBGLayoutConstants.BG_ELEMENT.equals(bgDimensionInfo.getNumber())) {
            combo.setSelectedItem((Object)DimensionMemberValueModeEnum.SelectMember);
        }
    }

    protected void getDimensiionMemberValueTypeCombo(KDComboBox combo, BgDimensionInfo bgDimensionInfo) {
        if (combo == null || bgDimensionInfo == null) {
            return;
        }
        combo.removeAllItems();
        if ("view".equals(bgDimensionInfo.getLayout())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
        } else if (MBGLayoutConstants.BG_PERIOD.equals(bgDimensionInfo.getNumber())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.Null);
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
        } else if (MBGLayoutConstants.BG_CURRENCY.equals(bgDimensionInfo.getNumber())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.Null);
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
            combo.addItem((Object)DimensionMemberValueModeEnum.RelationMapping);
        } else if (MBGLayoutConstants.BG_SCENARIO.equals(bgDimensionInfo.getNumber())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
            combo.addItem((Object)DimensionMemberValueModeEnum.RelationMapping);
        } else if (MBGLayoutConstants.BG_VERSION.equals(bgDimensionInfo.getNumber())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.Null);
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
            combo.addItem((Object)DimensionMemberValueModeEnum.RelationMapping);
        } else if (MBGLayoutConstants.BG_ELEMENT.equals(bgDimensionInfo.getNumber())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.All);
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
            combo.addItem((Object)DimensionMemberValueModeEnum.RelationMapping);
        } else if (MBGLayoutConstants.BG_INDEX.equals(bgDimensionInfo.getNumber())) {
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
            combo.addItem((Object)DimensionMemberValueModeEnum.RelationMapping);
        } else {
            combo.addItem((Object)DimensionMemberValueModeEnum.Null);
            combo.addItem((Object)DimensionMemberValueModeEnum.All);
            combo.addItem((Object)DimensionMemberValueModeEnum.SelectMember);
            combo.addItem((Object)DimensionMemberValueModeEnum.RelationMapping);
        }
        if (bgDimensionInfo != null) {
            DimensionMemberValueModeEnum memberValueType = bgDimensionInfo.getMemberValueType();
            boolean flag = false;
            for (int i = 0; i < combo.getItemCount(); ++i) {
                if (!memberValueType.equals(combo.getItemAt(i))) continue;
                combo.setSelectedItem((Object)memberValueType);
                flag = true;
                break;
            }
            if (!flag) {
                combo.setSelectedItem(combo.getItemAt(0));
                bgDimensionInfo.setMemberValueType((DimensionMemberValueModeEnum)((Object)combo.getItemAt(0)));
            }
        }
    }

    private KDComboBox getDimensionDisplayModeCombo(BgDimensionInfo bgDimensionInfo) {
        KDComboBox combo = new KDComboBox();
        combo.addItem((Object)DimensionDisplayModeEnum.Name);
        combo.addItem((Object)DimensionDisplayModeEnum.Number);
        combo.addItem((Object)DimensionDisplayModeEnum.NumberAndName);
        combo.setPreferredSize(new Dimension(100, 20));
        combo.setName("MemberValueDisplayMode");
        if (bgDimensionInfo != null) {
            combo.setSelectedItem((Object)bgDimensionInfo.getShowTypeEnum());
        }
        return combo;
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() {
        try {
            return DimensionMemberSelectHelper.getSchemeHelper((IUIObject)this.getUIContext().get("Owner"));
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return null;
    }

    private class DimensionRelationShowDefaultPrmt
    extends ShowDefaultTextPromptBox {
        private static final long serialVersionUID = -6773207018168259485L;

        private DimensionRelationShowDefaultPrmt() {
        }

        @Override
        protected String valueToString(Object o) {
            List datas = (List)this.getData();
            StringBuffer result = new StringBuffer();
            if (datas != null && !datas.isEmpty()) {
                MbgRelationMap map = null;
                for (int i = 0; i < datas.size(); ++i) {
                    map = (MbgRelationMap)datas.get(i);
                    if (map.getRelationShips() == null || map.getRelationShips().isEmpty()) continue;
                    result.append("[");
                    for (int r = 0; r < map.getRelationShips().size(); ++r) {
                        if (r != 0) {
                            result.append(",");
                        }
                        result.append(map.getRelationShips().get(r).getDimensionName());
                    }
                    result.append("]");
                }
            }
            if (result.length() == 0) {
                return this.getDefaultText();
            }
            return result.toString();
        }

        @Override
        protected boolean isShowDefaultText() {
            return false;
        }

        protected void setData(Object newdata, boolean postEvent, boolean notify) {
            if (newdata == null && this.data != null) {
                newdata = this.data;
                if (this.data instanceof List) {
                    List rl = (List)this.data;
                    for (MbgRelationMap rmp : rl) {
                        rmp.getRelationShips().clear();
                    }
                }
            }
            super.setData(newdata, postEvent, notify);
            for (KDPanel pnl : DimensionMemberSetUI.this.dimensionPanels.values()) {
                KDBizPromptBox prmt = DimensionMemberSetUI.this.getSelectRelationF7FromPnl(pnl);
                if (prmt == null) continue;
                prmt.updateData();
            }
        }
    }

    class DimensionMemberValueTypeItemListener
    implements ItemListener {
        DimensionMemberValueTypeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (!(e.getSource() instanceof Component)) {
                    return;
                }
                Component cpt = (Component)e.getSource();
                if (!"MemberValueType".equals(cpt.getName())) {
                    return;
                }
                KDComboBox valueTypeCombo = (KDComboBox)e.getSource();
                if (valueTypeCombo.getSelectedItem() == null) {
                    return;
                }
                if (!(cpt.getParent() instanceof KDPanel)) {
                    return;
                }
                KDPanel pnl = (KDPanel)cpt.getParent();
                BgDimensionInfo dimensionInfo = DimensionMemberSetUI.this.getDimensionByNumber(pnl.getName());
                if (dimensionInfo == null) {
                    return;
                }
                if (MBGLayoutConstants.BG_ORGANIZATION.equals(pnl.getName())) {
                    return;
                }
                KDBizPromptBox memberF7 = DimensionMemberSetUI.this.getMemberValueF7FromPnl(pnl);
                KDBizPromptBox mappingF7 = DimensionMemberSetUI.this.getMemberMappingF7FromPnl(pnl);
                KDComboBox bgPeriodCbx = DimensionMemberSetUI.this.getBgPeriodTypeF7FromPnl(pnl);
                KDCheckBox dinamicChck = DimensionMemberSetUI.this.getDinamicAddMemberChckFromPnl(pnl);
                if (memberF7 == null) {
                    return;
                }
                int selectedValue = ((DimensionMemberValueModeEnum)((Object)valueTypeCombo.getSelectedItem())).getValue();
                DimensionMemberSetUI.this.setF7State(memberF7, mappingF7, bgPeriodCbx, DimensionMemberSetUI.this.getBgPeriodTypeLabelFromPnl(pnl), selectedValue, dimensionInfo);
                DimensionMemberSetUI.this.setRelationMappingState(false, pnl);
                KDCheckBox chkSelectRelation = (KDCheckBox)DimensionMemberSetUI.this.findComponent(pnl, "isSelectRelation");
                if (selectedValue == 1) {
                    if (dinamicChck != null && dinamicChck.isVisible()) {
                        dinamicChck.setSelected(true);
                        dinamicChck.setEnabled(true);
                    }
                } else if (selectedValue == 2) {
                    if (dinamicChck != null && dinamicChck.isVisible()) {
                        dinamicChck.setSelected(false);
                        dinamicChck.setEnabled(false);
                    }
                } else if (selectedValue == 3) {
                    if (dinamicChck != null && dinamicChck.isVisible()) {
                        dinamicChck.setSelected(true);
                        dinamicChck.setEnabled(true);
                    }
                } else if (selectedValue == 4) {
                    DimensionMemberSetUI.this.setRelationMappingState(true, pnl);
                    chkSelectRelation.setSelected(false);
                }
                DimensionMemberSetUI.this.setCurScenFilter(pnl);
            }
        }
    }

    class SelectRelationListener
    implements ItemListener {
        SelectRelationListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getID() == 701) {
                if (!(e.getSource() instanceof KDCheckBox)) {
                    return;
                }
                KDCheckBox chk = (KDCheckBox)e.getSource();
                boolean curRelationCheckBoxSelected = chk.isSelected();
                KDPanel curPnl = (KDPanel)chk.getParent();
                if (!(curPnl instanceof KDPanel)) {
                    return;
                }
                KDBizPromptBox CurMappingF7 = DimensionMemberSetUI.this.getMemberMappingF7FromPnl(curPnl);
                DimensionRelationshipGroupInfo curGroupInfo = CurMappingF7 == null || CurMappingF7.getData() == null ? null : (DimensionRelationshipGroupInfo)((List)CurMappingF7.getData()).get(0);
                KDPanel rowPnl = (KDPanel)curPnl.getParent();
                DimensionMemberSetUI.this.changeChkStateForSameRelationship(rowPnl, curGroupInfo, curRelationCheckBoxSelected);
            }
        }
    }

    class CanAddMemberItemListener
    implements ItemListener {
        CanAddMemberItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getID() == 701) {
                if (!(e.getSource() instanceof KDCheckBox)) {
                    return;
                }
                KDCheckBox chk = (KDCheckBox)e.getSource();
                ((KDBizPromptBox)chk.getUserObject()).setEnabled(chk.isSelected());
            }
        }
    }

    class DimRelaF7ChangeChangeListener
    implements DataChangeListener {
        DimRelaF7ChangeChangeListener() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            if (!(eventObj.getSource() instanceof KDBizPromptBox)) {
                return;
            }
            KDBizPromptBox chk = (KDBizPromptBox)eventObj.getSource();
            KDPanel curPnl = (KDPanel)chk.getParent();
            if (!(curPnl instanceof KDPanel)) {
                return;
            }
            KDCheckBox chkSelectRelation = DimensionMemberSetUI.this.getIsSelectRelationCheckBoxFromPnl(curPnl);
            KDBizPromptBox CurMappingF7 = DimensionMemberSetUI.this.getMemberMappingF7FromPnl(curPnl);
            KDBizPromptBox prmtSelectRelation = DimensionMemberSetUI.this.getSelectRelationF7FromPnl(curPnl);
            DimensionRelationshipSelectDialog selectRelationF7 = (DimensionRelationshipSelectDialog)prmtSelectRelation.getSelector();
            DimensionRelationshipGroupInfo curGroupInfo = CurMappingF7 == null ? null : (DimensionRelationshipGroupInfo)((List)CurMappingF7.getData()).get(0);
            KDPanel rowPnl = (KDPanel)curPnl.getParent();
            DimensionMemberSetUI.this.setSelectRelation(prmtSelectRelation, (List)CurMappingF7.getData());
            selectRelationF7.setGroupIds((List)CurMappingF7.getData());
            chkSelectRelation.setSelected(this.getChkStateForSameRelationship(rowPnl, curGroupInfo));
        }

        private boolean getChkStateForSameRelationship(KDPanel rowPnl, DimensionRelationshipGroupInfo curGroupInfo) {
            if (rowPnl == null || curGroupInfo == null) {
                return false;
            }
            boolean curRelationCheckBoxSelected = false;
            String groupNumber = curGroupInfo.getNumber();
            KDPanel subPanel = null;
            String dimensionNum = null;
            int valueType = -1;
            KDComboBox valueTypeCombo = null;
            KDCheckBox chkSelectRelation = null;
            KDBizPromptBox mappingF7 = null;
            DimensionRelationshipGroupInfo groupInfo = null;
            int j = rowPnl.getComponentCount();
            for (int i = 0; i < j; ++i) {
                if (!(rowPnl.getComponent(i) instanceof KDPanel) || StringUtils.isEmpty((String)(dimensionNum = (subPanel = (KDPanel)rowPnl.getComponent(i)).getName())) || (valueType = ((DimensionMemberValueModeEnum)((Object)(valueTypeCombo = DimensionMemberSetUI.this.getMemberValueTypeComboFromPnl(subPanel)).getSelectedItem())).getValue()) != 4) continue;
                mappingF7 = DimensionMemberSetUI.this.getMemberMappingF7FromPnl(subPanel);
                groupInfo = mappingF7 == null ? null : (DimensionRelationshipGroupInfo)((List)mappingF7.getData()).get(0);
                chkSelectRelation = DimensionMemberSetUI.this.getIsSelectRelationCheckBoxFromPnl(subPanel);
                if (groupInfo == null || !groupInfo.getNumber().equals(groupNumber) || chkSelectRelation == null) continue;
                curRelationCheckBoxSelected = chkSelectRelation.isSelected();
                break;
            }
            return curRelationCheckBoxSelected;
        }
    }
}

