/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionRelationF7UI;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DimensionRelationF7UI
extends AbstractDimensionRelationF7UI {
    private static final long serialVersionUID = 1639173259463654017L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionRelationF7UI.class);
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_SOURCE = "dimension";
    private BgDimensionInfo curDimensionInfo;
    private String bgSchemeId = null;
    private BOSUuid orgTreeId = null;
    private boolean isMultiSelect = false;
    private boolean isCancel = true;
    private List<DimensionRelationshipGroupInfo> result = new ArrayList<DimensionRelationshipGroupInfo>();
    protected BgSchemeDimensionHelper schemeHelper = null;

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.bgSchemeId);
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgTreeId = (BOSUuid)this.getUIContext().get(DimensionConstants.DEF_CSL_NUMBER);
        this.curDimensionInfo = (BgDimensionInfo)this.getUIContext().get("dimensionInfo");
        this.bgSchemeId = (String)this.getUIContext().get("BGSCHEME_ID");
        List<BgDimensionInfo> alldims = this.getSchemeHelper().getAllDimensions();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < alldims.size(); ++i) {
            map.put(alldims.get(i).getNumber(), alldims.get(i).getName());
        }
        List res = TemplateFacadeFactory.getRemoteInstance().getDimensionRelationGroup(this.curDimensionInfo, this.bgSchemeId, this.orgTreeId);
        if (res != null && res.size() > 0) {
            this.tblMainTable.checkParsed();
            StringBuffer name = new StringBuffer();
            for (int i = 0; i < res.size(); ++i) {
                DimensionRelationshipGroupInfo info = (DimensionRelationshipGroupInfo)res.get(i);
                if (!this.isShow(info)) continue;
                IRow row = this.tblMainTable.addRow();
                name.setLength(0);
                for (int e = 0; e < info.getEntries().size(); ++e) {
                    if (e > 0) {
                        name.append(",");
                    }
                    if (map.containsKey(info.getEntries().get(e).getDimNumber())) {
                        name.append((String)map.get(info.getEntries().get(e).getDimNumber()));
                        continue;
                    }
                    name.append(info.getEntries().get(e).getDimName());
                }
                row.setUserObject((Object)info);
                row.getCell(COL_NUMBER, true).setValue((Object)info.getNumber());
                row.getCell(COL_NAME, true).setValue((Object)info.getName());
                row.getCell(COL_SOURCE, true).setValue((Object)name.toString());
            }
        }
        if (this.isMultiSelect) {
            this.tblMainTable.getSelectManager().setSelectMode(10);
        } else {
            this.tblMainTable.getSelectManager().setSelectMode(2);
        }
        this.tblMainTable.setEditable(false);
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    protected boolean isShow(DimensionRelationshipGroupInfo info) {
        return true;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public List<DimensionRelationshipGroupInfo> getResult() {
        return this.result;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        KDTRange range = this.tblMainTable.getSelectManager().toRange();
        if (range != null) {
            KDTSelectBlock select = null;
            if (range.size() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"not_have_selected"));
                return;
            }
            this.setCancel(false);
            this.result.clear();
            if (range.size() > 0 && range.get(0) instanceof KDTSelectBlock) {
                select = (KDTSelectBlock)range.get(0);
                for (int i = select.getBeginRow(); i <= select.getEndRow(); ++i) {
                    if (!(this.tblMainTable.getRow(i).getUserObject() instanceof DimensionRelationshipGroupInfo)) continue;
                    this.result.add((DimensionRelationshipGroupInfo)this.tblMainTable.getRow(i).getUserObject());
                }
            }
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    protected void tblMainTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.tblMainTable.getRowCount() > 0) {
            this.actionOk_actionPerformed(null);
        }
    }
}

