/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateNodeCollection;
import com.kingdee.eas.ma.mbg.BgTemplateNodeFactory;
import com.kingdee.eas.ma.mbg.DimRelationShipUpdateSearchKey;
import com.kingdee.eas.ma.mbg.DimensionRelationGroupShowEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionRelationShipUpdateUI;
import com.kingdee.eas.ma.mbg.client.BgRelationUpdateResultUI;
import com.kingdee.eas.ma.mbg.client.DimRelationUpdateProgressUI;
import com.kingdee.eas.ma.mbg.client.ProgressDialogUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class DimensionRelationShipUpdateUI
extends AbstractDimensionRelationShipUpdateUI {
    private static final long serialVersionUID = -402594494511179236L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionRelationShipUpdateUI.class);
    private String schemeId = null;
    private String orgId = null;
    private List<String> relationships = null;
    private CostCenterOrgUnitInfo ccouinfo = null;
    private BgSchemeDimensionHelper schemeHelper = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
        this.orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.schemeId = (String)this.getUIContext().get("BGSCHEME_ID");
        this.relationships = (List)this.getUIContext().get("BGFORM_IDS");
        DimensionRelationshipGroupInfo groupInfo = (DimensionRelationshipGroupInfo)this.getUIContext().get("GROUPORG_ID");
        this.ccouinfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.orgId));
        this.initDimensionShipGroupF7(groupInfo);
        this.kDDimensionShipGroupF7.setData((Object)groupInfo);
        this.initFormVersionF7();
        this.initTable(groupInfo);
        this.initTableForTemplate(null, groupInfo);
    }

    public void initTableForTemplate(String filterStr, DimensionRelationshipGroupInfo groupInfo) throws Exception {
        this.kDTableTemplateList.checkParsed();
        this.kDTableTemplateList.getColumn("select").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.bgScheme.id", (Object)this.schemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.templateStatus", (Object)0, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.ccouinfo.getId().toString(), CompareType.EQUALS));
        evi.setSelector(this.getSelectors(true));
        SorterItemInfo sortInfo = new SorterItemInfo("bgTemplate.number");
        sortInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sortInfo);
        BgTemplateNodeCollection coll = BgTemplateNodeFactory.getRemoteInstance().getBgTemplateNodeCollection(evi);
        this.kDTableTemplateList.removeRows();
        IRow row = null;
        String dimensionName = null;
        String dimensionNumber = null;
        DimRelationShipUpdateSearchKey keyEnum = (DimRelationShipUpdateSearchKey)((Object)this.kDSearchBox.getSelectedItem());
        for (int i = 0; i < coll.size(); ++i) {
            BgTemplateInfo info = coll.get(i).getBgTemplate();
            if (info.getFormType().getValue() == 0 || info.getFormType().getValue() == 8) continue;
            row = this.kDTableTemplateList.getRow(i);
            dimensionNumber = info.getNumber();
            dimensionName = info.getName();
            if (!StringUtils.isEmpty((String)filterStr) && keyEnum.getValue() == 1) {
                boolean numberContain = false;
                boolean nameContain = false;
                if (dimensionName.indexOf(filterStr) >= 0) {
                    numberContain = true;
                }
                if (!StringUtils.isEmpty((String)dimensionNumber) && dimensionNumber.indexOf(filterStr) >= 0) {
                    numberContain = true;
                }
                if (!numberContain && !nameContain) continue;
            }
            row = this.kDTableTemplateList.addRow();
            row.setUserObject((Object)info);
            row.getCell("select").setValue((Object)false);
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("type").setValue((Object)info.getFormType().getAlias());
            row.getCell("org").setValue((Object)info.getOrgUnit().getName());
        }
    }

    public SelectorItemCollection getSelectors(boolean flag) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        if (flag) {
            sic.add(new SelectorItemInfo("bgTemplate.id"));
            sic.add(new SelectorItemInfo("bgTemplate.number"));
            sic.add(new SelectorItemInfo("bgTemplate.name"));
            sic.add(new SelectorItemInfo("bgTemplate.orgUnit.id"));
            sic.add(new SelectorItemInfo("bgTemplate.orgUnit.name"));
            sic.add(new SelectorItemInfo("bgTemplate.orgUnit.longNumber"));
            sic.add(new SelectorItemInfo("bgTemplate.bgScheme.id"));
            sic.add(new SelectorItemInfo("bgTemplate.formType"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
        } else {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("dimensionNumber"));
            sic.add(new SelectorItemInfo("dimensionName"));
            sic.add(new SelectorItemInfo("costUnit.id"));
            sic.add(new SelectorItemInfo("costUnit.name"));
        }
        return sic;
    }

    public void initTable(DimensionRelationshipGroupInfo groupInfo) throws Exception {
        DimensionRelationClientHelper.loadTempTable(this, this.kDTableDimensionShip, groupInfo, this.ccouinfo, null, this.getSchemeHelper(), false);
        this.batchAddRow(groupInfo, null);
    }

    public void batchAddRow(DimensionRelationshipGroupInfo groupInfo, String filterStr) throws Exception {
        this.kDTableDimensionShip.getColumn("select").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        HashSet<String> orgIds = new HashSet<String>();
        if (groupInfo.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.childQuarantine)) {
            String[] parentNumbers = this.ccouinfo.getLongNumber().split("!");
            EntityViewInfo filter = new EntityViewInfo();
            filter.setFilter(new FilterInfo());
            filter.getFilter().getFilterItems().add(new FilterItemInfo("number", DimensionMemberRelationShipHelper.getLowerShowNumber(null, this.getSchemeHelper().getBgSchemeId(), this.ccouinfo.getId().toString()), CompareType.INCLUDE));
            CostCenterOrgUnitCollection collection = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(filter);
            for (int i = 0; i < collection.size(); ++i) {
                CostCenterOrgUnitInfo info = collection.get(i);
                orgIds.add(info.getId().toString());
            }
        } else if (groupInfo.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.equalQuarantine)) {
            orgIds.addAll(BgOrgUnitFactory.getRemoteInstance().getParentAndChildrenOrgUnitIds(this.ccouinfo.getId().toString(), this.getSchemeHelper().getBgOrgViewId()));
        } else if (groupInfo.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.allQuarantine)) {
            BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("Select orgUnitID  Where viewID = '" + this.getSchemeHelper().getBgOrgViewId() + "'");
            for (int i = 0; i < colls.size(); ++i) {
                orgIds.add(colls.get(i).getOrgUnitID().toString());
            }
        } else {
            orgIds.add(this.ccouinfo.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("dimensionGroup.id", (Object)groupInfo.getId().toString(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("costUnit.id", orgIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1, CompareType.EQUALS));
        evi.setSelector(this.getSelectors(false));
        SorterItemInfo sortInfo = new SorterItemInfo("dimensionNumber");
        sortInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sortInfo);
        DimensionRelationshipCollection DimensionRelationships = DimensionRelationshipFactory.getRemoteInstance().getDimensionRelationshipCollection(evi);
        ArrayList<DimensionRelationshipInfo> infoList = new ArrayList<DimensionRelationshipInfo>();
        for (int j = 0; j < DimensionRelationships.size(); ++j) {
            DimensionRelationshipInfo info = DimensionRelationships.get(j);
            if (this.relationships != null && this.relationships.contains(info.getId().toString())) {
                info.put("isSelect", 1);
            } else {
                info.put("isSelect", 0);
            }
            infoList.add(info);
        }
        Collections.sort(infoList, new Comparator<DimensionRelationshipInfo>(){

            @Override
            public int compare(DimensionRelationshipInfo o1, DimensionRelationshipInfo o2) {
                return Integer.parseInt(o2.get("isSelect").toString()) - Integer.parseInt(o1.get("isSelect").toString());
            }
        });
        this.kDTableDimensionShip.removeRows();
        IRow row = null;
        int rowSize = 0;
        String dimensionName = null;
        String dimensionNumber = null;
        DimRelationShipUpdateSearchKey keyEnum = (DimRelationShipUpdateSearchKey)((Object)this.kDSearchBox.getSelectedItem());
        for (int i = 0; i < infoList.size(); ++i) {
            DimensionRelationshipInfo info = (DimensionRelationshipInfo)infoList.get(i);
            row = this.kDTableDimensionShip.getRow(i);
            dimensionName = info.getDimensionName();
            dimensionNumber = info.getDimensionNumber();
            if (!StringUtils.isEmpty((String)filterStr) && keyEnum.getValue() == 2) {
                boolean numberContain = false;
                boolean nameContain = false;
                if (dimensionName.indexOf(filterStr) >= 0) {
                    numberContain = true;
                }
                if (!StringUtils.isEmpty((String)dimensionNumber) && dimensionNumber.contains(BgBaseConstants.SEP_THR_STR)) {
                    String[] numArr = dimensionNumber.split(BgBaseConstants.SEP_THR_STR);
                    for (int m = 0; m < numArr.length; ++m) {
                        String memberNum = numArr[m];
                        if (!memberNum.contains(BgBaseConstants.SEP_FOUR_STR) || memberNum.length() <= 4 || memberNum.substring(4, memberNum.length()).indexOf(filterStr) < 0) continue;
                        numberContain = true;
                    }
                }
                if (!numberContain && !nameContain) continue;
            }
            row = this.kDTableDimensionShip.addRow();
            row.setUserObject((Object)info);
            if (this.relationships != null && this.relationships.contains(info.getId().toString())) {
                row.getCell("select").setValue((Object)true);
            } else {
                row.getCell("select").setValue((Object)false);
            }
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell(DimensionConstants.DIMENSION_NUMBER).setValue((Object)info.getDimensionNumber());
            row.getCell(DimensionConstants.DIMENSION_NAME).setValue((Object)info.getDimensionName());
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT).setValue((Object)info.getCostUnit().getName());
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT_ID).setValue((Object)info.getCostUnit().getId().toString());
            ++rowSize;
        }
        KDTDataRequestEvent e1 = new KDTDataRequestEvent(this.kDTableDimensionShip);
        e1.setFirstRow(0);
        e1.setLastRow(rowSize - 1);
        DimensionRelationClientHelper.initRowValue(this, e1, this.kDTableDimensionShip, groupInfo, true, this.ccouinfo, null, this.getSchemeHelper());
    }

    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = this.createSchemeHelper(this.schemeId);
        }
        return this.schemeHelper;
    }

    protected BgSchemeDimensionHelper createSchemeHelper(String bgSchemeId) throws EASBizException, BOSException {
        return new BgSchemeDimensionHelper(null, bgSchemeId);
    }

    public void initFormVersionF7() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        BgSchemeDimensionHelper bgSchemeDimensionHelper = new BgSchemeDimensionHelper(this.schemeId);
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", bgSchemeDimensionHelper.getMemberSet(DimensionConstants.DEF_VERSION_NUMBER, true), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isRollVersion", (Object)0, CompareType.EQUALS));
        this.kDUpdateTableVersionF7.setEntityViewInfo(evi);
        BgVersionInfo info = (BgVersionInfo)bgSchemeDimensionHelper.getDefaultMember().get(DimensionConstants.DEF_VERSION_NUMBER);
        this.kDUpdateTableVersionF7.setData((Object)info);
    }

    public void initDimensionShipGroupF7(DimensionRelationshipGroupInfo groupInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.schemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isCsl", (Object)false, CompareType.EQUALS));
        this.kDDimensionShipGroupF7.setEntityViewInfo(evi);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll1.setEnabled(true);
        this.btnSelectAll2.setEnabled(true);
        this.btnRemoveAll1.setEnabled(true);
        this.btnRemoveAll2.setEnabled(true);
        this.kDSearch.setEnabled(true);
        this.btnSave.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kDDimensionShipGroupF7.setEditable(false);
    }

    @Override
    protected void kDDimensionShipGroupF7_dataChanged(DataChangeEvent e) throws Exception {
        DimensionRelationshipGroupInfo oldInfo = (DimensionRelationshipGroupInfo)e.getOldValue();
        DimensionRelationshipGroupInfo groupInfo = (DimensionRelationshipGroupInfo)e.getNewValue();
        if (groupInfo == null && e.getOldValue() != null && this.kDDimensionShipGroupF7.getUserObject() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"isNullShipGroup"));
            this.kDDimensionShipGroupF7.setDataNoNotify(e.getOldValue());
            groupInfo = oldInfo;
        }
        DimensionRelationClientHelper.loadTempTable(this, this.kDTableDimensionShip, groupInfo, this.ccouinfo, null, this.getSchemeHelper(), false);
        this.batchAddRow(groupInfo, this.kDTextField1.getText());
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkSaveData();
        this.updateShipToTemplateAndForm();
    }

    public void updateShipToTemplateAndForm() throws Exception {
        SimpleTimer time = new SimpleTimer();
        UIContext map = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DimRelationUpdateProgressUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            DimRelationUpdateProgressUI ui = (DimRelationUpdateProgressUI)window.getUIObject();
            ui.setTableReportUI(BgRelationUpdateResultUI.class.getName());
            ui.setShowTableMessage(true);
            logger.debug((Object)("begin " + time.getTime() + ""));
            this.invokeUpdateDimShipParam(ui);
            logger.debug((Object)("begin init" + time.getTime() + ""));
            ui.init();
            logger.debug((Object)("begin show" + time.getTime() + ""));
            window.show();
        }
    }

    public Object invokeUpdateDimShip(String orgId, String schemeId, Set shipValue, String templateId, Set versionIDs, Set stateSet, String groupID, Map templateMap) throws Exception {
        Object[] obj = new Object[3];
        Object[] templateInfo = (Object[])templateMap.get(templateId);
        try {
            List result = DimensionRelationshipFactory.getRemoteInstance().updateShipToTemplateAndForm(orgId, schemeId, shipValue, templateId, versionIDs, stateSet, groupID);
            if (result != null) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                }
            }
            obj[1] = result;
        }
        catch (Exception exc) {
            logger.error((Object)"", (Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"updateTimeOut"));
            }
            throw exc;
        }
        obj[0] = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"updateing", (Object[])templateInfo);
        return obj;
    }

    public void invokeUpdateDimShipParam(DimRelationUpdateProgressUI ui) throws Exception {
        Class[] cla = new Class[]{String.class, String.class, Set.class, String.class, Set.class, Set.class, String.class, Map.class};
        ui.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"title_relationUpdate"));
        ui.setInvokeClass(this.getMetaDataPK().getFullName());
        ui.setInvokeMethod("invokeUpdateDimShip");
        ui.setInvokeMethodParmeterType(cla);
        boolean isTheFirst = true;
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        Set<String> templateValue = this.getTableTemplateValue();
        Set<String> shipValue = this.getTableDimensionShipValue();
        Set<Integer> stateSet = this.getFormStateSet();
        Set<String> versionIDs = this.getVersionValue();
        String groupID = this.getGroupID();
        Map templateMap = this.getTableTemplateName();
        for (String templateId : templateValue) {
            Object[] obj;
            if (isTheFirst) {
                isTheFirst = false;
                obj = new Object[8];
                obj[3] = templateId;
                obj[7] = templateMap;
                vecPrameterValue.add(obj);
            }
            obj = new Object[]{this.orgId, this.schemeId, shipValue, templateId, versionIDs, stateSet, groupID, templateMap};
            vecPrameterValue.add(obj);
        }
        int size = vecPrameterValue.size();
        int objlength = 8;
        Object[][] valueMethod = new Object[size][objlength];
        for (int i = 0; i < size; ++i) {
            Object[] obj = (Object[])vecPrameterValue.get(i);
            for (int j = 0; j < objlength; ++j) {
                valueMethod[i][j] = obj[j];
            }
        }
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(vecPrameterValue.size() - 1);
    }

    public Set<Integer> getFormStateSet() {
        HashSet<Integer> states = new HashSet<Integer>();
        if (this.kDCheckBox1.isSelected()) {
            states.add(1);
        }
        if (this.kDCheckBox2.isSelected()) {
            states.add(42);
        }
        if (this.kDCheckBox3.isSelected()) {
            states.add(4);
        }
        return states;
    }

    public void checkSaveData() {
        Set<Integer> formState;
        Set<String> versionid;
        Set<String> temIds;
        Set<String> shipIds = this.getTableDimensionShipValue();
        if (shipIds.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"selectShipEntry"));
            SysUtil.abort();
        }
        if ((temIds = this.getTableTemplateValue()).isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"selectTemplate"));
            SysUtil.abort();
        }
        if ((versionid = this.getVersionValue()).isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"selectVersion"));
            SysUtil.abort();
        }
        if ((formState = this.getFormStateSet()).isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"selectFormState"));
            SysUtil.abort();
        }
    }

    public Set<String> getTableDimensionShipValue() {
        HashSet<String> shipIds = new HashSet<String>();
        IRow row = null;
        int in = this.kDTableDimensionShip.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.kDTableDimensionShip.getRow(i);
            if (!row.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            shipIds.add(row.getCell("id").getValue().toString());
        }
        return shipIds;
    }

    public Set<String> getTableTemplateValue() {
        HashSet<String> temIds = new HashSet<String>();
        IRow row = null;
        int in = this.kDTableTemplateList.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.kDTableTemplateList.getRow(i);
            if (!row.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            temIds.add(row.getCell("id").getValue().toString());
        }
        return temIds;
    }

    public Map getTableTemplateName() {
        HashMap<String, Object[]> temIds = new HashMap<String, Object[]>();
        IRow row = null;
        int in = this.kDTableTemplateList.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.kDTableTemplateList.getRow(i);
            if (!row.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            temIds.put(row.getCell("id").getValue().toString(), new Object[]{row.getCell("number").getValue().toString(), row.getCell("name").getValue().toString()});
        }
        return temIds;
    }

    public Set<String> getVersionValue() {
        HashSet<String> set = new HashSet<String>();
        if (this.kDUpdateTableVersionF7.getData() != null) {
            BgVersionInfo info;
            if (this.kDUpdateTableVersionF7.getData() instanceof Object[]) {
                Object[] objects = (Object[])this.kDUpdateTableVersionF7.getData();
                for (int i = 0; i < objects.length; ++i) {
                    BgVersionInfo info2 = (BgVersionInfo)objects[i];
                    if (info2 == null) continue;
                    set.add(info2.getId().toString());
                }
            } else if (this.kDUpdateTableVersionF7.getData() instanceof Object && (info = (BgVersionInfo)this.kDUpdateTableVersionF7.getData()) != null) {
                set.add(info.getId().toString());
            }
        }
        return set;
    }

    public String getGroupID() {
        String groupID = null;
        if (this.kDDimensionShipGroupF7.getData() != null) {
            groupID = ((DimensionRelationshipGroupInfo)this.kDDimensionShipGroupF7.getData()).getId().toString();
        }
        return groupID;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionSelectAll1_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kDTableDimensionShip.getRowCount();
        for (int index = 0; index < size; ++index) {
            if (this.kDTableDimensionShip.getCell(index, "select").getStyleAttributes().isLocked()) continue;
            this.kDTableDimensionShip.getCell(index, "select").setValue((Object)true);
        }
    }

    @Override
    public void actionSelectAll2_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kDTableTemplateList.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.kDTableTemplateList.getCell(index, "select").setValue((Object)true);
        }
    }

    @Override
    public void actionRemoveAll2_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kDTableTemplateList.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.kDTableTemplateList.getCell(index, "select").setValue((Object)false);
        }
    }

    @Override
    public void actionRemoveAll1_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kDTableDimensionShip.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.kDTableDimensionShip.getCell(index, "select").setValue((Object)false);
        }
    }

    @Override
    protected void kDTextField1_focusLost(FocusEvent e) throws Exception {
        this.doSearch();
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        this.doSearch();
    }

    protected void doSearch() throws Exception {
        String filterStr = this.kDTextField1.getText();
        DimensionRelationshipGroupInfo groupInfo = (DimensionRelationshipGroupInfo)this.kDDimensionShipGroupF7.getData();
        DimRelationShipUpdateSearchKey keyEnum = (DimRelationShipUpdateSearchKey)((Object)this.kDSearchBox.getSelectedItem());
        if (keyEnum.getValue() == 2) {
            this.batchAddRow(groupInfo, filterStr);
        } else if (keyEnum.getValue() == 1) {
            this.initTableForTemplate(filterStr, groupInfo);
        }
    }

    @Override
    protected void kDUpdateTableVersionF7_willShow(SelectorEvent e) throws Exception {
        super.kDUpdateTableVersionF7_willShow(e);
        EntityViewInfo evi = this.kDUpdateTableVersionF7.getEntityViewInfo();
        FilterInfo filter = evi.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("isRollVersion", (Object)false, CompareType.EQUALS));
        this.kDUpdateTableVersionF7.setEntityViewInfo(evi);
        this.kDUpdateTableVersionF7.getQueryAgent().resetRuntimeEntityView();
    }
}

