/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.MbgFormDimensionRelationEditUI;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class DimensionRelationshipSelectUI
extends MbgFormDimensionRelationEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionRelationshipSelectUI.class);
    public static final String GROUP = "relationGroup";
    private boolean isCancel = true;
    private List<MbgRelationMap> data = null;

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation"));
        this.btnSelectAll.setVisible(false);
        this.btnClearAll.setVisible(false);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOk.setVisible(true);
        this.btnCancel.setVisible(true);
        this.btnDelete.setVisible(false);
        this.btnAllSelect.setVisible(true);
        this.btnAllSelect.setEnabled(true);
        this.btnAllClear.setEnabled(true);
        this.btnAllClear.setVisible(true);
    }

    @Override
    protected void btnAllSelect_actionPerformed(ActionEvent e) throws Exception {
        this.btnSelectAll_actionPerformed(e);
    }

    @Override
    protected void btnAllClear_actionPerformed(ActionEvent e) throws Exception {
        this.btnClearAll_actionPerformed(e);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        MbgRelationMap map = this.getRelationMap();
        if (map != null) {
            map.getRelationShips().clear();
            for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
                IRow row = this.tblMain.getRow(r);
                if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
                map.getRelationShips().add((DimensionRelationshipInfo)row.getUserObject());
            }
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void dataChanged(DataChangeEvent eventObj) {
        this.data = (List)eventObj.getNewValue();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public void reShow() {
        this.isCancel = true;
        MbgRelationMap map = this.getRelationMap();
        if (map == null) {
            return;
        }
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < map.getRelationShips().size(); ++i) {
            numbers.add(map.getRelationShips().get(i).getDimensionNumber());
        }
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            IRow row = this.tblMain.getRow(r);
            row.getCell("select").setValue((Object)numbers.contains(row.getCell(DimensionConstants.DIMENSION_NUMBER).getValue()));
        }
    }

    protected MbgRelationMap getRelationMap() {
        if (this.data == null || this.data.isEmpty()) {
            return null;
        }
        DimensionRelationshipGroupInfo group = this.getGroupInfo();
        if (group == null) {
            return null;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.data.get(i).getGroup().getId().toString().equals(group.getId().toString())) continue;
            return this.data.get(i);
        }
        return null;
    }

    @Override
    public boolean isDimensionDelete() {
        return true;
    }

    public Object getData() {
        return this.data;
    }

    @Override
    protected void readGroup() {
        List groupIds = (List)this.getUIContext().get(GROUP);
        if (groupIds == null || groupIds.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation"));
            SysUtil.abort();
        }
        String orgId = this.getOrgUnitId();
        if (this.getUnionGroupId() != null) {
            orgId = this.getUnionGroupId();
        }
        try {
            DimensionMemberRelationShipHelper shipHelper = DimensionFormulaFacadeFactory.getRemoteInstance().buildRelationHelper((String)groupIds.get(0), orgId, null);
            if (shipHelper == null || shipHelper.getGroup() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation"));
                SysUtil.abort();
            }
            MbgRelationMap map = new MbgRelationMap((IMbgViewManager)this.getUIContext().get("VIEW_MANAGER"));
            map.setGroup(shipHelper.getGroup());
            map.setRelationShips(shipHelper.getCol());
            this.relations.put(map.getGroup(), map);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
    }

    private String getOrgUnitId() {
        return (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
    }

    private String getUnionGroupId() {
        return (String)this.getUIContext().get(BgBaseConstants.UNIONGROUP_ID);
    }
}

