/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionSourceSelectF7;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionSourceSelectF7
extends AbstractDimensionSourceSelectF7 {
    private static final long serialVersionUID = -4893121483707379149L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionSourceSelectF7.class);
    public static final String ALL_SOURCES = "all_sources";
    public static final String SELECT_SOURCES = "select_sources";
    public static final String COL_SELECT = "select";
    public static final String COL_NAME = "name";
    private boolean isCancel = true;
    private DimensionSourceCollection data = null;

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BgViewHelper.removeEditHelper(this.tblMain);
        this.tblMain.removeRows();
        DimensionSourceCollection allSources = (DimensionSourceCollection)((Object)this.getUIContext().get(ALL_SOURCES));
        DimensionSourceCollection selectSources = (DimensionSourceCollection)((Object)this.getUIContext().get(SELECT_SOURCES));
        HashSet<String> loadedIds = new HashSet<String>();
        this.loadSource(selectSources, loadedIds, true);
        this.loadSource(allSources, loadedIds, false);
    }

    private void loadSource(DimensionSourceCollection sources, Set<String> loadedIds, boolean isSelected) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        IRow row = null;
        for (int i = 0; i < sources.size(); ++i) {
            if (loadedIds.contains(sources.get(i).getId().toString())) continue;
            row = this.tblMain.addRow();
            loadedIds.add(sources.get(i).getId().toString());
            row.getCell(COL_NAME).setValue((Object)sources.get(i));
            row.getCell(COL_SELECT).setValue((Object)isSelected);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        DimensionSourceCollection sources = new DimensionSourceCollection();
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COL_SELECT).getValue())) continue;
            sources.add((DimensionSourceInfo)row.getCell(COL_NAME).getValue());
        }
        if (sources.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        sources.sort("order");
        this.data = sources.isEmpty() ? null : sources;
        this.isCancel = false;
        this.destroyWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.data;
    }
}

