/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractFunctionDimMemberSelectF7UI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.VirtualModeTableHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class FunctionDimMemberSelectF7UI
extends AbstractFunctionDimMemberSelectF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FunctionDimMemberSelectF7UI.class);
    private VirtualModeTableHelper virtualHelper = null;
    private Set<String> bgPeriodTypeNumbers = null;
    private BgPeriodTypeInfo bgPeriodType = null;
    public static final String KEY_BgPeriodTypeNumbers = "bgPeriodTypeNumbers";
    protected CalendarHelper calendar = new CalendarHelper();
    private BgPeriodDispInfo year = null;
    private NumberExpandHelper numberHelper = null;

    public FunctionDimMemberSelectF7UI() throws Exception {
        this.virtualHelper = new VirtualModeTableHelper(this, this.tblLeft);
    }

    @Override
    protected NumberExpandHelper getNumberExpandHelper() {
        if (this.numberHelper == null) {
            this.numberHelper = new NumberExpandHelper((CoreUI)this, this.tblLeft);
        }
        return this.numberHelper;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        this.bgPeriodTypeNumbers = (Set)this.getUIContext().get(KEY_BgPeriodTypeNumbers);
        super.onLoad();
        this.cbxFillType.setEnabled(false);
        this.cbxBgPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    FunctionDimMemberSelectF7UI.this.cbxBgPeriodType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    FunctionDimMemberSelectF7UI.this.handUIException(exc);
                }
            }
        });
        String bgSchemeId = this.getBgSchemeID();
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id,dateFrom,dateTo where id = '" + bgSchemeId + "'");
        Date beginTime = BgNPeriodHelper.getDayBegin((Date)bgSchemeInfo.getDateFrom());
        Date endTime = BgNPeriodHelper.getDayEnd((Date)bgSchemeInfo.getDateTo());
        this.setBgPeriodBeginDate(beginTime);
        this.setBgPeriodEndDate(endTime);
        this.loadYear();
        this.rdbCurrentOrg.setVisible(false);
        this.rdbAll.setVisible(false);
    }

    @Override
    protected void cbxDimension_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null && e.getStateChange() != 1 || this.cbxDimension.getSelectedItem().equals(this.cbxDimension.getUserObject())) {
            return;
        }
        this.cbxSelectType.setSelectedItem((Object)BgMemberSelectTypeEnum.Member);
        this.checkCanSwitchDim();
        BgDimensionBaseInfo dimension = DimensionClientHelper.getSelectDimension(this.cbxDimension);
        if (dimension == null) {
            return;
        }
        if (!dimension.getType().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            super.cbxDimension_itemStateChanged(e);
            this.lblBgType.setEnabled(false);
            this.lblBgType.setVisible(false);
            this.cbxBgPeriodType.setEnabled(false);
            this.cbxBgPeriodType.setVisible(false);
            this.contYear.setEnabled(false);
            this.contYear.setVisible(false);
            this.cbxYear.setEnabled(false);
            this.cbxYear.setVisible(false);
            this.btnExpand.setEnabled(false);
            this.btnExpand.setVisible(false);
            this.btnConstriction.setEnabled(false);
            this.btnConstriction.setVisible(false);
        } else {
            this.lblBgType.setEnabled(true);
            this.lblBgType.setVisible(true);
            this.cbxBgPeriodType.setEnabled(true);
            this.cbxBgPeriodType.setVisible(true);
            this.contYear.setEnabled(true);
            this.contYear.setVisible(true);
            this.cbxYear.setEnabled(true);
            this.cbxYear.setVisible(true);
            this.btnExpand.setEnabled(true);
            this.btnExpand.setVisible(true);
            this.btnConstriction.setEnabled(true);
            this.btnConstriction.setVisible(true);
            this.loadBgPeriodType();
            this.doQuery(null);
        }
        if (dimension.getNumber().equals(DimensionConstants.DEF_ACCOUNT_NUMBER)) {
            this.kDLabelContainer1.setVisible(true);
        } else {
            this.kDLabelContainer1.setVisible(false);
        }
        if (BgMemberSelectTypeEnum.Variate.equals((Object)this.getSelectType())) {
            this.initVariateType();
        }
        this.cbxDimension.setUserObject(this.cbxDimension.getSelectedItem());
    }

    @Override
    protected void switchSelectType(BgMemberSelectTypeEnum selectType) {
        super.switchSelectType(selectType);
        if (BgMemberSelectTypeEnum.Variate == selectType || BgMemberSelectTypeEnum.Function == selectType) {
            this.cbxBgPeriodType.setEnabled(false);
            this.cbxYear.setEnabled(false);
        } else {
            this.cbxBgPeriodType.setEnabled(true);
            this.cbxYear.setEnabled(true);
        }
    }

    protected void loadBgPeriodType() {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.setSelector(new SelectorItemCollection());
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add("*");
            SorterItemInfo info0 = new SorterItemInfo("simplename");
            info0.setSortType(SortType.ASCEND);
            evi.getSorter().add(info0);
            SorterItemInfo info1 = new SorterItemInfo("isSysdata");
            info1.setSortType(SortType.DESCEND);
            evi.getSorter().add(info1);
            SorterItemInfo info2 = new SorterItemInfo("number");
            info2.setSortType(SortType.ASCEND);
            evi.getSorter().add(info2);
            if (this.bgPeriodTypeNumbers == null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"Select FTypeId FROM T_Mbg_BgPeriodDisp", CompareType.INNER));
            } else if (this.bgPeriodTypeNumbers.isEmpty()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)BgBaseConstants.nullID));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.bgPeriodTypeNumbers, CompareType.INCLUDE));
            }
            BgPeriodTypeCollection coll = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(evi);
            this.cbxBgPeriodType.removeAllItems();
            if (coll != null && !coll.isEmpty()) {
                this.cbxBgPeriodType.addItems(coll.toArray());
                this.selectDefaultBgPeriodType();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void selectDefaultBgPeriodType() {
        int defaultIndex = -1;
        for (int i = 0; i < this.cbxBgPeriodType.getItemCount(); ++i) {
            BgPeriodTypeInfo itemAt = (BgPeriodTypeInfo)this.cbxBgPeriodType.getItemAt(i);
            if (!FiscalYearEnum.STANDARDYEAR.equals((Object)itemAt.getFiscalYear()) || itemAt.getBgPeriodEnum(true) == 8 || 4 != itemAt.getBgPeriodEnum(false)) continue;
            defaultIndex = i;
            break;
        }
        if (defaultIndex >= 0 && defaultIndex != this.cbxBgPeriodType.getSelectedIndex()) {
            this.cbxBgPeriodType.setSelectedIndex(defaultIndex);
        }
    }

    private BgPeriodTypeInfo getSelectBgPeriodType() {
        return (BgPeriodTypeInfo)this.cbxBgPeriodType.getSelectedItem();
    }

    protected void loadYear() throws Exception {
        logger.error((Object)"******************************* loadYear **********************************");
        this.year = null;
        this.cbxYear.removeAllItems();
        BgPeriodTypeInfo type = this.getSelectBgPeriodType();
        if (type == null) {
            return;
        }
        if (type.getBgPeriodEnum(false) == 0) {
            this.cbxYear.setAccessAuthority(0);
            FilterInfo filterInfo = new FilterInfo();
            BgPeriodDispHelper.getOnlySelfPeriodFilter((FilterInfo)filterInfo, (Date)this.getBgPeriodBeginDate(), (Date)this.getBgPeriodEndDate(), (BgPeriodTypeInfo)type);
            this.doQuery(filterInfo);
        } else {
            this.cbxYear.setAccessAuthority(0);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.setSelector(new SelectorItemCollection());
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("bgPeriod.year");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("longNumber");
            evi.getSelector().add("periodType");
            SorterItemInfo sic = new SorterItemInfo("bgPeriod.year");
            sic.setSortType(SortType.ASCEND);
            evi.getSorter().add(sic);
            if (this.getBgPeriodBeginDate() != null && this.getBgPeriodEndDate() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.getBgPeriodBeginDate())), CompareType.GREATER_EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.getBgPeriodEndDate())), CompareType.LESS_EQUALS));
            }
            if (!type.isSelfDefined()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", (Object)1));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.level", (Object)1));
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)type.getId().toString()));
            BgPeriodDispCollection yearPeriod = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(evi);
            if (yearPeriod != null && !yearPeriod.isEmpty()) {
                int defaultIndex = -1;
                int currYear = this.calendar.getCurrentlyYear();
                for (int i = 0; i < yearPeriod.size(); ++i) {
                    if (yearPeriod.get(i).getBgPeriod().getYear() == currYear) {
                        defaultIndex = i;
                    }
                    this.cbxYear.addItem((Object)yearPeriod.get(i).toBgPeriodInfo());
                }
                if (defaultIndex >= 0) {
                    this.cbxYear.setSelectedIndex(defaultIndex);
                } else {
                    this.cbxYear.setSelectedIndex(0);
                }
            }
        }
    }

    @Override
    protected void cbxBgPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxBgPeriodType_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        if (this.cbxBgPeriodType.getSelectedItem() != null) {
            BgPeriodTypeInfo newType = this.getSelectBgPeriodType();
            if (this.bgPeriodType == null || !this.bgPeriodType.getId().equals((Object)newType.getId())) {
                this.bgPeriodType = newType;
                this.loadYear();
            }
        }
    }

    @Override
    protected void cbxYear_itemStateChanged(ItemEvent e) throws Exception {
        if (this.getSelectType() == null || this.getSelectType().equals((Object)BgMemberSelectTypeEnum.Function)) {
            return;
        }
        super.cbxYear_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        this.doQuery(null);
    }

    @Override
    protected FilterInfo afterFilter(BgDimensionBaseInfo dimension, FilterInfo filter, String orgId) {
        super.afterFilter(dimension, filter, orgId);
        if (dimension.getType().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            BgPeriodTypeInfo newType = this.getSelectBgPeriodType();
            if (newType == null) {
                return filter;
            }
            filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)newType.getId().toString()));
        }
        return filter;
    }
}

