/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.client.utils.BizCalcClientHelper;
import com.kingdee.eas.ma.biz.client.utils.BizDimMemberSelectHelper;
import com.kingdee.eas.ma.mbg.BgDetailMemberEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgVariateClassEnum;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.MbgFunctionProcess;
import com.kingdee.eas.ma.mbg.client.AbstractFunctionSelectF7UI;
import com.kingdee.eas.ma.mbg.client.BooleanFunctionWizardUI;
import com.kingdee.eas.ma.mbg.client.MbgMathFunctionWizardUI;
import com.kingdee.eas.ma.mbg.client.NewDimensionMemberF7UI;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunction;
import com.kingdee.eas.ma.mbg.function.define.MbgFunctionSourceFactory;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgVariateTypeDispInfo;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FunctionSelectF7UI
extends AbstractFunctionSelectF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FunctionSelectF7UI.class);
    public static final String CAN_SELECT_ALL_DIM = "canSelectAllDim";
    public static final String CAN_SELECT_TYPE = "canSelectType";
    public static final String CAN_FILL_TYPE = "canFillType";
    public static final String SELECT_TYPE = "SelectType";
    public static final String SELECT_DIM = "selectDim";
    public static final String ISMULTISELECT = "isMultiSelect";
    public static final String ISENABLEPROPERTY = "ISENABLEPROPERTY";
    public static final String IS_ADD_NUMERIC_VARIATE = "isAddNumericVariate";
    protected boolean isAddNumericVariate = Boolean.TRUE;
    private boolean isHiddenPartCslDim = Boolean.FALSE;
    private String orgId = null;
    private NumberExpandHelper numberHelper = null;
    private Map dataTypeMap = null;
    private LinkedHashMap<String, BgDimensionMember> curSelectedFunction = new LinkedHashMap();
    private MbgViewListResultData backFillMember = null;
    protected boolean canSelectAllDim = false;
    protected BgMemberSelectTypeEnum selectType = null;
    protected boolean canSelectType = true;
    private boolean isQingAnalyse = false;
    private BgDimensionBaseInfo dimension = null;
    private Date beginDate = null;
    private Date endDate = null;

    public boolean isQingAnalyse() {
        return this.isQingAnalyse;
    }

    public void setQingAnalyse(boolean isQingAnalyse) {
        this.isQingAnalyse = isQingAnalyse;
    }

    public void setCanSelectAllDim(boolean canSelectAllDim) {
        this.canSelectAllDim = canSelectAllDim;
    }

    public void setSelectType(BgMemberSelectTypeEnum selectType) {
        this.selectType = selectType;
    }

    public BgMemberSelectTypeEnum getSelectType() {
        if (this.selectType == null || !this.selectType.equals((Object)((BgMemberSelectTypeEnum)((Object)this.cbxSelectType.getSelectedItem())))) {
            this.selectType = (BgMemberSelectTypeEnum)((Object)this.cbxSelectType.getSelectedItem());
        }
        return this.selectType;
    }

    public void setCanSelectType(boolean canSelectType) {
        this.canSelectType = canSelectType;
    }

    @Override
    public void setMultiSelect(boolean isMultiSelect) {
        super.setMultiSelect(isMultiSelect);
        if (isMultiSelect) {
            this.tblVaLeft.getSelectManager().setSelectMode(10);
            this.tblVaRight.getSelectManager().setSelectMode(10);
        } else {
            this.tblVaLeft.getSelectManager().setSelectMode(2);
            this.tblVaRight.getSelectManager().setSelectMode(2);
        }
    }

    public String getBgSchemeID() {
        return this.bgSchemeId;
    }

    public BgDimensionBaseInfo getDimension() {
        return this.dimension;
    }

    public void setDimension(BgDimensionBaseInfo dimension) {
        this.dimension = dimension;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public LinkedHashMap<String, BgDimensionMember> getCurSelectedFunction() {
        return this.curSelectedFunction;
    }

    public void setCurSelectedFunction(LinkedHashMap<String, BgDimensionMember> curSelectedFunction) {
        this.curSelectedFunction = curSelectedFunction;
    }

    public MbgViewListResultData getBackFillMember() {
        return this.backFillMember;
    }

    public void setBackFillMember(MbgViewListResultData backFillMember) {
        this.backFillMember = backFillMember;
    }

    public void setBgPeriodBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public void setBgPeriodEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getBgPeriodBeginDate() {
        return this.beginDate;
    }

    public Date getBgPeriodEndDate() {
        return this.endDate;
    }

    public void addFunction(Map<String, BgDimensionMember> addFunctionMap) {
        if (addFunctionMap == null || addFunctionMap.isEmpty()) {
            return;
        }
        MbgViewListResultData rstData = new MbgViewListResultData();
        rstData.setMemberType(BgMemberSelectTypeEnum.Function);
        BgDimensionMember member = null;
        if (addFunctionMap != null && !addFunctionMap.isEmpty()) {
            this.getCurSelectedFunction().putAll(addFunctionMap);
            IRow row = null;
            for (String funStr : addFunctionMap.keySet()) {
                member = new BgDimensionMember(null, null, funStr, funStr);
                row = this.tblFuncRight.addRow();
                row.getStyleAttributes().setLocked(true);
                this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() + 1);
                row.getCell("name").setValue((Object)member.getNumber());
                this.curSelectedFunction.put(member.getNumber(), member);
            }
        }
    }

    public void removeFunction(String oldFunction) {
        this.curSelectedFunction.remove(oldFunction);
        int deleteRowIndex = -1;
        for (int i = 0; i < this.tblFuncRight.getRowCount(); ++i) {
            String rowFunction = this.tblFuncRight.getRow(i).getCell("name").getValue().toString();
            if (!oldFunction.equals(rowFunction)) continue;
            deleteRowIndex = i;
            break;
        }
        this.tblFuncRight.removeRow(deleteRowIndex);
        this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() - 1);
    }

    public boolean checkFunctionRepeat(String memberKey) {
        boolean isExistSameParam = false;
        if (StringUtils.isEmpty((String)memberKey)) {
            return isExistSameParam;
        }
        LinkedHashMap<String, BgDimensionMember> curSelectedFunction = this.getCurSelectedFunction();
        if (curSelectedFunction.containsKey(memberKey)) {
            isExistSameParam = true;
        }
        return isExistSameParam;
    }

    private void refreshSelectedFunctionList(Set<String> functionStr) {
        if (functionStr == null || functionStr.isEmpty()) {
            return;
        }
        this.tblFuncRight.checkParsed();
        this.tblFuncRight.removeRows();
        this.tblFuncRight.setEditable(false);
        IRow row = null;
        String selectedFun2 = null;
        for (String selectedFun2 : functionStr) {
            row = this.tblFuncRight.addRow();
            this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() + 1);
            row.getCell("name").setValue((Object)selectedFun2);
        }
    }

    private void refreshSelectedFunctionList(MbgViewListResultData functionStr) {
        block13: {
            List members;
            block15: {
                block14: {
                    block12: {
                        if (functionStr == null || functionStr.isEmpty()) {
                            return;
                        }
                        BgDimensionMember selectedFun2 = null;
                        members = null;
                        Object member = null;
                        this.selectType = functionStr.getMemberType();
                        members = functionStr.getMembers();
                        if (this.cbxSelectType.getSelectedItem().equals((Object)BgMemberSelectTypeEnum.Function)) {
                            this.tblFuncRight.removeRows();
                        } else if (this.cbxSelectType.getSelectedItem().equals((Object)BgMemberSelectTypeEnum.Member)) {
                            this.tblRight.removeRows();
                        } else if (this.cbxSelectType.getSelectedItem().equals((Object)BgMemberSelectTypeEnum.Variate)) {
                            this.tblVaRight.removeRows();
                        } else if (this.cbxSelectType.getSelectedItem().equals((Object)BgMemberSelectTypeEnum.Property)) {
                            this.tblProRight.removeRows();
                        }
                        this.cbxSelectType.setSelectedItem((Object)functionStr.getMemberType());
                        if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Function)) break block12;
                        this.tblFuncRight.checkParsed();
                        this.tblFuncRight.removeRows();
                        this.tblFuncRight.setEditable(false);
                        IRow row = null;
                        for (BgDimensionMember selectedFun2 : members) {
                            this.curSelectedFunction.put(selectedFun2.getNumber(), selectedFun2);
                            row = this.tblFuncRight.addRow();
                            this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() + 1);
                            row.getCell("name").setValue((Object)selectedFun2.getNumber());
                        }
                        break block13;
                    }
                    if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Member)) break block14;
                    this.tblRight.checkParsed();
                    this.tblRight.removeRows();
                    this.tblRight.setEditable(false);
                    IRow row = null;
                    for (BgDimensionMember selectedFun2 : members) {
                        row = this.tblRight.addRow();
                        this.tblRight.setRowCount(this.tblRight.getRowCount() + 1);
                        row.setUserObject((Object)selectedFun2);
                        row.getCell("dimension").setValue((Object)new SourceDisplayInfo(this.dimension));
                        row.getCell("number").setValue((Object)selectedFun2.getNumber());
                        row.getCell("name").setValue((Object)selectedFun2.getName());
                        row.getCell("fillType").setValue((Object)DimensionMemberTypeEnum.getEnum(selectedFun2.getFillType()));
                    }
                    break block13;
                }
                if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Variate)) break block15;
                this.tblVaRight.checkParsed();
                this.tblVaRight.removeRows();
                this.tblVaRight.setEditable(false);
                IRow row = null;
                for (BgDimensionMember selectedFun2 : members) {
                    row = this.tblVaRight.addRow();
                    this.tblVaRight.setRowCount(this.tblVaRight.getRowCount() + 1);
                    row.setUserObject((Object)selectedFun2);
                    row.getCell("number").setValue((Object)selectedFun2.getNumber());
                    row.getCell("name").setValue((Object)selectedFun2.getName());
                }
                break block13;
            }
            if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Property)) break block13;
            this.tblProRight.checkParsed();
            this.tblProRight.removeRows();
            this.tblProRight.setEditable(false);
            IRow row = null;
            for (BgDimensionMember selectedFun2 : members) {
                row = this.tblProRight.addRow();
                this.tblProRight.setRowCount(this.tblProRight.getRowCount() + 1);
                row.setUserObject((Object)selectedFun2);
                row.getCell("id").setValue((Object)selectedFun2.getAttribute());
                row.getCell("number").setValue((Object)selectedFun2.getNumber());
                row.getCell("name").setValue((Object)selectedFun2.getName());
                row.getCell("proSortName").setValue((Object)selectedFun2.getSortValue());
            }
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.selectType = (BgMemberSelectTypeEnum)((Object)this.getUIContext().get(SELECT_TYPE));
        if (this.getUIContext().get(IS_ADD_NUMERIC_VARIATE) != null) {
            this.isAddNumericVariate = (Boolean)this.getUIContext().get(IS_ADD_NUMERIC_VARIATE);
        }
        if (this.getUIContext().get("isHiddenPartCsldim") != null) {
            this.isHiddenPartCslDim = (Boolean)this.getUIContext().get("isHiddenPartCsldim");
        }
        super.onLoad();
        if (this.selectType == BgMemberSelectTypeEnum.Variate && this.isAddNumericVariate) {
            BgVariateTypeDispInfo varDisp = new BgVariateTypeDispInfo("NUMERIC", BgVariateTypeDispInfo.NUMERIC_NAME, BgVariateClassEnum.CONSTANTS_TYPE);
            this.cbxDimension.insertItemAt((Object)varDisp, 0);
            if (this.getUIContext().get(SELECT_DIM) == null) {
                this.cbxDimension.setSelectedIndex(0);
            }
        }
        this.orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.dimension = (BgDimensionInfo)this.getUIContext().get("dimension");
        if (this.orgId == null) {
            this.orgId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        this.dataTypeMap = this.getUIContext().get("dataTypeMap") != null ? (Map)this.getUIContext().get("dataTypeMap") : new HashMap();
        if (this.getUIContext().get(ISMULTISELECT) != null) {
            boolean isMustSelect = (Boolean)this.getUIContext().get(ISMULTISELECT);
            this.setMultiSelect(isMustSelect);
        }
        if (this.getUIContext().get("isQingAnalyse") != null) {
            this.isQingAnalyse = (Boolean)this.getUIContext().get("isQingAnalyse");
            this.cbxFillType.setEnabled(!this.isQingAnalyse);
            BgDimensionBaseInfo dimension = (BgDimensionBaseInfo)this.getUIContext().get("dimension");
            if (dimension != null && DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimension.getNumber()) && this.getLeftTable().getColumn("description") != null) {
                this.getLeftTable().getColumn("description").getStyleAttributes().setHided(false);
                this.tblRight.getColumn("description").getStyleAttributes().setHided(false);
            }
        }
        this.enableCbxFillType(this.getMemberSelectType());
        if (this.getUIContext().get(CAN_FILL_TYPE) != null && !((Boolean)this.getUIContext().get(CAN_FILL_TYPE)).booleanValue()) {
            this.cbxFillType.setEnabled(false);
            this.setCanFillType(false);
        }
        this.fillBackValue();
        this.init();
    }

    protected void init() {
        Object isSelectAllDim;
        this.tblFuncRight.setEnabled(false);
        if (this.getMemberSelectType().equals((Object)BgMemberSelectTypeEnum.Member)) {
            this.setShareOrgUnSelect();
        }
        if ((isSelectAllDim = this.getUIContext().get("isMustAllDim")) != null) {
            this.cbxDimension.setEnabled(Boolean.parseBoolean(isSelectAllDim.toString()));
        }
        if (this.cbxDimension.getItemCount() == 1) {
            this.cbxDimension.setEnabled(false);
        }
    }

    public void onShow() throws Exception {
        if (this.getUIContext().get("Owner") instanceof MbgMathFunctionWizardUI) {
            this.tblVaLeft.getSelectManager().setSelectMode(10);
        }
        super.onShow();
    }

    private void fillBackValue() {
        if (this.getUIContext().get("backfillMember") != null && this.getUIContext().get("backfillMember") instanceof MbgViewListResultData) {
            this.backFillMember = (MbgViewListResultData)this.getUIContext().get("backfillMember");
            this.clearTableRrigt(this.backFillMember.getMemberType());
            this.splitMultiFunction(this.backFillMember.getMemberType(), this.backFillMember);
            this.refreshSelectedFunctionList(this.backFillMember);
        }
    }

    private boolean isFromMbgMathUI() {
        if (this.getUIContext().get("Owner") != null && (this.getUIContext().get("Owner") instanceof MbgMathFunctionWizardUI || this.getUIContext().get("Owner") instanceof BooleanFunctionWizardUI)) {
            return true;
        }
        return this.getUIContext().get(SELECT_TYPE) != null && ((BgMemberSelectTypeEnum)((Object)this.getUIContext().get(SELECT_TYPE))).equals((Object)BgMemberSelectTypeEnum.Variate);
    }

    private void splitMultiFunction(BgMemberSelectTypeEnum memberType, MbgViewListResultData backFillMember2) {
        boolean isFromMainUI = this.getUIContext().get("Owner") instanceof BizCalcMainUI;
        if (BgMemberSelectTypeEnum.Function.equals((Object)memberType) && !isFromMainUI) {
            List members = backFillMember2.getMembers();
            BgDimensionMember curMem = null;
            BgDimensionMember newMem = null;
            String curNum = null;
            String refField = null;
            String srcNum = null;
            String[] funArr = null;
            ArrayList<BgDimensionMember> newResult = null;
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgDimensionMember)) continue;
                curMem = (BgDimensionMember)members.get(i);
                curNum = curMem.getNumber();
                refField = curMem.getAttribute();
                srcNum = curMem.getSrcNumber();
                funArr = curNum.split(",@");
                if (funArr.length <= 1) continue;
                newResult = new ArrayList<BgDimensionMember>();
                for (int j = 0; j < funArr.length; ++j) {
                    newMem = j == 0 ? new BgDimensionMember(null, refField, funArr[j], funArr[j]) : new BgDimensionMember(null, refField, "@" + funArr[j], "@" + funArr[j]);
                    newResult.add(newMem);
                }
            }
            if (funArr != null && funArr.length > 1) {
                backFillMember2.getMembers().clear();
                backFillMember2.setMembers(newResult);
            }
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.canSelectAllDim = this.getUIContext().get(CAN_SELECT_ALL_DIM) != null ? (Boolean)this.getUIContext().get(CAN_SELECT_ALL_DIM) : false;
        boolean bl = this.canSelectType = this.getUIContext().get(CAN_SELECT_TYPE) != null ? (Boolean)this.getUIContext().get(CAN_SELECT_TYPE) : true;
        if (this.canSelectAllDim) {
            this.cbxDimension.setEnabled(true);
        }
        if (!this.canSelectType) {
            this.cbxSelectType.setEnabled(false);
        }
    }

    @Override
    protected void initCbBox() {
        BgDimensionBaseInfo dimension;
        super.initCbBox();
        if (this.getUIContext().get(SELECT_DIM) != null) {
            SourceDisplayInfo dim = new SourceDisplayInfo((BgDimensionInfo)this.getUIContext().get(SELECT_DIM));
            if (dim.getDimension() != null) {
                this.cbxDimension.setSelectedItem((Object)dim, false);
            }
            this.cbxDimension.setUserObject((Object)dim);
        }
        if (!((dimension = DimensionClientHelper.getSelectDimension(this.cbxDimension)).getNumber().equals(DimensionBaseConstants.DEF_CURRENCY_NUMBER) || dimension.getNumber().equals(DimensionBaseConstants.DEF_ELEMENT_NUMBER) || dimension.getNumber().equals(DimensionBaseConstants.DEF_VERSION_NUMBER) || dimension.getNumber().equals(DimensionBaseConstants.DEF_SCENARIO_NUMBER))) {
            this.cbxSelectType.addItem((Object)BgMemberSelectTypeEnum.Function);
        }
        if (Boolean.TRUE.equals(this.getUIContext().get(ISENABLEPROPERTY)) && this.getSelectDimension().getNumber() != null && !DimensionConstants.DEF_CSL_NUMBER.equals(this.getSelectDimension().getNumber()) && (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(this.getSelectDimension().getNumber()) || !DimensionConstants.canNotCancelProp.contains(this.getSelectDimension().getNumber()))) {
            this.cbxSelectType.addItem((Object)BgMemberSelectTypeEnum.Property);
        }
        if (this.isHiddenPartCslDim) {
            this.cbxSelectType.removeItem((Object)BgMemberSelectTypeEnum.Function);
            this.cbxSelectType.removeItem((Object)BgMemberSelectTypeEnum.Variate);
            this.cbxSelectType.addItem((Object)BgMemberSelectTypeEnum.Property);
        }
        if (DimensionConstants.DEF_CSL_NUMBER.equals(this.getSelectDimension().getNumber())) {
            this.cbxSelectType.removeItem((Object)BgMemberSelectTypeEnum.Property);
        }
        this.selectType = (BgMemberSelectTypeEnum)((Object)this.getUIContext().get(SELECT_TYPE));
        if (this.selectType != null) {
            this.cbxSelectType.setSelectedItem((Object)this.selectType);
            this.cbxSelectType.setUserObject((Object)this.getMemberSelectType());
            if (this.selectType.equals((Object)BgMemberSelectTypeEnum.Member)) {
                this.setShareOrgUnSelect();
            }
        }
        if (this.getUIContext().get("onlyMember") != null && Boolean.TRUE.equals(this.getUIContext().get("onlyMember"))) {
            this.cbxSelectType.removeItem((Object)BgMemberSelectTypeEnum.Property);
            this.cbxSelectType.removeItem((Object)BgMemberSelectTypeEnum.Function);
            this.cbxSelectType.removeItem((Object)BgMemberSelectTypeEnum.Variate);
        }
    }

    @Override
    protected void cbxSelectType_change() throws BOSException {
        SourceDisplayInfo info;
        BgDimensionBaseInfo dimension;
        if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            if (!this.checkCurrencyDimension()) {
                this.initFunctionType();
            }
            this.hideTableExceptFun();
        } else {
            this.setMathFunUIDisAble();
        }
        this.setTitle();
        super.cbxSelectType_change();
        Object selectedItem = this.cbxDimension.getSelectedItem();
        if (selectedItem instanceof SourceDisplayInfo && (dimension = (info = (SourceDisplayInfo)selectedItem).getDimension()) != null && DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimension.getNumber())) {
            if (BgMemberSelectTypeEnum.Member.equals((Object)this.getMemberSelectType())) {
                this.kDLabelContainer1.setVisible(true);
            } else {
                this.kDLabelContainer1.setVisible(false);
            }
        }
    }

    protected void setTitle() {
        if (BgMemberSelectTypeEnum.Variate.equals((Object)this.getMemberSelectType())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"variate_title"));
            this.cbxFillType.setEnabled(false);
        } else if (BgMemberSelectTypeEnum.Member.equals((Object)this.getMemberSelectType())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"member_title"));
            this.cbxFillType.setEnabled(false);
        } else if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"function_title"));
            this.cbxFillType.setEnabled(false);
        }
    }

    private void setMathFunUIDisAble() {
        if (this.isFromMbgMathUI()) {
            this.cbxFillType.setEnabled(false);
        } else if (this.getUIContext().get("isQingAnalyse") != null) {
            this.isQingAnalyse = (Boolean)this.getUIContext().get("isQingAnalyse");
            this.cbxFillType.setEnabled(!this.isQingAnalyse);
        } else {
            this.cbxFillType.setEnabled(true);
        }
        this.enableCbxFillType(this.getMemberSelectType());
    }

    @Override
    protected void checkCanSwitch(BgMemberSelectTypeEnum oldSelectType) {
        boolean canSwitch = true;
        if (BgMemberSelectTypeEnum.Function.equals((Object)oldSelectType)) {
            boolean bl = canSwitch = this.tblFuncRight.getRowCount() <= 0;
        }
        if (!canSwitch) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"only_one_source"));
            this.cbxSelectType.setSelectedItem(this.cbxSelectType.getUserObject(), false);
            return;
        }
        super.checkCanSwitch(oldSelectType);
    }

    private boolean checkCurrencyDimension() {
        Object dimension = this.getUIContext().get("dimension");
        return dimension != null && ((BgDimensionInfo)dimension).getNumber().equals(DimensionBaseConstants.DEF_CURRENCY_NUMBER);
    }

    @Override
    protected void switchSelectType(BgMemberSelectTypeEnum selectType) {
        super.switchSelectType(selectType);
        if (BgMemberSelectTypeEnum.Function == selectType) {
            this.tblFuncLeft.setVisible(true);
            this.tblFuncRight.setVisible(true);
            this.tblVaLeft.setVisible(false);
            this.tblVaRight.setVisible(false);
            this.tblProLeft.setVisible(false);
            this.tblProRight.setVisible(false);
            this.tblLeft.setVisible(false);
            this.tblRight.setVisible(false);
            this.btnAddAll.setVisible(false);
            this.btnAddAll.setEnabled(false);
        } else if (BgMemberSelectTypeEnum.Variate == selectType) {
            if (this.cbxSelectType.isEnabled()) {
                this.btnAddAll.setVisible(true);
                this.btnAddAll.setEnabled(true);
            } else {
                this.btnAddAll.setVisible(false);
                this.btnAddAll.setEnabled(false);
                this.cbxFillType.setEnabled(false);
                this.contYear.setVisible(false);
            }
            this.cbxFillType.setEnabled(false);
        } else {
            this.btnAddAll.setVisible(true);
            this.btnAddAll.setEnabled(true);
            this.setMathFunUIDisAble();
        }
    }

    @Override
    protected void cbxDimension_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null && e.getStateChange() != 1 || this.cbxDimension.getSelectedItem().equals(this.cbxDimension.getUserObject())) {
            return;
        }
        this.checkCanSwitchDim();
        if (this.selectType != null && this.selectType.equals((Object)BgMemberSelectTypeEnum.Variate)) {
            this.kDLabelContainer1.setVisible(false);
        } else {
            super.cbxDimension_itemStateChanged(e);
        }
        if (BgMemberSelectTypeEnum.Variate.equals((Object)this.getSelectType())) {
            this.initVariateType();
        }
        this.setMathFunUIDisAble();
        if (this.cbxDimension.getSelectedItem() != null && this.cbxDimension.getSelectedItem() instanceof SourceDisplayInfo) {
            if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(((SourceDisplayInfo)this.cbxDimension.getSelectedItem()).getDimension().getNumber())) {
                this.kDLabelContainer1.setVisible(true);
            } else {
                this.kDLabelContainer1.setVisible(false);
            }
        }
        this.cbxDimension.setUserObject(this.cbxDimension.getSelectedItem());
    }

    @Override
    protected void reSetLeftTableForCsl() {
        String dimNumber;
        if (!this.isHiddenPartCslDim) {
            return;
        }
        BgDimensionBaseInfo selectDimension = DimensionClientHelper.getSelectDimension(this.cbxDimension);
        if (selectDimension != null && DimensionBaseConstants.DEF_CSL_NUMBER.equals(dimNumber = selectDimension.getNumber())) {
            for (int i = 0; i < this.tblLeft.getRowCount(); ++i) {
                NumberExpandInfo expInfo;
                IRow row = this.tblLeft.getRow(i);
                ICell cell = row.getCell("number");
                Object value = cell.getValue();
                if (!(value instanceof NumberExpandInfo) || (expInfo = (NumberExpandInfo)value) == null || !BgCslDimConstants.canNotEditCslNumberSet.contains(expInfo.getNumber()) || "CSL-04".equals(expInfo.getNumber())) continue;
                this.tblLeft.removeRow(i);
                --i;
            }
        }
    }

    protected void checkCanSwitchDim() {
        boolean canSwitch = true;
        if (BgMemberSelectTypeEnum.Variate == this.cbxSelectType.getSelectedItem()) {
            boolean bl = canSwitch = this.tblVaRight.getRowCount() <= 0;
        }
        if (!canSwitch) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"only_one_dimension"));
            this.cbxDimension.setSelectedItem(this.cbxDimension.getUserObject(), false);
            return;
        }
        if (BgMemberSelectTypeEnum.Member == this.cbxSelectType.getSelectedItem()) {
            boolean bl = canSwitch = this.tblRight.getRowCount() <= 0;
        }
        if (BgMemberSelectTypeEnum.Function == this.cbxSelectType.getSelectedItem()) {
            boolean bl = canSwitch = this.tblFuncRight.getRowCount() <= 0;
        }
        if (!canSwitch) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"only_one_dimMember"));
            this.cbxDimension.setSelectedItem(this.cbxDimension.getUserObject(), false);
            return;
        }
    }

    @Override
    protected void initVariateType() {
        this.switchSelectType(BgMemberSelectTypeEnum.Variate);
        try {
            Object selectItem = this.cbxDimension.getSelectedItem();
            String dimNumber = null;
            if (selectItem instanceof BgVariateTypeDispInfo) {
                dimNumber = ((BgVariateTypeDispInfo)selectItem).getNumber();
            }
            if (selectItem instanceof SourceDisplayInfo) {
                dimNumber = ((SourceDisplayInfo)selectItem).getDimension().getNumber();
            }
            BgViewMemberSelectHelper.loadBgVariate(this.getBgSchemeID(), dimNumber, this.tblVaLeft, null);
        }
        catch (BOSException e) {
            logger.error((Object)("initVariateType error :" + e.getMessage()));
            this.handUIException(e);
        }
    }

    private void initFunctionType() {
        MbgFunctionSourceFactory factory = null;
        ArrayList<String> functionsName = null;
        this.tblFuncLeft.checkParsed();
        this.tblFuncLeft.removeRows();
        try {
            factory = MbgFunctionSourceFactory.getInstance();
        }
        catch (Exception e) {
            logger.error((Object)"load function error", (Throwable)e);
        }
        if (factory != null) {
            functionsName = new ArrayList<String>();
            List<MbgFunction> fnList = factory.getFunctionTypeMap().get("MEMBER");
            for (MbgFunction fn : fnList) {
                if (this.getUIContext().get("isShowRemove") != null && !Boolean.parseBoolean(this.getUIContext().get("isShowRemove").toString()) && fn.getName().indexOf("@Remove") != -1) continue;
                functionsName.add(fn.getName() + "  (" + fn.getLocalName() + ")");
            }
        }
        if (functionsName != null) {
            IRow row = null;
            for (int i = 0; i < functionsName.size(); ++i) {
                row = this.tblFuncLeft.addRow();
                this.tblFuncLeft.setRowCount(this.tblFuncLeft.getRowCount() + 1);
                row.getCell("name").setValue(functionsName.get(i));
            }
        }
    }

    private void hideTableExceptFun() {
        this.tblFuncLeft.setEditable(false);
        this.tblFuncLeft.setVisible(true);
        this.tblVaLeft.setVisible(false);
        this.tblVaRight.setVisible(false);
        this.tblProLeft.setVisible(false);
        this.tblProRight.setVisible(false);
        this.tblLeft.setVisible(false);
        this.tblRight.setVisible(false);
        this.cbxFillType.setEnabled(false);
        this.btnAddAll.setVisible(false);
        this.btnAddAll.setEnabled(false);
        this.rdbAll.setVisible(false);
        this.rdbCurrentOrg.setVisible(false);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            int selectRowIndex = this.tblFuncLeft.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncLeft.getRow(selectRowIndex);
            String functionName = row.getCell("name").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgId());
            uiContext.put((Object)DimensionConstants.DIMENSION, (Object)this.getDimension());
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeID());
            MbgFunctionProcess process = new MbgFunctionProcess(functionName, this, uiContext);
            process.process();
        } else if (BgMemberSelectTypeEnum.Variate.equals((Object)this.getMemberSelectType()) && (this.cbxSelectType.isEnabled() || this.isMultiSelect())) {
            List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblVaLeft);
            BgViewMemberSelectHelper.addRows(rows, this.tblVaLeft, this.tblVaRight, this.isMultiSelect(), false);
            return;
        }
        super.btnAdd_actionPerformed(e);
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member.equals((Object)this.getMemberSelectType())) {
            if (this.tblLeft.getRowCount() <= 0) {
                return;
            }
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = 0; i < this.tblLeft.getRowCount(); ++i) {
                rows.add(new Integer(i));
            }
            this.add(rows, true);
            return;
        }
        if (BgMemberSelectTypeEnum.Variate.equals((Object)this.getMemberSelectType())) {
            if (this.tblVaLeft.getRowCount() <= 0) {
                return;
            }
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = 0; i < this.tblVaLeft.getRowCount(); ++i) {
                rows.add(new Integer(i));
            }
            BgViewMemberSelectHelper.addRows(rows, this.tblVaLeft, this.tblVaRight, true, false);
            return;
        }
        super.btnAddAll_actionPerformed(e);
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            int selectRowIndex = this.tblFuncRight.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncRight.getRow(selectRowIndex);
            String functionName = row.getCell("name").getValue().toString();
            this.tblFuncRight.removeRow(selectRowIndex);
            this.getCurSelectedFunction().remove(functionName);
        }
        super.btnRemove_actionPerformed(e);
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            this.getCurSelectedFunction().clear();
            this.tblFuncRight.removeRows();
            this.refreshSelectedFunctionList(this.getCurSelectedFunction().keySet());
        }
        super.btnRemoveAll_actionPerformed(e);
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        String type = null;
        if (this.cbxDimension.getSelectedItem() != null) {
            Object obj = this.cbxDimension.getSelectedItem();
            if (obj instanceof SourceDisplayInfo) {
                type = ((SourceDisplayInfo)obj).getDimension().getType();
            } else if (obj instanceof BgVariateTypeDispInfo) {
                type = ((BgVariateTypeDispInfo)obj).getNumber();
            }
        }
        this.dataTypeMap.put(type, this.getMemberSelectType());
        super.btnOk_actionPerformed(e);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.refreshSelectedFunctionList((MbgViewListResultData)this.getUIContext().get("backfillMember"));
        super.btnCancel_actionPerformed(e);
        if (this.getUIContext().get("Owner") instanceof BizCalcMainUI) {
            ((BizCalcMainUI)this.getUIContext().get("Owner")).setTableLostFocus();
        }
    }

    @Override
    protected DimensionMemberSelectHelper createSelectHelper(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        return new BizDimMemberSelectHelper(schemeHelper);
    }

    @Override
    protected MbgViewListResultData getReturnData() {
        MbgViewListResultData data = null;
        List<Object> members = null;
        if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            data = new MbgViewListResultData();
            data.setMemberType(BgMemberSelectTypeEnum.Function);
            members = new ArrayList();
            String funName2 = null;
            BgDimensionMember dimMem = null;
            for (String funName2 : this.curSelectedFunction.keySet()) {
                String refNum = MbgFunctionHelper.getRefNumByFunction(funName2);
                dimMem = new BgDimensionMember(null, refNum, funName2, funName2);
                members.add(dimMem);
            }
            data.setMembers(members);
            return data;
        }
        if (BgMemberSelectTypeEnum.Variate.equals((Object)this.getMemberSelectType())) {
            try {
                members = this.getBgVariateLst(this.tblVaRight);
                if (members == null) {
                    return null;
                }
                data = new MbgViewListResultData();
                if (this.isSelfSelect) {
                    data.setCanAddMembers(members);
                } else {
                    data.setMembers(members);
                }
                data.setMemberType(BgMemberSelectTypeEnum.Variate);
                return data;
            }
            catch (BOSException e) {
                logger.error((Object)("getBgVariateLst error \uff1a" + e.getMessage()));
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        } else if (BgMemberSelectTypeEnum.Property.equals((Object)this.getMemberSelectType())) {
            try {
                members = this.getPropertyLst(this.tblProRight);
                if (members == null) {
                    return null;
                }
                data = new MbgViewListResultData();
                if (this.isSelfSelect) {
                    data.setCanAddMembers(members);
                } else {
                    data.setMembers(members);
                }
                data.setMemberType(BgMemberSelectTypeEnum.Property);
                return data;
            }
            catch (BOSException e) {
                logger.error((Object)("getBgVariateLst error \uff1a" + e.getMessage()));
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        return super.getReturnData();
    }

    public List<BgDimensionMember> getBgVariateLst(KDTable tblVaRight) throws BOSException {
        if (tblVaRight.getRowCount() == 0) {
            return null;
        }
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        BgDimensionMember bgVariateInfo = null;
        IRow row = null;
        int count = tblVaRight.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = tblVaRight.getRow(index);
            if (row.getUserObject() != null && row.getUserObject() instanceof BgVariateInfo) {
                bgVariateInfo = (BgDimensionMember)row.getUserObject();
            } else {
                String name = row.getCell("name").getValue().toString();
                String number = row.getCell("number").getValue().toString();
                bgVariateInfo = new BgDimensionMember(null, this.getDimension() != null ? this.getDimension().getRefField() : null, name, number);
            }
            result.add(bgVariateInfo);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public List<BgDimensionMember> getPropertyLst(KDTable tblProRight) throws BOSException {
        if (tblProRight.getRowCount() == 0) {
            return null;
        }
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        BgDimensionMember bgPropertyInfo = null;
        IRow row = null;
        int count = tblProRight.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = tblProRight.getRow(index);
            if (row.getUserObject() != null && row.getUserObject() instanceof BgDimensionMember) {
                bgPropertyInfo = (BgDimensionMember)row.getUserObject();
            } else {
                String name = row.getCell("name").getValue().toString();
                String number = row.getCell("number").getValue().toString();
                String id = row.getCell("id").getValue().toString();
                String propSortName = row.getCell("proSortName").getValue().toString();
                bgPropertyInfo = new BgDimensionMember(null, this.getDimension() != null ? this.getDimension().getRefField() : null, name, number);
                bgPropertyInfo.setAttribute(id);
                bgPropertyInfo.setSortValue((Comparable)((Object)propSortName));
            }
            result.add(bgPropertyInfo);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    @Override
    protected void tblFuncRight_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int selectRowIndex = this.tblFuncRight.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncRight.getRow(selectRowIndex);
            String functionStr = row.getCell("name").getValue().toString();
            String functionName = MbgFunctionHelper.getFunctionNameByFunParam(functionStr);
            BgDimensionMember member = null;
            BgDetailMemberEnum detailMem = null;
            MbgViewListResultData resultListOne = null;
            MbgViewListResultData resultListTwo = null;
            if (functionName.indexOf("@Remove") != -1) {
                String param = functionStr.substring(functionStr.indexOf("("), functionStr.lastIndexOf(")"));
                String listOne = param.substring(param.indexOf("[") + 1, param.indexOf("L2") - 2);
                String listTwoTmp = param.substring(param.indexOf("L2"), param.lastIndexOf("]"));
                String listTwo = listTwoTmp.substring(listTwoTmp.indexOf("[") + 1);
                MbgFunctionHelper.getMemNumByScopeMemFunction(functionStr);
                resultListOne = BizCalcClientHelper.parseAllFXMultiMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)listOne);
                resultListTwo = BizCalcClientHelper.parseAllFXMultiMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)listTwo);
            } else {
                member = BizCalcClientHelper.parseFXMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)functionStr);
                detailMem = MbgFunctionHelper.getDetailMemberByFuncParam(functionStr);
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgId());
            uiContext.put((Object)DimensionConstants.DIMENSION, (Object)this.getDimension());
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeID());
            uiContext.put((Object)"MEMBER", (Object)member);
            uiContext.put((Object)"bgDetailMember", (Object)detailMem);
            uiContext.put((Object)"isOpenByExist", (Object)true);
            uiContext.put((Object)"existMember", (Object)functionStr);
            uiContext.put((Object)"ExistListOne", (Object)resultListOne);
            uiContext.put((Object)"ExistListTwo", (Object)resultListTwo);
            MbgFunctionProcess openFun = new MbgFunctionProcess(functionName, this, uiContext);
            openFun.process();
        }
        super.tblFuncRight_tableClicked(e);
    }

    @Override
    protected void tblFuncLeft_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getButton() == 1 && BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            int selectRowIndex = this.tblFuncLeft.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncLeft.getRow(selectRowIndex);
            String functionName = row.getCell("name").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgId());
            uiContext.put((Object)DimensionConstants.DIMENSION, (Object)(this.getDimension() == null ? ((SourceDisplayInfo)this.cbxDimension.getSelectedItem()).getDimension() : this.getDimension()));
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeID());
            uiContext.put((Object)"beginDate", (Object)this.beginDate);
            uiContext.put((Object)"endDate", (Object)this.endDate);
            MbgFunctionProcess process = new MbgFunctionProcess(functionName, this, uiContext);
            process.process();
        }
        super.tblFuncLeft_tableClicked(e);
    }

    public String getFormula() throws Exception {
        if (this.getData() != null && ((MbgViewListResultData)this.getData()).getMembers() != null && BgMemberSelectTypeEnum.Variate.equals((Object)this.getMemberSelectType())) {
            StringBuffer formula = new StringBuffer();
            formula.append("VAR").append(":").append("[").append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(((BgDimensionMember)((MbgViewListResultData)this.getData()).getMembers().get(0)).getNumber()).append(BgBaseConstants.DOUBLE_QUOTATION_STR).append("]");
            return formula.toString();
        }
        return "";
    }

    @Override
    protected void reFillData(DataChangeEvent eventObj) {
        MbgViewListResultData newData = (MbgViewListResultData)eventObj.getNewValue();
        BgMemberSelectTypeEnum memberType = newData.getMemberType();
        if (BgMemberSelectTypeEnum.Function == memberType) {
            // empty if block
        }
        super.reFillData(eventObj);
    }

    @Override
    protected void reFillPropertys(MbgViewListResultData newData) {
    }

    private void clearTableRrigt(BgMemberSelectTypeEnum type) {
        if (type == null) {
            return;
        }
        if (type.equals((Object)BgMemberSelectTypeEnum.Member)) {
            this.tblRight.removeRows();
        } else if (type.equals((Object)BgMemberSelectTypeEnum.Variate)) {
            this.tblVaRight.removeRows();
        } else if (type.equals((Object)BgMemberSelectTypeEnum.Function)) {
            this.tblFuncRight.removeRows();
        }
    }

    protected void setShareOrgUnSelect() {
        if (this.dimension != null && this.dimension.getNumber().equals("BG_Organization")) {
            IRow row = null;
            String name = null;
            for (int i = 0; i < this.tblLeft.getRowCount(); ++i) {
                row = this.tblLeft.getRow(i);
                if (row.getCell("name") == null || row.getCell("name").getValue() == null || (name = row.getCell("name").getValue().toString()).indexOf("(s)") == -1) continue;
                row.getStyleAttributes().setBackground(Color.GRAY);
            }
        }
    }

    @Override
    protected void add(List rows, boolean isProcessHide) {
        int i;
        if (rows == null || rows.isEmpty()) {
            return;
        }
        String number = null;
        String name = null;
        int fillType = 0;
        BgDimensionBaseInfo dimension = null;
        int type = ((DimensionMemberTypeEnum)((Object)this.cbxFillType.getSelectedItem())).getValue();
        boolean tag = false;
        HashSet<String> selectedNumbers = new HashSet<String>();
        for (i = 0; i < this.tblRight.getRowCount(); ++i) {
            dimension = ((SourceDisplayInfo)this.tblRight.getCell(i, "dimension").getValue()).getDimension();
            number = NumberExpandHelper.getNumber((IRow)this.tblRight.getRow(i));
            fillType = ((DimensionMemberTypeEnum)((Object)this.tblRight.getRow(i).getCell("fillType").getValue())).getValue();
            selectedNumbers.add(dimension.getNumber() + "_" + number + String.valueOf(fillType));
        }
        dimension = DimensionClientHelper.getSelectDimension(this.cbxDimension);
        for (i = 0; i < rows.size(); ++i) {
            int rowIndex = (Integer)rows.get(i);
            IRow row = this.tblLeft.getRow(rowIndex);
            name = row.getCell("name").getValue().toString();
            if (!isProcessHide && row.getStyleAttributes().isHided() || this.isMoveVirtualOrg(row)) continue;
            number = NumberExpandHelper.getNumber((IRow)row);
            if (selectedNumbers.contains(dimension.getNumber() + "_" + number + String.valueOf(type))) continue;
            this.addOneRow(dimension, rowIndex, type, isProcessHide);
            if (type != 0 && !(row.getUserObject() instanceof TreeBaseInfo)) continue;
        }
        if (tag) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgTemplateResource", (String)"checkMemberNumber"));
        }
    }

    protected boolean isMoveVirtualOrg(IRow row) {
        String name = row.getCell("name").getValue().toString();
        return row.getStyleAttributes().getBackground().equals(Color.GRAY) || name.indexOf("(s)") != -1;
    }

    @Override
    protected void tblVaLeft_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            boolean isMultiSelect = this.cbxSelectType.isEnabled() || this.isMultiSelect();
            BgViewMemberSelectHelper.doubleVaClick(this.tblVaLeft, this.tblVaRight, isMultiSelect, false);
        }
    }

    protected void quickQuery() throws BOSException, EASBizException {
        if (this.checkIsDefaultSearchTipInfo()) {
            if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
                this.initFunctionType();
            }
            return;
        }
        if (BgMemberSelectTypeEnum.Function.equals((Object)this.getMemberSelectType())) {
            this.initFunctionType();
            int rowCount = this.tblFuncLeft.getRowCount3();
            IRow curRow = null;
            String functionName = null;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                curRow = this.tblFuncLeft.getRow(rowIndex);
                functionName = curRow.getCell("name").getValue().toString();
                if (functionName.indexOf(this.txtQuickQueryInput.getText()) != -1) continue;
                curRow.getStyleAttributes().setHided(true);
            }
        }
    }

    @Override
    protected void doQuickQuery() {
        super.doQuickQuery();
        if (this.getMemberSelectType().equals((Object)BgMemberSelectTypeEnum.Member)) {
            this.setShareOrgUnSelect();
        }
    }

    @Override
    protected KDTable getLeftTable() {
        BgMemberSelectTypeEnum memberSelectType;
        BgMemberSelectTypeEnum bgMemberSelectTypeEnum = memberSelectType = this.cbxSelectType == null ? null : this.getMemberSelectType();
        if (BgMemberSelectTypeEnum.Function.equals((Object)memberSelectType)) {
            return this.tblFuncLeft;
        }
        if (BgMemberSelectTypeEnum.Variate.equals((Object)memberSelectType)) {
            return this.tblVaLeft;
        }
        if (BgMemberSelectTypeEnum.Property.equals((Object)memberSelectType)) {
            return this.tblProLeft;
        }
        return super.getLeftTable();
    }

    @Override
    protected boolean isMemberByOrg() {
        BgMemberSelectTypeEnum memberSelectType;
        BgMemberSelectTypeEnum bgMemberSelectTypeEnum = memberSelectType = this.cbxSelectType == null ? BgMemberSelectTypeEnum.Member : this.getMemberSelectType();
        return BgMemberSelectTypeEnum.Member.equals((Object)memberSelectType);
    }

    protected boolean checkIsDefaultSearchTipInfo() {
        String cq = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"404_NewDimensionMemberF7UI");
        return StringUtils.equals((String)((String)this.txtQuickQueryInput.getUserObject()), (String)this.txtQuickQueryInput.getText()) || StringUtils.equals((String)cq, (String)this.txtQuickQueryInput.getText()) || "".equals(this.txtQuickQueryInput.getText());
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectType != null && this.selectType.equals((Object)BgMemberSelectTypeEnum.Variate)) {
            this.initVariateType();
        } else {
            super.actionRefresh_actionPerformed(e);
            if (this.getMemberSelectType().equals((Object)BgMemberSelectTypeEnum.Member)) {
                this.setShareOrgUnSelect();
            }
        }
    }

    @Override
    protected NewDimensionMemberF7UI.FilterFieldItem[] getFilterFields() {
        NewDimensionMemberF7UI.FilterFieldItem[] ffis = new NewDimensionMemberF7UI.FilterFieldItem[]{new NewDimensionMemberF7UI.FilterFieldItem(this, "number", this.getMLS("number", "Number"), ConstDataType.STRING), new NewDimensionMemberF7UI.FilterFieldItem(this, "name", this.getMLS("name", "Name"), ConstDataType.STRING)};
        ffis = this.addNumberNameCompFilter(ffis);
        return ffis;
    }
}

