/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMBgAnalyseBaseUI;
import com.kingdee.eas.ma.mbg.client.MBgAnalyseFilterBaseUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import org.apache.log4j.Logger;

public class MBgAnalyseBaseUI
extends AbstractMBgAnalyseBaseUI {
    private static final long serialVersionUID = 5842850137274288832L;
    private static final Logger logger = CoreUIObject.getLogger(MBgAnalyseBaseUI.class);
    protected IMetaDataPK mainQueryPk = null;
    private CommonQueryDialog dialog = null;
    private MBgAnalyseFilterBaseUI filterUI = null;
    protected FilterParam filterParam = null;
    public boolean isDefaultQuery = false;

    public void setMainQueryPk(IMetaDataPK mainQueryPk) {
        this.mainQueryPk = mainQueryPk;
    }

    public IMetaDataPK getMainQueryPk() {
        return this.mainQueryPk;
    }

    protected IMetaDataPK createQueryPk() {
        return MetaDataPK.create((String)"com.kingdee.eas.ma.base.BgElementQuery");
    }

    public void setDialog(CommonQueryDialog dialog) {
        this.dialog = dialog;
    }

    public CommonQueryDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = this.createCommonQueryDialog();
        }
        return this.dialog;
    }

    public void setFilterUI(MBgAnalyseFilterBaseUI filterUI) {
        this.filterUI = filterUI;
    }

    public MBgAnalyseFilterBaseUI getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = (MBgAnalyseFilterBaseUI)((Object)Class.forName(this.getFilterUIName()).newInstance());
                this.filterUI.setOwnerUi(this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.filterUI;
    }

    public String getFilterUIName() {
        return MBgAnalyseFilterBaseUI.class.getName();
    }

    public void setFilterParam(FilterParam filterParam) {
        this.filterParam = filterParam;
    }

    public void setFilterParam(CustomerParams cp) {
        this.setFilterParam(this.getFilterUI().getFilterParam(cp));
    }

    public FilterParam getFilterParam() {
        return this.filterParam;
    }

    public MBgAnalyseBaseUI() throws Exception {
        this.setMainQueryPk(this.createQueryPk());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(this.getUITitle());
        boolean hasDefaultQuery = this.hasDefaultQuery();
        if (hasDefaultQuery) {
            this.isDefaultQuery = true;
            this.executeQuery();
            this.isDefaultQuery = false;
        } else {
            this.setDialog(this.createCommonQueryDialog());
            if (this.getDialog() != null && this.getDialog().show()) {
                this.setFilterParam(this.getFilterUI().getCustomerParams());
                this.dealOtherFilter();
                this.executeQuery();
            } else {
                SysUtil.abort();
            }
        }
    }

    protected void dealOtherFilter() {
    }

    protected void executeQuery() throws Exception {
    }

    protected IQuerySolutionFacade getQueryFacadeInterface() throws BOSException {
        return QuerySolutionFacadeFactory.getRemoteInstance();
    }

    protected String getQueryMainName() {
        return MBgAnalyseBaseUI.class.getName();
    }

    protected boolean hasDefaultQuery() throws Exception {
        QuerySolutionInfo ds = this.getQueryFacadeInterface().getDefaultSolution(this.getQueryMainName(), this.getMainQueryPk().getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            if (cp.getCustomerParamsHashMap().get("ANALYSE_SCHEME_ID") != null) {
                String schemeId = cp.getCustomerParamsHashMap().get("ANALYSE_SCHEME_ID").toString();
                if (!BgSchemeFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)schemeId)))) {
                    return false;
                }
            }
            this.setFilterParam(cp);
        }
        return this.getFilterParam() != null;
    }

    protected CommonQueryDialog createCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setOwner((Component)this.getUIContext().get("Owner"));
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK(this.getMainQueryPk());
        dialog.setTitle(this.getFilterUI().getUITitle());
        dialog.setWidth(this.getWidthOfDialog());
        dialog.setHeight(this.getHeightOfDialog());
        dialog.setMaxReturnCountVisible(this.hasShowMaxReturnCount());
        dialog.addUserPanel((KDPanel)this.getFilterUI());
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        return dialog;
    }

    protected boolean hasShowMaxReturnCount() {
        return false;
    }

    protected int getWidthOfDialog() {
        return 640;
    }

    protected int getHeightOfDialog() {
        return 480;
    }
}

