/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IMBgAnalyseFacade;
import com.kingdee.eas.ma.mbg.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMBgAnalyseFilterUI;
import com.kingdee.eas.ma.mbg.query.BaseFilterParam;
import com.kingdee.eas.ma.mbg.query.BgAnalyseConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class MBgAnalyseFilterUI
extends AbstractMBgAnalyseFilterUI {
    private static final long serialVersionUID = -686523714685122326L;
    private static final Logger logger = CoreUIObject.getLogger(MBgAnalyseFilterUI.class);
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private String ANALYSE_SCHEME_ID = "ANALYSE_SCHEME_ID";
    private String ANALYSE_ORGUNIT_IDS = "ANALYSE_ORGUNIT_IDS";
    private String BG_ORGUNIT_IDS = "BG_ORGUNIT_IDS";

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public CtrlUnitInfo getCurrCU() {
        return this.currCU;
    }

    public String getResourceStr() {
        return BgAnalyseConstants.ANALYSE_RESOURCESTR;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initBiz();
    }

    protected void initBiz() {
        this.initOrgUnit();
    }

    protected void initOrgUnit() {
        this.prmtOrgUnit.setEditable(false);
        BgCommCHelper.initOrgUnit((CoreUIObject)this, (KDBizPromptBox)this.prmtOrgUnit, (Object)this.getCurrOrgUnit(), (String)this.getCurrCU().getId().toString(), (boolean)this.isMultiSelect());
    }

    protected IMBgAnalyseFacade getInterface() throws BOSException {
        return MBgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected boolean isMultiSelect() {
        return false;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
    }

    protected List<OrgUnitInfo> getOrgUnit() {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] _orgUnits = (OrgUnitInfo[])this.prmtOrgUnit.getData();
            int in = _orgUnits.length;
            for (int i = 0; i < in; ++i) {
                orgUnits.add(_orgUnits[i]);
            }
        } else if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            OrgUnitInfo _orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
            orgUnits.add(_orgUnit);
        }
        return orgUnits;
    }

    protected List<String> getOrgUnitIds() {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])this.prmtOrgUnit.getData();
            int in = orgUnits.length;
            for (int i = 0; i < in; ++i) {
                orgUnitIds.add(orgUnits[i].getId().toString());
            }
        } else if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            OrgUnitInfo _orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
            orgUnitIds.add(_orgUnit.getId().toString());
        }
        return orgUnitIds;
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re && this.prmtOrgUnit.getData() == null) {
            this.prmtOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectOrgUnit"));
            re = false;
        }
        return re;
    }

    @Override
    protected FilterParam createFilterParam() {
        return new BaseFilterParam();
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BaseFilterParam)) {
            return;
        }
        List ids = null;
        ArrayList bgOrgUnitIds = null;
        BaseFilterParam _filterParam = (BaseFilterParam)filterParam;
        ids = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(this.ANALYSE_ORGUNIT_IDS)));
        if (ids != null) {
            OrgUnitInfo orgUnit = null;
            for (String id : ids) {
                orgUnit = new OrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)id));
                _filterParam.getOrgUnits().add(orgUnit);
            }
        }
        if ((bgOrgUnitIds = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam(this.BG_ORGUNIT_IDS))) != null && !bgOrgUnitIds.isEmpty()) {
            BgOrgUnitInfo[] bgOrgUnitInfos = new BgOrgUnitInfo[bgOrgUnitIds.size()];
            for (int i = 0; i < bgOrgUnitIds.size(); ++i) {
                bgOrgUnitInfos[i] = new BgOrgUnitInfo();
                bgOrgUnitInfos[i].setId(BOSUuid.read((String)((String)bgOrgUnitIds.get(i))));
            }
            _filterParam.setBgOrgUnits(bgOrgUnitInfos);
        } else {
            _filterParam.setBgOrgUnits(this.getBgOrgByCostOrg(cp, _filterParam));
        }
    }

    protected BgOrgUnitInfo[] getBgOrgByCostOrg(CustomerParams cp, FilterParam filterParam) {
        BgOrgUnitInfo[] bgOrgUnitInfos = null;
        String bgSchemeId = null;
        List orgIds = null;
        Object bgOrgUnitIds = null;
        BaseFilterParam _filterParam = (BaseFilterParam)filterParam;
        orgIds = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(this.ANALYSE_ORGUNIT_IDS)));
        bgSchemeId = cp.getCustomerParam(this.ANALYSE_SCHEME_ID);
        if (!StringUtils.isEmpty((String)bgSchemeId) && orgIds != null && !orgIds.isEmpty()) {
            try {
                String bgOrgViewId = MbgAnalyseExeHelper.getBudgetViewID((String)bgSchemeId);
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", new HashSet(orgIds), CompareType.INCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
                if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
                    bgOrgUnitInfos = new BgOrgUnitInfo[bgOrgUnitCollection.size()];
                    for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                        bgOrgUnitInfos[i] = bgOrgUnitCollection.get(i);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return bgOrgUnitInfos;
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BaseFilterParam)) {
            return;
        }
        ArrayList<String> ids = null;
        ArrayList<String> bgOrgUnitIds = null;
        BaseFilterParam _filterParam = (BaseFilterParam)filterParam;
        if (!_filterParam.getOrgUnits().isEmpty()) {
            ids = new ArrayList<String>();
            for (OrgUnitInfo orgUnit : _filterParam.getOrgUnits()) {
                ids.add(orgUnit.getId().toString());
            }
            cp.addCustomerParam(this.ANALYSE_ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(ids)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_ORGUNIT_IDS);
        }
        if (_filterParam.getBgOrgUnits() != null) {
            bgOrgUnitIds = new ArrayList<String>();
            for (BgOrgUnitInfo bg : _filterParam.getBgOrgUnits()) {
                bgOrgUnitIds.add(bg.getId().toString());
            }
            cp.addCustomerParam(this.BG_ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(bgOrgUnitIds)));
        } else {
            cp.removeCustomerParam(this.BG_ORGUNIT_IDS);
        }
    }

    @Override
    protected void loadFromParams(FilterParam filterParam) {
        super.loadFromParams(filterParam);
        if (!(filterParam instanceof BaseFilterParam)) {
            return;
        }
        BaseFilterParam _filterParam = (BaseFilterParam)filterParam;
        if (!_filterParam.getOrgUnits().isEmpty()) {
            OrgUnitInfo[] orgUnits = new OrgUnitInfo[_filterParam.getOrgUnits().size()];
            int in = _filterParam.getOrgUnits().size();
            for (int i = 0; i < in; ++i) {
                orgUnits[i] = _filterParam.getOrgUnits().get(i);
            }
            this.prmtOrgUnit.setData((Object)orgUnits);
        } else {
            this.prmtOrgUnit.setData(null);
        }
    }

    @Override
    protected void saveToParams(FilterParam filterParam) {
        super.saveToParams(filterParam);
        if (!(filterParam instanceof BaseFilterParam)) {
            return;
        }
        BaseFilterParam _filterParam = (BaseFilterParam)filterParam;
        _filterParam.getOrgUnits().clear();
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])this.prmtOrgUnit.getData();
            int in = orgUnits.length;
            for (int i = 0; i < in; ++i) {
                _filterParam.getOrgUnits().add(orgUnits[i]);
            }
        } else if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            OrgUnitInfo _orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
            _filterParam.getOrgUnits().add(_orgUnit);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
    }
}

