/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgAdjustBalanceUI;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgAdjustBalanceUI
extends AbstractMbgAdjustBalanceUI
implements ISimpleQuickQueryHandler {
    private static final long serialVersionUID = 2357948057478369998L;
    private static final Logger logger = CoreUIObject.getLogger(MbgAdjustBalanceUI.class);
    private SimpleQuickQueryHandler queryQuery = null;
    protected boolean isFirstSortTable = true;
    protected KDTSortManager sm = null;
    protected int sort = 0;

    public void onLoad() throws Exception {
        this.queryQuery = new SimpleQuickQueryHandler(this.txtQuickSearch, (ISimpleQuickQueryHandler)this, EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"quickQueryText"));
        super.onLoad();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                MbgAdjustBalanceUI.this.tblMain_tableClicked(e);
            }
        });
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        for (int c = 0; c < this.tblMain.getColumnCount(); ++c) {
            this.tblMain.getColumn(c).setSortable(true);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(e);
            return;
        }
    }

    private void OrderByForTable(KDTMouseEvent e) {
        if (e.getType() == 0) {
            String columnName;
            if (this.isFirstSortTable) {
                this.sm = new KDTSortManager(this.tblMain){

                    protected void changeHeadStatus(int oldIndex, int newIndex, int sortType) {
                        super.changeHeadStatus(oldIndex, newIndex, sortType);
                    }
                };
                this.sm.setSortAuto(true);
            }
            if ((columnName = this.tblMain.getColumn(e.getColIndex()).getKey()) == null) {
                return;
            }
            this.sort = this.sort == 0 ? 1 : 0;
            this.sm.sort(e.getColIndex(), this.sort);
            this.tblMain.updateUI();
            this.isFirstSortTable = false;
        }
    }

    protected IBudgetBalance queryBalance() throws BOSException, EASBizException {
        if (this.sm != null) {
            this.sm.clear();
        }
        this.sort = 0;
        List<BgNDataInfo> adjustList = this.getAdjustList();
        if (adjustList == null || adjustList.isEmpty()) {
            return null;
        }
        HashMap adjustMap = new HashMap();
        for (BgNDataInfo data : adjustList) {
            if (!adjustMap.containsKey(data.getOrgUnitId())) {
                adjustMap.put(data.getOrgUnitId(), new HashMap());
            }
            ((Map)adjustMap.get(data.getOrgUnitId())).put(data.getFormula(), data.getAdjustValue());
        }
        IBudgetBalance balance = BgAdjustFacadaFactory.getRemoteInstance().showAdjustBalance(this.getBgSchemeId(), adjustMap, this.chkShowParent.isSelected());
        if (balance == null || balance.getBalance() == null || balance.getBalance().isEmpty()) {
            return balance;
        }
        HashMap<String, BgControlParam> paramMap = new HashMap<String, BgControlParam>();
        BgControlParam param = null;
        for (int i = 0; i < balance.getBalance().size(); ++i) {
            param = (BgControlParam)balance.getBalance().get(i);
            paramMap.put(this.getKey(param.getOrgUnit().getId().toString(), param.getFormula()), param);
        }
        BgNDataInfo data = null;
        for (int i = adjustList.size() - 1; i >= 0; --i) {
            data = adjustList.get(i);
            param = (BgControlParam)paramMap.get(this.getKey(data.getOrgUnitId(), data.getFormula()));
            if (param == null) continue;
            balance.getBalance().remove(param);
            balance.getBalance().add(0, param);
        }
        return balance;
    }

    protected String getKey(String orgId, String formula) {
        return orgId + "_" + formula;
    }

    protected String getBgSchemeId() {
        return (String)this.getUIContext().get("BGSCHEME_ID");
    }

    protected List<BgNDataInfo> getAdjustList() {
        return (List)this.getUIContext().get("InitDataObject");
    }

    @Override
    protected void chkShowParent_actionPerformed(ActionEvent e) throws Exception {
        this.showBalance();
    }

    protected void showBalance() throws EASBizException, BOSException {
        super.showBalance();
        this.quickQuery();
    }

    protected void setControlSettingColor(BgControlParam param, IRow row) {
    }

    public void doQuickQuery() {
        this.quickQuery();
    }

    protected void quickQuery() {
        IRow row = null;
        String queryText = this.queryQuery.getFilterString();
        boolean isShow = false;
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            row = this.tblMain.getRow(r);
            isShow = false;
            if (StringUtils.isEmpty((String)queryText)) {
                isShow = true;
            } else {
                for (int c = 0; c < this.tblMain.getColumnCount(); ++c) {
                    if (this.tblMain.getColumn(c).getStyleAttributes().isHided()) continue;
                    String displayText = null;
                    if ("orgUnit".equals(this.tblMain.getColumnKey(c)) && row.getCell(c).getValue() instanceof OrgUnitInfo) {
                        displayText = this.getCellHelper().getOrgUnitString((OrgUnitInfo)row.getCell(c).getValue());
                    }
                    if (displayText == null) {
                        displayText = String.valueOf(row.getCell(c).getValue());
                    }
                    if (displayText.indexOf(queryText) < 0) continue;
                    isShow = true;
                    break;
                }
            }
            row.getStyleAttributes().setHided(!isShow);
        }
    }
}

