/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.FtpException;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.client.AttachmentByBoListUI;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgAttachmentByBoListUI
extends AttachmentByBoListUI {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.client.MbgAttachmentByBoListUI");
    private static final long serialVersionUID = 2389942967985832290L;
    private String curFormId = null;
    private BgSchemeInfo bgSchemeInfo;

    public String getCurFormId() {
        return this.curFormId;
    }

    public void setCurFormId(String curFormId) {
        this.curFormId = curFormId;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curFormId = (String)this.getUIContext().get("CURRENT_FORM_ID");
        this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            // empty if block
        }
    }

    protected void checkFilled() throws EASBizException, BOSException {
        BgSchemeInfo scheme = this.getBgSchemeInfo();
        if (scheme != null) {
            BgSchemeFactory.getRemoteInstance().checkFilling(scheme.getId().toString());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkFilled();
        super.actionEdit_actionPerformed(e);
    }

    public void actionModifyContent_actionPerformed(ActionEvent e) throws Exception {
        this.checkFilled();
        super.actionModifyContent_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkFilled();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkFilled();
        if (this.confirmRemove()) {
            block7: {
                try {
                    AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
                    IIDList idList = attachmentClientManager.getIdInTable(this.tblMain, this.getKeyFieldName());
                    StringBuilder message = new StringBuilder();
                    IIDList canRemoveIds = this.canRemoveIds(attachmentClientManager, idList, message);
                    if (canRemoveIds.size() == 0) {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"attachAllFail"), (String)message.toString(), (int)1);
                        return;
                    }
                    attachmentClientManager.deleteAssoAttachment(this.getCurFormId(), canRemoveIds);
                    if (message.length() == 0) {
                        MsgBox.showInfo((String)Resrcs.getString((String)"DeleteSuccess"));
                    } else {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"attachPartialSuccess"), (String)message.toString(), (int)1);
                    }
                }
                catch (ObjectNotFoundException onfe) {
                    this.logger.info((Object)"", (Throwable)onfe);
                    this.refreshList();
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                catch (BOSException be) {
                    if (!StringUtils.equals((String)"java.io.IOException", (String)be.getCauseClassName()) && !StringUtils.equals((String)"com.enterprisedt.net.ftp.FTPException", (String)be.getCauseClassName())) break block7;
                    throw new FtpException(FtpException.FTPCONNECTEDFAIL);
                }
            }
            this.refresh(e);
        }
    }

    private IIDList canRemoveIds(AttachmentClientManager attachmentClientManager, IIDList idList, StringBuilder message) throws BOSException {
        HashSet<String> boIDs;
        RealModeIDList canRemoveIds = new RealModeIDList();
        Set<String> attachIds = this.getSelectedIds(attachmentClientManager, idList);
        IBoAttchAsso instance = BoAttchAssoFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("boID");
        selector.add("attachment.id");
        selector.add("attachment.name");
        view.setSelector(selector);
        AttachmentUIContextInfo attachCtxInfo = (AttachmentUIContextInfo)this.getUIContext().get(AttachmentUIContextInfo.class.getName());
        String boID = attachCtxInfo.getBoID();
        String[] boIds = attachCtxInfo.getBoIDs();
        if (boIds != null && boIds.length != 0) {
            boIDs = new HashSet<String>(Arrays.asList(boIds));
        } else {
            boIDs = new HashSet<String>();
            boIDs.add(boID);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("attachment.id", attachIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("boID", boIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        BoAttchAssoCollection boAttchAssoColls = instance.getBoAttchAssoCollection(view);
        for (BoAttchAssoInfo assoInfo : boAttchAssoColls) {
            if (assoInfo.getBoID() != null && assoInfo.getBoID().equals(this.curFormId)) {
                canRemoveIds.add(assoInfo.getAttachment().getId().toString());
                continue;
            }
            message.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"removeAttachmentError", (Object[])new Object[]{assoInfo.getAttachment().getName()})).append("\r\n");
        }
        return canRemoveIds;
    }

    private Set<String> getSelectedIds(AttachmentClientManager attachmentClientManager, IIDList idList) {
        HashSet<String> ids = new HashSet<String>(idList.getCount());
        int in = idList.getCount();
        for (int i = 0; i < in; ++i) {
            ids.add(idList.getID(i));
        }
        return ids;
    }
}

