/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.client.BizCalcListUI;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.mbg.BgDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDataDetailUI;
import com.kingdee.eas.ma.mbg.common.MbgDataDetailInfo;
import com.kingdee.eas.ma.mbg.common.MbgDataDetailMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataDetailUI
extends AbstractMbgDataDetailUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDataDetailUI.class);
    private final String col_dimmension = "dimmension";
    private final String col_member = "member";
    private final String col_description = "description";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tfBizCalc.setFocusable(false);
        this.fillData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.chbLock.setEnabled(false);
        this.chbForceLock.setEnabled(false);
        this.tfBizCalc.setEditable(false);
        this.chbDetail.setEnabled(false);
        this.cbDataState.setEnabled(false);
        this.prmtAuditOrg.setEnabled(false);
        this.prmtReOrg.setEnabled(false);
        this.cbDetailOrgAudit.setEnabled(false);
        this.prmtBgForm.setEnabled(false);
        this.prmtAuditFormOrg.setEnabled(false);
        this.prmtAuditFormNum.setEnabled(false);
        this.cbCreateType.setEnabled(false);
        this.tfFormulaBizCalc.setEditable(false);
    }

    public void fillData() throws BOSException {
        int i;
        int i2;
        MbgDataDetailInfo info = null;
        if (this.getUIContext().get("InitDataObject") instanceof MbgDataDetailInfo) {
            info = (MbgDataDetailInfo)this.getUIContext().get("InitDataObject");
        }
        String editScen = "";
        if (this.getUIContext().get("editScen") != null) {
            editScen = (String)this.getUIContext().get("editScen");
        }
        if (info == null) {
            return;
        }
        String shi = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"shi");
        String fou = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"fou");
        this.chbLock.setSelected(info.isLock());
        this.chbForceLock.setSelected(info.isForceLock());
        if (!info.getExpressionBizCals().isEmpty()) {
            this.tfBizCalc.setUserObject(info.getExpressionBizCals());
            String str = "";
            for (i2 = 0; i2 < info.getExpressionBizCals().size(); ++i2) {
                str = str + info.getExpressionBizCals().get(i2).getNumber() + ",";
            }
            if (str.length() > 0 && str.endsWith(",")) {
                str = str.substring(0, str.length() - 1);
            }
            this.tfBizCalc.setText(str);
            this.tfBizCalc.setCustomForegroundColor(Color.BLUE);
        }
        if (StringUtils.isEmpty((String)info.getFormula())) {
            return;
        }
        this.cbDataState.removeAllItems();
        for (i = 0; i < BgDataStateEnum.getEnumList().size(); ++i) {
            this.cbDataState.addItem(BgDataStateEnum.getEnumList().get(i));
        }
        this.cbCreateType.removeAllItems();
        for (i = 0; i < BgDataSourceEnum.getEnumList().size(); ++i) {
            this.cbCreateType.addItem(BgDataSourceEnum.getEnumList().get(i));
        }
        this.cbDetailOrgAudit.removeAllItems();
        if (info.getDataState() != null) {
            this.cbDetailOrgAudit.addItem((Object)shi);
            this.cbDetailOrgAudit.addItem((Object)fou);
        }
        this.chbDetail.setSelected(info.isDetail());
        this.cbDataState.setSelectedItem((Object)info.getDataState());
        this.prmtAuditOrg.setData((Object)info.getAuditDataOrg());
        this.prmtReOrg.setData((Object)info.getReportOrg());
        if (info.getDataState() != null) {
            if (info.isDetailOrgAudit()) {
                this.cbDetailOrgAudit.setSelectedItem((Object)shi);
            } else {
                this.cbDetailOrgAudit.setSelectedItem((Object)fou);
            }
        }
        if (!StringUtils.isEmpty((String)info.getRefFormNumber())) {
            this.prmtBgForm.setData((Object)info.getRefFormNumber());
        }
        this.prmtAuditFormOrg.setData((Object)info.getAuditFormOrg());
        this.prmtAuditFormNum.setData((Object)info.getAuditFormNumber());
        this.cbCreateType.setSelectedItem((Object)info.getBgDataSource());
        if (!info.getFormulaBizCalcs().isEmpty()) {
            this.tfFormulaBizCalc.setUserObject(info.getFormulaBizCalcs());
            String str = "";
            for (i2 = 0; i2 < info.getFormulaBizCalcs().size(); ++i2) {
                str = str + info.getFormulaBizCalcs().get(i2).getNumber() + ",";
            }
            if (str.length() > 0 && str.endsWith(",")) {
                str = str.substring(0, str.length() - 1);
            }
            this.tfFormulaBizCalc.setText(str);
            this.tfFormulaBizCalc.setCustomForegroundColor(Color.BLUE);
        }
        Set bgScenNums = BgScenarioHelper.getBgScenNums(null);
        if (info.getMembers() != null && !info.getMembers().isEmpty()) {
            this.tblMain.removeRows();
            IRow row = null;
            MbgDataDetailMember member = null;
            for (int i3 = 0; i3 < info.getMembers().size(); ++i3) {
                member = info.getMembers().get(i3);
                row = this.tblMain.addRow();
                row.getCell("dimmension").setValue((Object)member.getDimName());
                if (member.getDimNumber().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                    String description = "";
                    if (!StringUtils.isEmpty((String)editScen)) {
                        String[] editScens = editScen.split(",");
                        boolean isEditScen = false;
                        for (int x = 0; x < editScens.length; ++x) {
                            if (!member.getMemberNumber().equals(editScens[x])) continue;
                            isEditScen = true;
                            break;
                        }
                        description = bgScenNums.contains(member.getMemberNumber()) ? (isEditScen ? BgNFSHelper.getHardCodeRes("scenarioIsBg") : BgNFSHelper.getHardCodeRes("notScenarioIsBg")) : (isEditScen ? BgNFSHelper.getHardCodeRes("scenarioIsAct") : BgNFSHelper.getHardCodeRes("notScenarioIsAct"));
                    } else {
                        description = bgScenNums.contains(member.getMemberNumber()) ? BgNFSHelper.getHardCodeRes("scenarioIsBg") : BgNFSHelper.getHardCodeRes("scenarioIsAct");
                    }
                    row.getCell("member").setValue((Object)(member.getMemberName() + "(" + member.getMemberNumber() + ")"));
                    row.getCell("description").setValue((Object)description);
                    continue;
                }
                if (member.getDimNumber().equals(DimensionConstants.DEF_PROCESSTYPE_NUMBER)) {
                    row.getCell("member").setValue((Object)member.getMemberName());
                } else if (!StringUtils.isEmpty((String)member.getMemberNumber())) {
                    row.getCell("member").setValue((Object)(member.getMemberName() + "(" + member.getMemberNumber() + ")"));
                }
                row.getCell("description").setValue((Object)member.getDescription());
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void tfBizCalc_mouseClicked(MouseEvent e) throws Exception {
        this.tfBizCalc.setFocusable(true);
        if (e.getClickCount() == 2 && e.getSource() != null && e.getSource() instanceof KDTextField) {
            this.openBizCalc((KDTextField)e.getSource());
        }
    }

    @Override
    protected void tfFormulaBizCalc_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getSource() != null && e.getSource() instanceof KDTextField) {
            this.openBizCalc((KDTextField)e.getSource());
        }
    }

    protected void openBizCalc(KDTextField field) throws Exception {
        String selectText;
        if (field == null || StringUtils.isEmpty((String)field.getSelectedText()) || field.getUserObject() == null) {
            return;
        }
        String fieldText = field.getText();
        String bizNumber = selectText = field.getSelectedText();
        List bizCalcs = (List)field.getUserObject();
        for (int i = 0; i < bizCalcs.size(); ++i) {
            if (!bizNumber.equals(((BizCalcInfo)bizCalcs.get(i)).getNumber())) continue;
            BizCalcListUI.showBizEditUI((CoreUI)this, null, (String)((BizCalcInfo)bizCalcs.get(i)).getId().toString(), (BgSchemeInfo)((BizCalcInfo)bizCalcs.get(i)).getBgScheme(), (String)BizCalcMainUI.class.getName(), (String)OprtState.VIEW);
        }
    }
}

