/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgCustomerParamsFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgCustomerParamsFacade;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDataStateSynNewUI;
import com.kingdee.eas.ma.mbg.client.BgTemplateDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgDataStateSynClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.MbgDataStateSynFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgTemplateObject;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataStateSynNewUI
extends AbstractMbgDataStateSynNewUI {
    private static final long serialVersionUID = 5774582189509178340L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDataStateSynNewUI.class);
    private String BG_COSTCENTER_FLAG = "BG_COSTCENTER_FLAG";
    private String BG_SCHEME_FLAG = "BG_SCHEME_FLAG";
    private String BG_ORGUNIT_FLAG = "BG_ORGUNIT_FLAG";
    private String BG_TYPE_FLAG = "BG_TYPE_FLAG";
    private String BG_TEMPLATE_FLAG = "BG_TEMPLATE_FLAG";
    private String BG_PERIOD_FLAG = "BG_PERIOD_FLAG";
    private String BG_VERSION_FLAG = "BG_VERSION_FLAG";
    private String BG_CURRENCY_FLAG = "BG_CURRENCY_FLAG";
    private String BG_FORMSTATE_FLAG = "BG_FORMSTATE_FLAG";
    private List bgFormIds = null;
    Map<String, Object> defaultMap = new HashMap<String, Object>();
    private OrgUnitInfo costCenter = null;
    private RptSrcTypeEnum sourceType = RptSrcTypeEnum.PT_BUDGET_REPORT;
    private BgSchemeInfo bgschemeInfo = null;
    protected BgSchemeDimensionHelper schemeHelper = null;
    protected CoreUI owner = null;

    public List getBgFormIds() {
        return this.bgFormIds;
    }

    public void setBgFormIds(List bgFormIds) {
        this.bgFormIds = bgFormIds;
    }

    public void setOrgUnit(OrgUnitInfo costCenter) {
        this.costCenter = costCenter;
    }

    private OrgUnitInfo getOrgUnit() {
        return this.costCenter;
    }

    public RptSrcTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(RptSrcTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public void setBgschemeInfo(BgSchemeInfo bgschemeInfo) {
        this.bgschemeInfo = bgschemeInfo;
    }

    public BgSchemeInfo getBgschemeInfo() {
        return this.bgschemeInfo;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.getBgschemeInfo() != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getBgschemeInfo().getId().toString());
        }
        return this.schemeHelper;
    }

    public CoreUI getOwner() {
        return this.owner;
    }

    public MbgDataStateSynNewUI(CoreUI owner, BgSchemeInfo bgscheme) throws Exception {
        this.owner = owner;
        this.bgschemeInfo = bgscheme;
        this.getUIContext().put("Owner", owner);
    }

    public MbgDataStateSynNewUI() throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterOnLoad();
    }

    public void actionDataStateSyn_actionPerformed() throws Exception {
        MbgDataStateSynClientHelper.startSynNew(this, (BgSchemeInfo)this.prmtBgScheme.getData(), this.prmtBgOrgUnit.getData(), this.prmtBgTemplate.getData(), this.prmtBgPeriod.getData(), this.prmtBgVersion.getData(), this.prmtCurrency.getData(), this.rbAudit.isSelected() ? BgFormStateEnum.Approved : BgFormStateEnum.UnionReceive);
    }

    protected Boolean checkHasBgForms() throws Exception {
        return MbgDataStateSynClientHelper.checkHasBgForms(this, (BgSchemeInfo)this.prmtBgScheme.getData(), this.prmtBgOrgUnit.getData(), this.prmtBgTemplate.getData(), this.prmtBgPeriod.getData(), this.prmtBgVersion.getData(), this.prmtCurrency.getData(), this.rbAudit.isSelected() ? BgFormStateEnum.Approved : BgFormStateEnum.UnionReceive);
    }

    protected void afterOnLoad() throws Exception {
        this.txtDescription.setText(MbgDataStateSynClientHelper.getString("description.line3"));
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) != null) {
            this.setOrgUnit((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        } else {
            this.setOrgUnit(SysContext.getSysContext().getCurrentOrgUnit());
        }
        if (this.getUIContext().get("sourceType") != null) {
            this.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType")));
        }
        if (this.getUIContext().get("BGFORM_IDS") != null) {
            this.setBgFormIds((List)this.getUIContext().get("BGFORM_IDS"));
        }
        this.queryDefault();
        this.initF7();
    }

    protected void queryDefault() throws BOSException, EASBizException {
        this.defaultMap.put(this.BG_COSTCENTER_FLAG, this.getOrgUnit());
        this.defaultMap.put(this.BG_SCHEME_FLAG, this.getBgschemeInfo());
        if (this.getBgFormIds() != null && !this.getBgFormIds().isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(this.getBgFormIds()), CompareType.INCLUDE));
            evi.setSelector(BgNFSHelper.getFormBaseSelectors(false));
            BgFormCollection colls = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
            if (colls != null && !colls.isEmpty()) {
                int i;
                BgFormInfo bgFormInfo = null;
                HashSet<String> orgIds = new HashSet<String>();
                HashSet<String> checkTem = new HashSet<String>();
                BgTemplateCollection bgTemplateCollection = new BgTemplateCollection();
                HashSet<String> checkPeriod = new HashSet<String>();
                BgPeriodCollection bgPeriodCollection = new BgPeriodCollection();
                HashSet<String> checkVersion = new HashSet<String>();
                BgVersionCollection bgVersionCollection = new BgVersionCollection();
                HashSet<String> checkCurrency = new HashSet<String>();
                CurrencyCollection currencyCollection = new CurrencyCollection();
                for (int i2 = 0; i2 < colls.size(); ++i2) {
                    bgFormInfo = colls.get(i2);
                    orgIds.add(bgFormInfo.getOrgUnit().getId().toString());
                    if (!checkTem.contains(bgFormInfo.getBgTemplate().getId().toString())) {
                        checkTem.add(bgFormInfo.getBgTemplate().getId().toString());
                        bgTemplateCollection.add(bgFormInfo.getBgTemplate());
                    }
                    if (!checkPeriod.contains(bgFormInfo.getBgPeriod().getId().toString())) {
                        checkPeriod.add(bgFormInfo.getBgPeriod().getId().toString());
                        bgPeriodCollection.add(bgFormInfo.getBgPeriod());
                    }
                    if (!checkVersion.contains(bgFormInfo.getBgVersion().getId().toString()) && !bgFormInfo.getBgVersion().isIsRollVersion()) {
                        checkVersion.add(bgFormInfo.getBgVersion().getId().toString());
                        bgVersionCollection.add(bgFormInfo.getBgVersion());
                    }
                    if (checkCurrency.contains(bgFormInfo.getCurrency().getId().toString())) continue;
                    checkCurrency.add(bgFormInfo.getCurrency().getId().toString());
                    currencyCollection.add(bgFormInfo.getCurrency());
                }
                bgTemplateCollection.sort("number");
                bgPeriodCollection.sort("number");
                bgVersionCollection.sort("number");
                currencyCollection.sort("number");
                BgTemplateObject bgTemplateObject = new BgTemplateObject(bgTemplateCollection);
                Object[] bgPeriods = new Object[bgPeriodCollection.size()];
                for (int i3 = 0; i3 < bgPeriodCollection.size(); ++i3) {
                    bgPeriods[i3] = bgPeriodCollection.get(i3);
                }
                Object[] bgVersions = new Object[bgVersionCollection.size()];
                for (int i4 = 0; i4 < bgVersionCollection.size(); ++i4) {
                    bgVersions[i4] = bgVersionCollection.get(i4);
                }
                Object[] currencys = new Object[currencyCollection.size()];
                for (int i5 = 0; i5 < currencyCollection.size(); ++i5) {
                    currencys[i5] = currencyCollection.get(i5);
                }
                this.defaultMap.put(this.BG_TEMPLATE_FLAG, bgTemplateObject);
                this.defaultMap.put(this.BG_PERIOD_FLAG, bgPeriods);
                this.defaultMap.put(this.BG_VERSION_FLAG, bgVersions);
                this.defaultMap.put(this.BG_CURRENCY_FLAG, currencys);
                HashMap<String, BgFormInfo> tmpMap = new HashMap<String, BgFormInfo>();
                LinkedHashMap orderMap = new LinkedHashMap();
                for (i = 0; i < colls.size(); ++i) {
                    bgFormInfo = colls.get(i);
                    tmpMap.put(bgFormInfo.getId().toString(), bgFormInfo);
                }
                for (i = 0; i < this.getBgFormIds().size(); ++i) {
                    if (!tmpMap.containsKey(this.getBgFormIds().get(i))) continue;
                    orderMap.put((String)this.getBgFormIds().get(i), tmpMap.get(this.getBgFormIds().get(i)));
                    if (this.defaultMap.containsKey(this.BG_FORMSTATE_FLAG)) continue;
                    this.defaultMap.put(this.BG_FORMSTATE_FLAG, (Object)((BgFormInfo)tmpMap.get(this.getBgFormIds().get(i))).getState());
                }
                String bgOrgViewId = this.getSchemeHelper().getBgOrgViewId();
                EntityViewInfo view = new EntityViewInfo();
                view.setSelector(new SelectorItemCollection());
                view.getSelector().add("id");
                view.getSelector().add("number");
                view.getSelector().add("name");
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId, CompareType.EQUALS));
                view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", orgIds, CompareType.INCLUDE));
                view.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                view.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
                BgOrgUnitCollection bgOrgColls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
                if (bgOrgColls != null && !bgOrgColls.isEmpty()) {
                    MbgViewListResultData data = new MbgViewListResultData();
                    ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
                    for (int i6 = 0; i6 < bgOrgColls.size(); ++i6) {
                        members.add(new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.DEF_ORGUNIT_FIELD, bgOrgColls.get(i6).getName(), bgOrgColls.get(i6).getNumber()));
                    }
                    data.setMembers(members);
                    this.defaultMap.put(this.BG_ORGUNIT_FLAG, data);
                }
            }
        }
    }

    protected void initDefault() {
        if (this.defaultMap.containsKey(this.BG_COSTCENTER_FLAG)) {
            this.prmtCostCenter.setDataNoNotify(this.defaultMap.get(this.BG_COSTCENTER_FLAG));
        }
        if (this.defaultMap.containsKey(this.BG_SCHEME_FLAG)) {
            this.prmtBgScheme.setData(this.defaultMap.get(this.BG_SCHEME_FLAG));
        }
        if (this.defaultMap.containsKey(this.BG_ORGUNIT_FLAG)) {
            this.prmtBgOrgUnit.setDataNoNotify(this.defaultMap.get(this.BG_ORGUNIT_FLAG));
        } else {
            this.prmtBgOrgUnit.setDataNoNotify(null);
        }
        if (this.defaultMap.containsKey(this.BG_TEMPLATE_FLAG)) {
            this.prmtBgTemplate.setDataNoNotify(this.defaultMap.get(this.BG_TEMPLATE_FLAG));
        } else {
            this.prmtBgTemplate.setDataNoNotify(null);
        }
        if (this.defaultMap.containsKey(this.BG_PERIOD_FLAG)) {
            this.prmtBgPeriod.setDataNoNotify(this.defaultMap.get(this.BG_PERIOD_FLAG));
        } else {
            this.prmtBgPeriod.setDataNoNotify(null);
        }
        if (this.defaultMap.containsKey(this.BG_VERSION_FLAG)) {
            this.prmtBgVersion.setDataNoNotify(this.defaultMap.get(this.BG_VERSION_FLAG));
        } else {
            this.prmtBgVersion.setDataNoNotify(null);
        }
        if (this.defaultMap.containsKey(this.BG_CURRENCY_FLAG)) {
            this.prmtCurrency.setDataNoNotify(this.defaultMap.get(this.BG_CURRENCY_FLAG));
        } else {
            this.prmtCurrency.setDataNoNotify(null);
        }
        if (this.defaultMap.get(this.BG_FORMSTATE_FLAG) instanceof BgFormStateEnum) {
            if (((BgFormStateEnum)((Object)this.defaultMap.get(this.BG_FORMSTATE_FLAG))).equals((Object)BgFormStateEnum.UnionReceive)) {
                this.rbUnionReceive.setSelected(true);
            } else {
                this.rbAudit.setSelected(true);
            }
        }
    }

    protected void initF7() throws Exception {
        this.prmtCostCenter.setEditable(false);
        this.prmtBgScheme.setEditable(false);
        this.prmtBgOrgUnit.setEditable(false);
        this.prmtBgTemplate.setEditable(false);
        this.prmtBgPeriod.setEditable(false);
        this.prmtCurrency.setEditable(false);
        this.prmtCostCenter.setData((Object)this.getOrgUnit());
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setRootUnitID(this.getOrgUnit().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtCostCenter.setSelector((KDPromptSelector)f7);
        BgSchemeInfo bgSchemeInfo = this.getBgschemeInfo();
        this.prmtBgScheme.setData((Object)bgSchemeInfo);
        this.setBgScheme(bgSchemeInfo.getId().toString());
        BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, this.getOrgUnit(), false, this.getSourceType(), false, true);
        DimensionMemberSelectDialog bgOrgdialog = new DimensionMemberSelectDialog();
        bgOrgdialog.setOwner((Component)((Object)this));
        bgOrgdialog.setMulti(true);
        bgOrgdialog.setOnlySelectItem(true);
        bgOrgdialog.setSelectCombinItem(false);
        bgOrgdialog.setOnlyRefDim(true);
        bgOrgdialog.setEnableProperty(false);
        bgOrgdialog.setDimension(this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
        bgOrgdialog.setOrgId(this.getOrgUnit().getId().toString());
        bgOrgdialog.setBgSchemeId(this.getBgschemeInfo().getId().toString());
        bgOrgdialog.setShowRemove(true);
        bgOrgdialog.setShowOuSealup(false);
        bgOrgdialog.setCanSelectType(false);
        bgOrgdialog.reSetF7UI();
        BgCommHelper.removeUndo((KDBizPromptBox)this.prmtBgOrgUnit);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)bgOrgdialog);
        this.initTemplateFormBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        BgTemplateDialog templateDialog = new BgTemplateDialog();
        templateDialog.setCreateExcute(true);
        BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        if (_bgSchemeInfo != null) {
            templateDialog.setSchemeId(_bgSchemeInfo.getId().toString());
        }
        templateDialog.setFilterInfo(this.prmtBgTemplate.getEntityViewInfo().getFilter());
        this.prmtBgTemplate.setSelector((KDPromptSelector)templateDialog);
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this, true);
        dialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
        dialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
        dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgVersion, DimensionConstants.DEF_VERSION_NUMBER, this.schemeHelper);
        this.prmtBgVersion.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
        this.prmtCurrency.setEntityViewInfo(view);
        DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.schemeHelper);
        this.prmtCurrency.setEnabledMultiSelection(true);
        this.initDefault();
    }

    private void setBgScheme(String bgSchemeId) throws BOSException {
        BgSchemeInfo bgScheme = null;
        if (!StringUtils.isEmpty((String)bgSchemeId)) {
            try {
                BgSchemeCollection col = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection("select id, number, name, isfiling, isFormal,dataFrom,dataTo,orgUnit.id,orgUnit.name,bgDimSettings.*,bgDimSettings.Members.* where id = '" + bgSchemeId + "'");
                if (col != null && !col.isEmpty()) {
                    bgScheme = col.get(0);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        this.prmtBgScheme.setData(bgScheme);
    }

    protected void initTemplateFormBgScheme(BgSchemeInfo bgSchemeInfo) throws Exception {
        BgTemplateCollection bgTemplateColl = null;
        if (bgSchemeInfo != null) {
            bgTemplateColl = this.getBgTemplateOfBgScheme(bgSchemeInfo.getId());
        }
        boolean needRemove = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (bgTemplateColl != null && !bgTemplateColl.isEmpty()) {
            Object old = null;
            Set<String> oldIds = DimensionCommonHelper.getIds(this.prmtBgTemplate.getData());
            Set<String> ids = DimensionCommonHelper.getIds(bgTemplateColl.toArray());
            if (!oldIds.isEmpty() && ids.containsAll(oldIds)) {
                needRemove = false;
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
        }
        if (needRemove) {
            this.prmtBgTemplate.setData(null);
        }
        this.prmtBgTemplate.setEntityViewInfo(evi);
        FilterInfo filter = MbgPermissionHelper.addBgTemplatePermission(RptSrcTypeEnum.PT_BUDGET_REPORT, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgTemplate.getEntityViewInfo().getFilter(), bgSchemeInfo == null ? null : bgSchemeInfo.getId().toString());
        this.prmtBgTemplate.getEntityViewInfo().setFilter(filter);
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId) throws Exception {
        Object value = this.prmtBgOrgUnit.getValue();
        if (value != null && value instanceof BgOrgUnitInfo[]) {
            HashSet<String> mutiOrgUnit = new HashSet<String>();
            BgOrgUnitInfo[] infos = (BgOrgUnitInfo[])value;
            for (int i = 0; i < infos.length; ++i) {
                String orgUnitID = infos[i].getOrgUnitID();
                mutiOrgUnit.add(orgUnitID);
            }
            return TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, mutiOrgUnit, true);
        }
        OrgUnitInfo org = this.getOrgUnit();
        if (org == null) {
            org = SysContext.getSysContext().getCurrentCostUnit();
        }
        HashSet<String> mutiOrgUnit = new HashSet<String>();
        mutiOrgUnit.add(org.getId().toString());
        return TemplateFacadeFactory.getRemoteInstance().getBgTemplateColls(bgSchemeId, org.getId().toString(), true, false);
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo evi = this.prmtBgVersion.getEntityViewInfo();
        FilterInfo filter = evi.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("isRollVersion", (Object)false, CompareType.EQUALS));
        this.prmtBgVersion.setEntityViewInfo(evi);
        this.prmtBgVersion.getQueryAgent().resetRuntimeEntityView();
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re && DimensionCommonHelper.isEmpty(this.prmtBgScheme.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("selectBgScheme"));
            re = false;
        }
        if (re && DimensionCommonHelper.isEmpty(this.prmtBgOrgUnit.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("selectBgOrgUnit"));
            re = false;
        }
        try {
            if (re && !this.checkHasBgForms().booleanValue()) {
                MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("noFondBgForm"));
                re = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return re;
    }

    public void verifyData() throws Exception {
        super.verifyData();
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        OrgUnitInfo newInfo;
        OrgUnitInfo oldInfo = e.getOldValue() instanceof OrgUnitInfo ? (OrgUnitInfo)e.getOldValue() : null;
        OrgUnitInfo orgUnitInfo = newInfo = e.getNewValue() instanceof OrgUnitInfo ? (OrgUnitInfo)e.getNewValue() : null;
        if (newInfo == null && oldInfo != null) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("costCenterNotNull"));
            this.prmtCostCenter.setDataNoNotify((Object)oldInfo);
        } else if (!BgCommCHelper.isEqualsPK((IObjectValue)newInfo, (IObjectValue)oldInfo)) {
            BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtCostCenter.getData(), null, false, this.getSourceType(), false, false);
            BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), ((OrgUnitInfo)this.prmtCostCenter.getData()).getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        try {
            if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("bgSchemeNotNull"));
                this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
                this.bgSchemeChanged(newInfo);
            }
        }
        finally {
            this.prmtBgScheme.setUserObject(null);
        }
    }

    protected void initBgPeriodDialog() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, true);
        bgPeriodDialog.setAllowSort(false);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
        this.prmtBgPeriod.setHistoryRecordEnabled(false);
    }

    protected void bgSchemeChanged(BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        this.setBgschemeInfo(bgSchemeInfo);
        this.setBgTemplateF7();
        if (bgSchemeInfo != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(bgSchemeInfo.getId().toString());
        }
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null) {
            if (this.getSchemeHelper() != null) {
                this.prmtBgVersion.setDataNoNotify(null);
                DimensionMemberSelectHelper.addIdFilter(this.prmtBgVersion, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
            }
            if (this.prmtBgPeriod != null && this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
                BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
                bgPeriodDialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
                bgPeriodDialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
                bgPeriodDialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
                bgPeriodDialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
                Object periodInfo = null;
                Object objPeriod = this.prmtBgPeriod.getData();
                this.prmtBgPeriod.setDataNoNotify(null);
                bgPeriodDialog.setBgPeriods(null);
            }
            if (this.prmtBgOrgUnit.getSelector() instanceof DimensionMemberSelectDialog) {
                DimensionMemberSelectDialog bgOrgdialog = (DimensionMemberSelectDialog)this.prmtBgOrgUnit.getSelector();
                bgOrgdialog.setDimension(this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
                bgOrgdialog.setOrgId(this.getOrgUnit().getId().toString());
                bgOrgdialog.setBgSchemeId(this.getBgschemeInfo().getId().toString());
                this.prmtBgOrgUnit.setDataNoNotify(null);
            }
            this.prmtCurrency.setDataNoNotify(null);
            this.prmtBgTemplate.setDataNoNotify(null);
        }
    }

    protected BgTemplateCollection readBgTemplate(BOSUuid bgSchemeId, BOSUuid orgId) throws BOSException, EASBizException {
        return TemplateFacadeFactory.getRemoteInstance().getBgTemplateColls(bgSchemeId, null, true, false);
    }

    protected void setBgTemplateF7() throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        if (bgSchemeInfo == null) {
            this.prmtBgTemplate.setDataNoNotify(null);
            return;
        }
        BgTemplateCollection bgTemplateColl = null;
        if (bgSchemeInfo != null) {
            OrgUnitInfo org = this.getOrgUnit();
            bgTemplateColl = this.readBgTemplate(bgSchemeInfo.getId(), org.getId());
        }
        ArrayList<Object> selectedObjs = new ArrayList<Object>();
        if (this.prmtBgTemplate.getData() instanceof Object[]) {
            selectedObjs.addAll(Arrays.asList((Object[])this.prmtBgTemplate.getData()));
        } else if (this.prmtBgTemplate.getData() instanceof BgTemplateInfo) {
            selectedObjs.add(this.prmtBgTemplate.getData());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (bgTemplateColl != null && !bgTemplateColl.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < bgTemplateColl.size(); ++i) {
                ids.add(bgTemplateColl.get(i).getId().toString());
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            if (!selectedObjs.isEmpty()) {
                selectedObjs.remove(null);
                Iterator it = selectedObjs.iterator();
                while (it.hasNext()) {
                    if (ids.contains(((BgTemplateInfo)it.next()).getId().toString())) continue;
                    it.remove();
                }
            }
        } else {
            selectedObjs.clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
        }
        if (this.prmtBgTemplate.getData() != null && !selectedObjs.isEmpty()) {
            if (this.prmtBgTemplate.getData() instanceof BgTemplateInfo) {
                if (!selectedObjs.contains(this.prmtBgTemplate.getData())) {
                    this.prmtBgTemplate.setData(null);
                }
            } else if (this.prmtBgTemplate.getData() instanceof Object[] && !Arrays.equals(selectedObjs.toArray(), (Object[])this.prmtBgTemplate.getData())) {
                this.prmtBgTemplate.setData((Object)selectedObjs.toArray());
            }
        }
        this.prmtBgTemplate.setEntityViewInfo(evi);
        FilterInfo filter = MbgPermissionHelper.addBgTemplatePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgTemplate.getEntityViewInfo().getFilter(), bgSchemeInfo != null ? bgSchemeInfo.getId().toString() : null);
        this.prmtBgTemplate.getEntityViewInfo().setFilter(filter);
        this.prmtBgTemplate.getQueryAgent().setHandleCUFilter(false);
        if (this.prmtBgTemplate.getSelector() instanceof BgTemplateDialog) {
            BgTemplateDialog templateDialog = (BgTemplateDialog)this.prmtBgTemplate.getSelector();
            templateDialog.setSchemeId(bgSchemeInfo.getId().toString());
            templateDialog.setFilterInfo(this.prmtBgTemplate.getEntityViewInfo().getFilter());
        }
    }

    protected void prmtType_dataChanged(DataChangeEvent e) throws Exception {
        this.setBgTemplateF7();
    }

    @Override
    protected void prmtBgTemplate_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgTemplate.getSelector() instanceof BgTemplateDialog && this.prmtBgTemplate.getData() instanceof BgTemplateObject) {
            ((BgTemplateDialog)this.prmtBgTemplate.getSelector()).setOldData(((BgTemplateObject)this.prmtBgTemplate.getData()).getResult());
        }
        this.setBgTemplateF7();
    }

    @Override
    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("bgOrgUnitNotNull"));
            this.prmtBgOrgUnit.setDataNoNotify(e.getOldValue());
        }
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgOrgUnit.getSelector() instanceof DimensionMemberSelectDialog && this.prmtBgOrgUnit.getData() instanceof MbgViewListResultData) {
            ((DimensionMemberSelectDialog)this.prmtBgOrgUnit.getSelector()).reSetF7UI();
            ((DimensionMemberSelectDialog)this.prmtBgOrgUnit.getSelector()).setCurSelectFunction((MbgViewListResultData)this.prmtBgOrgUnit.getData());
        }
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
            BgPeriodInfo periodInfo = null;
            Object objPeriod = this.prmtBgPeriod.getData();
            if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                periodInfo = (BgPeriodInfo)objPeriod;
                BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                bgPeriodDialog.setBgPeriods(periodArray);
            } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
                bgPeriodDialog.setBgPeriods((BgPeriodInfo[])objPeriod);
            } else if (objPeriod != null && objPeriod instanceof Object[]) {
                BgPeriodInfo[] periodArray = new BgPeriodInfo[((Object[])objPeriod).length];
                for (int i = 0; i < ((Object[])objPeriod).length; ++i) {
                    if (!(((Object[])objPeriod)[i] instanceof BgPeriodInfo)) continue;
                    periodArray[i] = (BgPeriodInfo)((Object[])objPeriod)[i];
                }
                bgPeriodDialog.setBgPeriods(periodArray);
            } else {
                bgPeriodDialog.setBgPeriods(null);
            }
        }
        super.prmtBgPeriod_willShow(e);
    }

    public void clear() {
        this.initDefault();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        FilterParam filterParam = this.createFilterParam();
        this.saveToParams(filterParam);
        this.saveCustomerParams(cp, filterParam);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        FilterParam filterParam = this.createFilterParam();
        this.loadCustomerParams(cp, filterParam);
        filterParam = this.loadFilterParam(filterParam);
        this.loadFromParams(filterParam);
    }

    protected FilterParam createFilterParam() {
        return new MbgDataStateSynFilterParam();
    }

    public FilterParam getFilterParam(CustomerParams cp) {
        if (cp == null) {
            return null;
        }
        FilterParam filterParam = this.createFilterParam();
        this.loadCustomerParams(cp, filterParam);
        filterParam = this.loadFilterParam(filterParam);
        return filterParam;
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        if (cp == null || filterParam == null || !(filterParam instanceof MbgDataStateSynFilterParam)) {
            return;
        }
        MbgDataStateSynFilterParam mbgDataStateSynFilterParam = (MbgDataStateSynFilterParam)filterParam;
        String cpObj = null;
        cpObj = cp.getCustomerParam(this.BG_COSTCENTER_FLAG);
        if (!StringUtils.isEmpty((String)cpObj) && BgAnalyseHelper.decodeObject(cpObj) instanceof CostCenterOrgUnitInfo) {
            mbgDataStateSynFilterParam.setCostCenter((OrgUnitInfo)((CostCenterOrgUnitInfo)BgAnalyseHelper.decodeObject(cpObj)));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_SCHEME_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof BgSchemeInfo) {
            mbgDataStateSynFilterParam.setBgSchemeInfo((BgSchemeInfo)BgAnalyseHelper.decodeObject(cpObj));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_ORGUNIT_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof List) {
            mbgDataStateSynFilterParam.setBgOrgUnitMembers((List)BgAnalyseHelper.decodeObject(cpObj));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_TEMPLATE_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof BgTemplateObject) {
            mbgDataStateSynFilterParam.setBgTemplateObj((BgTemplateObject)BgAnalyseHelper.decodeObject(cpObj));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_PERIOD_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof Object[]) {
            mbgDataStateSynFilterParam.setBgPeriods((Object[])BgAnalyseHelper.decodeObject(cpObj));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_VERSION_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof Object[]) {
            mbgDataStateSynFilterParam.setBgVersions((Object[])BgAnalyseHelper.decodeObject(cpObj));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_CURRENCY_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof Object[]) {
            mbgDataStateSynFilterParam.setCurrencys((Object[])BgAnalyseHelper.decodeObject(cpObj));
        }
        if (!StringUtils.isEmpty((String)(cpObj = cp.getCustomerParam(this.BG_FORMSTATE_FLAG))) && BgAnalyseHelper.decodeObject(cpObj) instanceof BgFormStateEnum) {
            mbgDataStateSynFilterParam.setState((BgFormStateEnum)((Object)BgAnalyseHelper.decodeObject(cpObj)));
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        if (cp == null || filterParam == null || !(filterParam instanceof MbgDataStateSynFilterParam)) {
            return;
        }
        MbgDataStateSynFilterParam mbgDataStateSynFilterParam = (MbgDataStateSynFilterParam)filterParam;
        if (mbgDataStateSynFilterParam.getCostCenter() != null) {
            cp.addCustomerParam(this.BG_COSTCENTER_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getCostCenter())));
        } else {
            cp.removeCustomerParam(this.BG_COSTCENTER_FLAG);
        }
        if (mbgDataStateSynFilterParam.getBgSchemeInfo() != null) {
            cp.addCustomerParam(this.BG_SCHEME_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getBgSchemeInfo())));
        } else {
            cp.removeCustomerParam(this.BG_SCHEME_FLAG);
        }
        if (mbgDataStateSynFilterParam.getBgOrgUnitMembers() != null) {
            cp.addCustomerParam(this.BG_ORGUNIT_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getBgOrgUnitMembers())));
        } else {
            cp.removeCustomerParam(this.BG_ORGUNIT_FLAG);
        }
        if (mbgDataStateSynFilterParam.getBgTemplateObj() != null) {
            cp.addCustomerParam(this.BG_TEMPLATE_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getBgTemplateObj())));
        } else {
            cp.removeCustomerParam(this.BG_TEMPLATE_FLAG);
        }
        if (mbgDataStateSynFilterParam.getBgPeriods() != null) {
            cp.addCustomerParam(this.BG_PERIOD_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getBgPeriods())));
        } else {
            cp.removeCustomerParam(this.BG_PERIOD_FLAG);
        }
        if (mbgDataStateSynFilterParam.getBgVersions() != null) {
            cp.addCustomerParam(this.BG_VERSION_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getBgVersions())));
        } else {
            cp.removeCustomerParam(this.BG_VERSION_FLAG);
        }
        if (mbgDataStateSynFilterParam.getCurrencys() != null) {
            cp.addCustomerParam(this.BG_CURRENCY_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(mbgDataStateSynFilterParam.getCurrencys())));
        } else {
            cp.removeCustomerParam(this.BG_CURRENCY_FLAG);
        }
        if (mbgDataStateSynFilterParam.getState() != null) {
            cp.addCustomerParam(this.BG_FORMSTATE_FLAG, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes((Object)mbgDataStateSynFilterParam.getState())));
        } else {
            cp.removeCustomerParam(this.BG_FORMSTATE_FLAG);
        }
    }

    protected void loadFromParams(FilterParam filterParam) {
        if (!(filterParam instanceof MbgDataStateSynFilterParam)) {
            return;
        }
        MbgDataStateSynFilterParam mbgDataStateSynFilterParam = (MbgDataStateSynFilterParam)filterParam;
        if (mbgDataStateSynFilterParam.getCostCenter() != null) {
            this.prmtCostCenter.setData((Object)mbgDataStateSynFilterParam.getCostCenter());
        } else {
            this.prmtCostCenter.setData(null);
        }
        if (mbgDataStateSynFilterParam.getBgSchemeInfo() != null) {
            this.prmtBgScheme.setData((Object)mbgDataStateSynFilterParam.getBgSchemeInfo());
        } else {
            this.prmtBgScheme.setData(null);
        }
        if (mbgDataStateSynFilterParam.getBgOrgUnitMembers() != null) {
            MbgViewListResultData data = new MbgViewListResultData();
            data.setMembers(mbgDataStateSynFilterParam.getBgOrgUnitMembers());
            this.prmtBgOrgUnit.setData((Object)data);
        } else {
            this.prmtBgOrgUnit.setData(null);
        }
        if (mbgDataStateSynFilterParam.getBgTemplateObj() != null) {
            this.prmtBgTemplate.setData((Object)mbgDataStateSynFilterParam.getBgTemplateObj());
        } else {
            this.prmtBgTemplate.setData(null);
        }
        if (mbgDataStateSynFilterParam.getBgPeriods() != null) {
            this.prmtBgPeriod.setData((Object)mbgDataStateSynFilterParam.getBgPeriods());
        } else {
            this.prmtBgPeriod.setData(null);
        }
        if (mbgDataStateSynFilterParam.getBgVersions() != null) {
            this.prmtBgVersion.setData((Object)mbgDataStateSynFilterParam.getBgVersions());
        } else {
            this.prmtBgVersion.setData(null);
        }
        if (mbgDataStateSynFilterParam.getCurrencys() != null) {
            this.prmtCurrency.setData((Object)mbgDataStateSynFilterParam.getCurrencys());
        } else {
            this.prmtCurrency.setData(null);
        }
        if (mbgDataStateSynFilterParam.getState() instanceof BgFormStateEnum) {
            if (BgFormStateEnum.Approved.equals((Object)mbgDataStateSynFilterParam.getState())) {
                this.rbAudit.setSelected(true);
            } else {
                this.rbUnionReceive.setSelected(true);
            }
        }
    }

    protected void saveToParams(FilterParam filterParam) {
        if (!(filterParam instanceof MbgDataStateSynFilterParam)) {
            return;
        }
        MbgDataStateSynFilterParam mbgDataStateSynFilterParam = (MbgDataStateSynFilterParam)filterParam;
        if (this.prmtCostCenter.getData() instanceof OrgUnitInfo) {
            mbgDataStateSynFilterParam.setCostCenter((OrgUnitInfo)this.prmtCostCenter.getData());
        } else {
            mbgDataStateSynFilterParam.setCostCenter(null);
        }
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            mbgDataStateSynFilterParam.setBgSchemeInfo((BgSchemeInfo)this.prmtBgScheme.getData());
        } else {
            mbgDataStateSynFilterParam.setBgSchemeInfo(null);
        }
        if (this.prmtBgOrgUnit.getData() instanceof MbgViewListResultData && !((MbgViewListResultData)this.prmtBgOrgUnit.getData()).getMembers().isEmpty()) {
            mbgDataStateSynFilterParam.setBgOrgUnitMembers(((MbgViewListResultData)this.prmtBgOrgUnit.getData()).getMembers());
        } else {
            mbgDataStateSynFilterParam.setBgOrgUnitMembers(null);
        }
        if (this.prmtBgTemplate.getData() instanceof BgTemplateObject) {
            mbgDataStateSynFilterParam.setBgTemplateObj((BgTemplateObject)this.prmtBgTemplate.getData());
        } else {
            mbgDataStateSynFilterParam.setBgTemplateObj(null);
        }
        if (this.prmtBgPeriod.getData() instanceof Object[]) {
            mbgDataStateSynFilterParam.setBgPeriods((Object[])this.prmtBgPeriod.getData());
        } else {
            mbgDataStateSynFilterParam.setBgPeriods(null);
        }
        if (this.prmtBgVersion.getData() instanceof Object[]) {
            mbgDataStateSynFilterParam.setBgVersions((Object[])this.prmtBgVersion.getData());
        } else {
            mbgDataStateSynFilterParam.setBgVersions(null);
        }
        if (this.prmtCurrency.getData() instanceof Object[]) {
            mbgDataStateSynFilterParam.setCurrencys((Object[])this.prmtCurrency.getData());
        } else {
            mbgDataStateSynFilterParam.setCurrencys(null);
        }
        if (this.rbAudit.isSelected()) {
            mbgDataStateSynFilterParam.setState(BgFormStateEnum.Approved);
        } else if (this.rbUnionReceive.isSelected()) {
            mbgDataStateSynFilterParam.setState(BgFormStateEnum.UnionReceive);
        }
    }

    protected IBgCustomerParamsFacade getCPInterface() throws Exception {
        return BgCustomerParamsFacadeFactory.getRemoteInstance();
    }

    protected FilterParam loadFilterParam(FilterParam filterParam) {
        try {
            filterParam = this.getCPInterface().loadCustomerParams(filterParam);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        return filterParam;
    }
}

