/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDataStateSynUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.ma.mbg.client.BgTemplateDialog;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgDataStateSynClientHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataStateSynUI
extends AbstractMbgDataStateSynUI {
    private static final long serialVersionUID = 7864164881740802561L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDataStateSynUI.class);
    protected FullOrgUnitInfo ccOrgUnitInfo = null;

    public FullOrgUnitInfo getCcOrgUnitInfo() {
        return this.ccOrgUnitInfo;
    }

    public void setCcOrgUnitInfo(FullOrgUnitInfo ccOrgUnitInfo) {
        this.ccOrgUnitInfo = ccOrgUnitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        StringBuffer description = new StringBuffer();
        description.append(MbgDataStateSynClientHelper.getString("description.line1"));
        description.append("\r\n");
        description.append(MbgDataStateSynClientHelper.getString("description.line2"));
        this.txtDescription.setText(description.toString());
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) != null) {
            this.ccOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        }
        this.initF7();
    }

    private void initF7() throws Exception {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        this.prmtBgScheme.setData((Object)bgSchemeInfo);
        this.setBgScheme(bgSchemeInfo.getId().toString());
        BgNewOrgDialog orgDialog = new BgNewOrgDialog((IUIObject)this);
        orgDialog.setBgOrgViewId(((BgSchemeInfo)this.prmtBgScheme.getData()).getEditOrgViewId().toString());
        orgDialog.setMultipleSelect(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgDialog);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgSchemeInfo.getId().toString());
        this.initTemplateFormBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        BgTemplateDialog templateDialog = new BgTemplateDialog();
        BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        if (_bgSchemeInfo != null) {
            templateDialog.setSchemeId(_bgSchemeInfo.getId().toString());
        }
        templateDialog.setOrgInfo(this.getCcOrgUnitInfo());
        templateDialog.setFilterInfo(this.prmtBgTemplate.getEntityViewInfo().getFilter());
        this.prmtBgTemplate.setSelector((KDPromptSelector)templateDialog);
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this, true);
        dialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
        dialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
        dialog.setBgPeriodTypeNumbers(schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
        this.prmtCurrency.setEntityViewInfo(view);
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgVersion, DimensionConstants.DEF_VERSION_NUMBER, schemeHelper);
        DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, schemeHelper);
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo evi = this.prmtBgVersion.getEntityViewInfo();
        FilterInfo filter = evi.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("isRollVersion", (Object)false, CompareType.EQUALS));
        this.prmtBgVersion.setEntityViewInfo(evi);
        this.prmtBgVersion.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initTemplateFormBgScheme(BgSchemeInfo bgSchemeInfo) throws Exception {
        BgTemplateCollection bgTemplateColl = null;
        if (bgSchemeInfo != null) {
            bgTemplateColl = this.getBgTemplateOfBgScheme(bgSchemeInfo.getId());
        }
        boolean needRemove = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (bgTemplateColl != null && !bgTemplateColl.isEmpty()) {
            Object old = null;
            Set<String> oldIds = DimensionCommonHelper.getIds(this.prmtBgTemplate.getData());
            Set<String> ids = DimensionCommonHelper.getIds(bgTemplateColl.toArray());
            if (!oldIds.isEmpty() && ids.containsAll(oldIds)) {
                needRemove = false;
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
        }
        if (needRemove) {
            this.prmtBgTemplate.setData(null);
        }
        this.prmtBgTemplate.setEntityViewInfo(evi);
        FilterInfo filter = MbgPermissionHelper.addBgTemplatePermission(RptSrcTypeEnum.PT_BUDGET_REPORT, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgTemplate.getEntityViewInfo().getFilter(), bgSchemeInfo == null ? null : bgSchemeInfo.getId().toString(), true);
        this.prmtBgTemplate.getEntityViewInfo().setFilter(filter);
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId) throws Exception {
        Object value = this.prmtOrgUnit.getValue();
        if (value != null && value instanceof BgOrgUnitInfo[]) {
            HashSet<String> mutiOrgUnit = new HashSet<String>();
            BgOrgUnitInfo[] infos = (BgOrgUnitInfo[])value;
            for (int i = 0; i < infos.length; ++i) {
                String orgUnitID = infos[i].getOrgUnitID();
                mutiOrgUnit.add(orgUnitID);
            }
            return TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, mutiOrgUnit, false);
        }
        FullOrgUnitInfo org = this.getCcOrgUnitInfo();
        if (org == null) {
            org = SysContext.getSysContext().getCurrentCostUnit();
        }
        return TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, org.getId().toString());
    }

    private void setBgScheme(String bgSchemeId) throws BOSException {
        BgSchemeInfo bgScheme = null;
        if (!StringUtils.isEmpty((String)bgSchemeId)) {
            try {
                BgSchemeCollection col = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection("select id, number, name, isfiling, isFormal,dataFrom,dataTo,orgUnit.id,orgUnit.name,bgDimSettings.*,bgDimSettings.Members.* where id = '" + bgSchemeId + "'");
                if (col != null && !col.isEmpty()) {
                    bgScheme = col.get(0);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        this.prmtBgScheme.setData(bgScheme);
    }

    public void verifyData() throws Exception {
        super.verifyData();
        if (DimensionCommonHelper.isEmpty(this.prmtOrgUnit.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("selectBgOrgUnit"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty(this.prmtBgTemplate.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("selectBgTemplate"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty(this.prmtBgVersion.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("selectBgVersion"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty(this.prmtCurrency.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)MbgDataStateSynClientHelper.getString("selectCurrency"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnExecute_actionPerformed(ActionEvent e) throws Exception {
        super.btnExecute_actionPerformed(e);
        this.verifyData();
        MbgDataStateSynClientHelper.startSyn(this, (BgSchemeInfo)this.prmtBgScheme.getData(), this.prmtOrgUnit.getData(), this.prmtBgTemplate.getData(), this.prmtBgPeriod.getData(), this.prmtBgVersion.getData(), this.prmtCurrency.getData());
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }
}

