/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFactory;
import com.kingdee.eas.ma.mbg.AbstractBgFormInfo;
import com.kingdee.eas.ma.mbg.AbstractDimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationGroupShowEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDimRelationSelectUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class MbgDimRelationSelectUI
extends AbstractMbgDimRelationSelectUI {
    private static final long serialVersionUID = -5808298607039690947L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDimRelationSelectUI.class);
    private DimensionRelationshipGroupInfo group = null;
    private DimensionRelationshipCollection dimRelationCol = null;
    private String orgUnitID = null;
    private CostCenterOrgUnitInfo orgUnit = null;
    private FullOrgUnitInfo groupUnitInfo = null;
    private String firstSearchKey = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.firstSearchKey = this.getFirstSearchKey();
        this.initParams();
        this.fillValueToTable();
    }

    protected void fillValueToTable() throws EASBizException, BOSException {
        DimensionRelationshipCollection shipCol = this.getDimensionRelationshipCollection(null);
        this.processPeriodN(shipCol);
        KDTDataRequestEvent e1 = this.loadFields(this.tblMain, shipCol);
        this.loadTempTable(this.tblMain, this.group);
        this.initRowValue(this, e1, this.tblMain, this.group);
    }

    private KDTDataRequestEvent loadFields(KDTable tblMain, DimensionRelationshipCollection shipCol) {
        tblMain.checkParsed();
        tblMain.removeRows();
        tblMain.getColumn("select").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        DimensionRelationshipInfo shipInfo = null;
        IRow row = null;
        int rowSize = 0;
        int j = shipCol.size();
        for (int i = 0; i < j; ++i) {
            shipInfo = shipCol.get(i);
            row = tblMain.addRow();
            row.setUserObject((Object)shipInfo);
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell(DimensionConstants.DIMENSION_ID).setValue((Object)shipInfo.getId().toString());
            row.getCell(DimensionConstants.DIMENSION_NUMBER).setValue((Object)shipInfo.getDimensionNumber());
            row.getCell(DimensionConstants.DIMENSION_NAME).setValue((Object)shipInfo.getDimensionName());
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT).setValue((Object)this.orgUnit);
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT_ID).setValue((Object)this.orgUnit.getId().toString());
            ++rowSize;
        }
        KDTDataRequestEvent e1 = new KDTDataRequestEvent(tblMain);
        e1.setFirstRow(0);
        e1.setLastRow(rowSize - 1);
        return e1;
    }

    protected void loadTempTable(KDTable tblMain, DimensionRelationshipGroupInfo groupInfo) throws EASBizException, BOSException {
        tblMain.checkParsed();
        IRow head = tblMain.getHeadRow(0);
        if (head == null) {
            head = tblMain.addHeadRow();
        }
        if (groupInfo != null) {
            groupInfo = DimensionRelationshipGroupFactory.getRemoteInstance().getDimensionRelationshipGroupInfo((IObjectPK)new ObjectUuidPK(groupInfo.getId()), DimensionRelationClientHelper.getSelectorForTree());
            List<DimRelashipGroupEntryInfo> displaySort = DimensionRelationClientHelper.sortGroupEntry(groupInfo);
            DimRelashipGroupEntryInfo info = null;
            for (int index = 0; index < displaySort.size(); ++index) {
                info = displaySort.get(index);
                this.initColumn(head, tblMain, info);
            }
        }
        tblMain.repaint();
    }

    public void initColumn(IRow head, KDTable tblMain, DimRelashipGroupEntryInfo source) throws EASBizException, BOSException {
        String alias = source.getDimName();
        String msg = null;
        msg = MessageFormat.format(DimensionRelationClientHelper.getDimCommResource("sourceNumber"), alias);
        this.addHeadColumn(head, tblMain, msg, true, source);
        msg = MessageFormat.format(DimensionRelationClientHelper.getDimCommResource("sourceName"), alias);
        this.addHeadColumn(head, tblMain, msg, false, source);
    }

    public void addHeadColumn(IRow head, KDTable tblMain, String value, boolean isNumber, DimRelashipGroupEntryInfo source) throws EASBizException, BOSException {
        IColumn column = tblMain.addColumn();
        column.setKey(DimensionRelationClientHelper.getColumnKey(this.getSchemeHelper().getSrcNumber(source.getDimNumber()), isNumber));
        DimensionRelationClientHelper.setUserObject(tblMain, column, source);
        head.getCell(column.getColumnIndex()).setValue((Object)value);
        column.getStyleAttributes().setLocked(true);
    }

    public void initRowValue(CoreUI ownerUi, KDTDataRequestEvent e, KDTable tblMain, DimensionRelationshipGroupInfo group) throws EASBizException, BOSException {
        String dimensionNumber = null;
        String dimensionName = null;
        String[] Numbers = null;
        String[] Names2 = null;
        String[] subNumber = null;
        IRow row = null;
        List<String> srcNumbers = DimensionRelationClientHelper.getSrcNumbers(tblMain, true, this.getSchemeHelper());
        int rowCount = e.getLastRow();
        for (int i = e.getFirstRow(); i <= rowCount; ++i) {
            row = tblMain.getRow(i);
            dimensionNumber = row.getCell(DimensionConstants.DIMENSION_NUMBER).getValue().toString();
            dimensionName = row.getCell(DimensionConstants.DIMENSION_NAME).getValue().toString();
            Numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
            if (Numbers.length != (Names2 = DimensionRelationClientHelper.split(dimensionName, DimensionConstants.TICK_SEPARATOR)).length || Numbers.length != srcNumbers.size()) {
                MsgBox.showInfo((Component)ownerUi, (String)DimensionRelationClientHelper.getDimCommResource("dataError"));
                SysUtil.abort();
            }
            for (int j = 0; j < Numbers.length; ++j) {
                subNumber = Numbers[j].split(DimensionConstants.COLON_SEPARATOR);
                String numberKey = DimensionRelationClientHelper.getColumnKey(subNumber[0], true);
                String nameKey = DimensionRelationClientHelper.getColumnKey(subNumber[0], false);
                if (row.getCell(numberKey) == null) continue;
                row.getCell(numberKey).setValue((Object)subNumber[1]);
                row.getCell(nameKey).setValue((Object)Names2[j]);
            }
        }
    }

    protected DimensionRelationshipCollection getDimensionRelationshipCollection(String searchKey) throws EASBizException, BOSException {
        if (this.group != null && this.orgUnitID != null) {
            return new DimensionRelationshipCollection();
        }
        String groupId = this.group.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().addObjectCollection((IObjectCollection)this.getRelationshipSic());
        if (this.group.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.childQuarantine)) {
            String orgUnitId = null;
            orgUnitId = this.group.isIsCsl() ? (this.groupUnitInfo != null ? this.groupUnitInfo.getId().toString() : "000000000000000000000000000=") : (this.orgUnit != null ? this.orgUnit.getId().toString() : "000000000000000000000000000=");
            filter.getFilterItems().add(DimensionMemberRelationShipHelper.getLowerShowFilter(null, this.getSchemeHelper().getBgSchemeId(), orgUnitId));
        } else if (this.group.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.equalQuarantine)) {
            filter.getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)BgOrgUnitFactory.getRemoteInstance().getParentAndChildrenOrgUnitIds(this.orgUnit.getId().toString(), this.getSchemeHelper().getBgOrgViewId()), CompareType.INCLUDE));
        } else if (this.group.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.allQuarantine)) {
            HashSet<String> orgSet = new HashSet<String>();
            BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("Select orgUnitID  Where viewID = '" + this.getSchemeHelper().getBgOrgViewId() + "'");
            for (int i = 0; i < colls.size(); ++i) {
                orgSet.add(colls.get(i).getOrgUnitID().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("filterUnit.id", orgSet, CompareType.INCLUDE));
        } else if (this.group.isIsCsl()) {
            filter.getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)this.groupUnitInfo.getId()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)this.orgUnit.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("dimensionGroup.id", (Object)groupId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1, CompareType.EQUALS));
        if (!EmptyUtil.isEmpty((String)searchKey)) {
            String string = "%" + searchKey + "%";
            filter.getFilterItems().add(new FilterItemInfo("dimensionNumber", (Object)string, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("dimensionName", (Object)string, CompareType.LIKE));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo(DimensionConstants.DIMENSION_NUMBER));
        DimensionRelationshipCollection shipCol = null;
        try {
            shipCol = DimensionRelationshipFactory.getRemoteInstance().getDimensionRelationshipCollection(view);
            if (shipCol == null || shipCol.isEmpty() || this.orgUnit == null) {
                return shipCol;
            }
            HashSet<String> numbers = new HashSet<String>();
            DimensionRelationshipInfo infos = null;
            Iterator it = shipCol.iterator();
            while (it.hasNext()) {
                infos = (DimensionRelationshipInfo)it.next();
                if (!numbers.contains(infos.getDimensionNumber())) {
                    numbers.add(infos.getDimensionNumber());
                    continue;
                }
                it.remove();
            }
            HashMap queryMap = new HashMap();
            DimensionRelationshipInfo info = null;
            String[] combins = null;
            String srcNumber = null;
            String number = null;
            List<String> otherDims = this.getSchemeHelper().getAccAndOtherDim(false);
            if (otherDims == null || otherDims.isEmpty()) {
                return shipCol;
            }
            MbgViewCollection col = MbgViewFactory.getRemoteInstance().getMbgViewCollection("select MbgDim.number, MbgDim.id, id where segregationRule <> 1");
            Map viewMap = BgCommHelper.transeToMap((IObjectCollection)col);
            Iterator<String> itDim = otherDims.iterator();
            while (itDim.hasNext()) {
                if (viewMap.containsKey(this.getSchemeHelper().getDimension(itDim.next()).getViewId())) continue;
                itDim.remove();
            }
            if (otherDims == null || otherDims.isEmpty()) {
                return shipCol;
            }
            String dimNumber = null;
            for (int i = 0; i < shipCol.size(); ++i) {
                info = shipCol.get(i);
                combins = info.getDimensionNumber().split(",");
                for (int c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    dimNumber = this.getSchemeHelper().getDimensionBySrcNumber().get(srcNumber).getNumber();
                    if (!otherDims.contains(dimNumber)) continue;
                    if (!queryMap.containsKey(dimNumber)) {
                        queryMap.put(dimNumber, new HashSet());
                    }
                    ((Set)queryMap.get(dimNumber)).add(number);
                }
            }
            if (queryMap.isEmpty()) {
                return shipCol;
            }
            HashMap<String, Map> memberMap = new HashMap<String, Map>();
            for (String dn : queryMap.keySet()) {
                memberMap.put(dn, DimensionFormulaFacadeFactory.getRemoteInstance().queryMembers(this.orgUnit.getId().toString(), this.getSchemeHelper(), dn, (Set)queryMap.get(dn), false, null));
            }
            block9: for (int i = shipCol.size() - 1; i >= 0; --i) {
                info = shipCol.get(i);
                combins = info.getDimensionNumber().split(",");
                for (int c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    dimNumber = this.getSchemeHelper().getDimensionBySrcNumber().get(srcNumber).getNumber();
                    if (!otherDims.contains(dimNumber) || memberMap.containsKey(dimNumber) && ((Map)memberMap.get(dimNumber)).containsKey(number)) continue;
                    shipCol.removeObject(i);
                    continue block9;
                }
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return shipCol;
    }

    protected void processPeriodN(DimensionRelationshipCollection shipCol) throws EASBizException, BOSException {
        if (this.getUIContext().get("BGFORM_ID") != null) {
            boolean hasPeriod = false;
            if (this.group != null && !this.group.getEntries().isEmpty()) {
                for (int i = 0; i < this.group.getEntries().size(); ++i) {
                    if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(this.group.getEntries().get(i).getDimNumber())) continue;
                    hasPeriod = true;
                    break;
                }
            }
            if (hasPeriod) {
                Serializable info;
                HashSet<String> bgPeriodNumbers = new HashSet<String>();
                HashSet<String> removeIds = new HashSet<String>();
                Object iDimDataQuery = null;
                String bgPeriodNumber = null;
                int targetPeriodType = 0;
                String bgFormId = (String)this.getUIContext().get("BGFORM_ID");
                String bosType = BOSUuid.read((String)bgFormId).getType().toString();
                if ("3BA5F027".equals(bosType) && BgFormFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(bgFormId))) {
                    info = BgFormFactory.getRemoteInstance().getBgFormInfo("select id, bgPeriod.*  where id = '" + bgFormId + "'");
                    bgPeriodNumber = ((AbstractBgFormInfo)info).getBgPeriod().getNumber();
                    targetPeriodType = ((AbstractBgFormInfo)info).getBgPeriod().getPeriodType().getValue();
                } else if ("655ADD42".equals(bosType) && BgCslFormFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(bgFormId))) {
                    info = BgCslFormFactory.getRemoteInstance().getBgCslFormInfo("select id, bgPeriod.*  where id = '" + bgFormId + "'");
                    bgPeriodNumber = info.getBgPeriod().getNumber();
                    targetPeriodType = info.getBgPeriod().getPeriodType().getValue();
                } else if ("9E7BD5E2".equals(bosType) && MbgWorkPaperFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(bgFormId))) {
                    info = MbgWorkPaperFactory.getRemoteInstance().getMbgWorkPaperInfo("select id, bgPeriod.*  where id = '" + bgFormId + "'");
                    bgPeriodNumber = info.getBgPeriod().getNumber();
                    targetPeriodType = info.getBgPeriod().getPeriodType().getValue();
                }
                if (!StringUtils.isEmpty(bgPeriodNumber)) {
                    info = null;
                    String oldDimNum = null;
                    String oldDimName = null;
                    String newDimNum = null;
                    String newDimName = null;
                    for (int i = 0; i < shipCol.size(); ++i) {
                        info = shipCol.get(i);
                        oldDimNum = ((AbstractDimensionRelationshipInfo)info).getDimensionNumber();
                        oldDimName = ((AbstractDimensionRelationshipInfo)info).getDimensionName();
                        String newNumber = null;
                        String[] arrNums = oldDimNum.split(",");
                        for (int m = 0; m < arrNums.length; ++m) {
                            String[] strNums;
                            String arrNum = arrNums[m];
                            if (arrNum.indexOf(":") <= 0 || !DimensionConstants.DEF_PERIOD_SRCNUMBER.equals((strNums = arrNum.split(":"))[0])) continue;
                            try {
                                if (!BgPeriodNVariableHelper.checkCanConvert((String)strNums[1])) continue;
                                newNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNumber, (String)strNums[1], (int)targetPeriodType);
                                continue;
                            }
                            catch (Exception e) {
                                removeIds.add(info.getId().toString());
                            }
                        }
                        if (StringUtils.isEmpty(newNumber)) continue;
                        bgPeriodNumbers.add(newNumber);
                    }
                    HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
                    EntityViewInfo views = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgPeriodNumbers, CompareType.INCLUDE));
                    views.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("name");
                    sic.add("number");
                    sic.add("isLeaf");
                    sic.add("longnumber");
                    views.getSelector().addObjectCollection((IObjectCollection)sic);
                    SorterItemInfo sore = new SorterItemInfo("longNumber");
                    sore.setSortType(SortType.DESCEND);
                    views.getSorter().add(sore);
                    BgPeriodCollection coll = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(views);
                    if (coll != null) {
                        for (int i = 0; i < coll.size(); ++i) {
                            periodMap.put(coll.get(i).getNumber(), coll.get(i));
                        }
                    }
                    if (!periodMap.isEmpty()) {
                        block8: for (int i = 0; i < shipCol.size(); ++i) {
                            info = shipCol.get(i);
                            oldDimNum = ((AbstractDimensionRelationshipInfo)info).getDimensionNumber();
                            oldDimName = ((AbstractDimensionRelationshipInfo)info).getDimensionName();
                            String newNumber = null;
                            String[] arrNums = oldDimNum.split(",");
                            for (int m = 0; m < arrNums.length; ++m) {
                                String[] strNums;
                                String arrNum = arrNums[m];
                                if (arrNum.indexOf(":") <= 0 || !DimensionConstants.DEF_PERIOD_SRCNUMBER.equals((strNums = arrNum.split(":"))[0])) continue;
                                try {
                                    if (!BgPeriodNVariableHelper.checkCanConvert((String)strNums[1])) continue block8;
                                    newNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNumber, (String)strNums[1], (int)targetPeriodType);
                                    if (!StringUtils.isEmpty((String)newNumber)) {
                                        newDimNum = oldDimNum.replace(arrNum, DimensionConstants.DEF_PERIOD_SRCNUMBER + ":" + newNumber);
                                        ((AbstractDimensionRelationshipInfo)info).setDimensionNumber(newDimNum);
                                        info.put("TRANS_PERIOD", Boolean.TRUE);
                                    }
                                    if (!periodMap.containsKey(newNumber)) continue block8;
                                    newDimName = oldDimName.replace(strNums[1], ((BgPeriodInfo)periodMap.get(newNumber)).getName());
                                    ((AbstractDimensionRelationshipInfo)info).setDimensionName(newDimName);
                                }
                                catch (Exception exception) {}
                                continue block8;
                            }
                        }
                    }
                }
                HashSet<String> checkRepet = new HashSet<String>();
                DimensionRelationshipInfo info2 = null;
                Iterator ite = shipCol.iterator();
                while (ite.hasNext()) {
                    info2 = (DimensionRelationshipInfo)ite.next();
                    if (checkRepet.contains(info2.getDimensionNumber())) {
                        ite.remove();
                        continue;
                    }
                    checkRepet.add(info2.getDimensionNumber());
                    if (!removeIds.contains(info2.getId().toString())) continue;
                    ite.remove();
                }
            }
        }
    }

    protected void fillValueToTableForSearch(String searchKey) throws EASBizException, BOSException {
        DimensionRelationshipCollection shipCol = this.getDimensionRelationshipCollection(searchKey);
        KDTDataRequestEvent e1 = this.loadFields(this.tblMain, shipCol);
        this.initRowValue(this, e1, this.tblMain, this.group);
    }

    protected void initParams() {
        Object obj = this.getUIContext().get("DimensionRelationshipGroup");
        if (obj instanceof DimensionRelationshipGroupInfo) {
            this.group = (DimensionRelationshipGroupInfo)obj;
        }
        if ((obj = this.getUIContext().get("orgUnit")) instanceof CostCenterOrgUnitInfo) {
            this.orgUnit = (CostCenterOrgUnitInfo)obj;
        }
        if ((obj = this.getUIContext().get("groupUnit")) instanceof FullOrgUnitInfo) {
            this.groupUnitInfo = (FullOrgUnitInfo)obj;
        }
    }

    protected SelectorItemCollection getRelationshipSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("dimensionNumber");
        sic.add("dimensionName");
        sic.add("dimensionGroup.id");
        sic.add("costUnit.id");
        sic.add("isEnabled");
        return sic;
    }

    @Override
    protected void textSearch_focusLost(FocusEvent e) throws Exception {
        super.textSearch_focusLost(e);
        String searchKey = this.textSearch.getText();
        if (searchKey.equals(this.firstSearchKey)) {
            return;
        }
        this.fillValueToTableForSearch(searchKey);
        this.firstSearchKey = searchKey;
        this.textSearch.requestFocus();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.changeAllRowState(false);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.changeAllRowState(true);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.getAllSelectRowObject();
        this.getUIWindow().close();
    }

    protected void changeAllRowState(boolean isSelect) {
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.tblMain.getCell(i, "select").setValue((Object)isSelect);
        }
    }

    protected void getAllSelectRowObject() {
        this.dimRelationCol = new DimensionRelationshipCollection();
        IRow row = null;
        DimensionRelationshipInfo shipInfo = null;
        boolean isSelect = false;
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            row = this.tblMain.getRow(i);
            isSelect = Boolean.parseBoolean(this.tblMain.getCell(i, "select").getValue().toString());
            if (row == null || !isSelect || this.dimRelationCol.contains(shipInfo = (DimensionRelationshipInfo)row.getUserObject())) continue;
            this.dimRelationCol.add(shipInfo);
        }
        if (this.dimRelationCol.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        if (this.dimRelationCol != null) {
            this.dimRelationCol.clear();
        }
        this.getUIWindow().close();
    }

    public DimensionRelationshipCollection getDimRelationCol() {
        return this.dimRelationCol;
    }

    public void setDimRelationCol(DimensionRelationshipCollection dimRelationCol) {
        this.dimRelationCol = dimRelationCol;
    }

    public String getFirstSearchKey() {
        return this.textSearch.getText();
    }

    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        return DimensionMemberSelectHelper.getSchemeHelper(this.getUIContext().get("Owner"));
    }
}

