/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDimensionSelectF7UI;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class MbgDimensionSelectF7UI
extends AbstractMbgDimensionSelectF7UI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDimensionSelectF7UI.class);
    private static final String col_number = "number";
    private static final String col_name = "name";
    public static final String SHOWDIMS = "SHOWDIMS";
    private boolean isCancel = true;
    private Object data = null;

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.data;
    }

    public void onLoad() throws Exception {
        this.tblLeft.checkParsed();
        this.tblRight.checkParsed();
        super.onLoad();
        this.fillData();
    }

    protected void fillData() {
        List showDims = new ArrayList();
        if (this.getUIContext().get(SHOWDIMS) instanceof List) {
            showDims = (List)this.getUIContext().get(SHOWDIMS);
        }
        if (this.getUIContext().get("BGSCHEME_HELPER") instanceof BgSchemeDimensionHelper) {
            List<BgDimensionInfo> allDimensions;
            BgSchemeDimensionHelper schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
            this.tblLeft.removeRows();
            this.tblRight.removeRows();
            IRow row = null;
            HashSet<String> rightNumbers = new HashSet<String>();
            if (showDims != null) {
                for (BgDimensionInfo info : showDims) {
                    row = this.tblRight.addRow();
                    row.getCell(col_number).setValue((Object)info.getNumber());
                    row.getCell(col_name).setValue((Object)info.getName());
                    row.setUserObject((Object)info);
                    rightNumbers.add(info.getNumber());
                }
            }
            if ((allDimensions = schemeHelper.getAllDimensions()) != null && !allDimensions.isEmpty()) {
                for (BgDimensionInfo info : allDimensions) {
                    if (rightNumbers.contains(info.getNumber())) continue;
                    row = this.tblLeft.addRow();
                    row.getCell(col_number).setValue((Object)info.getNumber());
                    row.getCell(col_name).setValue((Object)info.getName());
                    row.setUserObject((Object)info);
                }
            }
        }
    }

    @Override
    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        this.checkSelectRow(this.tblLeft);
        if (e.getClickCount() == 2) {
            this.addRows(BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft));
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblLeft);
        this.addRows(BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft));
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        this.addRows(BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblLeft));
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        List rowIndexs = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight);
        if (rowIndexs.size() == this.tblRight.getRowCount()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"selectedDims_notEmpty"));
            return;
        }
        this.removeRows(BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight));
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"selectedDims_notEmpty"));
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveTop((KDTable)this.tblRight);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveUp((KDTable)this.tblRight);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveBottom((KDTable)this.tblRight);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow(this.tblRight);
        BgCommCHelper.moveDown((KDTable)this.tblRight);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblRight.getRowCount() > 0) {
            ArrayList<BgDimensionInfo> showDims = new ArrayList<BgDimensionInfo>();
            for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
                if (!(this.tblRight.getRow(i).getUserObject() instanceof BgDimensionInfo)) continue;
                showDims.add((BgDimensionInfo)this.tblRight.getRow(i).getUserObject());
            }
            this.data = showDims;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    protected void checkSelectRow(KDTable table) {
        if (table.getSelectManager().getBlocks() == null || table.getSelectManager().getBlocks().isEmpty()) {
            if (this.tblLeft == table) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"checkLeftSelectRow"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"checkRightSelectRow"));
            }
            SysUtil.abort();
        }
    }

    protected void addRows(List<Integer> rows) {
        int i;
        if (rows == null || rows.isEmpty()) {
            return;
        }
        String number = null;
        HashSet<String> selectedNumbers = new HashSet<String>();
        for (i = 0; i < this.tblRight.getRowCount(); ++i) {
            number = NumberExpandHelper.getNumber((IRow)this.tblRight.getRow(i));
            selectedNumbers.add(number);
        }
        for (i = 0; i < rows.size(); ++i) {
            int rowIndex = rows.get(i);
            IRow row = this.tblLeft.getRow(rowIndex);
            number = NumberExpandHelper.getNumber((IRow)row);
            if (selectedNumbers.contains(number)) continue;
            this.addOneRow(rowIndex);
            selectedNumbers.add(number);
        }
        if (this.tblLeft.getRowCount() > 0) {
            for (i = this.tblLeft.getRowCount() - 1; i >= 0; --i) {
                IRow row = this.tblLeft.getRow(i);
                number = NumberExpandHelper.getNumber((IRow)row);
                if (!selectedNumbers.contains(number)) continue;
                this.tblLeft.removeRow(i);
            }
        }
    }

    protected void addOneRow(int rowIndex) {
        IRow row = this.tblLeft.getRow(rowIndex);
        if (row == null) {
            return;
        }
        IRow newRow = this.tblRight.addRow();
        newRow.getCell(col_number).setValue(row.getCell(col_number).getValue());
        newRow.getCell(col_name).setValue(row.getCell(col_name).getValue());
        newRow.setUserObject(row.getUserObject());
    }

    protected void removeRows(List<Integer> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        Collections.sort(rows);
        for (int i = rows.size() - 1; i >= 0; --i) {
            IRow row = this.tblRight.getRow(rows.get(i).intValue());
            IRow newRow = this.tblLeft.addRow();
            newRow.getCell(col_number).setValue(row.getCell(col_number).getValue());
            newRow.getCell(col_name).setValue(row.getCell(col_name).getValue());
            newRow.setUserObject(row.getUserObject());
            this.tblRight.removeRow(rows.get(i).intValue());
        }
    }
}

