/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgFormActualBlockSetUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgFormActualBlockSetUI
extends AbstractMbgFormActualBlockSetUI {
    public static final String FILTER_ORGUNITIDS = "FILTER_ORGUNITIDS";
    private static final Logger logger = CoreUIObject.getLogger(MbgFormActualBlockSetUI.class);
    private Set<String> orgIds;

    public void setOrgIds(Set<String> orgIds) {
        this.orgIds = orgIds;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void initTable() {
    }

    @Override
    public void onLoad() throws Exception {
        if (this.getUIContext().get(FILTER_ORGUNITIDS) != null) {
            this.orgIds = (Set)this.getUIContext().get(FILTER_ORGUNITIDS);
        }
        super.onLoad();
    }

    @Override
    protected Set<Integer> getDefaultState() {
        HashSet<Integer> states = new HashSet<Integer>();
        if (!this.cbxShowAllBgForm.isSelected()) {
            states.add(new Integer(2));
            states.add(new Integer(51));
            states.add(new Integer(50));
            states.add(new Integer(6));
            states.add(new Integer(12));
        }
        return states;
    }

    private Set<Integer> getFilterState() {
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(4);
        states.add(15);
        return states;
    }

    @Override
    protected void cbxShowAllBgForm_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxShowAllBgForm_itemStateChanged(e);
        this.execQuery();
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        RptSrcTypeEnum sourceType = BgNFCHelper.getSourceType((IUIObject)this);
        String bgSchemeId = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null, CompareType.IS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        filter.setMaskString("(#0 or #1)");
        BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgTemplate.readonly", (Object)false, CompareType.EQUALS));
        BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgVersion.number", (Object)"Ve", CompareType.EQUALS));
        BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("processType", (Object)1, CompareType.EQUALS));
        BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("orgUnit.id", this.orgIds, CompareType.INCLUDE));
        if (!this.getDefaultState().isEmpty()) {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("state", this.getDefaultState(), CompareType.INCLUDE));
        } else {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("state", this.getFilterState(), CompareType.NOTINCLUDE));
        }
        if (bgSchemeId != null) {
            try {
                MbgPermissionHelper.addFieldDataPermission(sourceType, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter, MbgPermissionTypeEnum.TEMPLATE, "bgtemplate.id", bgSchemeId);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.activeBgForm();
    }

    private void activeBgForm() throws BOSException, EASBizException {
        String selectedKeyValue = this.getSelectedKeyValue();
        if (!StringUtils.isEmpty((String)selectedKeyValue)) {
            BOSUuid bgFormId = BOSUuid.read((String)selectedKeyValue);
            BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getSelectors());
            this.setBgform(bgForm);
        }
        this.setHasCancel(false);
        this.destroyWindow();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.activeBgForm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor executor = super.getQueryExecutor(queryPK, viewInfo);
        FilterInfo filter = this.getDefaultFilterForQuery();
        StringBuilder builder = new StringBuilder(filter.getMaskString());
        int size1 = filter.getFilterItems().size();
        if (!StringUtils.isEmpty((String)this.txtQuery.getText())) {
            String txt = "%" + this.txtQuery.getText().trim() + "%";
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("currency.name", (Object)txt, CompareType.LIKE));
            int size2 = filter.getFilterItems().size();
            for (int i = size1; i < size2; ++i) {
                if (i == size1) {
                    builder.append(" AND (").append("#").append(i).append(" OR ");
                    continue;
                }
                if (i == size2 - 1) {
                    builder.append("#").append(i).append(")");
                    continue;
                }
                builder.append("#").append(i).append(" OR ");
            }
            filter.setMaskString(builder.toString());
        }
        viewInfo.setFilter(filter);
        return executor;
    }

    public void dataChanged(DataChangeEvent eventObj) {
    }
}

