/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IMbgPermission;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.UserGroupInfo;
import com.kingdee.eas.ma.mbg.client.AbstractMbgPermissionListUI;
import com.kingdee.eas.ma.mbg.client.BgTypeSelectorDialog;
import com.kingdee.eas.ma.mbg.client.MbgPermissionEditUI;
import com.kingdee.eas.ma.mbg.client.MbgUserRoleBaseF7Dialog;
import com.kingdee.eas.ma.mbg.client.UserGroupListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgPermissionListUI
extends AbstractMbgPermissionListUI {
    private static final Logger logger = CoreUIObject.getLogger(MbgPermissionListUI.class);
    private MetaDataPK noUserQueryPK = MetaDataPK.create((String)"com.kingdee.eas.ma.mbg", (String)"MbgPermissionQuery");
    private MetaDataPK userQueryPK = MetaDataPK.create((String)"com.kingdee.eas.ma.mbg", (String)"MbgPermissionForUserQuery");
    private static final String RES = "com.kingdee.eas.ma.mbg.MbgPermissionResource";
    private final String COL_PERSON_NUMBER = "person.number";
    private final String COL_PERSON_NAME = "person.name";
    private final String COL_USER_NUMBER = "user.number";
    private final String COL_USER_NAME = "user.name";
    private final String COL_USERGROUP_NUMBER = "userGroup.number";
    private final String COL_DISP_NUMBER = "dispNumber";
    private final String COL_DISP_NAME = "dispName";
    private final String COL_ID = "id";
    private final String COL_SHEET_NAME = "bgTemplateSheet";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.prmtBgType.setSelector(this.getBgTypeSelectorDialog());
    }

    protected KDPromptSelector getBgTypeSelectorDialog() {
        BgTypeSelectorDialog dialog = new BgTypeSelectorDialog();
        dialog.setDisplaySelf(true);
        dialog.setOnlyDisplaySelf(false);
        dialog.setSourceType(this.getSourceType());
        return dialog;
    }

    protected void initTable() {
        this.tblMain.getColumn("person.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("person.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("user.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("user.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("userGroup.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bgTemplateSheet").setSortable(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtPerson.setEditable(false);
        this.prmtUserGroup.setEditable(false);
        this.prmtBgScheme.setEditable(false);
        this.prmtBgType.setEditable(false);
        this.prmtBgTemplate.setEditable(false);
        this.prmtOrgUnit.setEditable(false);
        this.initUserF7();
        BgCommCHelper.initOrgUnit((CoreUIObject)this, (KDBizPromptBox)this.prmtOrgUnit, null, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)this.getListPermission());
        this.prmtUserGroup.setQueryInfo("com.kingdee.eas.ma.mbg.UserGroupQuery");
        this.prmtBgScheme.setQueryInfo("com.kingdee.eas.ma.mbg.BgSchemeF7Query");
        this.prmtBgType.setQueryInfo("com.kingdee.eas.ma.mbg.BgTypeQuery");
        this.prmtBgTemplate.setQueryInfo("com.kingdee.eas.ma.mbg.BgTemplateF7Query");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String longnumber = SysContext.getSysContext().getCurrentOrgUnit().getLongNumber();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.longnumber", (Object)longnumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.longnumber", (Object)(longnumber + "!%"), CompareType.LIKE));
        filter.setMaskString(" #0 OR #1 ");
        this.prmtUserGroup.setEntityViewInfo(view);
        view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgSchemeType.schemeType", (Object)this.getSourceType().getValue()));
        this.prmtBgScheme.setEntityViewInfo(view);
        this.prmtBgTemplate.setEnabledMultiSelection(true);
        this.prmtBgTemplate.setDisplayFormat("$name$");
        this.prmtBgTemplate.setEditFormat("$number$");
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentOrgUnit());
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuUserGroup.setEnabled(true);
        this.menuUserGroup.setIcon(EASResource.getIcon((String)"imgTbtn_usermanage"));
        this.btnUserGroup.setIcon(EASResource.getIcon((String)"imgTbtn_usermanage"));
        this.btnUserGroup.setEnabled(true);
    }

    protected String getListPermission() {
        return "mbg_MbgPermission01_list";
    }

    private void initUserF7() {
        MbgUserRoleBaseF7Dialog userDialog = new MbgUserRoleBaseF7Dialog();
        userDialog.setUserUI(true);
        userDialog.setOrgUnit((OrgUnitInfo)SysContext.getSysContext().getCurrentCtrlUnit());
        userDialog.setSelectedData(this.getSelectedData());
        this.prmtPerson.setSelector((KDPromptSelector)userDialog);
        this.prmtPerson.setDisplayFormat("$name$");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return MbgPermissionEditUI.class.getName();
    }

    private IObjectCollection getSelectedData() {
        Object obj = this.prmtPerson.getData();
        UserCollection userColls = MbgPermissionHelper.getUserCollectionByObject(obj);
        return userColls;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MbgPermissionFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        UserCollection userColl = MbgPermissionHelper.getUserCollectionByObject(this.prmtPerson.getData());
        UserGroupInfo userGroup = (UserGroupInfo)this.prmtUserGroup.getData();
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgTypeInfo bgType = (BgTypeInfo)this.prmtBgType.getData();
        Object[] bgTemplates = (Object[])this.prmtBgTemplate.getData();
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtOrgUnit.getData();
        EntityViewInfo view = (EntityViewInfo)viewInfo.clone();
        FilterInfo filter = view.getFilter();
        if (filter != null) {
            if (filter.getFilterItems().size() > 0 && filter.getMaskString() != null && filter.getMaskString().length() > 0) {
                filter.setMaskString("(" + filter.getMaskString() + ")");
            }
        } else {
            filter = new FilterInfo();
            filter.setMaskString("");
        }
        view.setFilter(filter);
        if (orgUnit == null) {
            OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.longnumber", (Object)currOrgUnit.getLongNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.longnumber", (Object)(currOrgUnit.getLongNumber() + "!%"), CompareType.LIKE));
            if (filter.getFilterItems().size() <= 2) {
                filter.setMaskString("( #0 or #1 )");
            } else {
                filter.setMaskString(filter.getMaskString() + " and ( #" + (filter.getFilterItems().size() - 2) + " or #" + (filter.getFilterItems().size() - 1) + " )");
            }
        }
        if (userGroup != null) {
            BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("userGroup.id", (Object)userGroup.getId().toString(), CompareType.EQUALS));
        }
        if (bgScheme != null) {
            BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        }
        if (bgType != null) {
            BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgType.id", (Object)bgType.getId().toString(), CompareType.EQUALS));
        }
        if (bgTemplates != null && bgTemplates.length > 0) {
            HashSet<String> bgTemplateIDs = new HashSet<String>();
            for (int i = 0; i < bgTemplates.length; ++i) {
                if (bgTemplates[i] == null || !(bgTemplates[i] instanceof BgTemplateInfo)) continue;
                bgTemplateIDs.add(((BgTemplateInfo)bgTemplates[i]).getId().toString());
            }
            if (bgTemplateIDs.size() > 0) {
                BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgTemplate.id", bgTemplateIDs, CompareType.INCLUDE));
            }
        }
        if (orgUnit != null) {
            BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString(), CompareType.EQUALS));
        }
        BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
        if (userColl == null || userColl.isEmpty()) {
            view.setSelector(this.getSelector(false));
            queryPK = this.noUserQueryPK;
            SorterItemInfo sortItem1 = new SorterItemInfo("userGroup.number");
            sortItem1.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem1);
            SorterItemInfo sortItem2 = new SorterItemInfo("person.number");
            sortItem2.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem2);
            this.replaceUserColSorter(view.getSorter());
        } else {
            view.setSelector(this.getSelector(true));
            queryPK = this.userQueryPK;
            SorterItemInfo sortItem2 = new SorterItemInfo("dispnumber");
            sortItem2.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem2);
            SorterItemInfo sortItem1 = new SorterItemInfo("userGroup.number");
            sortItem1.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem1);
            HashSet<String> users = new HashSet<String>();
            for (int i = 0; i < userColl.size(); ++i) {
                users.add(userColl.get(i).getId().toString());
            }
            FilterItemInfo filterItem1 = new FilterItemInfo("person.id", users, CompareType.INCLUDE);
            FilterItemInfo filterItem2 = new FilterItemInfo("user.id", users, CompareType.INCLUDE);
            if (BgNFCHelper.findFilterItem(filter, "person.id") != null) {
                BgNFCHelper.replaceFilterItems(filter, filterItem1);
                BgNFCHelper.replaceFilterItems(filter, filterItem2);
            } else {
                int size = filter.getFilterItems().size();
                filter.getFilterItems().add(filterItem1);
                filter.getFilterItems().add(filterItem2);
                String maskStr = "";
                if (filter.getMaskString().length() != 0) {
                    maskStr = filter.getMaskString() + " AND ";
                }
                maskStr = maskStr + "( #" + size + " OR #" + (size + 1) + " ) ";
                filter.setMaskString(maskStr);
            }
        }
        return super.getQueryExecutor(queryPK, view);
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    private void replaceUserColSorter(SorterItemCollection sorter) {
        if (sorter == null) {
            return;
        }
        for (int i = 0; i < sorter.size(); ++i) {
            SorterItemInfo tmpItem = sorter.get(i);
            if (!tmpItem.getPropertyName().equals("dispname")) continue;
            tmpItem.setPropertyName("person.name");
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private SelectorItemCollection getSelector(boolean showRefUser) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("person.number");
        selector.add("person.name");
        selector.add("userGroup.name");
        selector.add("permissionType");
        selector.add("bgscheme.name");
        selector.add("bgType.name");
        selector.add("bgTemplate.name");
        selector.add("createTime");
        selector.add("creator.name");
        selector.add("orgunit.name");
        selector.add("bgOrgUnit.name");
        selector.add("bgOrgUnit.number");
        if (showRefUser) {
            selector.add("user.id");
            selector.add("user.number");
            selector.add("user.name");
            selector.add("dispnumber");
            selector.add("dispname");
        }
        return selector;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int first = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        for (int index = first; index <= last; ++index) {
            row = this.tblMain.getRow(index);
            if (this.isSysGenerate(row)) {
                row.getStyleAttributes().setBackground(new Color(235, 235, 235));
            }
            ids.add(row.getCell("id").getValue().toString());
            if (row.getCell("dispName").getValue() != null) continue;
            row.getCell("dispNumber").setValue(row.getCell("person.number").getValue() != null ? row.getCell("person.number").getValue() : row.getCell("user.number").getValue());
            row.getCell("dispName").setValue(row.getCell("person.name").getValue() != null ? row.getCell("person.name").getValue() : row.getCell("user.name").getValue());
        }
        try {
            Map map = ((IMbgPermission)this.getBizInterface()).getSheetName(ids);
            if (map != null && !map.isEmpty()) {
                for (int index = first; index <= last; ++index) {
                    row = this.tblMain.getRow(index);
                    if (!map.containsKey(row.getCell("id").getValue().toString())) continue;
                    String sheetName = (String)map.get(row.getCell("id").getValue().toString());
                    row.getCell("bgTemplateSheet").setValue((Object)sheetName);
                }
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            if (e.getClickCount() != 2) {
                super.tblMain_tableClicked(e);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    protected void prmtPerson_dataChanged(DataChangeEvent e) throws Exception {
        this.initUserF7();
        if (this.prmtPerson.getData() != null) {
            this.prmtOrgUnit.setData(null);
        }
        this.tblMain.refresh();
    }

    @Override
    protected void prmtUserGroup_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtUserGroup.getData() != null) {
            this.prmtOrgUnit.setData(null);
        }
        this.tblMain.refresh();
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo scheme = (BgSchemeInfo)e.getNewValue();
        if (scheme != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)scheme.getId().toString(), CompareType.EQUALS));
            if (this.prmtBgTemplate.getData() != null) {
                this.prmtBgTemplate.setData(null);
            }
            this.prmtBgTemplate.setEntityViewInfo(view);
        } else {
            this.prmtBgTemplate.setEntityViewInfo(null);
        }
        this.tblMain.refresh();
    }

    @Override
    protected void prmtBgTemplate_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"select_bgScheme"));
            e.setCanceled(true);
        }
    }

    @Override
    protected void prmtBgType_dataChanged(DataChangeEvent e) throws Exception {
        this.tblMain.refresh();
    }

    @Override
    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.tblMain.refresh();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.tblMain.refresh();
    }

    @Override
    public void actionUserGroup_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getUserGroupUIName(), (Map)ctx, null, OprtState.EDIT);
        window.show();
    }

    protected String getUserGroupUIName() {
        return UserGroupListUI.class.getName();
    }

    @Override
    protected void btnUserGroup_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        BgNFCHelper.putSourceType(uiContext, (CoreUI)this);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.refresh(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        super.actionRemove_actionPerformed(e);
        MbgPermissionFactory.getRemoteInstance().deleteSheetPermission(ids);
        this.refresh(e);
    }

    protected boolean confirmRemove() {
        Set<String> sysGenerateIds = this.getSysGenerateIdsAndUnSelectRow();
        if (sysGenerateIds.isEmpty()) {
            return super.confirmRemove();
        }
        if (sysGenerateIds.size() == this.getSelectedIdValues().size()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)MbgPermissionHelper.resource, (String)"cantDeleteSysGenerateData"));
            return false;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)MbgPermissionHelper.resource, (String)"isDeleteSysGenerateData")))) {
            this.unSelectRow();
            return true;
        }
        return false;
    }

    private void unSelectRow() {
        IRow row = null;
        KDTSelectBlock curBlock = null;
        List rowIndexs = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
        for (int i = 0; i < rowIndexs.size(); ++i) {
            row = this.tblMain.getRow(((Integer)rowIndexs.get(i)).intValue());
            if (!this.isSysGenerate(row)) continue;
            curBlock = new KDTSelectBlock(((Integer)rowIndexs.get(i)).intValue(), 0, ((Integer)rowIndexs.get(i)).intValue(), 0, 2);
            this.tblMain.getSelectManager().unselect(curBlock, false);
        }
    }

    private Set<String> getSysGenerateIdsAndUnSelectRow() {
        HashSet<String> sysGenerateIds = new HashSet<String>();
        IRow row = null;
        KDTSelectBlock curBlock = null;
        List rowIndexs = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
        for (int i = 0; i < rowIndexs.size(); ++i) {
            row = this.tblMain.getRow(((Integer)rowIndexs.get(i)).intValue());
            if (!this.isSysGenerate(row)) continue;
            curBlock = new KDTSelectBlock(((Integer)rowIndexs.get(i)).intValue(), 0, ((Integer)rowIndexs.get(i)).intValue(), 0, 2);
            sysGenerateIds.add(row.getCell("id").getValue().toString());
        }
        return sysGenerateIds;
    }

    private boolean isSysGenerate(IRow row) {
        if (row == null) {
            return false;
        }
        return StringUtils.isEmpty((String)((String)row.getCell("person.name").getValue())) && !StringUtils.isEmpty((String)((String)row.getCell("user.name").getValue()));
    }

    @Override
    protected void prmtBgType_willShow(SelectorEvent e) throws Exception {
    }
}

