/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgQingAnalyseCreateDataUI;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.QingDataFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgQingAnalyseCreateDataUI
extends AbstractMbgQingAnalyseCreateDataUI {
    private static final Logger logger = CoreUIObject.getLogger(MbgQingAnalyseCreateDataUI.class);
    private final String COL_ID = "id";
    private final String COL_NUMBER = "number";
    private final String COL_NAME = "name";
    private final String COL_TEMPLATETYPE = "templateType";
    private BgOrgUnitInfo bgOrgUnitInfo;
    private final String QINGANALYSE_BGSCHEME = "QINGANALYSE_BGSCHEME";
    private final String QINGANALYSE_BGTEMPLATE = "QINGANALYSE_BGTEMPLATE";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.prepareContext();
        this.initOrgPrmt(this.bgOrgUnitInfo);
    }

    private void prepareContext() {
        if (null != this.getUIContext().get("ORGUNIT_COST") && this.getUIContext().get("ORGUNIT_COST") instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.getUIContext().get("ORGUNIT_COST");
            this.prmtOrgUnit.setDataNoNotify((Object)orgUnitInfo);
        }
        if (null != this.getUIContext().get("BGSCHEME_INFO") && this.getUIContext().get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            this.prmtBgScheme.setDataNoNotify((Object)bgSchemeInfo);
        }
        if (null != this.getUIContext().get("BGORGUNIT_INFO") && this.getUIContext().get("BGORGUNIT_INFO") instanceof BgOrgUnitInfo) {
            this.bgOrgUnitInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
        } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
            this.prmtBgOrgUnit.setDataNoNotify(null);
            this.initOrgPrmt(null);
            this.tblMain.removeRows();
        }
    }

    private void initOrgPrmt(BgOrgUnitInfo bgOrgUnitInfo) throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgViewOrgDimensionF7 orgDialog = new BgViewOrgDimensionF7((IUIObject)this);
        orgDialog.setPermissionFilter(true);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgSchemeInfo.getId().toString());
        orgDialog.setBgOrgViewId(schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
        Set orgID = this.getCanSelectOrgIds(orgDialog.getBgOrgViewId());
        orgDialog.setOrgIds(orgID);
        orgDialog.setOrgUnitId(bgSchemeInfo.getOrgUnit().getId().toString());
        orgDialog.setShowVirtualOrg(false);
        orgDialog.setOnlyNoLeaf(false);
        orgDialog.setOnlyLeaf(false);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)orgDialog);
        if (bgOrgUnitInfo != null && orgID.contains(bgOrgUnitInfo.getOrgUnitID())) {
            this.prmtBgOrgUnit.setData((Object)bgOrgUnitInfo);
        } else {
            this.prmtBgOrgUnit.setData(null);
        }
    }

    private Set getCanSelectOrgIds(String bgOrgViewId) throws BOSException {
        HashSet<String> selectOrgIds = new HashSet<String>();
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            return selectOrgIds;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("orgUnitID");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTransferQingAnalyse", (Object)true, CompareType.EQUALS));
        view.setFilter(filterInfo);
        BgOrgUnitCollection col = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            selectOrgIds.add(col.get(i).getOrgUnitID());
        }
        return selectOrgIds;
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])this.prmtOrgUnit.getData();
            BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, orgUnits[0], false, RptSrcTypeEnum.PT_BUDGET_REPORT, false, false);
        } else if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtOrgUnit.getData(), false, RptSrcTypeEnum.PT_BUDGET_REPORT, false, false);
        }
        EntityViewInfo evi = this.prmtBgScheme.getEntityViewInfo();
        FilterInfo filter = evi.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("isEnableAnalyse", (Object)true, CompareType.EQUALS));
        this.prmtBgScheme.setEntityViewInfo(evi);
        this.prmtBgScheme.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null || DimensionCommonHelper.isEquals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.fillTable(this.queryBgTemplate());
    }

    private void fillTable(BgTemplateCollection templates) {
        this.tblMain.removeRows();
        if (null == templates || templates.isEmpty()) {
            return;
        }
        int in = templates.size();
        for (int i = 0; i < in; ++i) {
            BgTemplateInfo bgTemplateInfo = templates.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
            row.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
            row.getCell("name").setValue((Object)bgTemplateInfo.getName());
            row.getCell("templateType").setValue((Object)bgTemplateInfo.getFormType().getAlias());
            row.setUserObject((Object)bgTemplateInfo);
        }
    }

    private BgTemplateCollection queryBgTemplate() throws BOSException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("formType");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isTransferQingAnalyse", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)bgOrgUnitInfo.getOrgUnitID(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select  FBgTemplateID from T_MBG_BgTemplateNode where FOrgUnitID = '" + bgOrgUnitInfo.getOrgUnitID() + "'"), CompareType.INNER));
        filter.setMaskString(" #0 AND #1 AND ( #2 OR #3 )");
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        return BgTemplateFactory.getRemoteInstance().getBgTemplateCollection(view);
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveTop((KDTable)this.tblMain);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveUp((KDTable)this.tblMain);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveDown((KDTable)this.tblMain);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveBottom((KDTable)this.tblMain);
    }

    @Override
    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (null == this.prmtBgScheme.getData()) {
                this.prmtBgScheme.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
                re = false;
            }
            if (re && null == this.prmtBgOrgUnit.getData()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgDataQueryResource", (String)"msgCheckSelect", (Object[])new Object[]{this.contBgOrgUnit.getBoundLabelText()}));
                re = false;
            }
        }
        return re;
    }

    @Override
    protected FilterParam createFilterParam() {
        return new QingDataFilterParam();
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (null == cp || null == filterParam || !(filterParam instanceof QingDataFilterParam)) {
            return;
        }
        QingDataFilterParam _filterParam = (QingDataFilterParam)filterParam;
        String id = cp.getCustomerParam("QINGANALYSE_BGSCHEME");
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScheme(new BgSchemeInfo());
            _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScheme(null);
        }
        Set bgTemplateInfos = (Set)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam("QINGANALYSE_BGTEMPLATE")));
        if (null != bgTemplateInfos && !bgTemplateInfos.isEmpty()) {
            _filterParam.setBgtemplateInfos(bgTemplateInfos);
        } else {
            _filterParam.setBgtemplateInfos(null);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (null == cp || null == filterParam || !(filterParam instanceof QingDataFilterParam)) {
            return;
        }
        QingDataFilterParam _filterParam = (QingDataFilterParam)filterParam;
        if (null != _filterParam.getBgScheme()) {
            cp.addCustomerParam("QINGANALYSE_BGSCHEME", _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam("QINGANALYSE_BGSCHEME");
        }
        if (null != _filterParam.getBgtemplateInfos()) {
            cp.addCustomerParam("QINGANALYSE_BGTEMPLATE", BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(_filterParam.getBgtemplateInfos())));
        } else {
            cp.removeCustomerParam("QINGANALYSE_BGTEMPLATE");
        }
    }

    @Override
    protected void loadFromParams(FilterParam filterParam) {
        super.loadFromParams(filterParam);
        if (null == filterParam || !(filterParam instanceof QingDataFilterParam)) {
            return;
        }
        QingDataFilterParam _filterParam = (QingDataFilterParam)filterParam;
        this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
        if (null != _filterParam.getBgOrgUnits()) {
            BgOrgUnitInfo[] bgOrgUnitsTemp = _filterParam.getBgOrgUnits();
            BgOrgUnitInfo[] bgOrgUnits = new BgOrgUnitInfo[_filterParam.getBgOrgUnits().length];
            int in = _filterParam.getBgOrgUnits().length;
            for (int i = 0; i < in; ++i) {
                bgOrgUnits[i] = bgOrgUnitsTemp[i];
            }
            this.prmtBgOrgUnit.setDataNoNotify((Object)bgOrgUnits[0]);
        } else {
            this.prmtBgOrgUnit.setDataNoNotify(null);
        }
        this.tblMain.removeRows();
        Set<BgTemplateInfo> bgtemplateInfos = _filterParam.getBgtemplateInfos();
        for (BgTemplateInfo bgTemplateInfo : bgtemplateInfos) {
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
            row.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
            row.getCell("name").setValue((Object)bgTemplateInfo.getName());
            row.getCell("templateType").setValue((Object)bgTemplateInfo.getFormType().getAlias());
            row.setUserObject((Object)bgTemplateInfo);
        }
    }

    @Override
    protected void saveToParams(FilterParam filterParam) {
        super.saveToParams(filterParam);
        if (null == filterParam || !(filterParam instanceof QingDataFilterParam)) {
            return;
        }
        QingDataFilterParam _filterParam = (QingDataFilterParam)filterParam;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            _filterParam.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        } else {
            _filterParam.setBgScheme(null);
        }
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
            _filterParam.setBgOrgUnits(orgUnits);
        } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            BgOrgUnitInfo[] orgUnits = new BgOrgUnitInfo[]{_orgUnit};
            _filterParam.setBgOrgUnits(orgUnits);
        }
        if (this.tblMain.getRowCount() > 0) {
            LinkedHashSet<BgTemplateInfo> bgTemplateInfos = new LinkedHashSet<BgTemplateInfo>();
            int in = this.tblMain.getRowCount();
            for (int i = 0; i < in; ++i) {
                BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)this.tblMain.getRow(i).getUserObject();
                bgTemplateInfos.add(bgTemplateInfo);
            }
            _filterParam.setBgtemplateInfos(bgTemplateInfos);
        }
    }

    @Override
    public void clear() {
        super.clear();
    }
}

