/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFileInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseIntegrateFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgQingAnalyseFileConvertUI;
import com.kingdee.eas.ma.mbg.client.ProgressDialogUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MbgQingAnalyseFileConvertUI
extends AbstractMbgQingAnalyseFileConvertUI {
    private static final long serialVersionUID = -5911480686481275486L;
    private static final Logger logger = CoreUIObject.getLogger(MbgQingAnalyseFileConvertUI.class);
    private BgSchemeInfo bgSchemeInfo;
    private OrgUnitInfo orgUnitInfo;
    private BgSchemeDimensionHelper helper;

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public BgSchemeDimensionHelper getHelper() {
        return this.helper;
    }

    public void setHelper(BgSchemeDimensionHelper helper) {
        this.helper = helper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initFileSplitType(this.bgSchemeInfo.getId().toString());
    }

    private void initFileSplitType(String bgSchemeId) throws EASBizException, BOSException {
        this.helper = new BgSchemeDimensionHelper(bgSchemeId);
        Iterator<BgDimensionInfo> iter = this.helper.getAllDimensions().iterator();
        while (iter.hasNext()) {
            this.cbxSplitType.addItem((Object)this.toToString(iter.next()));
        }
        String splitFileType = null;
        if (splitFileType == null) {
            this.cbxSplitType.setSelectedItem((Object)this.toToString(this.helper.getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER)));
        } else {
            this.cbxSplitType.setSelectedItem((Object)this.toToString(this.helper.getDimension(splitFileType)));
        }
    }

    private String toToString(BgDimensionInfo info) {
        return info.getName() + "[" + info.getNumber() + "]";
    }

    private void init() {
        Object obj = this.getUIContext().get("BGSCHEME_INFO");
        if (obj instanceof BgSchemeInfo) {
            this.bgSchemeInfo = (BgSchemeInfo)obj;
            if (this.bgSchemeInfo != null) {
                this.prmtBgScheme.setData((Object)this.bgSchemeInfo);
            }
        }
        if ((obj = this.getUIContext().get("BGORGUNIT_INFO")) instanceof OrgUnitInfo) {
            this.orgUnitInfo = (OrgUnitInfo)obj;
        }
        this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"splitFileType"));
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        if (newInfo == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"isNullBgScheme"));
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        this.cbxSplitType.removeAllItems();
        this.initFileSplitType(newInfo.getId().toString());
        this.setBgSchemeInfo(newInfo);
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, this.orgUnitInfo, false, RptSrcTypeEnum.PT_BUDGET_REPORT, false, false);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"convertQingFileConfirmMsg"));
        if (result == 2) {
            return;
        }
        String targetNumber = (String)this.cbxSplitType.getSelectedItem();
        targetNumber = targetNumber.substring(targetNumber.indexOf("[") + 1, targetNumber.indexOf("]"));
        Object qingFileType = null;
        this.verify(targetNumber);
        if (targetNumber != null && !targetNumber.equals(qingFileType)) {
            List fileData = MbgQingAnalyseIntegrateFactory.getRemoteInstance().splitQingAnalyseFile(this.bgSchemeInfo.getId().toString(), targetNumber);
            UIContext ctx = new UIContext((Object)this);
            SimpleTimer time = new SimpleTimer();
            IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)ctx);
            if (win != null && win.getUIObject() instanceof ProgressDialogUI) {
                ProgressDialogUI ui = (ProgressDialogUI)win.getUIObject();
                logger.debug((Object)("begin qingAnalyseFile Convert time :" + time.getTime()));
                this.initParameterValue(targetNumber, fileData, ui);
                ui.init();
                logger.debug((Object)("end qingAnalyseFile convert time :" + time.getTime()));
                ui.show();
            }
        }
    }

    public void initParameterValue(String targetNumber, List fileData, ProgressDialogUI ui) {
        int objlength = 5;
        Class[] param = new Class[objlength];
        param[0] = String.class;
        param[1] = String.class;
        param[2] = String.class;
        param[3] = String.class;
        param[4] = String.class;
        Object[] obj = null;
        ui.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"qingAnalyseFileDialog"));
        ui.setInvokeClass(this.getMetaDataPK().getFullName());
        ui.setInvokeMethod("invokeFileConvert");
        ui.setInvokeMethodParmeterType(param);
        ui.setShowTableMessage(true);
        Vector<Object[]> vecParameterValue = new Vector<Object[]>();
        for (MbgQingAnalyseFileInfo fileInfo : fileData) {
            obj = new Object[objlength];
            obj[0] = fileInfo.getBgSchemeId();
            obj[1] = fileInfo.getOrgUnitId();
            obj[2] = fileInfo.getQsId();
            obj[3] = targetNumber;
            obj[4] = fileInfo.getDimNumber();
            vecParameterValue.add(obj);
        }
        Object[][] valueMethod = new Object[vecParameterValue.size()][objlength];
        int in = vecParameterValue.size();
        for (int i = 0; i < in; ++i) {
            obj = (Object[])vecParameterValue.get(i);
            for (int j = 0; j < objlength; ++j) {
                valueMethod[i][j] = obj[j];
            }
        }
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(vecParameterValue.size() - 1);
    }

    public Object invokeFileConvert(String bgSchemeId, String orgUnitId, String qsId, String targetDimNumber, String sourceDimNumber) throws EASBizException, BOSException {
        Object[] obj = new Object[]{"", MbgQingAnalyseIntegrateFactory.getRemoteInstance().splitSingleQingAnalyseFile(bgSchemeId, orgUnitId, qsId, targetDimNumber, sourceDimNumber)};
        return obj;
    }

    private boolean verify(String selectedItem) throws EASBizException, BOSException {
        boolean checkQingFileSize = MbgQingAnalyseFacadeFactory.getRemoteInstance().checkQingFileSize(selectedItem);
        if (!checkQingFileSize) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"fileLimitSize"));
            return false;
        }
        return true;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

