/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgUpdateCalculateRuleChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateCalcRuleImpAndExpUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateProcessChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateSchemeTemplateChildUI;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateCalculateInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class MbgUpdateCalculateRuleChildUI
extends AbstractMbgUpdateCalculateRuleChildUI {
    private static final long serialVersionUID = -6466405466587488928L;
    private static final Logger logger = CoreUIObject.getLogger(MbgUpdateCalculateRuleChildUI.class);
    public static String COLUMN_CALCRULE_NUMBER = "calcRuleNumber";
    public static String COLUMN_CALCRULE_NAME = "calcRuleName";
    public static String COLUMN_BG_SCHEME_NUMBER = "bgSchemeNumber";
    public static String COLUMN_BG_SCHEME_NAME = "bgSchemeName";
    public static String COLUMN_PERIODTYPE = "periodType";
    public static String COLUMN_DESC = "desc";
    public static String[] COLUMU_KEYS = new String[]{COLUMN_CALCRULE_NUMBER, COLUMN_CALCRULE_NAME, COLUMN_BG_SCHEME_NUMBER, COLUMN_BG_SCHEME_NAME, COLUMN_PERIODTYPE, COLUMN_DESC};
    private static String COLUMN_DESC0 = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calcRule_desc0");
    private static String COLUMN_DESC1 = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calcRule_desc1");

    public MbgUpdateCalculateRuleChildUI() throws Exception {
        this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_desc_0") + "\n" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_desc_1") + "\n" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_desc_2") + "\n" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_desc_3"));
    }

    private void initPoriodType() {
        KDComboBox cbxDimension = new KDComboBox();
        cbxDimension.addItem(null);
        cbxDimension.addItem((Object)BgPeriodEnum.YEAR);
        cbxDimension.addItem((Object)BgPeriodEnum.HALFYEAR);
        cbxDimension.addItem((Object)BgPeriodEnum.QUARTER);
        cbxDimension.addItem((Object)BgPeriodEnum.MONTH);
        cbxDimension.addItem((Object)BgPeriodEnum.MWEEK);
        cbxDimension.addItem((Object)BgPeriodEnum.TENDAYS);
        cbxDimension.addItem((Object)BgPeriodEnum.DAY);
        cbxDimension.addItem((Object)BgPeriodEnum.YWEEK);
        this.kDTable1.getColumn(COLUMN_PERIODTYPE).setRequired(true);
        this.kDTable1.getColumn(COLUMN_PERIODTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxDimension));
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) {
        if (COLUMN_PERIODTYPE.equals(this.kDTable1.getColumnKey(e.getColIndex()))) {
            Object oldCalcNum = this.kDTable1.getRow(e.getRowIndex()).getCell(COLUMN_CALCRULE_NUMBER).getValue();
            Object oldPeriodType = this.kDTable1.getRow(e.getRowIndex()).getCell(COLUMN_PERIODTYPE).getValue();
            if (oldCalcNum == null || "".equals(oldCalcNum.toString().trim())) {
                return;
            }
            if (oldPeriodType == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_periodisnull"));
                return;
            }
            int count = this.kDTable1.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (e.getRowIndex() == i || !this.kDTable1.getCell(i, COLUMN_CALCRULE_NUMBER).getValue().equals(oldCalcNum)) continue;
                this.kDTable1.getCell(i, COLUMN_PERIODTYPE).setValue(oldPeriodType);
            }
        }
    }

    @Override
    public void verifyData() throws Exception {
        int i;
        int count = this.kDTable1.getRowCount();
        HashMap<String, Object> calcNumMap = new HashMap<String, Object>();
        for (i = 0; i < count; ++i) {
            Object value2 = this.kDTable1.getRow(i).getCell(COLUMN_PERIODTYPE).getValue();
            if (value2 != null && !"".equals(value2)) continue;
            String calcNum = this.kDTable1.getRow(i).getCell(COLUMN_CALCRULE_NUMBER).getValue().toString();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_nullPeriod", (Object[])new Object[]{i + 1, calcNum}));
            SysUtil.abort();
        }
        for (i = 0; i < count; ++i) {
            String calcNum = this.kDTable1.getRow(i).getCell(COLUMN_CALCRULE_NUMBER).getValue().toString();
            Object periodType = this.kDTable1.getRow(i).getCell(COLUMN_PERIODTYPE).getValue();
            if (calcNumMap.containsKey(calcNum)) {
                if (calcNumMap.get(calcNum).equals(periodType)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calculateRule_period_dumpt", (Object[])new Object[]{i + 1, calcNum}));
                SysUtil.abort();
                continue;
            }
            calcNumMap.put(calcNum, periodType);
        }
    }

    @Override
    protected String getNextUIClassName() {
        try {
            this.verifyData();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
        return MbgUpdateProcessChildUI.class.getName();
    }

    @Override
    protected String getPrevUIClassName() {
        return MbgUpdateSchemeTemplateChildUI.class.getName();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        MbgUpdateConfigInfo configInfo = this.getConfigInfo();
        List calcInfos = null;
        try {
            if (calcInfos == null || calcInfos.isEmpty()) {
                calcInfos = MbgUpdateFacadeFactory.getRemoteInstance().checkCalcRule(configInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.fillPeriodType(calcInfos);
        this.loadTableData(calcInfos);
    }

    private void fillPeriodType(List<MbgUpdateCalculateInfo> calcInfos) {
        MbgUpdateConfigInfo configInfo = this.getConfigInfo();
        Map<String, MbgUpdateCalculateInfo> bizcalcs = configInfo.getBizCalcs();
        for (int i = 0; i < calcInfos.size(); ++i) {
            String schemeKey = calcInfos.get(i).getBgScheme() == null ? "" : calcInfos.get(i).getBgScheme().getNumber().toString();
            String calcKey = calcInfos.get(i).getBizCalc().getNumber().toString() + "_" + schemeKey;
            if (!bizcalcs.containsKey(calcKey)) continue;
            calcInfos.get(i).setPeriodType(bizcalcs.get(calcKey).getPeriodType());
        }
    }

    protected void checkTableParsed() {
        this.kDTable1.checkParsed();
        this.initPoriodType();
    }

    private void loadTableData(List<MbgUpdateCalculateInfo> calcInfos) {
        this.kDTable1.removeRows();
        this.addTableData(calcInfos);
    }

    private void addTableData(List<MbgUpdateCalculateInfo> calcInfos) {
        if (calcInfos != null && calcInfos.size() > 0) {
            IRow iRow = null;
            for (int i = 0; i < calcInfos.size(); ++i) {
                iRow = this.kDTable1.addRow();
                MbgUpdateCalculateInfo info = calcInfos.get(i);
                iRow.getCell(COLUMN_CALCRULE_NUMBER).setValue(info.getBizCalc() == null ? null : info.getBizCalc().getNumber());
                iRow.getCell(COLUMN_CALCRULE_NAME).setValue(info.getBizCalc() == null ? null : info.getBizCalc().getName());
                if (info.getBgScheme() != null) {
                    iRow.getCell(COLUMN_BG_SCHEME_NUMBER).setValue((Object)info.getBgScheme().getNumber());
                    iRow.getCell(COLUMN_BG_SCHEME_NAME).setValue((Object)info.getBgScheme().getName());
                    iRow.getCell(COLUMN_PERIODTYPE).setValue((Object)info.getPeriodType());
                    iRow.getCell(COLUMN_DESC).setValue((Object)COLUMN_DESC1);
                    info.setDescription(COLUMN_DESC1);
                } else {
                    info.setDescription(COLUMN_DESC0);
                    iRow.getCell(COLUMN_PERIODTYPE).setValue((Object)info.getPeriodType());
                    iRow.getCell(COLUMN_DESC).setValue((Object)COLUMN_DESC0);
                }
                iRow.setUserObject((Object)info);
            }
        }
    }

    private Map<String, MbgUpdateCalculateInfo> getClacInfoMap(List<MbgUpdateCalculateInfo> calcInfos) {
        HashMap<String, MbgUpdateCalculateInfo> map = new HashMap<String, MbgUpdateCalculateInfo>();
        for (int i = 0; i < calcInfos.size(); ++i) {
            String calcNum = calcInfos.get(i).getBizCalc().getNumber().toString();
            String schemeNum = calcInfos.get(i).getBgScheme().getNumber().toString();
            String combKey = calcNum + "_" + schemeNum;
            map.put(combKey, calcInfos.get(i));
        }
        return map;
    }

    private void removeExtraCalInfo(List<MbgUpdateCalculateInfo> calcInfos, KDTable kDTable1, List<Integer> extraList, List<Integer> unexpectPeriodTypeList) {
        int i;
        int rowCount = kDTable1.getRowCount();
        HashSet<String> calRules = new HashSet<String>();
        ArrayList<MbgUpdateCalculateInfo> recalcInfos = new ArrayList<MbgUpdateCalculateInfo>();
        recalcInfos.addAll(calcInfos);
        List itemList = this.getAllComboItems();
        IRow iRow = null;
        for (i = 0; i < rowCount; ++i) {
            iRow = kDTable1.getRow(i);
            calRules.add(iRow.getCell(COLUMN_CALCRULE_NUMBER).getValue().toString());
        }
        for (i = 0; i < recalcInfos.size(); ++i) {
            if (calRules.contains(((MbgUpdateCalculateInfo)recalcInfos.get(i)).getBizCalc().getNumber())) continue;
            extraList.add(i + 1);
            calcInfos.remove(recalcInfos.get(i));
        }
        for (i = 0; i < calcInfos.size(); ++i) {
            if (itemList.contains(calcInfos.get(i).getPeriodType())) continue;
            unexpectPeriodTypeList.add(i + 1);
        }
    }

    private List getAllComboItems() {
        Component component = this.kDTable1.getColumn(COLUMN_PERIODTYPE).getEditor().getComponent();
        KDComboBox box = (KDComboBox)component;
        int itemCount = box.getItemCount();
        ArrayList<Object> periodTypeList = new ArrayList<Object>();
        for (int i = 0; i < itemCount; ++i) {
            periodTypeList.add(box.getItemAt(i));
        }
        return periodTypeList;
    }

    private void addExcelData(List<MbgUpdateCalculateInfo> calcInfos, List<Integer> extraList, List<Integer> unexpectPeriodTypeList) {
        this.removeExtraCalInfo(calcInfos, this.kDTable1, extraList, unexpectPeriodTypeList);
        Map<Object, Object> calMap = new HashMap();
        calMap = this.getClacInfoMap(calcInfos);
        IRow iRow = null;
        block0: for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            String calNum;
            iRow = this.kDTable1.getRow(i);
            if (iRow.getCell(COLUMN_BG_SCHEME_NUMBER).getValue() == null || "".equals(iRow.getCell(COLUMN_BG_SCHEME_NUMBER).getValue().toString())) {
                calNum = iRow.getCell(COLUMN_CALCRULE_NUMBER).getValue().toString();
                for (int j = 0; j < calcInfos.size(); ++j) {
                    if (!calNum.equals(calcInfos.get(j).getBizCalc().getNumber().toString())) continue;
                    MbgUpdateCalculateInfo info = calcInfos.get(j);
                    iRow.getCell(COLUMN_CALCRULE_NUMBER).setValue(info.getBizCalc() == null ? null : info.getBizCalc().getNumber());
                    iRow.getCell(COLUMN_CALCRULE_NAME).setValue(info.getBizCalc() == null ? null : info.getBizCalc().getName());
                    if (info.getBgScheme() != null) {
                        iRow.getCell(COLUMN_BG_SCHEME_NUMBER).setValue((Object)info.getBgScheme().getNumber());
                        iRow.getCell(COLUMN_BG_SCHEME_NAME).setValue((Object)info.getBgScheme().getName());
                        iRow.getCell(COLUMN_PERIODTYPE).setValue((Object)info.getPeriodType());
                        iRow.getCell(COLUMN_DESC).setValue((Object)COLUMN_DESC1);
                        info.setDescription(COLUMN_DESC1);
                    } else {
                        info.setDescription(COLUMN_DESC0);
                        iRow.getCell(COLUMN_PERIODTYPE).setValue((Object)info.getPeriodType());
                        iRow.getCell(COLUMN_DESC).setValue((Object)COLUMN_DESC0);
                    }
                    iRow.setUserObject((Object)info);
                    continue block0;
                }
                continue;
            }
            calNum = iRow.getCell(COLUMN_CALCRULE_NUMBER).getValue().toString();
            String schemeNum = iRow.getCell(COLUMN_BG_SCHEME_NUMBER).getValue().toString();
            String combineKey = calNum + "_" + schemeNum;
            if (calMap.get(combineKey) == null) continue;
            MbgUpdateCalculateInfo info = (MbgUpdateCalculateInfo)calMap.get(combineKey);
            iRow.getCell(COLUMN_CALCRULE_NUMBER).setValue(info.getBizCalc() == null ? null : info.getBizCalc().getNumber());
            iRow.getCell(COLUMN_CALCRULE_NAME).setValue(info.getBizCalc() == null ? null : info.getBizCalc().getName());
            if (info.getBgScheme() != null) {
                iRow.getCell(COLUMN_BG_SCHEME_NUMBER).setValue((Object)info.getBgScheme().getNumber());
                iRow.getCell(COLUMN_BG_SCHEME_NAME).setValue((Object)info.getBgScheme().getName());
                iRow.getCell(COLUMN_PERIODTYPE).setValue((Object)info.getPeriodType());
                iRow.getCell(COLUMN_DESC).setValue((Object)COLUMN_DESC1);
                info.setDescription(COLUMN_DESC1);
            } else {
                info.setDescription(COLUMN_DESC0);
                iRow.getCell(COLUMN_PERIODTYPE).setValue((Object)info.getPeriodType());
                iRow.getCell(COLUMN_DESC).setValue((Object)COLUMN_DESC0);
            }
            iRow.setUserObject((Object)info);
        }
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        int i;
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"isImport", (Object)true);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.mbg.client.MbgUpdateCalcRuleImpAndExpUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calcRuleImport"));
        window.show();
        MbgUpdateCalcRuleImpAndExpUI m = (MbgUpdateCalcRuleImpAndExpUI)window.getUIObject();
        List<MbgUpdateCalculateInfo> importCalcInfos = m.getImportCalcInfos();
        LinkedList<Integer> extraCalcList = new LinkedList<Integer>();
        LinkedList<Integer> unexpectPeriodTypeList = new LinkedList<Integer>();
        this.addExcelData(importCalcInfos, extraCalcList, unexpectPeriodTypeList);
        this.checkTable(this.kDTable1);
        for (i = 0; i < extraCalcList.size(); ++i) {
            m.recordError("com.kingdee.eas.ma.mbg.MbgUpdateResultResource", "cantNotAddExtraCalc", new Object[]{extraCalcList.get(i)});
        }
        for (i = 0; i < unexpectPeriodTypeList.size(); ++i) {
            m.recordError("com.kingdee.eas.ma.mbg.MbgUpdateResultResource", "periodTypeNotExist", new Object[]{unexpectPeriodTypeList.get(i)});
        }
        if (!m.isCancelActionFlag()) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"importSuccessAndDetail"), (String)m.getShowDetailMsg().toString(), (int)1);
        }
        m.setShowDetailMsg(null);
        extraCalcList.clear();
        unexpectPeriodTypeList.clear();
    }

    private void checkTable(KDTable kDTable1) {
        int rowCount = kDTable1.getRowCount();
        IRow iRow = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < rowCount; ++i) {
            iRow = kDTable1.getRow(i);
            String calNum = iRow.getCell(COLUMN_CALCRULE_NUMBER).getValue().toString();
            String periodType = null;
            periodType = iRow.getCell(COLUMN_PERIODTYPE) == null ? "" : (iRow.getCell(COLUMN_PERIODTYPE).getValue() == null ? "" : iRow.getCell(COLUMN_PERIODTYPE).getValue().toString());
            String periodKey = calNum + "_" + periodType;
            if (iRow.getCell(COLUMN_PERIODTYPE) == null && "".equals(iRow.getCell(COLUMN_PERIODTYPE).getValue().toString())) continue;
            if (map.containsKey(calNum)) {
                if (!((String)map.get(calNum)).equals(periodKey)) continue;
                continue;
            }
            map.put(calNum, periodKey);
        }
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"isImport", (Object)false);
        ctx.put((Object)"data", (Object)this.loadTempTblData());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.mbg.client.MbgUpdateCalcRuleImpAndExpUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"calcRuleExport"));
        window.show();
    }

    private KDTable loadTempTblData() throws EASBizException, BOSException {
        KDTable tbl = MbgUpdateCalcRuleImpAndExpUI.createKDTableTemplateData();
        IRow destRow = null;
        IRow srcRow = null;
        tbl.removeRows();
        for (int j = 0; j < this.kDTable1.getRowCount(); ++j) {
            destRow = tbl.addRow();
            srcRow = this.kDTable1.getRow(j);
            destRow.getCell(COLUMU_KEYS[0]).setValue(srcRow.getCell(COLUMU_KEYS[0]).getValue());
            destRow.getCell(COLUMU_KEYS[1]).setValue(srcRow.getCell(COLUMU_KEYS[1]).getValue());
            destRow.getCell(COLUMU_KEYS[2]).setValue(srcRow.getCell(COLUMU_KEYS[2]).getValue());
            destRow.getCell(COLUMU_KEYS[3]).setValue(srcRow.getCell(COLUMU_KEYS[3]).getValue());
            destRow.getCell(COLUMU_KEYS[4]).setValue(srcRow.getCell(COLUMU_KEYS[4]).getValue());
            destRow.getCell(COLUMU_KEYS[5]).setValue(srcRow.getCell(COLUMU_KEYS[5]).getValue());
        }
        return tbl;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        int count = this.kDTable1.getRowCount();
        MbgUpdateConfigInfo calcConfigInfo = this.getConfigInfo();
        for (int i = 0; i < count; ++i) {
            BgPeriodEnum value4 = (BgPeriodEnum)this.kDTable1.getCell(i, COLUMN_PERIODTYPE).getValue();
            MbgUpdateCalculateInfo calcInfo = (MbgUpdateCalculateInfo)this.kDTable1.getRow(i).getUserObject();
            calcInfo.setPeriodType(value4);
            calcConfigInfo.addBizCalcs(calcInfo);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
    }
}

