/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.Excel2007Reader;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgUpdateOrgChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateCatalogChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateSchemeTemplateChildUI;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MbgUpdateOrgChildUI
extends AbstractMbgUpdateOrgChildUI {
    private static final long serialVersionUID = -5395344182682670605L;
    private static final Logger logger = CoreUIObject.getLogger(MbgUpdateOrgChildUI.class);
    public Map<String, Set<String>> longNumberMap = null;
    private static final String ORG_NUMBER = "orgNumber";
    private static final String ORG_NAME = "orgName";
    private static final String BG_SCHEME = "bgScheme";
    private static final String BG_TEMPLATE = "bgTemplate";
    private static final String DETAIL_ORG_NUMBER = "detailOrgNumber";
    private static final String DETAIL_ORG_NAME = "detailOrgName";
    private static final String ROW_NUMBER = "rowNumber";

    @Override
    protected String getNextUIClassName() {
        return MbgUpdateSchemeTemplateChildUI.class.getName();
    }

    @Override
    protected String getPrevUIClassName() {
        return MbgUpdateCatalogChildUI.class.getName();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        List orgInfos = null;
        try {
            orgInfos = MbgUpdateFacadeFactory.getRemoteInstance().checkOrgUnit(this.getConfigInfo());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.initTblMain(orgInfos);
        this.initF7();
        this.initLeafOrg(orgInfos);
    }

    @Override
    public void verifyData() throws Exception {
        super.verifyData();
        if (this.tblMain.getUserObject() != null) {
            for (MbgUpdateOrgInfo orgInfo : (List)this.tblMain.getUserObject()) {
                if (orgInfo.getTargetOrg() != null) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckSelectError"));
                SysUtil.abort();
            }
        }
        try {
            Map targetOrgMap = MbgUpdateFacadeFactory.getRemoteInstance().checkOrgBgDataAndAcData((List)this.tblMain.getUserObject());
            LinkedHashMap<String, Integer> reportMap = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                MbgUpdateOrgInfo updateOrgInfo = (MbgUpdateOrgInfo)row.getUserObject();
                String key = row.getCell(BG_SCHEME).getValue().toString() + "_" + row.getCell(DETAIL_ORG_NUMBER).getValue().toString();
                if (reportMap.containsKey(key) || targetOrgMap.get(updateOrgInfo.getBgScheme().getNumber()) == null || !((Boolean)((Map)targetOrgMap.get(updateOrgInfo.getBgScheme().getNumber())).get(updateOrgInfo.getTargetOrg().getId().toString())).booleanValue()) continue;
                reportMap.put(key, row.getRowIndex());
            }
            if (reportMap.size() != 0) {
                StringBuffer reportStrBuf = new StringBuffer();
                for (String key : reportMap.keySet()) {
                    reportStrBuf.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckReportDesc0", (Object[])new String[]{new Integer((Integer)reportMap.get(key) + 1).toString(), this.tblMain.getRow(((Integer)reportMap.get(key)).intValue()).getCell(DETAIL_ORG_NAME).getValue().toString()})).append("\n");
                }
                reportStrBuf.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckReportDesc1"));
                MsgBox.showWarning((String)reportStrBuf.toString());
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.tblMain.getUserObject() == null) {
            return;
        }
        MbgUpdateConfigInfo configInfo = this.getConfigInfo();
        for (MbgUpdateOrgInfo orgInfo : (List)this.tblMain.getUserObject()) {
            configInfo.addOrgConfig(orgInfo);
        }
    }

    public void initTblMain(List<MbgUpdateOrgInfo> orgInfos) {
        this.kDTextPane1.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckDescription1") + "\n" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckDescription2"));
        this.tblMain.checkParsed();
        this.tblMain.setUserObject(orgInfos);
        MbgUpdateConfigInfo configInfo = this.getConfigInfo();
        Map<String, MbgUpdateOrgInfo> orgConfigInfos = configInfo.getOrgConfig();
        for (MbgUpdateOrgInfo orgInfo : orgInfos) {
            MbgUpdateOrgInfo orgConfig = orgConfigInfos.get(orgInfo.getKey());
            if (orgConfig == null) continue;
            orgInfo.setTargetOrg(orgConfig.getTargetOrg());
        }
        for (MbgUpdateOrgInfo orgInfo : orgInfos) {
            IRow row = this.tblMain.addRow();
            row.getCell(ORG_NUMBER).setValue((Object)orgInfo.getSourceOrg().getNumber());
            row.getCell(ORG_NAME).setValue((Object)orgInfo.getSourceOrg().getName());
            if (orgInfo.getBgScheme() != null) {
                row.getCell(BG_SCHEME).setValue((Object)orgInfo.getBgScheme().getNumber());
            }
            if (orgInfo.getBgTemplate() != null) {
                row.getCell(BG_TEMPLATE).setValue((Object)orgInfo.getBgTemplate().getNumber());
            }
            if (orgInfo.getTargetOrg() != null) {
                row.getCell(DETAIL_ORG_NUMBER).setValue((Object)orgInfo.getTargetOrg().getNumber());
                row.getCell(DETAIL_ORG_NAME).setValue((Object)orgInfo.getTargetOrg().getName());
            }
            row.setUserObject((Object)orgInfo);
        }
    }

    public void initF7() {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(true);
        prmt.setDisplayFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setEditFormat("$number$");
        CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckSelectOrg"));
        orgView.setRootUnitID(CU.getId().toString());
        orgView.setMultiSelect(false);
        orgView.setContainSealUp(false);
        prmt.setSelector((KDPromptSelector)orgView);
        prmt.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                int rowIndex = MbgUpdateOrgChildUI.this.tblMain.getSelectManager().getActiveRowIndex();
                MbgUpdateOrgInfo updateOrgInfo = (MbgUpdateOrgInfo)MbgUpdateOrgChildUI.this.tblMain.getRow(rowIndex).getUserObject();
                ((BgOrgViewF7)((KDBizPromptBox)e.getSource()).getSelector()).setRootUnitID(updateOrgInfo.getSourceOrg().getId().toString());
            }
        });
        prmt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        this.tblMain.getColumn(DETAIL_ORG_NUMBER).setEditor((ICellEditor)editor);
    }

    public void initLeafOrg(List<MbgUpdateOrgInfo> orgInfos) {
        HashSet<String> rootLongNumberSet = new HashSet<String>();
        for (MbgUpdateOrgInfo orgInfo : orgInfos) {
            rootLongNumberSet.add(orgInfo.getSourceOrg().getLongNumber());
        }
        try {
            this.longNumberMap = MbgUpdateFacadeFactory.getRemoteInstance().checkLeafOrg(rootLongNumberSet);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
        ArrayList<MbgUpdateOrgInfo> orgInfos = (ArrayList<MbgUpdateOrgInfo>)this.tblMain.getUserObject();
        ArrayList<MbgUpdateOrgInfo> resultInfos = null;
        String searchStr = this.txtOrgSearch.getStringValue();
        if (searchStr == null) {
            resultInfos = orgInfos;
        } else if (searchStr.trim().equals("")) {
            resultInfos = orgInfos;
        } else if (!searchStr.trim().equals("")) {
            searchStr = searchStr.trim();
            resultInfos = new ArrayList<MbgUpdateOrgInfo>();
            for (MbgUpdateOrgInfo orgInfo : orgInfos) {
                if (!orgInfo.getSourceOrg().getNumber().toLowerCase().contains(searchStr.toLowerCase()) && !orgInfo.getSourceOrg().getName().contains(searchStr) && !orgInfo.getBgScheme().getNumber().toLowerCase().contains(searchStr.toLowerCase()) && !orgInfo.getBgTemplate().getNumber().toLowerCase().contains(searchStr.toLowerCase()) && (orgInfo.getTargetOrg() == null || !orgInfo.getTargetOrg().getNumber().toLowerCase().contains(searchStr.toLowerCase())) && (orgInfo.getTargetOrg() == null || !orgInfo.getTargetOrg().getName().contains(searchStr))) continue;
                resultInfos.add(orgInfo);
            }
        }
        this.tblMain.removeRows();
        if (resultInfos != null) {
            for (MbgUpdateOrgInfo orgInfo : resultInfos) {
                IRow row = this.tblMain.addRow();
                row.getCell(ORG_NUMBER).setValue((Object)orgInfo.getSourceOrg().getNumber());
                row.getCell(ORG_NAME).setValue((Object)orgInfo.getSourceOrg().getName());
                if (orgInfo.getBgScheme() != null) {
                    row.getCell(BG_SCHEME).setValue((Object)orgInfo.getBgScheme().getNumber());
                }
                if (orgInfo.getBgTemplate() != null) {
                    row.getCell(BG_TEMPLATE).setValue((Object)orgInfo.getBgTemplate().getNumber());
                }
                if (orgInfo.getTargetOrg() != null) {
                    row.getCell(DETAIL_ORG_NUMBER).setValue((Object)orgInfo.getTargetOrg().getNumber());
                    row.getCell(DETAIL_ORG_NAME).setValue((Object)orgInfo.getTargetOrg().getName());
                }
                row.setUserObject((Object)orgInfo);
            }
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionImport_actionPerformed(e);
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImport"));
        fileChooser.setFileFilter((FileFilter)new Excel2007FileFilter());
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        String filePath = null;
        FileFilter filter = null;
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            filter = fileChooser.getFileFilter();
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            if (filter instanceof ExcelFile) {
                kdsBook = POIXlsReader.parse((String)filePath);
            } else if (filter instanceof Excel2007FileFilter) {
                kdsBook = new Excel2007Reader().parse(filePath);
            }
        }
        catch (Exception e1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckFileNotExist"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckFileDamaged"));
            SysUtil.abort();
        }
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        int rowCount = sheet.getRowCount();
        String orgNumber = null;
        String orgName = null;
        String bgScheme = null;
        String bgTemplate = null;
        String detailOrgNumber = null;
        String detailOrgName = null;
        HashMap tarOrgMap = new HashMap();
        for (int row = 0; row < rowCount; ++row) {
            orgNumber = sheet.getCell(row, 0, false) == null ? null : sheet.getCell(row, 0, false).getValue().toString().trim();
            orgName = sheet.getCell(row, 1, false) == null ? null : sheet.getCell(row, 1, false).getValue().toString().trim();
            bgScheme = sheet.getCell(row, 2, false) == null ? null : sheet.getCell(row, 2, false).getValue().toString().trim();
            bgTemplate = sheet.getCell(row, 4, false) == null ? null : sheet.getCell(row, 4, false).getValue().toString().trim();
            detailOrgNumber = sheet.getCell(row, 6, false) == null ? null : sheet.getCell(row, 6, false).getValue().toString().trim();
            detailOrgName = sheet.getCell(row, 7, false) == null ? null : sheet.getCell(row, 7, false).getValue().toString().trim();
            String tarOrgKey = bgScheme + "_" + orgNumber + "_" + bgTemplate;
            HashMap<String, String> updateView = new HashMap<String, String>();
            updateView.put(ORG_NUMBER, orgNumber);
            updateView.put(ORG_NAME, orgName);
            updateView.put(BG_SCHEME, bgScheme);
            updateView.put(BG_TEMPLATE, bgTemplate);
            updateView.put(DETAIL_ORG_NUMBER, detailOrgNumber);
            updateView.put(DETAIL_ORG_NAME, detailOrgName);
            tarOrgMap.put(tarOrgKey, updateView);
        }
        LinkedHashMap<String, Integer> isEmpty = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> isDiff = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> isError = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> isNotExist = new LinkedHashMap<String, Integer>();
        HashMap<String, Object> finalUpdateOrg = new HashMap<String, Object>();
        List<MbgUpdateOrgInfo> orgInfos = this.getMbgUpdateOrgInfos();
        Map updateView = null;
        String updateKey = null;
        String orgKey = null;
        for (int i = 0; i < orgInfos.size(); ++i) {
            orgKey = orgInfos.get(i).getBgScheme().getNumber() + "_" + orgInfos.get(i).getSourceOrg().getNumber() + "_" + orgInfos.get(i).getBgTemplate().getNumber();
            updateView = (Map)tarOrgMap.get(orgKey);
            if (updateView == null) continue;
            updateKey = (String)updateView.get(BG_SCHEME) + "_" + (String)updateView.get(ORG_NUMBER);
            String tarOrgNumber = (String)updateView.get(DETAIL_ORG_NUMBER);
            if (StringUtils.isEmpty((String)tarOrgNumber) && isEmpty.get(updateKey) == null) {
                isEmpty.put(updateKey, i + 1);
                continue;
            }
            if (finalUpdateOrg.get(updateKey) != null) {
                if (((String)finalUpdateOrg.get(updateKey)).equals(tarOrgNumber)) continue;
                isDiff.put(updateKey, i + 1);
                continue;
            }
            finalUpdateOrg.put(updateKey, tarOrgNumber);
        }
        finalUpdateOrg.keySet().removeAll(isEmpty.keySet());
        finalUpdateOrg.keySet().removeAll(isDiff.keySet());
        HashSet<String> targetOrgNumberSet = new HashSet<String>();
        for (String key : finalUpdateOrg.keySet()) {
            targetOrgNumberSet.add((String)finalUpdateOrg.get(key));
        }
        Map<String, OrgUnitInfo> targetOrgInfos = this.checkOrgUnit(targetOrgNumberSet);
        List<MbgUpdateOrgInfo> updateOrgInfos = null;
        updateOrgInfos = this.getMbgUpdateOrgInfos();
        for (int i = 0; i < updateOrgInfos.size(); ++i) {
            Object orgInfo = updateOrgInfos.get(i);
            String schemeAndOrgKey = ((MbgUpdateOrgInfo)orgInfo).getBgScheme().getNumber() + "_" + ((MbgUpdateOrgInfo)orgInfo).getSourceOrg().getNumber();
            if (!finalUpdateOrg.containsKey(schemeAndOrgKey)) continue;
            String tarOrgNumber = (String)finalUpdateOrg.get(schemeAndOrgKey);
            OrgUnitInfo tarOrgInfo = targetOrgInfos.get(tarOrgNumber);
            if (tarOrgInfo != null) {
                String parentLongNumber = ((MbgUpdateOrgInfo)orgInfo).getSourceOrg().getLongNumber();
                String longNumber = tarOrgInfo.getLongNumber();
                if (this.longNumberMap.get(parentLongNumber).contains(longNumber)) {
                    ((MbgUpdateOrgInfo)orgInfo).setTargetOrg(tarOrgInfo);
                    continue;
                }
                if (isError.containsKey(schemeAndOrgKey)) continue;
                isError.put(schemeAndOrgKey, i + 1);
                continue;
            }
            isNotExist.put(schemeAndOrgKey, i + 1);
        }
        this.tblMain.removeRows();
        for (Object orgInfo : (List)this.tblMain.getUserObject()) {
            IRow row = this.tblMain.addRow();
            row.getCell(ORG_NUMBER).setValue((Object)((MbgUpdateOrgInfo)orgInfo).getSourceOrg().getNumber());
            row.getCell(ORG_NAME).setValue((Object)((MbgUpdateOrgInfo)orgInfo).getSourceOrg().getName());
            if (((MbgUpdateOrgInfo)orgInfo).getBgScheme() != null) {
                row.getCell(BG_SCHEME).setValue((Object)((MbgUpdateOrgInfo)orgInfo).getBgScheme().getNumber());
            }
            if (((MbgUpdateOrgInfo)orgInfo).getBgTemplate() != null) {
                row.getCell(BG_TEMPLATE).setValue((Object)((MbgUpdateOrgInfo)orgInfo).getBgTemplate().getNumber());
            }
            if (((MbgUpdateOrgInfo)orgInfo).getTargetOrg() != null) {
                row.getCell(DETAIL_ORG_NUMBER).setValue((Object)((MbgUpdateOrgInfo)orgInfo).getTargetOrg().getNumber());
                row.getCell(DETAIL_ORG_NAME).setValue((Object)((MbgUpdateOrgInfo)orgInfo).getTargetOrg().getName());
            }
            row.setUserObject(orgInfo);
        }
        StringBuffer msgBuf = new StringBuffer();
        for (String key : isEmpty.keySet()) {
            msgBuf.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImportIsEmpty", (Object[])new String[]{((Integer)isEmpty.get(key)).toString()})).append("\n");
        }
        for (String key : isDiff.keySet()) {
            msgBuf.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImportIsDiff", (Object[])new String[]{((Integer)isDiff.get(key)).toString()})).append("\n");
        }
        for (String key : isError.keySet()) {
            msgBuf.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImportIsError", (Object[])new String[]{((Integer)isError.get(key)).toString()})).append("\n");
        }
        for (String key : isNotExist.keySet()) {
            msgBuf.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImportIsNotExist", (Object[])new String[]{((Integer)isNotExist.get(key)).toString()})).append("\n");
        }
        if (msgBuf.length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImportSuccess"));
        } else {
            String error = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckImportFailed");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)msgBuf.toString(), (int)0);
        }
    }

    @Override
    public void actionExportToExcel_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckExport"));
        Object filter = new ExcelFileFilter();
        fileChooser.addChoosableFileFilter((FileFilter)filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)filter);
        File file = null;
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            int re;
            filePath = fileChooser.getSelectedFile().getPath();
            filter = fileChooser.getFileFilter();
            file = fileChooser.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                if (filter instanceof ExcelFileFilter) {
                    filePath = fileChooser.getSelectedFile() + ".xls";
                }
                file = new File(filePath);
            }
            if (file.exists() && ((re = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckFileExist"))) == 1 || re == 2)) {
                return;
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        try {
            if (filter instanceof ExcelFileFilter) {
                KDSBook kdsBook = new KDSBook("001");
                KDSSheet kdsSheet = new KDSSheet(kdsBook, "Sheet1");
                kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"font"), 0, 9));
                kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
                kdsSheet.setCellValue(0, 0, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)ORG_NUMBER));
                kdsSheet.setCellValue(0, 1, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)ORG_NAME));
                kdsSheet.setCellValue(0, 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"bgSchemeNumber"));
                kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"bgSchemeName"));
                kdsSheet.setCellValue(0, 4, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"bgTemplateNumber"));
                kdsSheet.setCellValue(0, 5, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"bgTemplateName"));
                kdsSheet.setCellValue(0, 6, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)DETAIL_ORG_NUMBER));
                kdsSheet.setCellValue(0, 7, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)DETAIL_ORG_NAME));
                IRow row = null;
                for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                    row = this.tblMain.getRow(i);
                    kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell(0).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 1, (Object)row.getCell(1).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 2, (Object)row.getCell(2).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 3, (Object)((MbgUpdateOrgInfo)row.getUserObject()).getBgScheme().getName());
                    kdsSheet.setCellValue(i + 1, 4, (Object)row.getCell(3).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 5, (Object)((MbgUpdateOrgInfo)row.getUserObject()).getBgTemplate().getName());
                    kdsSheet.setCellValue(i + 1, 6, row.getCell(4).getValue() == null ? null : row.getCell(4).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 7, row.getCell(5).getValue() == null ? null : row.getCell(5).getValue().toString());
                }
                kdsBook.addSheet(null, kdsSheet);
                ExportManager export = new ExportManager();
                export.exportToExcel(kdsBook, filePath);
                kdsBook = null;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckExportSuccess"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckFileOpened"));
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        block6: {
            int activeRow;
            block5: {
                super.tblMain_editStopped(e);
                activeRow = this.tblMain.getSelectManager().getActiveRowIndex();
                if (!(e.getValue() instanceof FullOrgUnitInfo)) break block5;
                OrgUnitInfo targetOrgInfo = (OrgUnitInfo)e.getValue();
                MbgUpdateOrgInfo mbgUpdateOrgInfo = (MbgUpdateOrgInfo)this.tblMain.getRow(activeRow).getUserObject();
                OrgUnitInfo sourceOrgInfo = mbgUpdateOrgInfo.getSourceOrg();
                BgSchemeInfo bgSchemeInfo = mbgUpdateOrgInfo.getBgScheme();
                if (!this.longNumberMap.get(sourceOrgInfo.getLongNumber()).contains(targetOrgInfo.getLongNumber())) {
                    this.tblMain.getRow(activeRow).getCell(DETAIL_ORG_NUMBER).setValue(null);
                    this.tblMain.getRow(activeRow).getCell(DETAIL_ORG_NAME).setValue(null);
                    mbgUpdateOrgInfo.setTargetOrg(null);
                    this.tblMain.getRow(activeRow).setUserObject((Object)mbgUpdateOrgInfo);
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckF7SelectError"));
                    SysUtil.abort();
                }
                for (MbgUpdateOrgInfo orgInfo : (List)this.tblMain.getUserObject()) {
                    if (!orgInfo.getSourceOrg().getId().toString().equals(sourceOrgInfo.getId().toString()) || !orgInfo.getBgScheme().getId().toString().equals(bgSchemeInfo.getId().toString())) continue;
                    orgInfo.setTargetOrg(targetOrgInfo);
                }
                for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                    IRow row = this.tblMain.getRow(i);
                    MbgUpdateOrgInfo updateOrgInfo = (MbgUpdateOrgInfo)row.getUserObject();
                    if (!updateOrgInfo.getSourceOrg().getId().toString().equals(sourceOrgInfo.getId().toString()) || !updateOrgInfo.getBgScheme().getId().toString().equals(bgSchemeInfo.getId().toString())) continue;
                    updateOrgInfo.setTargetOrg(targetOrgInfo);
                    row.getCell(DETAIL_ORG_NAME).setValue((Object)targetOrgInfo.getName());
                    row.getCell(DETAIL_ORG_NUMBER).setValue((Object)targetOrgInfo.getNumber());
                }
                break block6;
            }
            if (e.getValue() != null) break block6;
            MbgUpdateOrgInfo activeRowOrgInfo = (MbgUpdateOrgInfo)this.tblMain.getRow(activeRow).getUserObject();
            for (MbgUpdateOrgInfo orgInfo : (List)this.tblMain.getUserObject()) {
                if (!orgInfo.getSourceOrg().getId().toString().equals(activeRowOrgInfo.getSourceOrg().getId().toString()) || !orgInfo.getBgScheme().getId().toString().equals(activeRowOrgInfo.getBgScheme().getId().toString())) continue;
                orgInfo.setTargetOrg(null);
            }
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                MbgUpdateOrgInfo orgInfo;
                orgInfo = (MbgUpdateOrgInfo)this.tblMain.getRow(i).getUserObject();
                if (!orgInfo.getSourceOrg().getId().toString().equals(activeRowOrgInfo.getSourceOrg().getId().toString()) || !orgInfo.getBgScheme().getId().toString().endsWith(activeRowOrgInfo.getBgScheme().getId().toString())) continue;
                this.tblMain.getRow(i).getCell(DETAIL_ORG_NUMBER).setValue(null);
                this.tblMain.getRow(i).getCell(DETAIL_ORG_NAME).setValue(null);
                orgInfo.setTargetOrg(null);
            }
        }
    }

    public Map<String, OrgUnitInfo> checkOrgUnit(Set<String> orgNumberSet) throws BOSException {
        HashMap<String, OrgUnitInfo> orgInfos = new HashMap<String, OrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", orgNumberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = CostCenterOrgUnitFactory.getRemoteInstance().getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            orgInfos.put(((OrgUnitInfo)colls.get(i)).getNumber(), (OrgUnitInfo)colls.get(i));
        }
        return orgInfos;
    }

    protected void sort(List<MbgUpdateOrgInfo> orgInfos) {
        Collections.sort(orgInfos, (Comparator)new Comparator<MbgUpdateOrgInfo>(){

            @Override
            public int compare(MbgUpdateOrgInfo o1, MbgUpdateOrgInfo o2) {
                return o1.getBgTemplate().getNumber().compareTo(o2.getBgTemplate().getNumber());
            }
        });
        Collections.sort(orgInfos, (Comparator)new Comparator<MbgUpdateOrgInfo>(){

            @Override
            public int compare(MbgUpdateOrgInfo o1, MbgUpdateOrgInfo o2) {
                return o1.getSourceOrg().getNumber().compareTo(o2.getSourceOrg().getNumber());
            }
        });
        Collections.sort(orgInfos, (Comparator)new Comparator<MbgUpdateOrgInfo>(){

            @Override
            public int compare(MbgUpdateOrgInfo o1, MbgUpdateOrgInfo o2) {
                return o1.getBgScheme().getNumber().compareTo(o2.getBgScheme().getNumber());
            }
        });
    }

    protected List<MbgUpdateOrgInfo> getMbgUpdateOrgInfos() {
        return (List)this.tblMain.getUserObject();
    }
}

