/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgUpdateProcessChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdate820CatalogChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateCalculateRuleChildUI;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateUtilConfig;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgUpdateProcessChildUI
extends AbstractMbgUpdateProcessChildUI {
    private static final long serialVersionUID = 3867887283171917425L;
    private static final Logger logger = CoreUIObject.getLogger(MbgUpdateProcessChildUI.class);
    protected static final String KEY = "key";
    protected static final String UPITEMS = "upItems";
    protected static final String RESULT = "result";
    MySwingWorker1 work1 = new MySwingWorker1();
    MySwingWorker worker = new MySwingWorker();

    @Override
    protected String getNextUIClassName() {
        return MbgUpdate820CatalogChildUI.class.getName();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initTable();
    }

    @Override
    protected String getPrevUIClassName() {
        return MbgUpdateCalculateRuleChildUI.class.getName();
    }

    @Override
    protected void btnUpdate_actionPerformed(ActionEvent e) throws Exception {
        super.btnUpdate_actionPerformed(e);
        this.btnUpdate.setEnabled(false);
        this.btnNext.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.worker.start();
        this.work1.start();
    }

    private void initTable() {
        this.tblMain.checkParsed();
        List<String> lst = MbgUpdateUtilConfig.getUpdateConfig();
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            row.getCell(KEY).setValue((Object)lst.get(i));
            row.getCell(UPITEMS).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)lst.get(i)));
        }
    }

    private void loadResult(Map<String, MbgUpdateResultInfo> result) {
        if (result == null) {
            try {
                result = MbgUpdateFacadeFactory.getRemoteInstance().readProcess();
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        String key = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            key = (String)this.tblMain.getRow(i).getCell(KEY).getValue();
            MbgUpdateResultInfo r = (MbgUpdateResultInfo)result.get(key);
            ICell cell = this.tblMain.getRow(i).getCell(RESULT);
            if (r == null || r.getResultMsg().equals(cell.getUserObject())) continue;
            cell.setUserObject((Object)r.getResultMsg());
            cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)r.getResultMsg()));
        }
        this.tblMain.updateUI();
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        this.mainUi.cancel();
    }

    protected void setCloseButton() {
        this.btnUpdate.setEnabled(false);
        this.btnUpdate.setVisible(false);
        this.btnNext.setVisible(true);
        this.btnNext.setEnabled(true);
        this.btnPrev.setEnabled(false);
    }

    protected void executeUpdate() throws BOSException, EASBizException {
        MbgUpdateFacadeFactory.getRemoteInstance().processClear();
        MbgUpdateFacadeFactory.getRemoteInstance().updateTable();
        List result = MbgUpdateFacadeFactory.getRemoteInstance().executeUpdate(this.getConfigInfo());
        this.getMainUi().checkUpdated();
    }

    private class MySwingWorker1
    extends SwingWorker {
        private boolean isStart = false;

        private MySwingWorker1() {
        }

        public void start() {
            this.isStart = true;
            super.start();
        }

        public Object construct() {
            try {
                while (this.isStart) {
                    Thread.sleep(500L);
                    MbgUpdateProcessChildUI.this.loadResult(null);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }

        public void stop() {
            if (this.isStart) {
                this.isStart = false;
                MbgUpdateProcessChildUI.this.loadResult(null);
                super.stop();
            }
        }
    }

    private class MySwingWorker
    extends SwingWorker {
        private MySwingWorker() {
        }

        public Object construct() {
            try {
                MbgUpdateProcessChildUI.this.btnUpdate.setEnabled(false);
                MbgUpdateProcessChildUI.this.btnPrev.setEnabled(false);
                MbgUpdateFacadeFactory.getRemoteInstance().processClear();
                MbgUpdateProcessChildUI.this.executeUpdate();
                MbgUpdateProcessChildUI.this.loadResult(null);
                MbgUpdateProcessChildUI.this.setCloseButton();
            }
            catch (Exception e) {
                MbgUpdateProcessChildUI.this.btnPrev.setEnabled(true);
                MbgUpdateProcessChildUI.this.btnCancel.setEnabled(true);
                logger.error((Object)"", (Throwable)e);
                MbgUpdateProcessChildUI.this.handUIExceptionAndAbort(e);
            }
            finally {
                MbgUpdateProcessChildUI.this.work1.stop();
                this.stop();
            }
            return null;
        }
    }
}

